<?php
if (!defined('ABSPATH')) {
    exit();
}
if (!class_exists('CELP_cron')) {
    class CELP_cron
    {

        public function __construct()
        {
            // Register schedule interval
            add_filter('cron_schedules', array($this, 'celp_cron_schedules'));   
            add_action('celp_extra_data_update', array($this, 'celp_cron_extra_data_autoupdater'));

        }

        /*
         *    Create new schedule interval if not already registered
         */
        public function celp_cron_schedules($schedules)
        {
            if (!isset($schedules["celp-7-min"])) {
                $schedules["celp-7-min"] = array(
                    'interval' => 7 * 60,
                    'display' => __('After every 7 minutes'),
                );
            }
            if (!isset($schedules['every_30_days'])) {

                $schedules['every_30_days'] = array(
                    'interval' => 30 * 24 * 60 * 60, // 2,592,000 seconds
                    'display'  => __('Once every 30 days'),
                );
            }
            return $schedules;
        }   

        function celp_cron_extra_data_autoupdater() {
       
            $settings       = get_option('openexchange-api-settings', []);
            $celp_response  = isset($settings['celp_extra_info']) ? $settings['celp_extra_info'] : '';

            if (!empty($celp_response) || $celp_response === 'on'){
          
                if (class_exists('CELP_cron')) {
                    CELP_cron::celp_send_data();
                }
            }
        }

        static public function celp_send_data() {
            $feedback_url = CELP_FEEDBACK_API.'wp-json/coolplugins-feedback/v1/site';
            $extra_data_details = celp_get_user_info();
        
            
            $server_info    = $extra_data_details['server_info'];
            $extra_details  = $extra_data_details['extra_details'];
            $site_url       = get_site_url();
            $install_date   = get_option('celp-install-date');
            $unique_key     = '6';  // Ensure this key is unique per plugin to prevent collisions when site URL and install date are the same across plugins
            $site_id        = $site_url . '-' . $install_date . '-' . $unique_key;
            $initial_version = get_option('celp_initial_save_version');
            $initial_version = is_string($initial_version) ? sanitize_text_field($initial_version) : 'N/A';
            $plugin_version = defined('CELP_VERSION') ? CELP_VERSION : 'N/A';
            $admin_email    = sanitize_email(get_option('admin_email') ?: 'N/A');
            
            $post_data = array(
                
                'site_id'           => md5($site_id),
                'plugin_version'    => $plugin_version,
                'plugin_name'       => 'Cryptocurrency Exchanges List PRO',
                'plugin_initial'    => $initial_version,
                'email'             => $admin_email,
                'site_url'          => esc_url_raw($site_url),
                'server_info'       => $server_info,
                'extra_details'     => $extra_details,
            );
            
            $response = wp_remote_post($feedback_url, array(      
                'method'    => 'POST',
                'timeout'   => 30,
                'headers'   => array(
                    'Content-Type' => 'application/json',
                ),
                'body'      => wp_json_encode($post_data),
            ));

            if (is_wp_error($response)) {

                error_log('CELP Feedback Send Failed: ' . $response->get_error_message());
                return;
            }
            
            $response_body  = wp_remote_retrieve_body($response);   
            $decoded        = json_decode($response_body, true);

            if (!wp_next_scheduled('celp_extra_data_update')) {

                wp_schedule_event(time(), 'every_30_days', 'celp_extra_data_update');
            }
            $response_body  = wp_remote_retrieve_body($response);
            $decoded        = json_decode($response_body, true);
        
        }

    }
    // CELP_cron::update_coin_exchange_data();
    new CELP_cron();
}
