<?php
/**
 * 404 page file
 *
 * @package    WordPress
 * @subpackage Floor Press
 * @author     Webinane <webinane@gmail.com>
 * @version    1.0
 */

$text = sprintf(__('It seems we can\'t find what you\'re looking for. Perhaps searching can help or go back to <a href="%s">Homepage</a>', 'deeds'), esc_html(home_url('/')));
$allowed_html = wp_kses_allowed_html( 'post' );
?>
<?php get_header();
$data = \deeds\Includes\Classes\Common::instance()->data( '404' )->get();

$options = deeds_WSH()->option();
if ( class_exists( '\Elementor\Plugin' ) AND $data->get( 'tpl-type' ) == 'e' AND $data->get( 'tpl-elementor' ) ) {
	echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $data->get( 'tpl-elementor' ) );
} else {
	?>
    <!-- <?php do_action( 'deeds_banner', $data ); ?> -->
	<section>
		<div class="gap">
			<div class="container">
				<div class="row">
					<div class="col-lg-12">
						<div class="error-page">
							<h1>4
								<i class="fas fa-cog" aria-hidden="true"></i>
								4
							</h1>
							<span><?php echo wp_kses( $options->get( '404-page_title' ), $allowed_html ) ? wp_kses( $options->get( '404-page_title' ), $allowed_html ) : esc_html_e( 'Ooops,', 'deeds' ); ?></span>

							<p><?php echo wp_kses( $options->get('404-page-text'), $allowed_html ) ? wp_kses($options->get('404-page-text' ), $allowed_html ) : $text; ?></p>
							<?php if ( $options->get('404_page_form', true ) ) : ?>
								<?php echo get_search_form(); ?>
							<?php endif; ?>
							<?php echo wp_kses( $options->get('Search_bottom_title', esc_html__('404, Not found', 'deeds')), $allowed_html ) ? '<h4>' . wp_kses( $options->get('Search_bottom_title'), $allowed_html ) . '</h4>' : ''; ?>

							<?php if ( $options->get( 'back_home_btn', true ) ) : ?>
								<a href="<?php echo( home_url( '/' ) ); ?>" class="main-btn"><?php echo wp_kses( $options->get('back_home_btn_label'), $allowed_html ) ? wp_kses( $options->get('back_home_btn_label'), $allowed_html ) : esc_html_e( 'Back To Home', 'deeds' ); ?></a>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section><!-- error page -->

	<?php
}
get_footer(); ?>
