<?php

require_once get_template_directory() . '/includes/loader.php';
require_once get_template_directory() . '/inc/theme-setup.php';

add_action('after_setup_theme', 'deeds_setup_theme');
add_action('after_setup_theme', 'deeds_load_default_hooks');

function deeds_setup_theme() {

	load_theme_textdomain('deeds', get_template_directory() . '/languages');

	// Add default posts and comments RSS feed links to head.

	/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
	*/
	add_theme_support('title-tag');
	add_theme_support('custom-header');
	add_theme_support('custom-background');

	/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	*/
	add_theme_support('post-thumbnails');
	add_theme_support('automatic-feed-links');

	// Set the default content width.
	$GLOBALS['content_width'] = 525;

	// This theme uses wp_nav_menu() in two locations.
	register_nav_menus(array(
		'main_menu' => esc_html__('Main Menu', 'deeds'),
	));

	/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
	*/
	add_theme_support('html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	));

	// Add theme support for Custom Logo.
	add_theme_support('custom-logo', array(
		'width' => 250,
		'height' => 250,
		'flex-width' => true,
	));

	// Add theme support for selective refresh for widgets.
	add_theme_support('customize-selective-refresh-widgets');

	/*
		 * This theme styles the visual editor to resemble the theme style,
		 * specifically font, colors, and column width.
	*/
	add_editor_style();
	add_action('admin_init', 'deeds_admin_init', 2000000);
}

/**
 * [deeds_widgets_init]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */
function deeds_widgets_init() {

	global $wp_registered_sidebars;

	$theme_options = get_theme_mod(deeds_NAME . '_options-mods');

	register_sidebar(array(
		'name' => esc_html__('Default Sidebar', 'deeds'),
		'id' => 'default-sidebar',
		'description' => esc_html__('Widgets in this area will be shown on the right-hand side.', 'deeds'),
		'before_widget' => '<div id="%1$s" class="%2$s widget">',
		'after_widget' => '</div>',
		'before_title' => '<div class="widget-title"><h4>',
		'after_title' => '</h4></div>',
	));

	if (!is_object(deeds_WSH())) {
		return;
	}

	$sidebars = deeds_set($theme_options, 'custom_sidebar_name');

	foreach (array_filter((array) $sidebars) as $sidebar) {

		if (deeds_set($sidebar, 'topcopy')) {
			continue;
		}

		$name = $sidebar;
		if (!$name) {
			continue;
		}
		$slug = str_replace(' ', '_', $name);

		register_sidebar(array(
			'name' => $name,
			'id' => sanitize_title($slug),
			'before_widget' => '<div id="%1$s" class="%2$s widget">',
			'after_widget' => '</div>',
			'before_title' => '<div class="widget-title"><h4>',
			'after_title' => '</h4></div>',
		));
	}

	update_option('wp_registered_sidebars', $wp_registered_sidebars);
}

add_action('widgets_init', 'deeds_widgets_init');

/**
 * [deeds_admin_init]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */

function deeds_admin_init() {
	remove_action('admin_notices', array('ReduxFramework', '_admin_notices'), 99);
}

/**
 * [deeds_set description]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */
if (!function_exists('deeds_set')) {
	function deeds_set($var, $key, $def = '') {
		//if( ! $var ) return false;

		if (is_object($var) && isset($var->$key)) {
			return $var->$key;
		} elseif (is_array($var) && isset($var[$key])) {
			return $var[$key];
		} elseif ($def) {
			return $def;
		} else {
			return false;
		}
	}
}
function deactivate_old_donation_plugin() {
	deactivate_plugins('webinane-donation/webinane-donation.php');

}
add_action('admin_init', 'deactivate_old_donation_plugin');

add_filter('acf/settings/save_json', function( $path ) {

	// update path
	$path = get_template_directory() . '/acf-json';
	// return
	return $path;

});

add_filter('acf/settings/load_json', function( $paths ) {

	// remove original path (optional)
	unset($paths[0]);

	// append path
	$paths[] = get_template_directory() . '/acf-json';

	// return
	return $paths;

});

if ( ! function_exists( 'deeds_remote_get_content' ) ) {

	function deeds_remote_get_content($file_url, $args = array()) {
		$try = wp_remote_get($file_url, $args)['body'];
		return $try;
	}

}



// Function to display the meta box content
function custom_meta_box_callback($post) {
    // Add a nonce field to check for security
    wp_nonce_field('custom_meta_box_nonce', 'custom_meta_box_nonce');

    // Retrieve the existing values from the database
    $fields = array(
        'location',
        'venue',
        'organizer',
        'category',
        'address',
        'event_start_date',
        'event_end_date',
        'phone_number',
        'fax',
        'email',
        'remaining_tickets',
        'price',
        'event_time',
    );

    foreach ($fields as $field) {
        $$field = get_post_meta($post->ID, '_' . $field, true);
    }

    // Format the dates to remove the time portion
    $event_start_date = !empty($event_start_date) ? date('Y-m-d', strtotime($event_start_date)) : '';
    $event_end_date = !empty($event_end_date) ? date('Y-m-d', strtotime($event_end_date)) : '';



    echo '<label for="event_time">Event Time:</label>';
    echo '<input type="time" id="event_time" name="event_time" value="' . esc_attr($event_time) . '" /><br>';

    // Output the field HTML
    echo '<label for="location">Location: </label>';
    echo '<input type="text" id="location" name="location" value="' . esc_attr($location) . '" size="25" /></br>';
    echo '<br>';
    echo '<label for="venue">Venue: </label>';
    echo '<input type="text" id="venue" name="venue" value="' . esc_attr($venue) . '" size="25" /><br>';

    echo '<label for="organizer">Organizer: </label>';
    echo '<input type="text" id="organizer" name="organizer" value="' . esc_attr($organizer) . '" size="25" /><br>';

    echo '<label for="category">Category: </label>';
    echo '<input type="text" id="category" name="category" value="' . esc_attr($category) . '" size="25" /><br>';

    echo '<label for="address">Address</label>';
    echo '<input type="text" id="address" name="address" value="' . esc_attr($address) . '" size="25" /><br>';

    echo '<label for="event_start_date"> Event Start Date:</label>';
    echo '<input type="date" id="event_start_date" name="event_start_date" value="' . esc_attr($event_start_date) . '" /><br>';

    echo '<label for="event_end_date">Event End Date:</label>';
    echo '<input type="date" id="event_end_date" name="event_end_date" value="' . esc_attr($event_end_date) . '" /><br>';

    echo '<label for="phone_number">Phone Number:</label>';
    echo '<input type="tel" id="phone_number" name="phone_number" value="' . esc_attr($phone_number) . '" size="25" /><br>';

    echo '<label for="fax">Fax:</label>';
    echo '<input type="tel" id="fax" name="fax" value="' . esc_attr($fax) . '" size="25" /><br>';

    echo '<label for="email">Email:</label>';
    echo '<input type="email" id="email" name="email" value="' . esc_attr($email) . '" size="25" /><br>';

    echo '<label for="remaining_tickets">Remaining Tickets:</label>';
    echo '<input type="number" id="remaining_tickets" name="remaining_tickets" value="' . esc_attr($remaining_tickets) . '" size="10" /><br>';

    echo '<label for="price">Price:</label>';
    echo '<input type="number" step="1" id="price" name="price" value="' . esc_attr($price) . '" size="10" /><br>';

    
   

}

// // Function to add the meta box
function add_custom_meta_box() {
    add_meta_box(
        'custom_meta_box',            // Unique ID
        'Event Details',            // Meta Box Title
        'custom_meta_box_callback',   // Callback function to display the meta box content
        ['event'],                       // Post type to show the meta box (change to your desired post type or a custom post type)
        'normal',                     // Context (where the meta box is displayed: 'normal', 'advanced', or 'side')
        'high'                        // Priority (order in which the meta box is displayed: 'high', 'core', 'default', or 'low')
    );
}
add_action('add_meta_boxes', 'add_custom_meta_box');

// Function to save the meta box data
function save_custom_meta_box_data($post_id) {
    // Check if the current user is authorized to save the meta box data
    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    // Verify the nonce for security
    if (!isset($_POST['custom_meta_box_nonce']) || !wp_verify_nonce($_POST['custom_meta_box_nonce'], 'custom_meta_box_nonce')) {
        return;
    }

    // Save the meta box data
    $fields = array(
        'location',
        'venue',
        'organizer',
        'category',
        'address',
        'event_start_date',
        'event_end_date',
        'phone_number',
        'fax',
        'email',
        'remaining_tickets',
        'price',
        'event_time',
    );

    foreach ($fields as $field) {
        if (isset($_POST[$field])) {
            update_post_meta($post_id, '_' . $field, sanitize_text_field($_POST[$field]));
        }
    }
}
add_action('save_post', 'save_custom_meta_box_data');




add_theme_support('woocommerce');




// Register Custom Post Type Event
function create_event_post_type() {

    $labels = array(
        'name'                  => _x( 'Events', 'Post Type General Name', 'webinane-elementor' ),
        'singular_name'         => _x( 'Event', 'Post Type Singular Name', 'webinane-elementor' ),
        'menu_name'             => __( 'Events', 'webinane-elementor' ),
        'name_admin_bar'        => __( 'Event', 'webinane-elementor' ),
        'archives'              => __( 'Event Archives', 'webinane-elementor' ),
        'attributes'            => __( 'Event Attributes', 'webinane-elementor' ),
        'parent_item_colon'     => __( 'Parent Event:', 'webinane-elementor' ),
        'all_items'             => __( 'All Events', 'webinane-elementor' ),
        'add_new_item'          => __( 'Add New Event', 'webinane-elementor' ),
        'add_new'               => __( 'Add New', 'webinane-elementor' ),
        'new_item'              => __( 'New Event', 'webinane-elementor' ),
        'edit_item'             => __( 'Edit Event', 'webinane-elementor' ),
        'update_item'           => __( 'Update Event', 'webinane-elementor' ),
        'view_item'             => __( 'View Event', 'webinane-elementor' ),
        'view_items'            => __( 'View Events', 'webinane-elementor' ),
        'search_items'          => __( 'Search Event', 'webinane-elementor' ),
        'not_found'             => __( 'Not found', 'webinane-elementor' ),
        'not_found_in_trash'    => __( 'Not found in Trash', 'webinane-elementor' ),
        'featured_image'        => __( 'Featured Image', 'webinane-elementor' ),
        'set_featured_image'    => __( 'Set featured image', 'webinane-elementor' ),
        'remove_featured_image' => __( 'Remove featured image', 'webinane-elementor' ),
        'use_featured_image'    => __( 'Use as featured image', 'webinane-elementor' ),
        'insert_into_item'      => __( 'Insert into event', 'webinane-elementor' ),
        'uploaded_to_this_item' => __( 'Uploaded to this event', 'webinane-elementor' ),
        'items_list'            => __( 'Events list', 'webinane-elementor' ),
        'items_list_navigation' => __( 'Events list navigation', 'webinane-elementor' ),
        'filter_items_list'     => __( 'Filter events list', 'webinane-elementor' ),
    );
    $args = array(
        'label'                 => __( 'Event', 'webinane-elementor' ),
        'description'           => __( 'Post Type for Events', 'webinane-elementor' ),
        'labels'                => $labels,
        'supports'              => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
        'taxonomies'            => array( 'category', 'post_tag' ),
        'hierarchical'          => false,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 5,
        'menu_icon'             => 'dashicons-analytics',
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => true,
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'capability_type'       => 'post',
        
    );
    register_post_type( 'event', $args );

}
add_action( 'init', 'create_event_post_type', 0 );

// Enable Elementor for Event Post Type
function enable_elementor_for_event( $post_types ) {
    // Add your custom post type 'event'
    $post_types[] = 'event';
    return $post_types;
}
add_filter( 'elementor_pro/utils/get_public_post_types', 'enable_elementor_for_event' );
add_filter( 'elementor/utils/get_the_public_post_types', 'enable_elementor_for_event' );

function load_slick_scripts() {
    wp_enqueue_script('jquery');
    wp_enqueue_style('slick-css', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css');
    wp_enqueue_style('slick-theme-css', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css');
    wp_enqueue_script('slick-js', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'load_slick_scripts');
add_filter('pt-ocdi/time_for_one_import', function() {
    return 600; // 10 minutes
});
add_filter('pt-ocdi/regenerate_thumbnails_in_content_import', '__return_false');