<?php

namespace deeds\Includes\Classes;


/**
 * Header and Enqueue class
 */
class Header_Enqueue {


	public static function init() {
		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'enqueue' ) );

		add_filter( 'wp_resource_hints', array( __CLASS__, 'resource_hints' ), 10, 2 );
	}

	/**
	 * Gets the arrays from method scripts and styles and process them to load.
	 * Styles are being loaded by default while scripts only enqueue and can be loaded where required.
	 *
	 * @return void This function returns nothing.
	 */
	public static function enqueue() {

		self::scripts();

		self::styles();

	}

	/**
	 * The major scripts loader to load all the scripts of the theme. Developer can hookup own scripts.
	 * All the scripts are being load in footer.
	 *
	 * @return array Returns the array of scripts to load
	 */
	public static function scripts() {
		$options = get_theme_mod( deeds_NAME . '_options-mods' );
		$ssl     = is_ssl() ? 'https' : 'http';

		$scripts = array(
			'bootstrap'         => 'assets/js/bootstrap.min.js',
			'deeds-script'     => 'assets/js/custom-scripts.js',
			'fancybox'          => 'assets/js/fancybox.min.js',
			'isotope'           => 'assets/js/isotope.min.js',
			'owl-carousel'      => 'assets/js/owl.carousel.min.js',
			'select2'      		=> 'assets/js/select2.min.js',
			'event-slick'      	=> 'assets/js/slick.min.js',
			'jquery-slk'      	=> 'assets/js/jquery-slick.js',
		);

		$scripts = apply_filters( 'deeds/includes/classes/header_enqueue/scripts', $scripts );
		/**
		 * Enqueue the scripts
		 *
		 * @var array
		 */
		foreach ( $scripts as $name => $js ) {

			if ( strstr( $js, 'http' ) || strstr( $js, 'https' ) || strstr( $js, 'googleapis.com' ) ) {

				wp_register_script( "{$name}", $js, '', '', true );
			} else {
				wp_register_script( "{$name}", get_template_directory_uri() . '/' . $js, '', '', true );
			}
		}

		wp_enqueue_script( array(
			'jquery',
			'bootstrap',
			'imagesloaded',
			'perfect-scrollbar',
			'isotope',
			'deeds-script',
		) );


		$header_data = array(
			'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
			'nonce'   => wp_create_nonce( deeds_NONCE ),
		);

		wp_localize_script( 'jquery', 'deeds_data', $header_data );

		if ( deeds_set( $options, 'footer_js' ) ) {

			wp_add_inline_script( 'jquery', deeds_set( $options, 'footer_js' ) );
		}

	}

	/**
	 * The major styles loader to load all the styles of the theme. Developer can hookup own styles.
	 * All the styles are being load in head.
	 *
	 * @return array Returns the array of styles to load
	 */
	public static function styles() {
		$styles = array(
			'google-fonts'      => self::fonts_url(),
			'bootstrap'         => 'assets/css/bootstrap.min.css',
			'owl-carousel'      => 'assets/css/owl.carousel.min.css',
			'main-style'        => 'assets/css/style.css',
			'default'           => 'assets/css/default.css',
			'responsive'        => 'assets/css/responsive.css',
			'color'             => 'assets/css/color.css',
			'slick-css'			=> 'assets/css/slick.css',
            'slick-css-deafult'	=> 'assets/css/slick-theme.css'
		);

		if( is_rtl() ) {
			$styles['main-rtl'] = 'assets/css/rtl.css';
		}

		$styles = apply_filters( 'deeds/includes/classes/header_enqueue/styles', $styles );

		/**
		 * Enqueue the styles
		 *
		 * @var array
		 */
		foreach ( $styles as $name => $style ) {

			if ( strstr( $style, 'http' ) || strstr( $style, 'https' ) || strstr( $style, 'fonts.googleapis' ) ) {
				wp_enqueue_style( "deeds-{$name}", $style );
			} else {
				wp_enqueue_style( "deeds-{$name}", get_template_directory_uri() . '/' . $style );
			}
		}
		$options      = deeds_WSH()->option();
		$custom_style = '';

		wp_add_inline_style( 'color', $custom_style );

		$header_styles = self::header_styles(); 
		
		if ( $custom_font = $options->get('theme_custom_font') ) {
            $header_styles .= deeds_custom_fonts_load( $custom_font );
        }

		wp_add_inline_style( 'deeds-main-style', $header_styles );

		if( $options->get('theme_preloader') ) {
			wp_enqueue_style('deeds_preloader', get_template_directory_uri().'/assets/css/loader.min.css');
		}

	}

	/**
	 * Register custom fonts.
	 */
	public static function fonts_url() {
		$fonts_url = '';

		$font_families['PT Serif']      = 'PT Serif:400,400i,700,700i';
		$font_families['Muli']      = 'Muli:200,300,400,500,600,700';

		$font_families['Poppins']     = 'Poppins:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
		$font_families['Lato']        = 'Lato:400,400i';

		$font_families = apply_filters( 'deeds/includes/classes/header_enqueue/font_families', $font_families );

		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( 'latin,latin-ext' ),
		);

		$protocol  = is_ssl() ? 'https' : 'http';
		$fonts_url = add_query_arg( $query_args, $protocol . '://fonts.googleapis.com/css' );

		return esc_url_raw($fonts_url);
	}


	/**
	 * Add preconnect for Google Fonts.
	 *
	 * @since deeds 1.0
	 *
	 * @param array  $urls          URLs to print for resource hints.
	 * @param string $relation_type The relation type the URLs are printed.
	 *
	 * @return array $urls           URLs to print for resource hints.
	 */
	public static function resource_hints( $urls, $relation_type ) {
		if ( wp_style_is( 'deeds-fonts', 'queue' ) && 'preconnect' === $relation_type ) {
			$urls[] = array(
				'href' => 'https://fonts.gstatic.com',
				'crossorigin',
			);
		}

		return $urls;
	}

	/**
	 * header_styles
	 *
	 * @since deeds 1.0
	 *
	 * @param array $urls URLs to print for resource hints.
	 */
	public static function header_styles() {

		$data = \deeds\Includes\Classes\Common::instance()->data( 'blog' )->get();

		$options = deeds_WSH()->option();

		$styles = '';
		if ( $options->get( 'footer_top_button' ) ) :
			$styles .= "#topcontrol {
				background: " . $options->get( 'button_bg' ) . " none repeat scroll 0 0 !important;
				opacity: 0.5;

				color: " . $options->get( 'button_color' ) . " !important;

			}";

		endif;

		$settings = get_theme_mod( deeds_NAME . '_options-mods' );

		if ( $custom_font = deeds_set( $settings, 'theme_custom_font' ) ) {

			$styles .= apply_filters('deeds_redux_custom_fonts_load', $custom_font );


		}

		return $styles;
	}


}