<?php

return array(
	'title'      => esc_html__( 'Footer Setting', 'deeds' ),
	'id'         => 'footer_setting',
	'desc'       => '',
	'subsection' => false,
	'fields'     => array(
		array(
			'id'      => 'footer_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Footer Source Type', 'deeds' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'deeds' ),
				'e' => esc_html__( 'Elementor', 'deeds' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => 'footer_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'deeds' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page'	=> -1
			],
			'required' => [ 'footer_source_type', '=', 'e' ],
		),

		array(
			'id'       => 'footer_default_st',
			'type'     => 'section',
			'title'    => esc_html__( 'Footer Default', 'deeds' ),
			'indent'   => true,
			'required' => [ 'footer_source_type', '=', 'd' ],
		),
		array(
			'id'      => 'footer_background',
			'type'    => 'media',
			'title'   => esc_html__( 'Footer Background', 'deeds' ),
			'default' => array( 'url' => deeds_URI . 'assets/images/parallax.png' ),
		),
		array(
			'id'    => 'footer_social_share',
			'type'  => 'social_profiles',
			'title' => esc_html__( 'Social Profiles', 'deeds' ),
		),
		array(
			'id'      => 'copyright_text',
			'type'    => 'textarea',
			'title'   => __( 'Copyright Text', 'deeds' ),
			'desc'    => esc_html__( 'Enter the Copyright Text', 'deeds' ),
			'default' => 'Webinane Themes © 2019',
		),
		array(
			'id'       => 'footer_js',
			'type'     => 'ace_editor',
			'title'    => esc_html__( 'Footer Javascript', 'deeds' ),
			'subtitle' => esc_html__( 'Enter javascript code to add in page footer section', 'deeds' ),
			'mode'     => 'javascript',
			'theme'    => 'monokai',
		),
		array(
			'id'       => 'footer_default_ed',
			'type'     => 'section',
			'indent'   => false,
			'required' => [ 'footer_source_type', '=', 'd' ],
		),
	),
);
