<?php
/**
 * Tag Main File.
 *
 * @package deeds
 * @author  Webinane
 * @version 1.0
 */

get_header();
global $wp_query;
$data  = \deeds\Includes\Classes\Common::instance()->data( 'search' )->get();
$class = ( $data->get( 'layout' ) != 'full' ) ? 'col-xs-12 col-sm-12 col-md-12 col-lg-8' : 'col-xs-12 col-sm-12 col-md-12';

if ( class_exists( '\Elementor\Plugin' ) AND $data->get( 'tpl-type' ) == 'e' AND $data->get( 'tpl-elementor' ) ) {
	echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $data->get( 'tpl-elementor' ) );
} else {
    do_action( 'deeds_banner', $data );
	?>
	<section>
		<div class="gap">
			<div class="container">
				<div class="row blog-page">
					<?php
					if ( $data->get( 'layout' ) == 'left' ) {
						do_action( 'deeds_sidebar', $data );
					}
					?>
					<div class="<?php echo esc_attr( $class ); ?>">
						<?php if( have_posts() ) : ?>
							<?php
							while ( have_posts() ) :
								the_post();
								deeds_template_load( 'templates/blog/blog.php', compact( 'data' ) );
							endwhile;
							deeds_the_pagination( $wp_query->max_num_pages );
							?>
						<?php else : ?>
							<div class="search-notfound">
								<h4>
									<?php printf(esc_html__( 'No result found for "%s"', 'deeds' ), get_search_query()); ?>
								</h4>
								<p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'deeds' ); ?></p>
								<?php get_search_form() ?>
							</div>
							
						<?php endif; ?>
					</div>
					<?php
					if ( $data->get( 'layout' ) == 'right' ) {
						do_action( 'deeds_sidebar', $data );
					}
					?>
				</div>
			</div>
		</div>
	</section>
	<?php
}
get_footer();

