<?php
/**
 * Footer Template  File
 *
 * @package deeds
 * @author  Webiane
 * @version 1.0
 */

$options = deeds_WSH()->option();
$back    = $options->get( 'footer_background' );
$back    = deeds_set( $back, 'url', deeds_URI . 'assets/images/parallax.png' );
$allowed_html = wp_kses_allowed_html( 'post' );

// Get footer background style
$footer_style = '';
if ( ! empty( $back ) ) {
	$footer_style = 'style="background-image: url(' . esc_url( $back ) . ');"';
}
?>
<footer class="site-footer" <?php echo $footer_style; ?>>

	<div class="container">
		<div class="footer-data text-center">
			<?php
			$icons = $options->get( 'footer_social_share' );
			
			if ( ! empty( $icons ) && is_array( $icons ) ) :
				?>
				<div class="social-links2">
					<?php
					foreach ( $icons as $idx => $arr ) :
						// Check if icon is enabled according to Redux social_profiles documentation
						if ( isset( $arr['enabled'] ) && ! empty( $arr['enabled'] ) ) :
							$id = deeds_set( $arr, 'id', '' );
							$class = deeds_set( $arr, 'class', '' );
							$url = deeds_set( $arr, 'url', '#' );
							$icon = deeds_set( $arr, 'icon', 'fa-link' );
							$color = deeds_set( $arr, 'color', '#fff' );
							$background = deeds_set( $arr, 'background', '#333' );
							?>
							<a class="instagram-hvr wow zoomIn <?php echo esc_attr( $class . ' ' . $id ); ?>" data-wow-delay="1s" data-wow-duration=".5s" href="<?php echo esc_url( $url ); ?>" target="_blank" style="background-color:<?php echo esc_attr( $background ); ?>; color: <?php echo esc_attr( $color ); ?>"><i class="<?php echo esc_attr( $icon ); ?>"></i></a>
						<?php endif;
					endforeach;
					?>
				</div>
			<?php endif; ?>
			<p>
				<?php echo wp_kses( $options->get( 'copyright_text', 'Webinane Themes &copy 2019' ), $allowed_html ); ?>
			</p>
		</div><!-- Footer Data -->
	</div>

</footer>

<?php
// Output footer JavaScript if set
$footer_js = $options->get( 'footer_js' );
if ( ! empty( $footer_js ) ) :
	?>
	<script type="text/javascript">
		<?php echo wp_kses_post( $footer_js ); ?>
	</script>
	<?php
endif;
?>
