<?php

/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     1.6.4
 */

defined('ABSPATH') || exit;

get_header('shop');

$options = deeds_WSH()->option();
$banner_settings = $options->get('banner_title');
$banner_background = $options->get('page_background');
$banner_background_url = isset($banner_background['url']) ? $banner_background['url'] : '';

?>

<div class="container product-page-container">
    <div class="deeds-banner-section" style="background-image: url('<?php echo esc_url($banner_background_url); ?>');">
    </div>

    <div class="row">
        <div class="col-lg-6 product-left-column product-gallery-images">
            <?php
            while (have_posts()):
                the_post();

                if (has_post_thumbnail()) {
                    $product = wc_get_product(get_the_ID());
                    $image_id = $product->get_image_id();
                    if ($image_id) {
                        $featured_image_url = wp_get_attachment_image_url($image_id, 'woocommerce_single'); // 433x433 by default for single product images
                        ?>
                        <img id="featured-image" src="<?php echo esc_url($featured_image_url); ?>" alt="Featured Image" class="img-fluid">
                        <?php
                    }
                }

                // Get total sales for the product
                $total_sales = $product->get_total_sales();
            endwhile;
            ?>

            <?php
            $gallery = $product->get_gallery_attachment_ids();
            $attachment_count = count($gallery);
            ?>
            <ul class="nav nav-tabs" id="galleryTab">
                <?php
                if ($attachment_count > 0):
                    $counter2 = 1;
                    foreach ($gallery as $id) {
                        // Get the 433x433 size for the gallery images as well
                        $img_url = wp_get_attachment_image_url($id, 'woocommerce_single'); // Ensuring 433x433 for gallery images
                        ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $counter2 === 1 ? 'active' : ''; ?>" id="tab<?php echo $counter2; ?>"
                               data-toggle="tab" href="#image<?php echo $counter2; ?>" role="tab">
                                <img src="<?php echo esc_url($img_url); ?>" alt="Gallery Image" class="img-fluid gallery-thumbnail">
                            </a>
                        </li>
                        <?php
                        $counter2++;
                    }
                endif;
                ?>
            </ul>

        </div>

        <div class="col-lg-6 product-right-column product-price">
            <div class="license-tabs">
                <div class="tab-content" id="licenseTabContent">
                    <div class="tab-pane fade show active" id="single-license" role="tabpanel">
                        <?php
                        woocommerce_template_single_price();
                        woocommerce_template_single_title();
                        woocommerce_template_single_rating();
                        ?>
                        <span>Quantity</span>
                        <?php
                        $single_license_price = get_post_meta(get_the_ID(), 'single_license_price', true);
                        if ($single_license_price) {
                            echo '<div class="price">' . wc_price($single_license_price) . '</div>';
                        }
                        woocommerce_template_single_add_to_cart();
                        ?>
                    </div>

                    <div class="tab-pane fade" id="extended-license" role="tabpanel">
                        <?php
                        woocommerce_template_single_price();
                        woocommerce_template_single_rating();
                        $extended_license_price = get_post_meta(get_the_ID(), 'extended_license_price', true);
                        if ($extended_license_price) {
                            echo '<div class="price">' . wc_price($extended_license_price) . '</div>';
                        }
                        woocommerce_template_single_add_to_cart();
                        ?>
                    </div>
                </div>
            </div>

            <div class="addon_parent">
                <h3 class="custom-product-features-title"><?php echo $product_addon_title; ?></h3>
                <?php
                $product_info = get_post_meta(get_the_ID(), '_product_info', true);
                if (!empty($product_info)) {
                    echo wpautop($product_info);
                } else {
                    woocommerce_template_single_excerpt();
                }
                ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12 product-detail">
            <ul class="nav nav-tabs" id="productTabs" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="item-details-tab" data-toggle="tab" href="#item-details" role="tab"
                       aria-controls="item-details" aria-selected="true">Description</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="reviews-tab" data-toggle="tab" href="#reviews" role="tab"
                       aria-controls="reviews" aria-selected="false">Reviews</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="comments-tab" data-toggle="tab" href="#products_comments" role="tab"
                       aria-controls="products_comments" aria-selected="false">Comments</a>
                </li>
            </ul>

            <div class="tab-content" id="productTabContent">
                <div class="tab-pane fade show active" id="item-details" role="tabpanel" aria-labelledby="item-details-tab">
                    <?php the_content(); ?>
                </div>

                <div class="tab-pane fade" id="reviews" role="tabpanel" aria-labelledby="reviews-tab">
                    <?php comments_template('single-product-reviews.php'); ?>
                </div>

                <div class="tab-pane fade" id="products_comments" role="tabpanel" aria-labelledby="comments-tab">
                    <?php
                    $product_id = get_the_ID();
                    $args = array(
                        'post_id' => $product_id,
                        'status' => 'approve',
                        'type' => 'comment',
                        'meta_query' => array(
                            array(
                                'key' => 'rating',
                                'compare' => 'NOT EXISTS'
                            )
                        )
                    );
                    $comments = get_comments($args);

                    if ($comments) {
                        echo '<h3>Comments</h3>';
                        echo '<ul class="comment-list">';
                        wp_list_comments(array('style' => 'ul', 'short_ping' => true, 'avatar_size' => 50), $comments);
                        echo '</ul>';
                    } else {
                        echo '<p>No comments yet.</p>';
                    }

                    $comment_form_args = array(
                        'title_reply' => 'Leave a Comment',
                        'comment_field' => '<p class="comment-form-comment"><label for="comment">Comment</label> <textarea id="comment" name="comment" cols="45" rows="8" required></textarea></p>',
                        'label_submit' => 'Post Comment',
                        'comment_notes_before' => '<p class="comment-notes">Your email address will not be published. Required fields are marked <span class="required">*</span></p>',
                    );

                    comment_form($comment_form_args, $product_id);
                    ?>
                </div>
            </div>
        </div>
    </div>

    <div class="related-products">
        <?php woocommerce_output_related_products(); ?>
    </div>
</div>

<script type="text/javascript">
    jQuery(document).ready(function($) {
        $('#galleryTab a').click(function(e) {
            e.preventDefault();
            var newImage = $(this).find('img').attr('src');
            $('#featured-image').attr('src', newImage); // Use full-size image for the featured area
        });
    });
</script>

<?php
do_action('woocommerce_after_single_product');
get_footer('shop');
?>
