<?php

if ( ! function_exists( 'dor_mikado_meta_boxes_map_after_setup_theme' ) ) {
	function dor_mikado_meta_boxes_map_after_setup_theme() {
		/**
		 * Loades all meta-boxes by going through all folders that are placed directly in meta-boxes folder
		 * and loads map.php file in each.
		 *
		 * @see https://php.net/manual/en/function.glob.php
		 */
		do_action( 'dor_mikado_action_before_meta_boxes_map' );
		
		foreach ( glob( MIKADO_FRAMEWORK_ROOT_DIR . '/admin/meta-boxes/*/map.php' ) as $meta_box_load ) {
			include_once $meta_box_load;
		}
		
		do_action( 'dor_mikado_action_meta_boxes_map' );
		
		do_action( 'dor_mikado_action_after_meta_boxes_map' );
	}
	
	add_action( 'after_setup_theme', 'dor_mikado_meta_boxes_map_after_setup_theme', 1 );
}

if ( ! function_exists( 'dor_mikado_meta_boxes_map_init' ) ) {
    function dor_mikado_meta_boxes_map_init() {

        do_action( 'dor_mikado_action_meta_boxes_map_on_init_action' );

    }

    add_action( 'init', 'dor_mikado_meta_boxes_map_init', 1 );
}