<?php

if ( ! function_exists( 'dor_mikado_map_post_audio_meta' ) ) {
	function dor_mikado_map_post_audio_meta() {
		$audio_post_format_meta_box = dor_mikado_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Audio Post Format', 'dor' ),
				'name'  => 'post_format_audio_meta'
			)
		);
		
		dor_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_audio_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Audio Type', 'dor' ),
				'description'   => esc_html__( 'Choose audio type', 'dor' ),
				'parent'        => $audio_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Audio Service', 'dor' ),
					'self'            => esc_html__( 'Self Hosted', 'dor' )
				)
			)
		);
		
		$mkdf_audio_embedded_container = dor_mikado_add_admin_container(
			array(
				'parent' => $audio_post_format_meta_box,
				'name'   => 'mkdf_audio_embedded_container'
			)
		);
		
		dor_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_audio_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio URL', 'dor' ),
				'description' => esc_html__( 'Enter audio URL', 'dor' ),
				'parent'      => $mkdf_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_audio_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		dor_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_audio_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio Link', 'dor' ),
				'description' => esc_html__( 'Enter audio link', 'dor' ),
				'parent'      => $mkdf_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_audio_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'dor_mikado_action_meta_boxes_map', 'dor_mikado_map_post_audio_meta', 23 );
}