<?php

if ( ! function_exists( 'dor_mikado_logo_meta_box_map' ) ) {
	function dor_mikado_logo_meta_box_map() {

		$logo_meta_box = dor_mikado_create_meta_box(
			array(
				'scope' => apply_filters( 'dor_mikado_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'logo_meta' ),
				'title' => esc_html__( 'Logo', 'dor' ),
				'name'  => 'logo_meta'
			)
		);

        dor_mikado_create_meta_box_field(
            array(
                'parent'        => $logo_meta_box,
                'type'          => 'select',
                'name'          => 'mkdf_logo_source_meta',
                'default_value' => '',
                'label'         => esc_html__( 'Select Logo Source', 'dor' ),
                'description'   => esc_html__( 'Choose whether you would like to use logo as image or text', 'dor' ),
                'options'       => array(
                    ''     => esc_html__('Default', 'dor'),
                    'image' => esc_html__( 'Image', 'dor' ),
                    'text' => esc_html__( 'Text', 'dor' )
                )
            )
        );

        $image_logo_container = dor_mikado_add_admin_container(
            array(
                'parent'          => $logo_meta_box,
                'name'            => 'image_logo_container',
                'dependency' => array(
                    'hide' => array(
                        'mkdf_logo_source_meta'  => 'text'
                    )
                )
            )
        );

		dor_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_logo_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Logo Image - Default', 'dor' ),
				'description' => esc_html__( 'Choose a default logo image to display ', 'dor' ),
				'parent'      => $image_logo_container
			)
		);

		dor_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_logo_image_dark_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Logo Image - Dark', 'dor' ),
				'description' => esc_html__( 'Choose a default logo image to display ', 'dor' ),
				'parent'      => $image_logo_container
			)
		);

		dor_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_logo_image_light_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Logo Image - Light', 'dor' ),
				'description' => esc_html__( 'Choose a default logo image to display ', 'dor' ),
				'parent'      => $image_logo_container
			)
		);

		dor_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_logo_image_sticky_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Logo Image - Sticky', 'dor' ),
				'description' => esc_html__( 'Choose a default logo image to display ', 'dor' ),
				'parent'      => $image_logo_container
			)
		);

		dor_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_logo_image_mobile_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Logo Image - Mobile', 'dor' ),
				'description' => esc_html__( 'Choose a default logo image to display ', 'dor' ),
				'parent'      => $image_logo_container
			)
		);

        dor_mikado_create_meta_box_field(
            array(
                'parent'      => $logo_meta_box,
                'type'        => 'text',
                'name'        => 'mkdf_logo_text_meta',
                'label'       => esc_html__( 'Logo Text', 'dor' ),
                'description' => esc_html__( 'Enter your logo text', 'dor' ),
                'dependency' => array(
                    'hide' => array(
                        'mkdf_logo_source_meta'  => 'image'
                    )
                )
            )
        );

        dor_mikado_create_meta_box_field(
			array(
				'parent'      => $logo_meta_box,
				'type'        => 'text',
				'name'        => 'mkdf_logo_text_font_size_meta',
				'label'       => esc_html__( 'Logo Text Font Size (px)', 'dor' ),
				'description' => esc_html__( 'Enter font size for your logo text', 'dor' ),
				'args'        => array(
					'col_width' => 2,
					'suffix'    => esc_html__( 'px', 'dor' )
				),
				'dependency' => array(
					'hide' => array(
						'mkdf_logo_source_meta'  => 'image'
					)
				)
			)
		);

        dor_mikado_create_meta_box_field(
            array(
                'parent'      => $logo_meta_box,
                'type'        => 'color',
                'name'        => 'mkdf_logo_text_color_meta',
                'label'       => esc_html__( 'Logo Text Color', 'dor' ),
                'description' => esc_html__( 'Choose color for your logo text', 'dor' ),
                'dependency' => array(
                    'hide' => array(
                        'mkdf_logo_source_meta'  => 'image'
                    )
                )
            )
        );

		dor_mikado_create_meta_box_field(
			array(
				'parent'      => $logo_meta_box,
				'type'        => 'text',
				'name'        => 'mkdf_mobile_logo_text_meta',
				'label'       => esc_html__( 'Mobile Logo Text', 'dor' ),
				'description' => esc_html__( 'Enter your logo text for mobile device', 'dor' ),
				'dependency' => array(
					'hide' => array(
						'mkdf_logo_source_meta'  => 'image'
					)
				)
			)
		);
	}
	
	add_action( 'dor_mikado_action_meta_boxes_map', 'dor_mikado_logo_meta_box_map', 47 );
}