<?php

if ( ! function_exists( 'dor_mikado_register_search_post_type_widget' ) ) {
	/**
	 * Function that register search opener widget
	 */
	function dor_mikado_register_search_post_type_widget( $widgets ) {
		$widgets[] = 'DorMikadoClassSearchPostType';
		
		return $widgets;
	}
	
	add_filter( 'dor_core_filter_register_widgets', 'dor_mikado_register_search_post_type_widget' );
}

if ( ! function_exists( 'dor_mikado_search_post_types' ) ) {
	function dor_mikado_search_post_types() {
		
		if ( empty( $_POST ) || ! isset( $_POST ) ) {
			dor_mikado_ajax_status( 'error', esc_html__( 'All fields are empty', 'dor' ) );
		} else {
			check_ajax_referer( 'mkdf_search_post_types_nonce', 'search_post_types_nonce' );

			$args = array(
				'post_type'      => $_POST['postType'],
				'post_status'    => 'publish',
				'order'          => 'DESC',
				'orderby'        => 'date',
				's'              => $_POST['term'],
				'posts_per_page' => 5
			);
			
			$html  = '';
			$query = new WP_Query( $args );
			
			if ( $query->have_posts() ) {
				$html .= '<ul>';
					while ( $query->have_posts() ) {
						$query->the_post();
						$html .= '<li><a href="' . get_the_permalink() . '">' . get_the_title() . '</a></li>';
					}
				$html              .= '</ul>';
				$json_data['html'] = $html;
				dor_mikado_ajax_status( 'success', '', $json_data );
			} else {
				$html              .= '<ul>';
					$html              .= '<li>' . esc_html__( 'No posts found.', 'dor' ) . '</li>';
				$html              .= '</ul>';
				$json_data['html'] = $html;
				dor_mikado_ajax_status( 'success', '', $json_data );
			}
		}
		
		wp_die();
	}
	
	add_action( 'wp_ajax_dor_mikado_search_post_types', 'dor_mikado_search_post_types' );
    add_action( 'wp_ajax_nopriv_dor_mikado_search_post_types', 'dor_mikado_search_post_types' );
}