<?php
class DorMikadoElementorProductInfo extends \Elementor\Widget_Base {

	public function get_name() {
		return 'mkdf_product_info'; 
	}

	public function get_title() {
		return esc_html__( 'Product Info', 'dor' );
	}

	public function get_icon() {
		return 'dor-elementor-custom-icon dor-elementor-product-info';
	}

	public function get_categories() {
		return [ 'mikado' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'dor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'product_id',
			[
				'label'     => esc_html__( 'Selected Product', 'dor' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'If you left this field empty then product ID will be of the current page', 'dor' )
			]
		);

		$this->add_control(
			'product_info_type',
			[
				'label'     => esc_html__( 'Product Info Type', 'dor' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'title' => esc_html__( 'Title', 'dor'), 
					'featured_image' => esc_html__( 'Featured Image', 'dor'), 
					'category' => esc_html__( 'Category', 'dor'), 
					'excerpt' => esc_html__( 'Excerpt', 'dor'), 
					'price' => esc_html__( 'Price', 'dor'), 
					'rating' => esc_html__( 'Rating', 'dor'), 
					'add_to_cart' => esc_html__( 'Add To Cart', 'dor'), 
					'tag' => esc_html__( 'Tag', 'dor'), 
					'author' => esc_html__( 'Author', 'dor'), 
					'date' => esc_html__( 'Date', 'dor')
				),
				'default' => 'title'
			]
		);

		$this->add_control(
			'featured_image_size',
			[
				'label'     => esc_html__( 'Featured Image Proportions', 'dor' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'dor'), 
					'full' => esc_html__( 'Original', 'dor'), 
					'dor_mikado_image_square' => esc_html__( 'Square', 'dor'), 
					'dor_mikado_image_landscape' => esc_html__( 'Landscape', 'dor'), 
					'dor_mikado_image_portrait' => esc_html__( 'Portrait', 'dor'), 
					'medium' => esc_html__( 'Medium', 'dor'), 
					'large' => esc_html__( 'Large', 'dor'), 
					'woocommerce_single' => esc_html__( 'Shop Single', 'dor'), 
					'woocommerce_thumbnail' => esc_html__( 'Shop Thumbnail', 'dor')
				),
				'default' => 'full',
				'condition' => [
					'product_info_type' => array( 'featured_image' )
				]
			]
		);

		$this->add_control(
			'add_to_cart_skin',
			[
				'label'     => esc_html__( 'Add To Cart Skin', 'dor' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'dor'), 
					'white' => esc_html__( 'White', 'dor'), 
					'dark' => esc_html__( 'Dark', 'dor')
				),
				'default' => '',
				'condition' => [
					'product_info_type' => array( 'add_to_cart' )
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'product_info_style',
			[
				'label' => esc_html__( 'Product Info Style', 'dor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'product_info_color',
			[
				'label'     => esc_html__( 'Product Info Color', 'dor' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'product_info_type' => array( 'title', 'category', 'excerpt', 'price', 'rating', 'tag', 'author', 'date' )
				]
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'dor' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'Set title tag for product title element', 'dor' ),
				'options' => array(
					'' => esc_html__( 'Default', 'dor'), 
					'h1' => esc_html__( 'h1', 'dor'), 
					'h2' => esc_html__( 'h2', 'dor'), 
					'h3' => esc_html__( 'h3', 'dor'), 
					'h4' => esc_html__( 'h4', 'dor'), 
					'h5' => esc_html__( 'h5', 'dor'), 
					'h6' => esc_html__( 'h6', 'dor'), 
					'p' => esc_html__( 'p', 'dor')
				),
				'default' => 'h2',
				'condition' => [
					'product_info_type' => array( 'title' )
				]
			]
		);

		$this->add_control(
			'category_tag',
			[
				'label'     => esc_html__( 'Category Tag', 'dor' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'Set category tag for product category element', 'dor' ),
				'options' => array(
					'' => esc_html__( 'Default', 'dor'), 
					'h1' => esc_html__( 'h1', 'dor'), 
					'h2' => esc_html__( 'h2', 'dor'), 
					'h3' => esc_html__( 'h3', 'dor'), 
					'h4' => esc_html__( 'h4', 'dor'), 
					'h5' => esc_html__( 'h5', 'dor'), 
					'h6' => esc_html__( 'h6', 'dor')
				),
				'default' => '',
				'condition' => [
					'product_info_type' => array( 'category' )
				]
			]
		);

		$this->add_control(
			'add_to_cart_size',
			[
				'label'     => esc_html__( 'Add To Cart Size', 'dor' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'dor'), 
					'small' => esc_html__( 'Small', 'dor'), 
					'medium' => esc_html__( 'Medium', 'dor'), 
					'large' => esc_html__( 'Large', 'dor')
				),
				'default' => '',
				'condition' => [
					'product_info_type' => array( 'dor' )
				]
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();
		extract($params);

	    $params['product_id'] = !empty($params['product_id']) ? $params['product_id'] : get_the_ID();
	    $params['title_tag'] = !empty($params['title_tag']) ? $params['title_tag'] : 'h2';
	    $params['category_tag'] = !empty($params['category_tag']) ? $params['category_tag'] : '';
	    $params['product_info_style'] = $this->getProductInfoStyle($params);
		    
		$html = '';
			$html .= '<div class="mkdf-product-info">';

	            switch ($product_info_type) {
		            case 'title':
			            $html .= $this->getItemTitleHtml($params);
			            break;
		            case 'featured_image':
			            $html .= $this->getItemFeaturedImageHtml($params);
			            break;
		            case 'category':
			            $html .= $this->getItemCategoryHtml($params);
			            break;
		            case 'excerpt':
			            $html .= $this->getItemExcerptHtml($params);
			            break;
		            case 'price':
			            $html .= $this->getItemPriceHtml($params);
			            break;
		            case 'rating':
			            $html .= $this->getItemRatingHtml($params);
			            break;
		            case 'add_to_cart':
			            $html .= $this->getItemAddToCartHtml($params);
			            break;
		            case 'tag':
			            $html .= $this->getItemTagHtml($params);
			            break;
		            case 'author':
			            $html .= $this->getItemAuthorHtml($params);
			            break;
		            case 'date':
			            $html .= $this->getItemDateHtml($params);
			            break;
		            default:
			            $html .= $this->getItemTitleHtml($params);
			            break;
	            }

			$html .= '</div>';

        echo dor_mikado_get_module_part($html);
	}

	private function getProductInfoStyle( $params ) {
		$styles = array();
		
		if ( ! empty( $params['product_info_color'] ) ) {
			$styles[] = 'color: ' . $params['product_info_color'];
		}
		
		return $styles;
	}

	public function getItemTitleHtml( $params ) {
		$html               = '';
		$product_id         = $params['product_id'];
		$title              = get_the_title( $product_id );
		$title_tag          = $params['title_tag'];
		$product_info_style = $params['product_info_style'];
		
		if ( ! empty( $title ) ) {
			$html = '<' . dor_mikado_escape_title_tag( $title_tag ) . ' itemprop="name" class="mkdf-pi-title entry-title" ' . dor_mikado_get_inline_style( $product_info_style ) . '>';
				$html .= '<a itemprop="url" href="' . esc_url( get_the_permalink( $product_id ) ) . '">' . esc_html( $title ) . '</a>';
			$html .= '</' . dor_mikado_escape_title_tag( $title_tag ) . '>';
		}
		
		return $html;
	}

	public function getItemFeaturedImageHtml( $params ) {
		$html                = '';
		$product_id          = $params['product_id'];
		$featured_image_size = ! empty( $params['featured_image_size'] ) ? $params['featured_image_size'] : 'full';
		$featured_image      = get_the_post_thumbnail( $product_id, $featured_image_size );
		
		if ( ! empty( $featured_image ) ) {
			$html = '<a itemprop="url" class="mkdf-pi-image" href="' . esc_url( get_the_permalink( $product_id ) ) . '">' . $featured_image . '</a>';
		}
		
		return $html;
	}

	public function getItemCategoryHtml( $params ) {
		$html               = '';
		$product_id         = $params['product_id'];
		$categories         = wp_get_post_terms( $product_id, 'product_cat' );
		$product_info_style = $params['product_info_style'];
		
		if ( ! empty( $categories ) ) {
			$html .= '<div class="mkdf-pi-category">';
				foreach ( $categories as $cat ) {
					if ( ! empty( $params['category_tag'] ) ) {
						$html .= '<' . dor_mikado_escape_title_tag( $params['category_tag'] ) . ' ' . dor_mikado_get_inline_style( $product_info_style ) . '>';
						$html .= '<a itemprop="url" class="mkdf-pi-category-item" href="' . esc_url( get_term_link( $cat->term_id ) ) . '">' . esc_html( $cat->name ) . '</a>';
						$html .= '</' . dor_mikado_escape_title_tag( $params['category_tag'] ) . '>';
					} else {
						$html .= '<a itemprop="url" class="mkdf-pi-category-item" href="' . esc_url( get_term_link( $cat->term_id ) ) . '" ' . dor_mikado_get_inline_style( $product_info_style ) . '>' . esc_html( $cat->name ) . '</a>';
					}
				}
			$html .= '</div>';
		}
		
		return $html;
	}

	public function getItemExcerptHtml( $params ) {
		$html               = '';
		$product_id         = $params['product_id'];
		$excerpt            = get_the_excerpt( $product_id );
		$product_info_style = $params['product_info_style'];
		
		if ( ! empty( $excerpt ) ) {
			$html = '<div class="mkdf-pi-excerpt"><p itemprop="description" class="mkdf-pi-excerpt-item" ' . dor_mikado_get_inline_style( $product_info_style ) . '>' . esc_html( $excerpt ) . '</p></div>';
		}
		
		return $html;
	}

	public function getItemPriceHtml( $params ) {
		$html               = '';
		$product_id         = $params['product_id'];
		$product            = wc_get_product( $product_id );
		$product_info_style = $params['product_info_style'];
		
		if ( $price_html = $product->get_price_html() ) {
			$html = '<div class="mkdf-pi-price" ' . dor_mikado_get_inline_style( $product_info_style ) . '>' . $price_html . '</div>';
		}
		
		return $html;
	}

	public function getItemRatingHtml( $params ) {
		$html               = '';
		$product_id         = $params['product_id'];
		$product            = wc_get_product( $product_id );
		$product_info_style = $params['product_info_style'];
		
		if ( get_option( 'woocommerce_enable_review_rating' ) !== 'no' ) {
			$average = $product->get_average_rating();
			
			$html = '<div class="mkdf-pi-rating" title="' . sprintf( esc_attr__( "Rated %s out of 5", "dor" ), $average ) . '" ' . dor_mikado_get_inline_style( $product_info_style ) . '><span style="width:' . ( ( $average / 5 ) * 100 ) . '%"></span></div>';
		}
		
		return $html;
	}

	public function getItemAddToCartHtml( $params ) {
		$product_id = $params['product_id'];
		$product    = wc_get_product( $product_id );
		
		$button_classes = 'button add_to_cart_button ajax_add_to_cart mkdf-btn mkdf-btn-solid';
		
		if ( ! $product->is_in_stock() ) {
			$button_classes = 'button ajax_add_to_cart mkdf-btn mkdf-btn-solid mkdf-out-of-stock';
		} else if ( $product->get_type() === 'variable' ) {
			$button_classes = 'button product_type_variable add_to_cart_button mkdf-btn mkdf-btn-solid';
		} else if ( $product->get_type() === 'external' ) {
			$button_classes = 'button product_type_external mkdf-btn mkdf-btn-solid';
		}
		
		if ( ! empty( $params['add_to_cart_skin'] ) ) {
			$button_classes .= ' mkdf-' . $params['add_to_cart_skin'] . '-skin mkdf-btn-custom-hover-color mkdf-btn-custom-hover-bg mkdf-btn-custom-border-hover';
		}
		
		if ( ! empty( $params['add_to_cart_size'] ) ) {
			$button_classes .= ' mkdf-btn-' . $params['add_to_cart_size'];
		}
		
		$html = '<div class="mkdf-pi-add-to-cart">';
		$html .= apply_filters( 'dor_mikado_filter_product_info_add_to_cart_link',
			sprintf( '<a rel="nofollow" href="%s" data-quantity="%s" data-product_id="%s" data-product_sku="%s" class="%s">%s</a>',
				esc_url( $product->add_to_cart_url() ),
				esc_attr( isset( $quantity ) ? $quantity : 1 ),
				esc_attr( $product_id ),
				esc_attr( $product->get_sku() ),
				esc_attr( $button_classes ),
				esc_html( $product->add_to_cart_text() )
			),
			$product );
		$html .= '</div>';
		
		return $html;
	}

	public function getItemTagHtml( $params ) {
		$html               = '';
		$product_id         = $params['product_id'];
		$tags               = wp_get_post_terms( $product_id, 'product_tag' );
		$product_info_style = $params['product_info_style'];
		
		if ( ! empty( $tags ) ) {
			$html = '<div class="mkdf-pi-tag">';
				foreach ( $tags as $tag ) {
					$html .= '<a itemprop="url" class="mkdf-pi-tag-item" href="' . esc_url( get_term_link( $tag->term_id ) ) . '" ' . dor_mikado_get_inline_style( $product_info_style ) . '>' . esc_html( $tag->name ) . '</a>';
				}
			$html .= '</div>';
		}
		
		return $html;
	}

	public function getItemAuthorHtml( $params ) {
		$html               = '';
		$product_id         = $params['product_id'];
		$product_post       = get_post( $product_id );
		$autor_id           = $product_post->post_author;
		$author             = get_the_author_meta( 'display_name', $autor_id );
		$product_info_style = $params['product_info_style'];
		
		if ( ! empty( $author ) ) {
			$html = '<div class="mkdf-pi-author" ' . dor_mikado_get_inline_style( $product_info_style ) . '>' . esc_html( $author ) . '</div>';
		}
		
		return $html;
	}

	public function getItemDateHtml( $params ) {
		$html               = '';
		$product_id         = $params['product_id'];
		$date               = get_the_time( get_option( 'date_format' ), $product_id );
		$product_info_style = $params['product_info_style'];
		
		if ( ! empty( $date ) ) {
			$html = '<div class="mkdf-pi-date" ' . dor_mikado_get_inline_style( $product_info_style ) . '>' . esc_html( $date ) . '</div>';
		}
		
		return $html;
	}
	
}

if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new DorMikadoElementorProductInfo() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new DorMikadoElementorProductInfo() );
}