<?php

add_action('vc_load_default_templates_action', 'pix_init_wpb_templates'); // Hook in
if (!function_exists('pix_all_wpb_templates')) {
    function pix_all_wpb_templates() {
        require_once('intros.php');
        require_once('features.php');
        require_once('content.php');
        require_once('headings.php');
        require_once('blog.php');
        require_once('portfolio.php');
        require_once('shop.php');
        require_once('pricing.php');
        require_once('pages.php');
        require_once('cta.php');
        require_once('faq.php');
        require_once('maps.php');
        require_once('clients.php');
        require_once('tabs.php');
        require_once('sliders.php');
        require_once('testimonials.php');
        require_once('accordion.php');
        require_once('video.php');
        require_once('reviews.php');
        require_once('gallery.php');
        require_once('forms.php');
        require_once('marquee.php');
        require_once('team.php');
        require_once('image_carousel.php');
        require_once('links.php');
        require_once('countdown.php');
        require_once('numbers.php');
        require_once('404.php');
        require_once('stories.php');
        require_once('miscellaneous.php');
        require_once('footers.php');

        $templates = array();
		try {
			//code...
		
        $templates = array_merge($templates, pix_templates_intros());
        $templates = array_merge($templates, pix_templates_features());
        $templates = array_merge($templates, pix_templates_content());
        $templates = array_merge($templates, pix_templates_headings());
        $templates = array_merge($templates, pix_templates_blog());
        $templates = array_merge($templates, pix_templates_portfolio());
        $templates = array_merge($templates, pix_templates_shop());
        $templates = array_merge($templates, pix_templates_pricing());
        $templates = array_merge($templates, pix_templates_cta());
        $templates = array_merge($templates, pix_templates_pages());
        $templates = array_merge($templates, pix_templates_faq());
        $templates = array_merge($templates, pix_templates_maps());
        $templates = array_merge($templates, pix_templates_clients());
        $templates = array_merge($templates, pix_templates_tabs());
        $templates = array_merge($templates, pix_templates_sliders());
        $templates = array_merge($templates, pix_templates_testimonials());
        $templates = array_merge($templates, pix_templates_accordion());
        $templates = array_merge($templates, pix_templates_video());
        $templates = array_merge($templates, pix_templates_reviews());
        $templates = array_merge($templates, pix_templates_gallery());
        $templates = array_merge($templates, pix_templates_forms());
        $templates = array_merge($templates, pix_templates_marquee());
        $templates = array_merge($templates, pix_templates_team());
        $templates = array_merge($templates, pix_templates_image_carousel());
        $templates = array_merge($templates, pix_templates_links());
        $templates = array_merge($templates, pix_templates_countdown());
        $templates = array_merge($templates, pix_templates_numbers());
        $templates = array_merge($templates, pix_templates_404());
        $templates = array_merge($templates, pix_templates_stories());
        $templates = array_merge($templates, pix_templates_footers());
	} catch (\Throwable $th) {
		//throw $th;
	}
        return $templates;
    }
}
if (!function_exists('pix_init_wpb_templates')) {
    function pix_init_wpb_templates() {
        $templates = pix_all_wpb_templates();
        foreach ($templates as $key => $value) {
            vc_add_default_templates($value);
        }
    }
}

if (!function_exists('pix_get_templates_wpb_thumbs')) {
    function pix_get_templates_wpb_thumbs() {
        $templates = pix_all_wpb_templates();
        $result = array();
        foreach ($templates as $key => $value) {
            $name = strtolower($value['name']);
            $name = str_replace(' ', '-', $name);
            $result[$name] = $value['image_path'];
        }
        return $result;
    }
}

// After VC Init
add_action('vc_after_init', 'vc_after_init_actions');

function vc_after_init_actions() {
	// Enable VC by default on a list of Post Types
	if (function_exists('vc_set_default_editor_post_types')) {
		$list = [
			'page',
			'post',
			'pixfooter',
			'portfolio',
			'pixpopup'
		];
		vc_set_default_editor_post_types($list);
	}
}