<?php

add_action('pixfort_location_header', 'pixDefaultHeader', 10, 2);

if (!function_exists('pixDefaultHeader')) {
    function pixDefaultHeader() {
        $displayDefaultHeader = true;
        if ( is_user_logged_in() && current_user_can( 'administrator' ) ) {
            if (defined('PIXFORT_PLUGIN_VERSION')) {
                if (version_compare(PIXFORT_PLUGIN_VERSION, PIXFORT_THEME_VERSION, '<')) {
                    echo '<div class="alert bg-primary m-0 text-white rounded-0">Please make sure to update pixfort core plugin to the latest version from <strong>Essentials Dashboard → Install Plugins</strong> (This message is displayed for logged-in admin users only).</div>';
                }
            }
        }
        if (defined('PIXFORT_PLUGIN_VERSION')) {
            if (version_compare(PIXFORT_PLUGIN_VERSION, '3.2.14', '>=')) {
                $displayDefaultHeader = false;
            }
        }
        if ($displayDefaultHeader) {
?>
        <header data-area="header" id="masthead" class="bg-white pixfort-header-area pixfort-area-content pix-header pix-header-desktop d-block pix-header-normal pix-scroll-shadow  header-scroll pix-header-container-area">
            <div class="container">
                <div class="pix-row d-flex justify-content-between">
                    <nav data-col="header" class="pixfort-header-col navbar pix-main-menu navbar-hover-drop navbar-expand-lg navbar-light">
                        <?php echo pix_get_header_logo([]); ?>
                        <?php echo pix_get_header_menu(['disable_mega' => true]); ?>
                    </nav>
                </div>
            </div>
        </header>
    <?php
        }
    }
}


/**
 * Header Logo element
 */
if (! function_exists('pix_get_header_logo')) {
    function pix_get_header_logo($opts) {
        extract(shortcode_atts(array(
            'height'         => '',
            'width'         => '',
            'width'         => '',
            'color'         => 'body-default',
            'custom_color'         => '',
            'area'             => '',
            'animation'             => 'slide-in-up',
            'logo_img'             => '',
            'logo_scroll_img'             => '',
            'custom_url'             => '',
            'target'             => '',
        ), $opts));
        $max = '';
        $classes = '';
        $themeDefault = false;
        if (!empty($target)) $target = '_blank';
        
        $classes .= 'text-heading-default';
        $themeDefault = true;
        
        $link = home_url('/');
        if (!empty($custom_url)) {
            $link = $custom_url;
        }
        $custom_logo_url = false;
        $scroll_logo_url = false;
        $logo_class = '';

        $imgWidth = '';
        $imgHeight = '';
        $imgWidthMobile = '';
        $imgHeightMobile = '';

        $custom_logo_img = false;
        $altText = get_bloginfo('name');

        if (pix_get_option('scroll-logo-img') && pix_get_option('scroll-logo-img')['url']) {
            $custom_logo_img_scroll = pix_get_option('scroll-logo-img');
            $scroll_logo_url = $custom_logo_img_scroll['url'];
            $logo_class = 'pix-logo';
            // if(!empty($custom_logo_img_scroll['height'])){
            //     $imgHeightScroll = $custom_logo_img_scroll['height'];
            // }
            // if(!empty($custom_logo_img_scroll['width'])){
            //     $imgWidthScroll = $custom_logo_img_scroll['width'];
            // }
        }
        if (!empty($logo_scroll_img) && $logo_scroll_img != '') {
            $scroll_logo_url = $logo_scroll_img;
            $logo_class = 'pix-logo';
        }
        if (!empty($area) && ($area == 'm_header' || $area == 'm_stack' || $area == 'm_topbar') && pix_get_option('mobile-logo-img') && pix_get_option('mobile-logo-img')['url']) {
            $custom_logo_img_mobile = pix_get_option('mobile-logo-img');
            $custom_logo_url = $custom_logo_img_mobile['url'];
            if (!empty($custom_logo_img_mobile['height'])) {
                $imgHeightMobile = (int) $custom_logo_img_mobile['height'];
            }
            if (!empty($custom_logo_img_mobile['width'])) {
                $imgWidthMobile = (int) $custom_logo_img_mobile['width'];
                if (empty($width) && !empty($height)) {
                    $width = (int) $height * ($imgWidthMobile / $imgHeightMobile);
                }
            }
            if (!empty($custom_logo_img_mobile['alt'])) {
                $altText = $custom_logo_img_mobile['alt'];
            }
        } else {
            if (pix_get_option('logo-img') && pix_get_option('logo-img')['url']) {
                $custom_logo_img = pix_get_option('logo-img');
                $custom_logo_url = $custom_logo_img['url'];
            }
            if (!empty($custom_logo_img['height'])) {
                $imgHeight = (int) $custom_logo_img['height'];
            }
            if (!empty($custom_logo_img['width'])) {
                $imgWidth = (int) $custom_logo_img['width'];
                if (empty($width) && !empty($height)) {
                    $width = (int) $height * ($imgWidth / $imgHeight);
                }
            }
            if (!empty($custom_logo_img['alt'])) {
                $altText = $custom_logo_img['alt'];
            }
        }

        if (!empty($logo_img)) {
            $custom_logo_url = $logo_img;
        }

        if (empty($height)) {
            if (!empty($custom_logo_url)) {
                $max = 'max-width:180px;';
            }
        }
        $animation_class = 'animate-in';
        $animation_div_class = '';
        if ($animation == 'disabled') {
            $animation_class = '';
        } elseif ($animation == 'slide-in-up') {
            $animation_class .= ' slide-in-container';
            $animation_div_class = 'slide-in-container';
        }

    ?>
        <div class="<?php echo esc_attr($animation_div_class); ?> d-flex align-items-center">
            <div class="d-inline-block <?php echo esc_attr($animation_class); ?>" data-anim-type="<?php echo esc_attr($animation); ?>" style="<?php echo esc_attr($max); ?>">
                <?php
                $img_style = '';
                $heightVal = '';
                $widthVal = '';
                if (!empty($height) && $height != '') {
                    if (is_numeric($height)) {
                        $height .= 'px';
                    }
                    $img_style = 'height:' . $height . ';width:auto;';
                    $heightVal = preg_replace("/[^0-9]/", "", $height);
                }
                if (!empty($width) && $width != '') {
                    $widthVal = preg_replace("/[^0-9.]/", "", $width);
                }
                if ($themeDefault) {
                ?>
                    <h3 class="site-title"><strong><a class="navbar-brand pix-header-text font-weight-bold text-24 pix-mr-20 <?php echo esc_attr($classes); ?>" href="<?php echo esc_url($link); ?>" rel="home"><?php echo esc_html($altText); ?></a></strong></h3>
                    <?php
                } else {
                    if (!empty($area) && ($area == 'm_header' || $area == 'm_stack' || $area == 'm_topbar') && (pix_get_option('mobile-logo-img') && pix_get_option('mobile-logo-img')['url'] || !empty($custom_logo_url))) {
                    ?>
                        <a class="navbar-brand" href="<?php echo esc_url($link); ?>" target="<?php echo esc_attr($target); ?>" rel="home">
                            <img class="<?php echo esc_attr($logo_class); ?>" src="<?php echo esc_url($custom_logo_url); ?>" alt="<?php echo esc_attr($altText); ?>" height="<?php echo esc_attr($heightVal); ?>" width="<?php echo esc_attr($widthVal); ?>" style="<?php echo esc_attr($img_style); ?>">
                            <?php
                            if ($scroll_logo_url) {
                            ?>
                                <img class="pix-logo-scroll" src="<?php echo esc_url($scroll_logo_url); ?>" alt="<?php bloginfo('name'); ?>" style="<?php echo esc_attr($img_style); ?>">
                            <?php
                            }
                            ?>
                        </a>
                        <?php

                    } else {
                        if ($custom_logo_url && !empty($custom_logo_url)) {

                        ?>
                            <a class="navbar-brand" href="<?php echo esc_url($link); ?>" target="<?php echo esc_attr($target); ?>" rel="home">
                                <img class="<?php echo esc_attr($logo_class); ?>" height="<?php echo esc_attr($heightVal); ?>" width="<?php echo esc_attr($widthVal); ?>" src="<?php echo esc_url($custom_logo_url); ?>" alt="<?php echo esc_attr($altText); ?>" style="<?php echo esc_attr($img_style); ?>">
                                <?php
                                if ($scroll_logo_url && $area == 'header') {
                                ?>
                                    <img class="pix-logo-scroll" src="<?php echo esc_url($scroll_logo_url); ?>" alt="<?php bloginfo('name'); ?>" style="<?php echo esc_attr($img_style); ?>">
                                <?php
                                }
                                ?>
                            </a>
                        <?php
                        } else {
                        ?>
                            <h3 class="site-title"><strong><a class="navbar-brand pix-header-text font-weight-bold text-24 pix-mr-20 <?php echo esc_attr($classes); ?>" href="<?php echo esc_url($link); ?>" rel="home"><?php bloginfo('name'); ?></a></strong></h3>
                <?php
                        }
                    }
                }

                ?>
            </div>
        </div>
        <?php
    }
}

/**
 * Header Menu element
 */
if (! function_exists('pix_get_header_menu')) {
    function pix_get_header_menu($opts) {
        extract(shortcode_atts(array(
            'size'         => 'mx-2',
            'color'     => 'dark-opacity-4',
            'is_right_float'                     => '',
            'custom_color'                     => '',
            'scroll_color'                     => '',
            'menu'                     => 'menu-1',
            'area'                     => '',
            'menu_style'                     => '',
            'hidden_state'                     => false,
            'drop_bg'                     => 'white',
            'dark_mode'                     => '',
            'nav_line_color'                     => '',
            'nav_scroll_line_color'                     => '',
            'active_line'                     => '',
            'dropdown_angle'                     => '',
            'is_bold'                     => '',
            'nav_id'                     => false,
        ), $opts));
        if ($area != 'header' && $area != 'm_header') {
        ?>
            <nav class="navbar navbar-hover-drop navbar-expand-lg navbar-light p-0">
            <?php
        }
        if (empty($nav_id)) {
            if (defined('PIX_DEMO')) {
                $nav_id = 'pixfort-' . $area . '-' . $menu . '-' . $drop_bg;
            } else {
                $nav_id = rand(10, 1000);
            }
        }


        $desktop_areas = array('topbar', 'header', 'stack');
        $isMobile = false;
        if (!in_array($area, $desktop_areas)) {
            $isMobile = true;
            ?>
                <button class="navbar-toggler hamburger--spin hamburger small-menu-toggle" type="button" data-toggle="collapse" data-target="#navbarNav-<?php echo esc_attr($nav_id); ?>" aria-controls="navbarNav-<?php echo esc_attr($nav_id); ?>" aria-expanded="false" aria-label="<?php echo esc_attr__('Toggle navigation', 'essentials'); ?>">
                    <span class="hamburger-box">

                        <span class="hamburger-inner bg-<?php echo esc_attr($color); ?>">
                            <span class="hamburger-inner-before bg-<?php echo esc_attr($color); ?>"></span>
                            <span class="hamburger-inner-after bg-<?php echo esc_attr($color); ?>"></span>
                        </span>

                    </span>
                </button>
            <?php
        }
        $menu_classes = '';

        if (!empty($dropdown_angle)) {
            $angleColor = '';
            if (!empty($color)) {
                if ($color == 'custom') {
                    $angleColor = 'color: ' . $custom_color . ';';
                } else {
                    $angleColor = 'color: var(--pix-' . $color . ');';
                }
            }
            $menuDropdownIcon = '#navbarNav-' . $nav_id . ' > ul > li > .pix-nav-link.dropdown-toggle > span:before {
                ' . $angleColor . '
            }';
            if (!empty($scroll_color)) {
                $menuDropdownIcon .= '.is-scroll #navbarNav-' . $nav_id . ' > ul > li > .pix-nav-link.dropdown-toggle > span:before {
                    color: var(--pix-' . $scroll_color . ') !important;
                }';
            }
            $menu_classes .= 'pix-nav-dropdown-angle' . ' ';
            wp_register_style('pix-header-menu-handle', false);
            wp_enqueue_style('pix-header-menu-handle');
            wp_add_inline_style('pix-header-menu-handle', $menuDropdownIcon);
        }




        if (!empty($nav_scroll_line_color)) {
            // echo $nav_scroll_line_color;
            // $custom_under_scroll_line = '.is-scroll #navbarNav-'.$nav_id.' .nav-style-megamenu>li.nav-item .nav-link span:after { background: '.$nav_scroll_line_color.' !important; }';
            // wp_register_style( 'pix-header-menu-handle', false );
            // wp_enqueue_style( 'pix-header-menu-handle' );
            // wp_add_inline_style( 'pix-header-menu-handle', $custom_under_scroll_line );
            $menu_classes .= $nav_scroll_line_color . ' ';
        }
        $menu_classes .= $nav_line_color . ' ';
        $menu_classes .= $active_line . ' ';
        if (!empty($is_right_float)) {
            if ($is_right_float === true) {
                $menu_classes .= 'justify-content-end ';
            } else {
                $menu_classes .= 'justify-content-' . $is_right_float . ' ';
            }
        }
        if (!empty($dark_mode)) {
            $menu_classes .= 'pix-is-dark ';
        }
        $opts['isMobile'] = $isMobile;
        require_once(get_template_directory() . '/inc/bootstrap-wp-navwalker.php');
        $menuArgs = array(
            'depth'             => 5,
            'container_class' => 'collapse navbar-collapse align-self-stretch ' . $menu_classes,
            'container_id' => 'navbarNav-' . $nav_id,
            'menu_class' => 'navbar-nav nav-style-megamenu align-self-stretch align-items-center ',
            'fallback_cb' => '',
            'echo' => true,
            'menu' => $menu,
            'walker' => new wp_bootstrap_navwalker($opts)
        );
        if (in_array($area, $desktop_areas)) {
            if ($menu_style == 'hidden') {
                if (!empty($hidden_state) && $hidden_state) $hidden_state = 'menu-hidden-state';
                $menuBtn = '<li class="toggle-btn-item"><a class="hamburger--spin hamburger normal-menu-toggle d-flex ' . esc_attr($hidden_state) . '" href="#" data-target="#navbarNav-' . esc_attr($nav_id) . '" aria-label="' . esc_attr__('Toggle navigation', 'essentials') . '">
                    <span class="hamburger-box">
                        <span class="hamburger-inner bg-' . esc_attr($color) . '">
                            <span class="hamburger-inner-before bg-' . esc_attr($color) . '"></span>
                            <span class="hamburger-inner-after bg-' . esc_attr($color) . '"></span>
                        </span>
                    </span>
                </a></li>';
                if ($is_right_float === 'end') {
                    $menuArgs['items_wrap'] = '<ul id="%1$s" class="%2$s pix-menu-toggle-style">%3$s ' . $menuBtn . '</ul>';
                } else {
                    $menuArgs['items_wrap'] = '<ul id="%1$s" class="%2$s pix-menu-toggle-style">' . $menuBtn . '%3$s</ul>';
                }
            }
        }
        wp_nav_menu(
            $menuArgs
        );



        if ($area != 'header' && $area != 'm_header') {
            ?>
            </nav>
<?php
        }
    }
}
