<?php

namespace EXMAGE\Admin;

use EXMAGE\EXMAGEEnv;
use EXMAGE\Includes\EXMAGEDATA;

defined( 'ABSPATH' ) || exit;

class EXMAGESettings {
	protected static $instance = null;

	protected $dropdown_class        = 'vi-ui dropdown fluid exmage-dropdown';
	protected $dropdown_search_class = 'vi-ui dropdown search fluid exmage-dropdown';
	protected $settings;

	public static function instance() {
		return self::$instance == null ? self::$instance = new self() : self::$instance;
	}

	public function __construct() {
		$this->settings = EXMAGEDATA::instance();

		add_action( 'exmage_pre_update_settings', [ $this, 'exmage_pre_merge_update_settings' ], 10, 2 );

		EXMAGESettings_Helper::config( [ 'slug' => 'EXMAGE', 'data' => EXMAGEDATA::instance() ] );

	}

	public function render_page() {
		$tabs      = $this->define_tabs();
		$first_tab = array_key_first( $tabs );
		?>
        <div class="wrap">
            <h1>
				<?php printf( "%s %s", esc_html( EXMAGEEnv::get( 'plugin_name' ) ), esc_html__( 'Settings', 'exmage-wordpress-image-links' ) ); ?>
            </h1>
            <form method="post" id="exmage-settings-form" class="vi-ui form">
				<?php wp_nonce_field( 'exmage-nonce-settings', 'exmage-nonce-settings' ); ?>

                <div class="vi-ui top attached tabular menu">
					<?php
					foreach ( $tabs as $slug => $text ) {
						$active = $first_tab == $slug ? 'active' : '';
						printf( ' <a class="item %s" data-tab="%s">%s</a>', esc_attr( $active ), esc_attr( $slug ), esc_html( $text ) );
					}
					?>
                </div>
				<?php
				foreach ( $tabs as $slug => $text ) {
					$active = $first_tab == $slug ? 'active' : '';
					$method = $slug . '_options';

					printf( '<div class="vi-ui bottom attached %s tab segment" data-tab="%s">', esc_attr( $active ), esc_attr( $slug ) );
					do_action( 'exmage_settings_pre_tab_content_' . $slug );
					if ( method_exists( $this, $method ) ) {
						$options = $this->$method();
						EXMAGESettings_Helper::output_fields( $options );
					} else {
						$custom_method = $slug . '_settings';
						if ( method_exists( $this, $custom_method ) ) {
							$this->$custom_method();
						} else {
							do_action( 'exmage_settings_tab', $slug );
						}
					}

					echo '</div>';
				}
				?>
                <p class="exmage-save-settings-container">
                    <button type="submit" class="vi-ui button labeled icon primary exmage-save-settings"
                            name="exmage_save_settings" value="save_setting">
                        <i class="save icon"></i>
						<?php esc_html_e( 'Save', 'exmage-wordpress-image-links' ); ?>
                    </button>
                    <button type="submit" class="vi-ui button labeled icon exmage-save-settings" name="exmage_save_check">
                        <i class="send icon"></i>
						<?php esc_html_e( 'Save & Check Key', 'exmage-wordpress-image-links' ); ?>
                    </button>
                </p>
            </form>
        </div>
		<?php
		do_action( 'villatheme_support_exmage-wordpress-image-links' );
	}

	public function define_tabs() {
		return [
			'general'     => esc_html__( 'General', 'exmage-wordpress-image-links' ),
			'video'       => esc_html__( 'Video', 'exmage-wordpress-image-links' ),
			'ai_engine'   => esc_html__( 'AI Engine', 'exmage-wordpress-image-links' ),
			'cdn_uploads' => esc_html__( 'CDN Uploads', 'exmage-wordpress-image-links' ),
			'update'      => esc_html__( 'Update', 'exmage-wordpress-image-links' ),
		];
	}

	public function general_options() {
		$placeholder_replace_image = $this->settings->get_param( 'placeholder_replace_image' );
		$placeholder_src           = $placeholder_replace_image ? wp_get_attachment_image_url( $placeholder_replace_image ) : EXMAGEEnv::get( 'img_url' ) . 'add-photo-bigger.svg';

		$placeholder_media_block = sprintf( '<div class="exmage-upload-icon-wrap">
                                        <input type="hidden" name="EXMAGE_placeholder_replace_image" class="exmage-upload-icon" value="%s"/>
                                        <span class="exmage-upload-icon-preview"><img alt="Icon" src="%s" data-src_placeholder="%s"/></span>' .// phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
		                                    '<i class="exmage-upload-icon-remove times circle outline icon%s"></i>
                                        <span class="exmage-upload-icon-add-new">%s</span>
                                    </div>',
			esc_attr( $placeholder_replace_image ),
			esc_url( $placeholder_src ),
			EXMAGEEnv::get( 'img_url' ) . 'add-photo-bigger.svg',
			esc_attr( $placeholder_replace_image ? '' : ' exmage-hidden' ),
			esc_html__( 'Upload / Add image', 'exmage-wordpress-image-links' ) );

		$options = [
			[
				'type' => 'section_start',
			],
			[
				'id'    => 'enable',
				'title' => esc_html__( 'Enable', 'exmage-wordpress-image-links' ),
				'type'  => 'checkbox',
			],
			[
				'id'    => 'enable_replace_media_after_deactive_plugin',
				'title' => esc_html__( 'Enable Replace media after deactivated', 'exmage-wordpress-image-links' ),
				'type'  => 'checkbox',
				'desc'  => esc_html__( 'Enables the ability to replace images uploaded by Exmage after the plugin is disabled.', 'exmage-wordpress-image-links' ),
			],
			[
				'id'       => 'placeholder_replace_image',
				'title'    => esc_html__( 'Placeholder image', 'exmage-wordpress-image-links' ),
				'type'     => 'media',
				'html'     => $placeholder_media_block,
				'rowClass' => 'placeholder_replace_image',
				'desc'     => esc_html__( 'The placeholder image will replace the image uploaded by Exmage after the plugin is deactivated.', 'exmage-wordpress-image-links' ),
			],

			[ 'type' => 'section_end' ],
		];

		return $options;
	}

	public function video_options() {

		$options = [
			[
				'type' => 'section_start',
			],
			[
				'id'    => 'enable_video',
				'title' => esc_html__( 'Enable', 'exmage-wordpress-image-links' ),
				'type'  => 'checkbox',
			],
			[
				'id'    => 'enable_thumbnail_video',
				'title' => esc_html__( 'Enable Set thumbnail video', 'exmage-wordpress-image-links' ),
				'type'  => 'checkbox',
			],
			[
				'id'    => 'enable_set_feature_video_for_post',
				'title' => esc_html__( 'Enable Set Feature Video For Post', 'exmage-wordpress-image-links' ),
				'type'  => 'checkbox',
				'desc'  => esc_html__( 'Enable Set Feature Video For Post', 'exmage-wordpress-image-links' ),
			],

			[
				'type' => 'section_end',
			],
			[
				'type' => 'section_start',
			],

			[ 'type' => 'section_end' ],
		];

		return $options;
	}

	public function ai_engine_options() {

		$options_model = [
			'General' => [
				'disable' => esc_html__( 'Disable', 'exmage-wordpress-image-links' ),
			],
			'Google'  => [
				'gemini-1.5-flash'     => esc_html__( 'Gemini 1.5 Flash', 'exmage-wordpress-image-links' ),
				'gemini-1.5-flash-8b'  => esc_html__( 'Gemini 1.5 Flash-8B', 'exmage-wordpress-image-links' ),
				'gemini-1.5-pro'       => esc_html__( 'Gemini 1.5 Pro', 'exmage-wordpress-image-links' ),
				'gemini-2.0-flash-exp' => esc_html__( 'Gemini 2.0 Flash (Experimental)', 'exmage-wordpress-image-links' ),
			],
			'OpenAI'  => [
				'gpt-4o'                 => esc_html__( 'GPT 4o', 'exmage-wordpress-image-links' ),
				'gpt-4-turbo'            => esc_html__( 'GPT 4 Turbo', 'exmage-wordpress-image-links' ),
				'gpt-4'                  => esc_html__( 'GPT 4', 'exmage-wordpress-image-links' ),
				'gpt-3.5-turbo-16k'      => esc_html__( 'GPT 3.5 Turbo 16k', 'exmage-wordpress-image-links' ),
				'gpt-3.5-turbo'          => esc_html__( 'GPT 3.5 Turbo', 'exmage-wordpress-image-links' ),
				'gpt-3.5-turbo-instruct' => esc_html__( 'GPT 3.5 Turbo Instruct', 'exmage-wordpress-image-links' ),
			]
		];
		$options       = [
			[
				'type' => 'section_start',
			],
			[
				'id'      => 'ai_model',
				'title'   => esc_html__( 'AI Model', 'exmage-wordpress-image-links' ),
				'type'    => 'opt_select',
				'options' => $options_model,
				'class'   => $this->dropdown_class,
			],
			[
				'id'       => 'ai_gemini_api_key',
				'title'    => esc_html__( 'Google AI API Key (Gemini)', 'exmage-wordpress-image-links' ),
				'type'     => 'text',
				'rowClass' => 'ai_gemini_api_key',
			],

			[
				'id'       => 'ai_openai_api_key',
				'title'    => esc_html__( 'Open AI API Key (Chat GPT)', 'exmage-wordpress-image-links' ),
				'type'     => 'text',
				'rowClass' => 'ai_openai_api_key',
			],
			[
				'id'           => 'check_ai_engine',
				'title'        => esc_html__( 'Test AI Engine', 'exmage-wordpress-image-links' ),
				'type'         => 'button',
				'labeled_text' => esc_html__( 'Test AI Engine', 'exmage-wordpress-image-links' ),
				'class'        => 'vi-ui button primary exmage-check-ai-engine-settings',
				'rowClass'     => 'check_ai_engine',
				'notice'       => wp_kses_post( '<span class="exmage-test-notice"></span>' ),
				'desc'         => esc_html__( 'Check AI Engine API is working', 'exmage-wordpress-image-links' ),
			],
			[
				'type' => 'section_end'
			],
			[
				'type'  => 'section_start',
				'title' => esc_html__( 'ALT Text Instructions', 'exmage-wordpress-image-links' ),
				'desc'  => esc_html__( 'EXMAGE will create ALT attributes using AI, based on the image content and the settings you\'ve configured below.', 'exmage-wordpress-image-links' ),
			],
			[
				'id'    => 'ai_alt_exclude_image_exist_alt',
				'title' => esc_html__( 'No alt-text images only', 'exmage-wordpress-image-links' ),
				'type'  => 'checkbox',
				'desc'  => esc_html__( 'Exclude images that already have alt text', 'exmage-wordpress-image-links' ),
			],
			[
				'id'       => 'ai_command_min_characters',
				'title'    => esc_html__( 'Min characters', 'exmage-wordpress-image-links' ),
				'type'     => 'number',
				'rowClass' => 'ai_command_min_characters',
				'desc'     => esc_html__( 'Alt text length range. Control the minimum number of characters for the AI-generated ALT text', 'exmage-wordpress-image-links' ),
			],
			[
				'id'       => 'ai_command_max_characters',
				'title'    => esc_html__( 'Max characters', 'exmage-wordpress-image-links' ),
				'type'     => 'number',
				'rowClass' => 'ai_command_max_characters',
				'desc'     => esc_html__( 'Set a maximum number of characters as you need. For example, keep it under 80 for SEO best practices, or allow more if you want richer descriptions.', 'exmage-wordpress-image-links' ),
			],
			[
				'id'       => 'ai_command_writing_style',
				'title'    => esc_html__( 'Writing style', 'exmage-wordpress-image-links' ),
				'type'     => 'text',
				'rowClass' => 'ai_command_writing_style',
				'desc'     => esc_html__( 'Define how you want the description to sound. E.g. Simple - Clear and minimal; Descriptive - More detailed and informative; or Captivating - Engaging, vivid language', 'exmage-wordpress-image-links' ),
			],
			[
				'id'       => 'ai_command_writing_tone',
				'title'    => esc_html__( 'Writing tone', 'exmage-wordpress-image-links' ),
				'type'     => 'text',
				'rowClass' => 'ai_command_writing_tone',
				'desc'     => esc_html__( 'Tone of voice. Set the overall tone for the generated ALT text.', 'exmage-wordpress-image-links' ),
			],
			[
				'id'       => 'ai_render_alt_mess',
				'title'    => esc_html__( '"Alt Image" prompt', 'exmage-wordpress-image-links' ),
				'type'     => 'textarea',
				'classRow' => 'ai_render_alt_mess',
				'desc'     => ( $this->description_prompt() ),
			],
			[
				'type' => 'section_end',
			]

		];

		return $options;
	}

	public function cdn_uploads_options() {

		$options_cdn = [
			'disable'    => esc_html__( 'Disable', 'exmage-wordpress-image-links' ),
			'cloudinary' => esc_html__( 'Cloudinary', 'exmage-wordpress-image-links' ),
			'cloudflare' => esc_html__( 'Cloudflare', 'exmage-wordpress-image-links' ),
			'aws'        => esc_html__( 'AWS Amazon', 'exmage-wordpress-image-links' ),
		];
		$options     = [
			[
				'type' => 'section_start',
			],
			[
				'id'      => 'cdn_type',
				'title'   => esc_html__( 'Choose CDN type', 'exmage-wordpress-image-links' ),
				'type'    => 'select',
				'options' => $options_cdn,
				'class'   => $this->dropdown_class,
			],
			[
				'id'       => 'cloudinary_api_key',
				'title'    => esc_html__( 'Cloudinary API Key ', 'exmage-wordpress-image-links' ),
				'type'     => 'text',
				'desc'     => esc_html__( 'Find your API Key in Cloudinary Dashboard under Settings → API', 'exmage-wordpress-image-links' ),
				'rowClass' => 'cloudinary_cdn',
			],
			[
				'id'       => 'cloudinary_api_secret',
				'title'    => esc_html__( 'Cloudinary API Secret', 'exmage-wordpress-image-links' ),
				'type'     => 'text',
				'desc'     => esc_html__( 'Get your API Secret in Cloudinary Dashboard under Settings → API', 'exmage-wordpress-image-links' ),
				'rowClass' => 'cloudinary_cdn',
			],
			[
				'id'       => 'cloudinary_cloud_name',
				'title'    => esc_html__( 'Cloudinary Clound Name', 'exmage-wordpress-image-links' ),
				'type'     => 'text',
				'desc'     => esc_html__( 'Your Cloudinary cloud name is shown in Settings → API section', 'exmage-wordpress-image-links' ),
				'rowClass' => 'cloudinary_cdn',
			],
			[
				'id'       => 'cloudinary_upload_preset',
				'title'    => esc_html__( 'Cloudinary Upload Preset', 'exmage-wordpress-image-links' ),
				'type'     => 'text',
				'desc'     => esc_html__( 'Find or create an Upload Preset in Settings → Upload and copy its name', 'exmage-wordpress-image-links' ),
				'rowClass' => 'cloudinary_cdn',
			],
			[
				'id'       => 'cloudflare_account_id',
				'title'    => esc_html__( 'Cloudflare Account ID', 'exmage-wordpress-image-links' ),
				'desc'     => sprintf( esc_html__( 'Go to your Cloudflare dashboard → R2 Storage → copy your Account ID from the Overview tab. %s', 'exmage-wordpress-image-links' ), '<a href="https://dash.cloudflare.com/" target="_blank">Read more</a>' ),
				'type'     => 'text',
				'rowClass' => 'cloudflare_cdn',
			],
			[
				'id'       => 'cloudflare_access_key',
				'title'    => esc_html__( 'Cloudflare Access Key', 'exmage-wordpress-image-links' ),
				'type'     => 'text',
				'desc'     => sprintf( esc_html__( 'Go to R2 → Manage API Tokens → create or view an existing API token to get the Access Key and Secret Key. %s', 'exmage-wordpress-image-links' ), '<a href="https://dash.cloudflare.com/?to=/:account/r2/api-tokens" target="_blank">Read more</a>' ),
				'rowClass' => 'cloudflare_cdn',
			],
			[
				'id'    => 'cloudflare_secret_key',
				'title' => esc_html__( 'Cloudflare Secret Key', 'exmage-wordpress-image-links' ),
				'type'  => 'text',
				'desc'  => sprintf( esc_html__( 'Go to R2 → Manage API Tokens → create or view an existing API token to get the Access Key and Secret Key. %s', 'exmage-wordpress-image-links' ), '<a href="https://dash.cloudflare.com/?to=/:account/r2/api-tokens" target="_blank">Read more</a>' ),

				'rowClass' => 'cloudflare_cdn',
			],
			[
				'id'       => 'cloudflare_bucket_name',
				'title'    => esc_html__( 'Cloudflare Bucket Name', 'exmage-wordpress-image-links' ),
				'desc'     => sprintf( esc_html__( 'When creating a bucket in R2 Storage, you’ll assign a name — that’s your Bucket Name. %s', 'exmage-wordpress-image-links' ), '<a href="https://dash.cloudflare.com/?to=/:account/r2/buckets" target="_blank">Read more</a>' ),
				'type'     => 'text',
				'rowClass' => 'cloudflare_cdn',
			],
			[
				'id'       => 'cloudflare_public_development_url',
				'title'    => esc_html__( 'Cloudflare Public Development URL', 'exmage-wordpress-image-links' ),
				'type'     => 'text',
				'desc'     => sprintf( esc_html__( 'Public Bucket is a feature that allows users to expose the contents of their R2 buckets directly to the Internet. %s', 'exmage-wordpress-image-links' ), '<a href="https://developers.cloudflare.com/r2/buckets/public-buckets/#managed-public-buckets-through-r2dev" target="_blank">Read more</a>' ),
				'rowClass' => 'cloudflare_cdn',
			],

			[
				'id'       => 'aws_access_key',
				'title'    => esc_html__( 'AWS Amazon Access Key', 'exmage-wordpress-image-links' ),
				'desc'     => sprintf( esc_html__( 'Go to AWS Management Console → IAM → Users → [your user] → Security credentials tab → Create access key to get Access Key ID and Secret Access Key. %s', 'exmage-wordpress-image-links' ), '<a href="https://console.aws.amazon.com/iam/home#/users" target="_blank">Read more</a>' ),
				'type'     => 'text',
				'rowClass' => 'aws_cdn',
			],
			[
				'id'       => 'aws_secret_key',
				'title'    => esc_html__( 'AWS Amazon Secret Key', 'exmage-wordpress-image-links' ),
				'desc'     => sprintf( esc_html__( 'Go to AWS Management Console → IAM → Users → [your user] → Security credentials tab → Create access key to get Access Key ID and Secret Access Key. %s', 'exmage-wordpress-image-links' ), '<a href="https://console.aws.amazon.com/iam/home#/users" target="_blank">Read more</a>' ),
				'type'     => 'text',
				'rowClass' => 'aws_cdn',
			],
			[
				'id'       => 'aws_bucket_name',
				'title'    => esc_html__( 'AWS Amazon Bucket Name', 'exmage-wordpress-image-links' ),
				'desc'     => sprintf( esc_html__( 'Go to AWS Management Console → S3 → your bucket name is the name of the bucket you created there. %s', 'exmage-wordpress-image-links' ), '<a href="https://s3.console.aws.amazon.com/s3/home" target="_blank">Read more</a>' ),
				'type'     => 'text',
				'rowClass' => 'aws_cdn',
			],
			[
				'id'       => 'aws_region_name',
				'title'    => esc_html__( 'AWS Amazon Region Name', 'exmage-wordpress-image-links' ),
				'type'     => 'text',
				'desc'     => sprintf( esc_html__( 'Go to AWS Management Console → S3 → select your bucket → in Properties tab, you’ll find the Region (example: ap-southeast-1, us-east-1). %s', 'exmage-wordpress-image-links' ), '<a href="https://s3.console.aws.amazon.com/s3/home" target="_blank">Read more</a>' ),
				'rowClass' => 'aws_cdn',
			],

			[
				'type' => 'section_end'
			],


		];

		return $options;
	}

	public function update_options() {
		$options = [
			[
				'type' => 'section_start',
			],
			[
				'id'    => 'update_key',
				'title' => esc_html__( 'Auto Update Key', 'exmage-wordpress-image-links' ),
				'type'  => 'update_pro',
			],
			[ 'type' => 'section_end' ],
		];

		return $options;
	}

	public function description_prompt() {
		return '
            <span><b>Shortcode {image_url}</b> : is image url</span><br>
            <span><b>Shortcode {MIN_CHARACTERS}</b> : is min characters</span><br>
            <span><b>Shortcode {MAX_CHARACTERS}</b> : is max characters</span><br>
            <span><b>Shortcode {WRITING_STYLE}</b> : is writing style</span><br>
            <span><b>Shortcode {WRITING_TONE}</b> : is writing tone</span>
        ';
	}

	public function exmage_pre_merge_update_settings( $update_option ) {
		if ( isset( $_POST['exmage-nonce-settings'] ) && ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['exmage-nonce-settings'] ) ), 'exmage-nonce-settings' ) ) {
			return $update_option;
		}
		if ( isset( $_POST['exmage_my_account_page'] ) ) {
			$update_option = wp_parse_args( $update_option, [ 'exmage_my_account_page' => villatheme_sanitize_kses( wp_unslash( $_POST['exmage_my_account_page'] ) ) ] );// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		}
		if ( isset( $_POST['exmage_field_mapping'] ) ) {
			$update_option = wp_parse_args( $update_option, [ 'field_mapping' => villatheme_sanitize_kses( wp_unslash( $_POST['exmage_field_mapping'] ) ) ] );// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

		}

		return $update_option;
	}

	public function save_settings() {
		$s_nonce         = isset( $_POST['exmage-nonce-settings'] ) ? sanitize_text_field( wp_unslash( $_POST['exmage-nonce-settings'] ) ) : '';
		$is_save_setting = isset( $_POST['exmage_save_settings'] ) && ! empty( $_POST['exmage_save_settings'] ) ? true : false;
		$is_save_content = isset( $_POST['exmage_save_content'] ) && ! empty( $_POST['exmage_save_content'] ) ? true : false;
		if ( ( $is_save_setting || $is_save_content ) && $s_nonce &&
		     wp_verify_nonce( $s_nonce, 'exmage-nonce-settings' ) && current_user_can( 'manage_options' )
		) {
			try {
				$tabs    = $this->define_tabs();
				$options = [];
				foreach ( $tabs as $slug => $text ) {
					$method = $slug . '_options';
					if ( method_exists( $this, $method ) ) {
						$options = array_merge( $options, $this->$method() );
					} else {
						$options = array_merge( $options, apply_filters( 'exmage_save_setting_option', [], $slug ) );
					}
				}

				$options = apply_filters( 'exmage_settings_before_save', $options );

				add_filter( 'exmage_admin_settings_sanitize_option_names', [
					$this,
					'sanitize_textarea_to_array'
				], 10, 3 );
				add_filter( 'exmage_admin_settings_sanitize_option_cmt_frontend', [
					$this,
					'sanitize_textarea_to_array'
				], 10, 3 );

				/*flush end point*/
				flush_rewrite_rules();

				EXMAGESettings_Helper::save_fields( $options );
				EXMAGEDATA::instance()->init_params();

			} catch ( \Exception $e ) {
				echo esc_html( $e->getMessage() );
			}
		}
	}

	public function sanitize_textarea_to_array( $value, $option, $raw_value ) {
		if ( empty( $raw_value ) || ! is_array( $raw_value ) ) {
			return [];
		}

		foreach ( $raw_value as $key => $names ) {
			$names         = explode( "\n", wp_kses_post( $names ) );
			$value[ $key ] = array_map( 'trim', $names );
		}

		return $value;
	}

	public function sanitize_working_hours_holiday( $value ) {
		if ( ! empty( $value ) && is_array( $value ) ) {
			$value = array_filter( $value, function ( $event ) {
				return count( array_filter( $event ) );
			} );
		}

		return $value;
	}
}
