<?php


if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'widgets_init', function () {
	register_widget( 'EXMAGE_Widget_Selector' );
} );

if ( ! class_exists( 'EXMAGE_Widget_Selector' ) ) {

	class EXMAGE_Widget_Selector extends WP_Widget {
		protected $settings;

		function __construct() {

			$this->settings = \EXMAGE\Includes\EXMAGEDATA::instance();
			parent::__construct(
				'exmage_widget', // Base ID
				esc_attr__( 'Exmage Video', 'exmage-wordpress-image-links' ), // Name
				array(
					'description' => esc_attr__( 'Choose external media create by Exmage. Widget of Exmage by VillaTheme', 'exmage-wordpress-image-links' ),
				) // Args
			);
		}

		/**
		 * Show front end
		 *
		 * @param $args
		 * @param $instance
		 */
		public function widget( $args, $instance ) {
			if ( $this->settings->get_param( 'enable' ) ) {
				echo $args['before_widget'];// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				if ( ! empty( $instance['title'] ) ) {
					echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				}
				$exmage_id = $instance['exmage_id'] ?? '';
				if ( ! empty( $exmage_id ) ) {
					$mime_type = get_post_mime_type( $exmage_id );
					$src_video = wp_get_attachment_url( $exmage_id );
					$html      = '';
					if ( strpos( $mime_type, 'video' ) !== false ) {
					$_exmage_external_oembed_src = get_post_meta( $exmage_id, '_exmage_external_oembed_src', true );

					if ( ! empty( $_exmage_external_oembed_src ) ) {
						$src_video = $_exmage_external_oembed_src;
						$html      = "<iframe src='{$src_video}' width='100%' height=''></iframe>";
					} else {
						/*Default video wordpress*/
						$html = '<div class="wp-media-wrapper wp-video"><video controls="controls" class="wp-video-shortcode" preload="metadata"><source type="' . $mime_type . '" src="' . $src_video . '"/> </video></div>';

					}
				} else if ( strpos( $mime_type, 'image' ) !== false ) {
						$html = wp_get_attachment_image( $exmage_id, 'full' );
					}

					echo ( $html );
				}


				echo $args['after_widget'];// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			}
		}

		/**
		 * Fields in widget configuration
		 *
		 * @param $instance
		 */
		public function form( $instance ) {
			//
			$title     = ! empty( $instance['title'] ) ? $instance['title'] : '';
			$exmage_id = isset( $instance['exmage_id'] ) ? $instance['exmage_id'] : '';

			?>
            <p>
                <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'exmage-wordpress-image-links' ); ?></label>
                <input placeholder="<?php echo esc_attr__( 'Please enter your title', 'exmage-wordpress-image-links' ) ?>"
                       class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
                       name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text"
                       value="<?php echo esc_attr( $title ); ?>">
            </p>
            <div>
                <label for="<?php echo esc_attr( $this->get_field_id( 'exmage_id' ) ); ?>"><?php esc_html_e( 'Choose Exmage video', 'exmage-wordpress-image-links' ) ?></label>
                <br/>
                <div class="exmage-wrap-feature-preview">
					<?php
					if ( ! empty( $exmage_id ) ) {
						$mime_type = get_post_mime_type( $exmage_id );
						$src_video = wp_get_attachment_url( $exmage_id );
						$html      = '';
						if ( strpos( $mime_type, 'video' ) !== false ) {
							$_exmage_external_oembed_src = get_post_meta( $exmage_id, '_exmage_external_oembed_src', true );

							if ( ! empty( $_exmage_external_oembed_src ) ) {
								$src_video = $_exmage_external_oembed_src;
								$html      = "<iframe src='{$src_video}' width='100%' height=''></iframe>";
							} else {
								/*Default video wordpress*/
								$html = do_shortcode( '[video src="' . $src_video . '"]' );
							}
						} else if ( strpos( $mime_type, 'image' ) !== false ) {
							$html = wp_get_attachment_image( $exmage_id, 'thumbnail' );
						}
						$html .= '<a href="#" id="remove-exmage-thumbnail">' . esc_html__( 'Remove featured media', 'exmage-wordpress-image-links' ) . '</a>';
						echo ( $html );
					}

					?>

                </div>
                <button type="button" class="button button-primary button-large exmage-choose-feature-media"><?php echo esc_html__( 'Choose Media', 'exmage-wordpress-image-links' ); ?></button>
                <input class="widefat exmage_id" id="exmage_feature_media_id"
                       name="<?php echo esc_attr( $this->get_field_name( 'exmage_id' ) ); ?>" type="hidden"
                       value="<?php echo esc_attr( $exmage_id ); ?>">
            </div>

			<?php do_action( 'exmage_after_widget_form', $instance, $this ) ?>
			<?php
		}

		/**
		 * Save widget configuration
		 *
		 * @param $new_instance
		 * @param $old_instance
		 *
		 * @return array
		 */
		public function update( $new_instance, $old_instance ) {
			$instance              = array();
			$instance['title']     = ( ! empty( $new_instance['title'] ) ) ? wp_strip_all_tags( $new_instance['title'] ) : '';
			$instance['exmage_id'] = ( ! empty( $new_instance['exmage_id'] ) ) ? $new_instance['exmage_id'] : '';


			return apply_filters( 'exmage_save_widget_data', $instance, $new_instance, $old_instance );
		}


	}
}
?>