'use strict';
jQuery(document).ready(function ($) {

    $(document).on('click', '.exmage-migrate-button,.exmage-convert-external-button', function (event) {
        convert_attachment($(this));
    });
    /*Add field filter external image*/
    let ids_media = [];
    let attachment_img_ids = [];

    $('body').on('click', '.download_exmage_all', (e) => {
        e.preventDefault();
        let text_count = ids_media.length > 0 ? ids_media.length : 'all';
        if (confirm('Do you really want to download ' + text_count + ' images?')) {
            let per_download = 5;

            if (!ids_media.length) {
                get_all_attachment_id();
            }
            if (!ids_media.length) {
                alert("No Exmage available for download.")
            }
            for (let i = 0; i < per_download; i++) {
                let current_media_id = ids_media[i],
                    button_selector = $('#post-' + current_media_id).find('.exmage-migrate-button');
                convert_attachment(button_selector, true);
            }
        }
    });
    $('body').on('change', 'input[name="media[]"],#cb-select-all-1', (e) => {
        let ids_media = [];

        $('.exmage-migrate-button').map(function () {
            let current_tr = $(this).closest('tr');
            if (current_tr.find('input[name="media[]"]').prop('checked')) {
                ids_media.push($(this).data('attachment_id'));
            }
        });
        if (ids_media.length) {
            $('.download_exmage_all .exmage_number_download').html(ids_media.length);
        } else {
            $('.download_exmage_all .exmage_number_download').html("all");
        }

        if (exmage_admin_params.enable_ai_engine != 'disabled') {
            attachment_img_ids = [];
            $('.exmage-generator-alt-button').map(function () {
                let current_tr = $(this).closest('tr');
                if (current_tr.find('input[name="media[]"]').prop('checked')) {
                    attachment_img_ids.push($(this).data('attachment_id'));
                }
            });
            if (attachment_img_ids.length) {
                $('.generator_alt_exmage_all .exmage_number_generator_alt').html(attachment_img_ids.length);
            } else {
                $('.generator_alt_exmage_all .exmage_number_generator_alt').html("all");
            }
        }
    });

    function get_all_attachment_id() {
        ids_media = [];
        $('.exmage-migrate-button').map(function () {
            ids_media.push($(this).data('attachment_id'));

        });
    }

    function convert_attachment($button, multiple = false) {
        let attachment_id = $button.data('attachment_id'),
            $container = $button.closest('.exmage-external-url-container'),
            $message = $container.find('.exmage-migrate-message'),
            to_external = $button.is('.exmage-migrate-button') ? 0 : 1;
        if (!$button.hasClass('exmage-button-loading')) {
            $button.addClass('exmage-button-loading');
            $message.html('');
            $.ajax({
                url: exmage_admin_params.ajaxurl,
                type: 'POST',
                data: {
                    action: 'exmage_convert_external_image',
                    attachment_id: attachment_id,
                    to_external: to_external,
                    _exmage_ajax_nonce: exmage_admin_params._exmage_ajax_nonce,
                },
                success(response) {
                    if (response.status === 'success') {

                        $container.find('.exmage-external-url-content').html('');
                        if (multiple) {
                            ids_media = jQuery.grep(ids_media, function (value) {
                                return value !== attachment_id;
                            });

                            if (ids_media.length) {
                                let current_media_id = ids_media[0],
                                    button_selector = $('#post-' + current_media_id).find('.exmage-migrate-button');
                                convert_attachment(button_selector, true);
                            }
                        }
                    } else {
                        $message.html('<span class="exmage-message-error"><span class="exmage-use-url-message-content">' + response.message + '</span></span>');
                    }
                },
                error() {
                    $message.html('<span class="exmage-message-error"><span class="exmage-use-url-message-content">An error occurs</span></span>');
                },
                complete() {
                    $button.removeClass('exmage-button-loading');
                }
            });
        }
    }

    /*Process image url*/
    $(document).on('click', '.exmage-use-url-input-multiple-add', function () {
        data_preprocessing($(this).closest('.exmage-container-form').find('.exmage-use-url-input-multiple'));
        exmage_handle_url_input($(this).closest('.exmage-container-form').find('.exmage-use-url-input-multiple'));
    });


    $(document).on('click', '.exmage-delete-field', function () {
        let t = $(this),
            t_closet = t.closest('.exmage-table-tr'),
            t_body_table = t.closest('.exmage-wrap-body-table');
        let count = t_body_table.find('.exmage-table-tr').length;
        if (count > 1) {
            t_closet.remove();
        } else {
            alert('You cannot delete all fields!');
        }
        return false;
    });
    $(document).on('click', '.exmage-add-field', function () {
        let t = $(this),
            t_closet = t.closest('.exmage-table-tr'),
            t_body_table = t.closest('.exmage-wrap-body-table');
        let template = t_closet.clone();
        let thumbnail_field_img = template.find('.exmage_thumbnail_field img');
        let preview_field_img = template.find('.exmage_preview_field img');
        template.find('.exmage-add-external-url-media').val('');/*Remove external video or image clone*/
        template.find('.exmage-remove-thumb-video').trigger('click');/*Remove thumb id and thumb url clone*/

        template.attr('data-media_type', 'image');/*Set default tr media_type*/
        thumbnail_field_img.attr('src', thumbnail_field_img.data('placeholder_image'));
        preview_field_img.attr('src', preview_field_img.data('placeholder_src'));

        t_body_table.append(template);
        return false;
    });
    $(document).on('click', '.exmage-remove-thumb-video', function (e) {
        e.preventDefault();
        let t = $(this),
            t_p = t.parent();
        let thumbnail_field_img = t_p.find('img');
        let thumbnail_field_img_id = t_p.find('.exmage-exist-thumb-id');
        let thumbnail_field_img_url = t_p.find('.exmage-thumb-video-url');
        thumbnail_field_img.attr('src', thumbnail_field_img.data('placeholder_image'));
        thumbnail_field_img_id.val('');
        thumbnail_field_img_url.val('');
        t.addClass('exmage-hidden');
        return false;
    });

    /*Add button generator in page edit attachment*/
    if (exmage_admin_params.enable_ai_engine != 'disabled') {
        if ($('body').hasClass('wp-admin') && $('body').hasClass('post-type-attachment')) {

            var $template_button = `<div class="exmage-wrap-button-render" style="margin-top: 15px;"><button class="exmage-generator-alt-button button button-primary">AI generator</button><div class="exmage-generator-alt-message"></div></div><div class="exmage-use-url-input-overlay exmage-hidden"></div>`;

            /*Add button to edit attachment*/
            $('.wp_attachment_details .attachment-alt-text').append($template_button);

        }
    }
    $(document).on('click', '.exmage-shortcode-icon-copy', function () {
        let t = $(this),
            t_parent = t.parent();
        navigator.clipboard.writeText(t_parent.find('.exmage-shortcode').text()).then(function () {
            alert('Copied');
        }, function (err) {
            console.error('Copy error', err);
        });
        return false;
    });

    /*Upload feature thumb for post*/
    $(document).on('click', '.exmage-choose-feature-media', function (e) {
        e.preventDefault()
        let t = $(this),
            t_parent = t.parent(),
            t_closest_form = t.closest('form'),
            t_preview_media = t_parent.find('.exmage-wrap-feature-preview'),
            feature_media_id = t_parent.find('#exmage_feature_media_id');

        let active_frame = wp.media.frames.file_frame = wp.media({
            title: 'Choose media',
            button: {
                text: 'Choose media'
            },
            library: {type: ["image", "video"]},
            multiple: false
        });
        active_frame.on('open', function () {
            active_frame.content.mode('browse'); /*browse = Media Library*/

        });
        active_frame.on('select', function () {
            let attachment = active_frame.state().get('selection').first().toJSON();

            let template_preview = ``;
            let src_attachment = attachment.url;
            if (attachment.mime.includes("video")) {
                if (typeof attachment._exmage_external_oembed_src != 'undefined' && attachment._exmage_external_oembed_src != '') {
                    src_attachment = attachment._exmage_external_oembed_src;
                }
                template_preview = `<iframe src="${src_attachment}" width="100%" height=""></iframe>`;
            } else {
                template_preview = `<img src="${src_attachment}" alt="${attachment.alt}" >`;
            }
            template_preview += `<a href="#" id="remove-exmage-thumbnail">Remove featured media</a>`;
            feature_media_id.val(attachment.id);
            t_preview_media.html(template_preview);
            t_closest_form.trigger('change');
        });
        active_frame.open();
    });
    $(document).on('click', '#remove-exmage-thumbnail', function (e) {
        e.preventDefault()
        let t = $(this),
            t_parent = t.parent().parent(),
            t_preview_media = t_parent.find('.exmage-wrap-feature-preview'),
            feature_media_id = t_parent.find('#exmage_feature_media_id');
        t_preview_media.html('');
        feature_media_id.val('');
    });

    /*Generator alt image*/
    $(document).on('click', '.exmage-generator-alt-button', function () {
        let t = $(this),
            t_p = t.parent(),
            t_p_p = t_p.parent(),
            post_ID = $('#post_ID').val(),
            $message = t_p.find('.exmage-generator-alt-message'),
            textarea_alt = t_p_p.find('textarea'),
            t_overlay = t_p_p.find('.exmage-use-url-input-overlay');
        t.addClass('exmage-button-loading');
        t_overlay.removeClass('exmage-hidden');
        $message.html('');
        if (!post_ID) {
            if (typeof _wpMediaGridSettings != 'undefined' && _wpMediaGridSettings.queryVars) {
                post_ID = _wpMediaGridSettings.queryVars.item ?? '';
            }
        }
        if (!post_ID) {
            const urlParams = new URLSearchParams(window.location.search);
            post_ID = urlParams.get('item');
        }
        if (!post_ID) {
            post_ID = t.data('attachment_id');
        }

        $.ajax({
            url: exmage_admin_params.ajaxurl,
            type: 'POST',
            data: {
                action: 'exmage_generator_alt_image',
                attachment_id: post_ID,
                _exmage_ajax_nonce: exmage_admin_params._exmage_ajax_nonce,
            },
            success(response) {
                if (response.status === 'success') {
                    textarea_alt.val(response.content);
                    $message.html('<span class="exmage-message-success"><span class="exmage-use-url-message-content">' + response.message + '</span></span>');
                } else {
                    $message.html('<span class="exmage-message-error"><span class="exmage-use-url-message-content">' + response.message + '</span></span>');
                }
            },
            error() {
                $message.html('<span class="exmage-message-error"><span class="exmage-use-url-message-content">An error occurs</span></span>');
            },
            complete() {
                t.removeClass('exmage-button-loading');
                t_overlay.addClass('exmage-hidden');
            }
        });
        return false;
    });

    $(document).on('click', '.generator_alt_exmage_all', function () {
        if (attachment_img_ids.length > 0) {
            $(this).addClass('exmage-button-loading');
            for (let i in attachment_img_ids) {
                $('.exmage-generator-alt-button[data-attachment_id="' + attachment_img_ids[i] + '"]').addClass('exmage-button-loading');
            }
            let attachment_id = attachment_img_ids.shift();
            exmage_bulk_generator_alt_image(attachment_id);
        } else {
            alert('You need to select at least one image before generating.!');
        }
        return false;
    });

    /*Preview image*/
    $(document).on('paste', '.exmage-add-external-url-field.exmage-add-external-url-media', function () {
        let t = $(this),
            t_closest = t.closest('.exmage-table-tr'),
            t_closest_table = t.closest('.exmage-wrap-body-table'),
            t_closest_wrap_loading = t_closest_table.find('.exmage-use-url-input-overlay'),
            t_image_preview_wrap = t_closest.find('.exmage_preview_field'),
            t_image_preview = t_image_preview_wrap.find('.exmage-image-preview'),
            t_image_thumb_wrap = t_closest.find('.exmage_thumbnail_field'),
            t_image_thumb = t_image_thumb_wrap.find('.exmage-image-thumbnail'),
            placeholder_src = t_image_preview.data('placeholder_src');
        /*When the paste event needs to delay a little while to get the value field*/
        setTimeout(function () {
            if (isImageURL(t.val())) {
                t_image_preview.attr('src', t.val());
                t_image_thumb_wrap.hide();
                t_image_preview_wrap.show();
                t_closest.attr('data-media_type', 'image');
            } else if (isVideoURL(t.val())) {
                t_closest.attr('data-media_type', 'video');
                t_image_thumb_wrap.show();
                t_image_preview_wrap.hide();
                t_closest_wrap_loading.removeClass('exmage-hidden');
                $.ajax({
                    url: exmage_admin_params.ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'exmage_preload_video_data',
                        url_val: t.val(),
                        _exmage_ajax_nonce: exmage_admin_params._exmage_ajax_nonce,
                    },
                    success(response) {
                        if (response.status === 'success') {
                            let data = response.details ?? [];
                            if (data.poster) {
                                t_image_thumb.attr('src', data.poster);
                                t_image_thumb_wrap.find('.exmage-thumb-video-url').val(data.poster);
                                t_image_thumb_wrap.find('.exmage-remove-thumb-video').removeClass('exmage-hidden');
                            }
                        }
                    },
                    error() {
                    },
                    complete() {
                        t_closest_wrap_loading.addClass('exmage-hidden');
                    }
                });
            } else {
                t_image_preview.attr('src', placeholder_src);
                t_image_thumb_wrap.hide();
                t_image_preview_wrap.hide();
            }
        }, 0);
    });

    $(document).on('change', '.exmage-add-external-url-field.exmage-add-external-url-media', function (event) {
        let t = $(this),
            t_closest = t.closest('.exmage-table-tr'),
            t_closest_table = t.closest('.exmage-wrap-body-table'),
            t_closest_wrap_loading = t_closest_table.find('.exmage-use-url-input-overlay'),
            t_image_preview_wrap = t_closest.find('.exmage_preview_field'),
            t_image_preview = t_image_preview_wrap.find('.exmage-image-preview'),
            t_image_thumb_wrap = t_closest.find('.exmage_thumbnail_field'),
            t_image_thumb = t_image_thumb_wrap.find('.exmage-image-thumbnail'),
            placeholder_src = t_image_preview.data('placeholder_src');

        if (isImageURL(t.val())) {
            t_image_preview.attr('src', t.val());
            t_image_thumb_wrap.hide();
            t_image_preview_wrap.show();
            t_closest.attr('data-media_type', 'image');
        } else if (isVideoURL(t.val())) {
            t_closest.attr('data-media_type', 'video');
            t_image_thumb_wrap.show();
            t_image_preview_wrap.hide();
            t_closest_wrap_loading.removeClass('exmage-hidden');
            $.ajax({
                url: exmage_admin_params.ajaxurl,
                type: 'POST',
                data: {
                    action: 'exmage_preload_video_data',
                    url_val: t.val(),
                    _exmage_ajax_nonce: exmage_admin_params._exmage_ajax_nonce,
                },
                success(response) {
                    if (response.status === 'success') {
                        let data = response.details ?? [];
                        if (data.poster) {
                            t_image_thumb.attr('src', data.poster);
                            t_image_thumb_wrap.find('.exmage-thumb-video-url').val(data.poster);
                            t_image_thumb_wrap.find('.exmage-remove-thumb-video').removeClass('exmage-hidden');
                        }
                    }
                },
                error() {
                },
                complete() {
                    t_closest_wrap_loading.addClass('exmage-hidden');
                }
            });
        } else {
            t_closest.attr('data-media_type', 'image');
            t_image_preview.attr('src', placeholder_src);
            t_image_thumb_wrap.hide();
            t_image_preview_wrap.hide();
        }

        if (t.val() !== '') {
            t_closest.find('.exmage-add-field').trigger('click');
        }

    });

    /*Choose Image from media*/
    $(document).on('click', '.exmage-select-existing-image', function () {
        let active_frame = wp.media.frame;
        if (active_frame) {
            if ('upload' === active_frame.content.mode()) {
                active_frame.content.mode('browse');
            }
            let $select = $(this), attachment_id = $select.data('attachment_id'),
                _state = active_frame.content.view._state;
            let selection = active_frame.state().get('selection');
            if (selection) {
                selection.reset();
                selection.add(wp.media.attachment(attachment_id));
            }
            if (_state === 'library' || _state === 'edit-attachment') {
                if (!wp.media.attachment(attachment_id).attributes.url) {
                    if (active_frame.content.get() && active_frame.content.get().collection) {
                        active_frame.content.get().collection._requery(true);
                    }
                    active_frame.trigger('library:selection:add');
                } else {
                    if (!wp.media.attachment(attachment_id).attributes.url) {
                        wp.media.attachment(attachment_id).fetch();
                    }
                }
            }
        }
    });

    /*Click Edit url exmage*/
    $(document).on('click', '.exmage-edit-url', function () {
        let t = $(this),
            t_closet = t.closest('.exmage-wrap-edit-field-external-url');
        t_closet.addClass('editing');
        return false;
    });
    /*Click save edit url exmage*/
    $(document).on('click', '.exmage-save-edit-url', function () {
        let t = $(this),
            t_closet = t.closest('.exmage-wrap-edit-field-external-url'),
            url_field = t_closet.find('.exmage-edit-external-url-field'),
            url_field_val = url_field.val(),
            attachment_id_field = t.closest('tr').find('.check-column input'),
            td_title = t.closest('tr').find('td.title'),
            attachment_id = attachment_id_field.val(),
            $message = t.closest('.exmage-external-url-container').find('.exmage-migrate-message');

        t.addClass('dashicons-update-alt');
        t.addClass('loading');
        if (url_field_val !== '' && attachment_id !== '') {

            $.ajax({
                url: exmage_admin_params.ajaxurl,
                type: 'POST',
                data: {
                    action: 'exmage_edit_url',
                    attachment_id: attachment_id,
                    url_val: url_field_val,
                    _exmage_ajax_nonce: exmage_admin_params._exmage_ajax_nonce,
                },
                success(response) {
                    if (response.status === 'success') {
                        $message.html(response.message);
                        td_title.find('img').attr('src', url_field_val);
                        td_title.find('img').attr('srcset', '');
                        t_closet.find('.exmage-external-url').text(url_field_val);
                        $message.html('<span class="exmage-message-success"><span class="exmage-use-url-message-content">' + response.message + '</span></span>');
                    } else {
                        $message.html('<span class="exmage-message-error"><span class="exmage-use-url-message-content">' + response.message + '</span></span>');
                    }
                },
                error() {

                },
                complete() {
                    t.removeClass('dashicons-update-alt');
                    t.removeClass('loading');
                    t_closet.removeClass('editing');
                }
            });
        } else {
            alert('Error, please reload and try again!');
        }
        t_closet.addClass('editing');
        return false;
    });

    /*Choose thumb video from media*/
    $(document).on('click', '.exmage_thumbnail_field', function () {
        let t = $(this),
            t_field = t.find('.exmage-exist-thumb-id'),
            t_img = t.find('.exmage-image-thumbnail'),
            t_img_close = t.find('.exmage-remove-thumb-video');
        let active_frame = wp.media.frames.file_frame = wp.media({
            title: 'Choose Thumbnail',
            button: {
                text: 'Choose Thumbnail'
            },
            multiple: false
        });
        active_frame.on('open', function () {
            active_frame.content.mode('browse'); /*browse = Media Library*/

            $(active_frame.content.selector).addClass('exmage-frame-choose-thumb-for-video');

        });
        active_frame.on('select', function () {
            let attachment = active_frame.state().get('selection').first().toJSON();
            t_field.val(attachment.id);
            t_img.attr('src', attachment.url);
            t_img_close.removeClass('exmage-hidden');
            $('.exmage-tab-item[data-tab=video]').trigger('click');
        });
        active_frame.open();
    });
});

function data_preprocessing($input) {
    let $container = $input.closest('.exmage-container-form'),
        tab_content = $container.find('.exmage-wrap-tab-content'),
        tab_content_list = tab_content.find('.exmage-tab-content-item');

    let arr_url = [];
    let arr_url_thumb = [];

    let tr = tab_content_list.find('.exmage-wrap-body-table .exmage-table-tr');
    tr.each(function (i, e) {
        let tr_this = jQuery(this);
        let field_url = tr_this.find('.exmage-add-external-url-field');
        let media_type = tr_this.attr('data-media_type');
        let tr_thumb_val ='';
        if (field_url.val()) {
            arr_url.push(field_url.val());
        }
        if (media_type == 'video') {
            tr_thumb_val = tr_this.find('.exmage-thumb-video-url').val();
            if (tr_thumb_val == '') {
                tr_thumb_val = tr_this.find('.exmage-exist-thumb-id').val();
            }
        }
        arr_url_thumb.push(tr_thumb_val ?? '');
    });

    jQuery('.exmage-use-url-input-multiple').val(arr_url.toString());
    jQuery('.exmage-use-url-input-multiple-thumbnail').val(arr_url_thumb.toString());/*Only for upload video*/

}

function exmage_handle_url_input($input, $type) {
    let $container = $input.closest('.exmage-container-form'),
        $overlay = $container.find('.exmage-use-url-input-overlay'),
        $message = $container.find('.exmage-use-url-message');
    if ($overlay.hasClass('exmage-hidden')) {
        $message.html('');
        setTimeout(function () {
            let urls = $input.val();
            let urls_thumb = $container.find('.exmage-use-url-input-multiple-thumbnail').val();

            let is_url_valid = false, is_single = $input.is('input');
            try {
                if (is_single) {
                    let url_obj = new URL(urls);
                    if (url_obj.protocol === 'https:' || url_obj.protocol === 'http:') {
                        is_url_valid = true;
                    } else {
                        $message.html('<p class="exmage-message-error"><span class="exmage-use-url-message-content">Please enter a valid image URL</span></p>');
                    }
                } else {
                    if (urls) {
                        is_url_valid = true;
                    } else {
                        $message.html('<p class="exmage-message-error"><span class="exmage-use-url-message-content">Please enter at least a valid image URL to continue</span></p>');
                        return;
                    }
                }
            } catch (e) {
                $overlay.addClass('exmage-hidden');
                $message.html('<p class="exmage-message-error"><span class="exmage-use-url-message-content">Please enter a valid image URL</span></p>');
                return;
            }
            if (is_url_valid) {
                $overlay.removeClass('exmage-hidden');
                jQuery.ajax({
                    url: exmage_admin_params.ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'exmage_handle_url',
                        urls: urls,
                        urls_thumb: urls_thumb,
                        post_id: exmage_admin_params.post_id,
                        _exmage_ajax_nonce: exmage_admin_params._exmage_ajax_nonce,
                        is_single: is_single ? 1 : '',
                    },
                    success(response) {
                        let active_frame = wp.media ? wp.media.frame : '';
                        if (response.status === 'success') {
                            let details = response.details, message = '';
                            for (let i in details) {
                                if (details[i].status === 'success') {
                                    if (is_single) {
                                        message += `<p class="exmage-message-${details[i].status}"><span class="exmage-use-url-message-content">${details[i].message}</span>, ID: <a target="_blank" href="${details[i].edit_link}">${details[i].id}</a></p>`;
                                    } else {
                                        message += `<li class="exmage-message-${details[i].status}"><span class="exmage-result-url">${details[i].url} =><span class="exmage-use-url-message-content">${details[i].message}</span>, ID: <a target="_blank" href="${details[i].edit_link}">${details[i].id}</a></li>`;
                                    }
                                    if (active_frame) {
                                        let _state = active_frame.content.view._state;
                                        let selection = active_frame.state().get('selection');

                                        if ('upload' === active_frame.content.mode()) {
                                            active_frame.content.mode('browse');
                                        }
                                        if (_state === 'library' || _state === 'edit-attachment') {

                                            if (selection) {
                                                selection.reset();

                                                selection.add(wp.media.attachment(details[i].id));
                                            }
                                            if (active_frame.content.get() && active_frame.content.get().collection) {
                                                active_frame.content.get().collection._requery(true);
                                            }
                                            active_frame.trigger('library:selection:add');
                                        } else {
                                            if (selection) {
                                                selection.reset();
                                                selection.add(wp.media.attachment(details[i].id));
                                            }
                                            wp.media.attachment(details[i].id).fetch();
                                        }
                                    }
                                } else {
                                    if (details[i].id) {
                                        let item_message = `<span class="exmage-use-url-message-content">${details[i].message}</span>, ID: <a target="_blank" href="${details[i].edit_link}">${details[i].id}</a>`;
                                        if (active_frame && active_frame.content.get() && active_frame.content.get().collection) {
                                            item_message = `${item_message}. <span class="exmage-select-existing-image" data-attachment_id="${details[i].id}">${exmage_admin_params.i18n_select_existing_image}</span>.`;
                                        }
                                        if (is_single) {
                                            message += `<p class="exmage-message-${details[i].status}">${item_message}</p>`;
                                        } else {
                                            message += `<li class="exmage-message-${details[i].status}"><span class="exmage-result-url">${details[i].url} =>${item_message}</li>`;
                                        }
                                    } else {
                                        if (is_single) {
                                            message += `<p class="exmage-message-${details[i].status}"><span class="exmage-use-url-message-content">${details[i].message}</span></p>`;
                                        } else {
                                            message += `<li class="exmage-message-${details[i].status}"><span class="exmage-result-url">${details[i].url} =><span class="exmage-use-url-message-content">${details[i].message}</span></li>`;
                                        }
                                    }
                                }
                            }
                            if (!is_single) {
                                message = `<ol>${message}</ol>`;
                            }
                            $message.html(message);
                        } else if (response.status === 'queue') {
                            $message.html('<p class="exmage-message-queue"><span class="exmage-use-url-message-content">' + response.message + '</span></p>');
                        } else {
                            $message.html('<p class="exmage-message-error"><span class="exmage-use-url-message-content">' + response.message + '</span></p>');
                        }
                    },
                    error() {
                        $message.html('<p class="exmage-message-error"><span class="exmage-use-url-message-content">An error occurs.</span></p>');
                    },
                    complete(jqXHR, textStatus) {
                        $overlay.addClass('exmage-hidden');

                        let responseJSON = jqXHR.responseJSON ?? {};
                        if (responseJSON.details && responseJSON.details.length) {
                            let details = responseJSON.details;
                            if (details.length) {
                                let details_item = details[0];
                                if (typeof details_item.type !== 'undefined') {
                                    jQuery('.exmage-add-external-url-field.exmage-add-external-url-media').val('');
                                    if (details_item.type == 'video') {
                                        jQuery('.exmage-image-thumbnail').each(function () {
                                            let $this = jQuery(this),
                                                placeholder_image = $this.data('placeholder_image');
                                            $this.attr('src', placeholder_image);
                                        })
                                    }
                                } else {
                                    jQuery('.exmage-add-external-url-field').val('');
                                }
                            }
                        }
                    }
                });
            }
        }, 1);
    }
}

function isImageURL(url) {

    var imageExtensions = /\.(jpg|jpeg|png|gif|bmp|webp|svg|tiff)(\?.*)?$/i;


    var imageDomains = [
        /(?:https?:\/\/)?(?:.+\.)?imgur\.com\/.+/,
        /(?:https?:\/\/)?(?:.+\.)?gyazo\.com\/.+/,
        /(?:https?:\/\/)?(?:.+\.)?prnt\.sc\/.+/,
        /(?:https?:\/\/)?drive\.google\.com\/uc\?id=.+/,
        /(?:https?:\/\/)?images\.unsplash\.com\/.+/,
        /(?:https?:\/\/)?cdn\.discordapp\.com\/attachments\/.+/,
        /(?:https?:\/\/)?somecdn\.net\/photo\?id=.+/
    ];


    if (imageExtensions.test(url)) {
        return true;
    }

    for (var i = 0; i < imageDomains.length; i++) {
        if (imageDomains[i].test(url)) {
            return true;
        }
    }

    return false;
}

function isVideoURL(url) {
    var videoPatterns = [
        /(?:https?:\/\/)?(?:www\.)?(?:youtube\.com\/(?:(?:watch\?(?:.*&)?v=)|(?:embed|v|vi|shorts)\/)|youtu\.be\/)([A-Za-z0-9_-]{11})/,
        /(?:https?:\/\/)?(?:www\.)?vimeo\.com\/.+/,
        /(?:https?:\/\/)?(?:www\.)?dailymotion\.com\/video\/.+/,
        /(?:https?:\/\/)?(?:www\.)?twitter\.com\/.+\/status\/.+/,
        /(?:https?:\/\/)?(?:www\.)?ted\.com\/talks\/.+/,
        /(?:https?:\/\/)?(?:www\.)?kickstarter\.com\/projects\/.+\/.+\/video/,
        /(?:https?:\/\/)?(?:.+\.)?wistia\.com\/medias\/.+/,
        /(?:https?:\/\/)?videopress\.com\/v\/.+/,
        /(?:https?:\/\/)?(?:www\.)?tiktok\.com\/@.+\/video\/.+/,
        /(?:https?:\/\/)?drive\.google\.com\/file\/d\/.+\/view/
    ];

    // Some popular external videos
    var videoExtensions = /\.(mp4|mov|avi|wmv|flv|webm|mkv|m4v|3gp)(\?.*)?$/i;

    // Check foreach pattern
    for (var i = 0; i < videoPatterns.length; i++) {
        if (videoPatterns[i].test(url)) {
            return true;
        }
    }

    // Check video extension
    if (videoExtensions.test(url)) {
        return true;
    }

    return false;
}

function exmage_bulk_generator_alt_image(attachment_id) {
    let button = $('.exmage-generator-alt-button[data-attachment_id="' + attachment_id + '"]');
    let current_tr = button.closest('tr');
    let current_td = button.closest('td');
    let $message = current_td.find('.exmage-generator-alt-message');
    $.ajax({
        url: exmage_admin_params.ajaxurl,
        type: 'POST',
        data: {
            action: 'exmage_generator_alt_image',
            attachment_id: attachment_id,
            _exmage_ajax_nonce: exmage_admin_params._exmage_ajax_nonce,
        },
        success(response) {
            if (response.status === 'success') {
                $message.html('<span class="exmage-message-success"><span class="exmage-use-url-message-content">' + response.message + '</span></span>');
            } else {
                $message.html('<span class="exmage-message-error"><span class="exmage-use-url-message-content">' + response.message + '</span></span>');
            }
        },
        error() {
            $message.html('<span class="exmage-message-error"><span class="exmage-use-url-message-content">An error occurs</span></span>');
        },
        complete() {
            button.removeClass('exmage-button-loading');
            if (attachment_img_ids.length > 0) {
                let attachment_id = attachment_img_ids.shift();
                exmage_bulk_generator_alt_image(attachment_id);
            } else {
                $('.generator_alt_exmage_all').removeClass('exmage-button-loading');
                alert('Generator completed.')
            }
        }
    });
}