<?php

namespace EXMAGE\Frontend;

use EXMAGE\EXMAGEEnv;
use EXMAGE\Includes\EXMAGEDATA;
use WP_Query;
use WP_REST_Request;

defined( 'ABSPATH' ) || exit;

class Frontend {
	protected static $instance = null;
	protected        $settings;
	protected        $detect_lang;

	public static function instance() {
		return self::$instance == null ? self::$instance = new self() : self::$instance;
	}

	public function __construct() {
		$this->settings = EXMAGEDATA::instance();

		$this->detect_lang = 'en';
		add_action( 'init', [ $this, 'exmage_frontend_init' ] );

	}

	public function exmage_frontend_init() {
		if ( $this->settings->get_param( 'enable' ) ) {
			add_filter( 'wp_get_attachment_url', array( $this, 'wp_get_attachment_url' ), 10, 2 );
			add_filter( 'wp_calculate_image_srcset', array( $this, 'wp_calculate_image_srcset' ), 10, 5 );
		}
	}

	/**
	 * @param $url
	 * @param $id
	 *
	 * @return mixed
	 */
	public function wp_get_attachment_url( $url, $id ) {
		if ( get_post_meta( $id, '_exmage_imported', true ) ) {
			return $url;
		}
		if ( ! get_post_meta( $id, '_exmage_external_url', true ) ) {
			return $url;
		}
		$post = get_post( $id );
		if ( $post && 'attachment' === $post->post_type ) {
			$_wp_attached_file = get_post_meta( $id, '_wp_attached_file', true );
			if ( $_wp_attached_file ) {
				if ( substr( $_wp_attached_file, 0, 7 ) === "http://" || substr( $_wp_attached_file, 0, 8 ) === "https://" ) {
					$url = $_wp_attached_file;
				}
			}
		}

		return $url;
	}

	/**
	 * @param $sources
	 * @param $size_array
	 * @param $image_src
	 * @param $image_meta
	 * @param $attachment_id
	 *
	 * @return mixed
	 */
	public function wp_calculate_image_srcset( $sources, $size_array, $image_src, $image_meta, $attachment_id ) {
		if ( get_post_meta( $attachment_id, '_exmage_imported', true ) ) {
			return $sources;
		}
		if ( ! get_post_meta( $attachment_id, '_exmage_external_url', true ) ) {
			return $sources;
		}

		if ( $sources ) {
			$upload_dir    = wp_get_upload_dir();
			$image_baseurl = trailingslashit( $upload_dir['baseurl'] );
			if ( is_ssl() && 'https' !== substr( $image_baseurl, 0, 5 ) && ! empty( $_SERVER['HTTP_HOST'] ) && wp_parse_url( $image_baseurl, PHP_URL_HOST ) === $_SERVER['HTTP_HOST'] ) {
				$image_baseurl = set_url_scheme( $image_baseurl, 'https' );
			}
			$_wp_attached_file = get_post_meta( $attachment_id, '_wp_attached_file', true );
			foreach ( $sources as &$src ) {
				$pos = strpos( $_wp_attached_file, 'wp-content/uploads/' );
				if ( false !== $pos ) {
					$src['url'] = str_replace( $image_baseurl, substr( $_wp_attached_file, 0, $pos - 1 ) . '/wp-content/uploads/', $src['url'] );
				} else {
					$src['url'] = str_replace( $image_baseurl, '', $src['url'] );
				}
			}
		}

		return $sources;
	}


}