<?php

namespace EXMAGE\Frontend;


use EXMAGE\Includes\EXMAGEDATA;
use EXMAGE\Includes\EXMAGEVIDEO;

defined( 'ABSPATH' ) || exit;

class Shortcode {
	protected static $instance = null;
	protected        $settings;
	protected        $video;

	public static function instance() {
		return self::$instance == null ? self::$instance = new self() : self::$instance;
	}

	public function __construct() {
		$this->settings = EXMAGEDATA::instance();
		$this->video    = EXMAGEVIDEO::instance();
		add_shortcode( 'exmage_video', [ $this, 'exmage_shortcode' ] );
	}

	/**
	 * @param $atts
	 *
	 * @return false|string|void
	 */
	public function exmage_shortcode( $atts ) {
		ob_start();
		extract( shortcode_atts( array(
			'id'     => '',
			'width'  => '640',
			'height' => '480',
		), $atts ) );
		if ( empty( $id ) ) {
			return;
		}

		$html      = '';
		$src_video = get_post_meta( $id, '_exmage_external_oembed_src', true );
		if ( ! empty( $src_video ) ) {
			if ( $this->video->check_is_dailymotion_video( $src_video ) ) {
				$html = "<div style='position:relative;padding-bottom:56.25%;height:0;overflow:hidden;'><iframe src='{$src_video}' style='width:100%; height:100%; position:absolute; left:0; top:0; overflow:hidden; border:none;' allowfullscreen title='Dailymotion Video Player' allow='web - share'></iframe></div>";
			} else {

				$html = "<iframe src='{$src_video}' width='{$width}' height='{$height}'></iframe>";
			}
		}

		echo ( $html );
		return ob_get_clean();
	}
}