<?php

namespace EXMAGE\Includes;

defined( 'ABSPATH' ) || exit;

use EXMAGE\Admin\EXMAGELogs;
use EXMAGE\Includes\EXMAGEDATA;
use EXMAGE\Includes\EXMAGEQueryDB;
use WP_List_Table;
use EXMAGE\EXMAGEEnv;

class ClassLogs extends WP_List_Table {
	protected static $instance = null;
	protected static $format_date, $woo_payments;
	private          $data     = array();

	/**
	 * Get instance class
	 *
	 * @param bool $new Is new instance
	 *
	 * @return ClassLogs|null
	 */
	public static function get_instance( $new = false ) {
		if ( $new || null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Get format date
	 */
	public static function get_format_date() {
		if ( self::$format_date ) {
			return self::$format_date;
		}

		return self::$format_date = get_option( 'date_format' ) . ' ' . get_option( 'time_format' );
	}

	/**
	 * Get conversation table column
	 */
	function get_columns() {
		$columns = array(
			'cb'       => '<input type="checkbox" />',
			'image_id' => esc_html__( 'ID', 'exmage-wordpress-image-links' ),
			'image'    => esc_html__( 'Image', 'exmage-wordpress-image-links' ),
			'date'     => esc_html__( 'Date', 'exmage-wordpress-image-links' )
		);

		return $columns;
	}

	/**
	 * Column combobox.
	 */
	public function column_cb( $item ) {
		return sprintf( '<input type="checkbox" name="id[]" value="%s" />', $item['id'] ?? 0 );
	}

	/**
	 * Diplay table column
	 *
	 * @param array|object $item Item in table data
	 * @param string $column_name
	 *
	 * @return string|void
	 */
	public function column_default( $item, $column_name ) {
		switch ( $column_name ) {
			case 'date':
				$time_format = $item['date_created'] ? date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), $item['date_created'] ) : '';

				return esc_html( $time_format );
				break;
			case 'image_id':

				break;
			case 'image':

				break;

			default:
		}

		return '';
	}

	/**
	 * Get bulk actions.
	 *
	 * @return array
	 */
	public function get_bulk_actions() {
		return array(
			'delete' => esc_html__( 'Delete', 'exmage-wordpress-image-links' ),
		);
	}

	/**
	 * Display tablenav for search
	 */
	public function display_tablenav( $which ) {
		printf( '<div class="tablenav %s">', esc_attr( $which ) );
		wp_nonce_field( 'exmage-nonce-settings', 'exmage-nonce-settings' );
		if ( $this->has_items() ) {
			printf( '<div class="alignleft actions bulkactions">' );
			$this->bulk_actions( $which );
			printf( '</div>' );
		}
		$this->pagination( $which );
		printf( '<br class="clear" /></div>' );
	}

	public function get_sortable_columns() {
		$sortable_columns = array(
			'date' => array( 'name', true ),
		);

		return $sortable_columns;
	}

	/**
	 * Query and prepare data for table
	 */
	public function prepare_items() {
		$per_page     = $this->get_items_per_page( 'exmage_logs_per_page', 30 );
		$current_page = $this->get_pagenum();
		$action       = $this->current_action();
		$where        = 1;

		$this->process_bulk_action( $action );

		$args     = [
			'where'  => $where,
			'limit'  => $per_page,
			'offset' => ( $current_page - 1 ) * $per_page
		];
		$get_logs = EXMAGEQueryDB::instance()->get_activity_logs( $args );

		usort( $get_logs, array( $this, 'usort_reorder' ) );

		$this->items = $get_logs;
		if ( ! empty( $this->items ) ) {
			$total_items = EXMAGEQueryDB::instance()->get_logs_count();
			$this->set_pagination_args( array(
				'total_items' => $total_items,
				'per_page'    => $per_page,
				'total_pages' => ceil( $total_items / $per_page )
			) );
		}
		$columns               = $this->get_columns();
		$hidden                = array();
		$sortable              = $this->get_sortable_columns();
		$this->_column_headers = array( $columns, $hidden, $sortable );
	}

	public function usort_reorder( $a, $b ) {
		$orderby = ( ! empty( $_REQUEST['orderby'] ) ) ? sanitize_text_field( wp_unslash( $_REQUEST['orderby'] ) ) : 'id';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$order   = ( ! empty( $_REQUEST['order'] ) ) ? sanitize_text_field( wp_unslash( $_REQUEST['order'] ) ) : 'asc';// phpcs:ignore WordPress.Security.NonceVerification.Recommended

		switch ( $orderby ) {
			case 'name':
				$result = strnatcmp( $a['user_nicename'], $b['user_nicename'] );
				break;
			case 'earning':
				$result = floatval( $a['earning'] ) < floatval( $b['earning'] ) ? 1 : - 1;
				break;
			case 'balance':
				$result = floatval( $a['balance'] ) < floatval( $b['balance'] ) ? 1 : - 1;
				break;
			default:
				//map order field with database field
				$result = strnatcmp( $a[ $orderby ], $b[ $orderby ] );
		}

		return ( $order === 'desc' ) ? $result : - $result;
	}

	public function process_bulk_action( $action ) {
		if ( $action && ! empty( $action ) ) {
			switch ( $action ) {
				case 'delete':
					if ( ! current_user_can( 'manage_options' ) ) {
						wp_die( esc_html__( 'You do not have permission to delete affiliate requests', 'exmage-wordpress-image-links' ) );
					}
					if ( isset( $_POST['exmage-nonce-settings'] ) && ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['exmage-nonce-settings'] ) ), 'exmage-nonce-settings' ) ) {
						wp_die( esc_html__( 'Nonce verify failed, please try again later', 'exmage-wordpress-image-links' ) );
					}

					$log_ids = isset( $_REQUEST['id'] ) ? array_map( 'absint', (array) villatheme_sanitize_fields( wp_unslash( $_REQUEST['id'] ) ) ) : array();// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
					if ( $log_ids ) {
						foreach ( $log_ids as $log_id ) {
							EXMAGEQueryDB::instance()->delete_log_by_id( $log_id );
						}
					}
					break;
			}
		}
	}
}