<?php

namespace EXMAGE\Includes;

use EXMAGE\EXMAGEEnv;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class EXMAGEDATA {
	protected static $instance = null, $allow_html = null;

	protected $params, $default_data, $social_prefix_url;

	protected $exmage_list_icon = [ "exmage-icon arrow_up", "exmage-icon arrow_down", "exmage-icon arrow_left", "exmage-icon arrow_right" ];


	private function __construct() {
		$this->default_data = [];

	}

	public static function instance() {
		// If the single instance hasn't been set, set it now.
		if ( null == self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function init_params() {
		$this->default_data = [
			'enable'                         => 1,
			'enable_video'                   => 1,
			'placeholder_replace_image'      => '',
			'enable_thumbnail_video'         => 1,
			'enable_ai_engine'               => 0,
			'ai_model'                       => 'disabled',
			'ai_alt_exclude_image_exist_alt' => 1,
			'ai_command_min_characters'      => 20,
			'ai_command_max_characters'      => 90,
			'ai_command_writing_style'       => esc_html__( 'Descriptive, clear, SEO-optimized', 'exmage-wordpress-image-links' ),
			'ai_command_writing_tone'        => esc_html__( 'Neutral, informative', 'exmage-wordpress-image-links' ),
			'ai_render_alt_mess'             => esc_html__( 'Writing SEO-friendly image descriptions for the alt attribute in HTML. Based on the image link provided {image_url}, analyze the image content and generate an appropriate alt text. Must be between {MIN_CHARACTERS} and {MAX_CHARACTERS} characters. Style: {WRITING_STYLE}. Tone: {WRITING_TONE}.', 'exmage-wordpress-image-links' ),
			/*Gemini*/
			'ai_gemini_api_key'              => '',
			/*OpenAI*/
			'ai_openai_api_key'              => '',
			/*Upload CDN*/
			'cdn_type'                       => 'disable',
			'update_key'                     => '',
		];
		$option = get_option( 'EXMAGE_data', [] );
		$params = apply_filters('EXMAGE_data',wp_parse_args( $option, $this->default_data ));

		$this->params = $params;
	}


	public function get_social_prefix_url() {
		return $this->social_prefix_url;
	}

	public function get_params() {
		if ( ! $this->params ) {
			$this->init_params();
		}

		return $this->params;
	}

	public function get_param( $name = '', $name_sub = '', $language = '' ) {
		$language = apply_filters( '_exmage_settings_language', $language, $name, $name_sub );
		if ( ! $this->params ) {
			$this->init_params();
		}
		if ( ! $name ) {
			return $this->params;
		} elseif ( isset( $this->params[ $name ] ) ) {
			if ( $name_sub ) {
				if ( isset( $this->params[ $name ][ $name_sub ] ) ) {
					if ( $language ) {
						$name_language = $name_sub . '_' . $language;
						if ( isset( $this->params[ $name ][ $name_language ] ) ) {
							return apply_filters( 'exmage_params_' . $name . '__' . $name_language, $this->params[ $name ][ $name_language ] );
						} else {
							return apply_filters( 'exmage_params_' . $name . '__' . $name_language, $this->params[ $name ][ $name_sub ] );
						}
					} else {
						return apply_filters( 'exmage_params_' . $name . '__' . $name_sub, $this->params[ $name ] [ $name_sub ] );
					}
				} elseif ( $this->default_data[ $name ] [ $name_sub ] ) {
					return apply_filters( 'exmage_params_' . $name . '__' . $name_sub, $this->default_data[ $name ] [ $name_sub ] );
				} else {
					return false;
				}
			} else {
				if ( $language ) {
					$name_language = $name . '_' . $language;
					if ( isset( $this->params[ $name_language ] ) ) {
						return apply_filters( 'exmage_params_' . $name_language, $this->params[ $name_language ] );
					} else {
						return apply_filters( 'exmage_params_' . $name_language, $this->params[ $name ] );
					}
				} else {
					return apply_filters( 'exmage_params_' . $name, $this->params[ $name ] );
				}
			}
		} else {
			if ( $name == 'exmage_icons' ) {
				return apply_filters( 'exmage_params_' . $name, $this->exmage_list_icon );
			}

			return false;
		}
	}


	/**
	 * Used to escape html content
	 *
	 * @param $content
	 *
	 * @return string
	 */
	public static function kses_post( $content ) {
		if ( self::$allow_html === null ) {
			self::$allow_html = wp_kses_allowed_html( 'post' );
			self::$allow_html = self::filter_allowed_html( self::$allow_html );
		}

		return wp_kses( $content, self::$allow_html );
	}

	/**
	 * @param $tags
	 *
	 * @return array
	 */
	public static function filter_allowed_html( $tags ) {
		$tags = array_merge_recursive( $tags, array(
				'input'  => array(
					'type'         => 1,
					'id'           => 1,
					'name'         => 1,
					'class'        => 1,
					'placeholder'  => 1,
					'autocomplete' => 1,
					'style'        => 1,
					'value'        => 1,
					'size'         => 1,
					'checked'      => 1,
					'disabled'     => 1,
					'readonly'     => 1,
					'data-*'       => 1,
				),
				'form'   => array(
					'method' => 1,
					'id'     => 1,
					'class'  => 1,
					'action' => 1,
					'data-*' => 1,
				),
				'select' => array(
					'id'       => 1,
					'name'     => 1,
					'class'    => 1,
					'multiple' => 1,
					'data-*'   => 1,
				),
				'option' => array(
					'value'    => 1,
					'selected' => 1,
					'data-*'   => 1,
				),
				'style'  => array(
					'id'    => 1,
					'class' => 1,
					'type'  => 1,
				),
				'source' => array(
					'type' => 1,
					'src'  => 1
				),
				'video'  => array(
					'width'  => 1,
					'height' => 1,
					'src'    => 1
				),
			)
		);
		foreach ( $tags as $key => $value ) {
			if ( $key === 'input' ) {
				$tags[ $key ]['data-*']   = 1;
				$tags[ $key ]['checked']  = 1;
				$tags[ $key ]['disabled'] = 1;
				$tags[ $key ]['readonly'] = 1;
			} elseif ( in_array( $key, array( 'div', 'span', 'a', 'form', 'select', 'option', 'tr', 'td' ) ) ) {
				$tags[ $key ]['data-*'] = 1;
			}
		}

		return $tags;
	}


	public static function country_code_key_from_headers() {
		return apply_filters( 'exmage_country_code_from_headers', array(
			'HTTP_GEOIP_COUNTRY_CODE',
			'GEOIP_COUNTRY_CODE',
			'HTTP_CF_IPCOUNTRY',
			'MM_COUNTRY_CODE',
			'HTTP_X_COUNTRY_CODE',
			'HTTP_X_QC_COUNTRY',
		) );
	}

	public function use_session() {
		return apply_filters( 'exmage_use_session', $this->get_param( 'use_session' ) );
	}

	public static function is_request_to_rest_api() {
		if ( empty( $_SERVER['REQUEST_URI'] ) ) {
			return false;
		}

		$rest_prefix = '/' . untrailingslashit( rest_get_url_prefix() ) . '/';
		$request_uri = esc_url_raw( wp_unslash( $_SERVER['REQUEST_URI'] ) );

		return false !== strpos( $request_uri, $rest_prefix );
	}

	public function get_country_language( $country ) {
		$s_lang   = self::get_param( 'language' );
		$def_lang = '';

		foreach ( $s_lang as $sl_key => $sl_val ) {
			$def_lang = empty( $def_lang ) ? $sl_key : $def_lang;
			if ( in_array( $country, $sl_val ) ) {
				return $sl_key;
			}
		}

		return $def_lang;
	}

	public function get_language_data() {
		$s_lang    = self::get_param( 'language' );
		$bind_lang = [];
		$def_lang  = '';
		foreach ( (array) $s_lang as $sl_key => $sl_val ) {
			$def_lang             = empty( $def_lang ) ? $sl_key : $def_lang;
			$bind_lang[ $sl_key ] = self::get_language_info( $sl_key );
		}

		return [ 'def' => $def_lang, 'data' => $bind_lang ];
	}

	public function get_language_info( $language_code = '' ) {
		$languages = apply_filters( 'exmage_get_languages', include EXMAGEEnv::get( 'templates_dir' ) . 'dist' . DIRECTORY_SEPARATOR . 'languages.php' );

		if ( ! $language_code ) {
			return $languages;
		}

		if ( isset( $languages[ $language_code ] ) ) {
			return $languages[ $language_code ];
		}

		return '';
	}

	/**
	 * @param $ai_model
	 *
	 * @return false|string
	 */
	public function ai_model_type( $ai_model ) {
		if ( in_array( $ai_model, [
			'gemini-1.5-flash',
			'gemini-1.5-flash-8b',
			'gemini-1.5-pro',
			'gemini-2.0-flash-exp'
		] ) ) {
			return 'gemini';
		}
		if ( in_array( $ai_model, [
			'gpt-4o',
			'gpt-4-turbo',
			'gpt-4',
			'gpt-3.5-turbo-16k',
			'gpt-3.5-turbo',
			'gpt-3.5-turbo-instruct',
		] ) ) {
			return 'gpt';
		}

		return false;
	}

	/**
	 * @param $message
	 * @param $data
	 *
	 * @return array|string|string[]
	 */
	public function ai_command_replace_shortcodes( $message, $data = [] ) {
		$arr = array(
			'{image_url}'      => isset( $data['image_url'] ) ? $data['image_url'] : '',
			'{WRITING_STYLE}'  => isset( $data['writing_style'] ) ? $data['writing_style'] : '',
			'{WRITING_TONE}'   => isset( $data['writing_tone'] ) ? $data['writing_tone'] : '',
			'{MIN_CHARACTERS}' => isset( $data['min_characters'] ) ? $data['min_characters'] : '',
			'{MAX_CHARACTERS}' => isset( $data['max_characters'] ) ? $data['max_characters'] : '',
		);

		return str_replace( array_keys( $arr ), array_values( $arr ), $message );
	}

}