/**
 * WordPress dependencies
 */
import { setLocaleData } from '@wordpress/i18n';
import { createRoot } from '@wordpress/element';
import domReady from '@wordpress/dom-ready';

setLocaleData( { '': {} }, 'it-l10n-ithemes-security-pro' );

/**
 * Internal dependencies
 */
import App from './dashboard/app.js';

domReady( () => {
	const el = document.getElementById( 'itsec-dashboard-root' );

	if ( el ) {
		const canManage = el.dataset.canManage === '1';
		const installType = el.dataset.installType;

		createRoot( el ).render( <App context={ { canManage, installType } } /> );
	}
} );

export * from './dashboard/utils';
export { useRegisterCards } from './dashboard/cards';
export Card from './dashboard/components/card';
export CardHeader, {
	Title as CardHeaderTitle,
} from './dashboard/components/card/header';
export CardFooter, {
	FooterSchemaActions as CardFooterSchemaActions,
} from './dashboard/components/card/footer';
export PromoCard from './dashboard/components/edit-cards/promo-card';
export { CardHappy } from './dashboard/components/empty-states';
