<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;

class MediCenterWidget_Announcement_Box extends Widget_Base 
{

	public function get_name()
	{
		return 'announcement_box';
	}

	public function get_title()
	{
		return esc_html__("Announcement Box", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-posts-ticker';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		$mc_colors_arr = array("#3156a3" => esc_html__("Dark blue", "medicenter"), "#0384ce" => esc_html__("Blue", "medicenter"), "#42b3e5" => esc_html__("Light blue", "medicenter"), "#000000" => esc_html__("Black", "medicenter"), "#AAAAAA" => esc_html__("Gray", "medicenter"), "#444444" => esc_html__("Dark gray", "medicenter"), "#CCCCCC" => esc_html__("Light gray", "medicenter"), "#43a140" => esc_html__("Green", "medicenter"), "#008238" => esc_html__("Dark green", "medicenter"), "#7cba3d" => esc_html__("Light green", "medicenter"), "#f17800" => esc_html__("Orange", "medicenter"), "#cb451b" => esc_html__("Dark orange", "medicenter"), "#ffa800" => esc_html__("Light orange", "medicenter"), "#db5237" => esc_html__("Red", "medicenter"), "#c03427" => esc_html__("Dark red", "medicenter"), "#f37548" => esc_html__("Light red", "medicenter"), "#0097b5" => esc_html__("Turquoise", "medicenter"), "#006688" => esc_html__("Dark turquoise", "medicenter"), "#00b6cc" => esc_html__("Turquoise", "medicenter"), "#00b6cc" => esc_html__("Light turquoise", "medicenter"), "#6969b3" => esc_html__("Violet", "medicenter"), "#3e4c94" => esc_html__("Dark violet", "medicenter"), "#9187c4" => esc_html__("Light violet", "medicenter"), "#FFFFFF" => esc_html__("White", "medicenter"), "#fec110" => esc_html__("Yellow", "medicenter"));
	
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'header',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Header", 'medicenter'),
				'label_block' => true
			]
		);
		$this->add_control(
			'content',
			[
				'type' => Controls_Manager::WYSIWYG,
				'label' => esc_html__("Text", 'medicenter')
			]
		);
		$this->add_control(
			'bg_image',
			[
				'label' => esc_html__("Background image", 'medicenter'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__("Select background image from media library.", 'medicenter')
			]
		);
		$this->add_control(
			'button_label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Button label", 'medicenter'),
				'label_block' => true
			]
		);
		$this->add_control(
			'button_url',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Button url", 'medicenter'),
				'label_block' => true
			]
		);
		$this->add_control(
			'button_size',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Button size", 'medicenter'),
				'options' => [
					'medium' => esc_html__("Medium", 'medicenter'),
					'tiny' => esc_html__("Tiny", 'medicenter'),
					'small' => esc_html__("Small", 'medicenter'),
					'large' => esc_html__("Large", 'medicenter')
				],
				'default' => 'medium'
			]
		);
		$this->add_control(
			'button_style',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Button style", 'medicenter'),
				'options' => [
					'dark-color' => esc_html__("Dark color", 'medicenter'),
					'light-color' => esc_html__("Light color", 'medicenter'),
					'light' => esc_html__("Light", 'medicenter'),
					'custom' => esc_html__("Custom...", 'medicenter')
				],
				'default' => 'dark-color'
			]
		);
		$this->add_control(
			'button_icon',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Button icon", 'medicenter'),
				'options' => [
					'none' => esc_html__("None", 'medicenter'),
					'template-arrow-horizontal-1-after' => esc_html__("Horizontal arrow", 'medicenter'),
					'template-arrow-circle-after' => esc_html__("Circle arrow", 'medicenter'),
					'template-cart-after' => esc_html__("Cart", 'medicenter'),
					'template-search-after' => esc_html__("Search", 'medicenter'),
					'template-mail-after' => esc_html__("Mail", 'medicenter'),
					'template-phone-after' => esc_html__("Phone", 'medicenter'),
					'template-location-after' => esc_html__("Location", 'medicenter'),
					'template-comment-1-after' => esc_html__("Comment", 'medicenter'),
					'wpb_address_book' => esc_html__("Address book icon", 'medicenter'),
					'wpb_alarm_clock' => esc_html__("Alarm clock icon", 'medicenter'),
					'wpb_anchor' => esc_html__("Anchor icon", 'medicenter'),
					'wpb_application_image' => esc_html__("Application Image icon", 'medicenter'),
					'wpb_arrow' => esc_html__("Arrow icon", 'medicenter'),
					'wpb_asterisk' => esc_html__("Asterisk icon", 'medicenter'),
					'wpb_hammer' => esc_html__("Hammer icon", 'medicenter'),
					'wpb_balloon' => esc_html__("Balloon icon", 'medicenter'),
					'wpb_balloon_buzz' => esc_html__("Balloon Buzz icon", 'medicenter'),
					'wpb_balloon_facebook' => esc_html__("Balloon Facebook icon", 'medicenter'),
					'wpb_balloon_twitter' => esc_html__("Balloon Twitter icon", 'medicenter'),
					'wpb_battery' => esc_html__("Battery icon", 'medicenter'),
					'wpb_binocular' => esc_html__("Binocular icon", 'medicenter'),
					'wpb_document_excel' => esc_html__("Document Excel icon", 'medicenter'),
					'wpb_document_image' => esc_html__("Document Image icon", 'medicenter'),
					'wpb_document_music' => esc_html__("Document Music icon", 'medicenter'),
					'wpb_document_office' => esc_html__("Document Office icon", 'medicenter'),
					'wpb_document_pdf' => esc_html__("Document PDF icon", 'medicenter'),
					'wpb_document_powerpoint' => esc_html__("Document Powerpoint icon", 'medicenter'),
					'wpb_document_word' => esc_html__("Document Word icon", 'medicenter'),
					'wpb_bookmark' => esc_html__("Bookmark icon", 'medicenter'),
					'wpb_camcorder' => esc_html__("Camcorder icon", 'medicenter'),
					'wpb_camera' => esc_html__("Camera icon", 'medicenter'),
					'wpb_chart' => esc_html__("Chart icon", 'medicenter'),
					'wpb_chart_pie' => esc_html__("Chart pie icon", 'medicenter'),
					'wpb_clock' => esc_html__("Clock icon", 'medicenter'),
					'wpb_fire' => esc_html__("Fire icon", 'medicenter'),
					'wpb_heart' => esc_html__("Heart icon", 'medicenter'),
					'wpb_mail' => esc_html__("Mail icon", 'medicenter'),
					'wpb_play' => esc_html__("Play icon", 'medicenter'),
					'wpb_shield' => esc_html__("Shield icon", 'medicenter'),
					'wpb_video' => esc_html__("Video icon", 'medicenter')
				],
				'default' => 'none',
			]
		);
		$this->add_control(
			'button_text_color',
			[
				'type' => Controls_Manager::COLOR,
				'label' => esc_html__("Button text color", 'medicenter'),
				'default' => "#FFFFFF",
				'condition' => [
					'button_style' => "custom",
				]
			]
		);
		$this->add_control(
			'button_hover_text_color',
			[
				'type' => Controls_Manager::COLOR,
				'label' => esc_html__("Button Hover text color", 'medicenter'),
				'default' => "#FFFFFF",
				'condition' => [
					'button_style' => "custom",
				]
			]
		);
		$this->add_control(
			'button_color',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Button color", 'medicenter'),
				'options' => $mc_colors_arr,
				'default' => "#3156a3",
				'condition' => [
					'button_style' => "custom",
				]
			]
		);
		$this->add_control(
			'button_custom_color',
			[
				'type' => Controls_Manager::COLOR,
				'label' => esc_html__("or pick custom button color", 'medicenter'),
				'default' => "",
				'condition' => [
					'button_style' => "custom",
				]
			]
		);
		$this->add_control(
			'button_animation',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Button animation", 'medicenter'),
				'options' => [
					'' => esc_html__("none", 'medicenter'),
					'fadeIn' => esc_html__("fade in", 'medicenter'),
					'scale' => esc_html__("scale", 'medicenter'),
					'slideRight' => esc_html__("slide right", 'medicenter'),
					'slideRight200' => esc_html__("slide right 200%", 'medicenter'),
					'slideLeft' => esc_html__("slide left", 'medicenter'),
					'slideLeft50' => esc_html__("slide left 50%", 'medicenter'),
					'slideDown' => esc_html__("slide down", 'medicenter'),
					'slideDown200' => esc_html__("slide down 200%", 'medicenter'),
					'slideUp' => esc_html__("slide up", 'medicenter')
				],
				'default' => ''
			]
		);
		$this->add_control(
			'button_animation_duration',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Button animation duration", 'medicenter'),
				'default' => 600
			]
		);
		$this->add_control(
			'animation_delay',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Button animation delay", 'medicenter'),
				'default' => 0
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$settings["animation"] = $settings["button_animation"];
		$settings["animation_duration"] = $settings["button_animation_duration"];
		$settings["bg_image"] = $settings["bg_image"]["id"];
		if((int)\Elementor\Plugin::$instance->editor->is_edit_mode())
		{
			$settings["is_elementor_edit_mode"] = 1;
		}
		echo mc_theme_announcement_box_shortcode($settings, $settings["content"]);
	}

	protected function content_template(){}
}
?>
