<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class MediCenterWidget_Blog extends Widget_Base 
{

	public function get_name()
	{
		return 'blog';
	}

	public function get_title()
	{
		return esc_html__("Blog", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-post-list';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return true;
	}

	protected function register_controls()
	{
		//get posts list
		global $medicenter_posts_array;
		
		//get categories
		$post_categories = get_terms("category");
		$post_categories_array = array();
		$post_categories_array["-"] = esc_html__("All", 'medicenter');
		foreach($post_categories as $post_category)
		{
			$post_categories_array[$post_category->slug] = $post_category->name;
		}
		
		//image sizes
		$image_sizes_array = array();
		$image_sizes_array["default"] = esc_html__("Default", 'medicenter');
		$image_sizes_array["full"] = esc_html__("full (original image resolution)", 'medicenter');
		global $_wp_additional_image_sizes;
		foreach(get_intermediate_image_sizes() as $s) 
		{
			if(isset($_wp_additional_image_sizes[$s])) 
			{
				$width = intval($_wp_additional_image_sizes[$s]['width']);
				$height = intval($_wp_additional_image_sizes[$s]['height']);
			}
			else
			{
				$width = get_option($s.'_size_w');
				$height = get_option($s.'_size_h');
			}
			$image_sizes_array[$s] = $s . " (" . $width . "x" . $height . ")";
		}
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'mc_pagination',
			[
				'label' => esc_html__("Pagination", 'medicenter'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'medicenter'),
				'label_off' => esc_html__('No', 'medicenter'),
				'return_value' => '1',
				'default' => ''
			]
		);
		$this->add_control(
			'items_per_page',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Items per page/Post count", 'medicenter'),
				'default' => 4,
				'description' => esc_html__("Items per page if pagination is set to 'yes' or post count otherwise. Set -1 to display all.", 'medicenter')
			]
		);
		$this->add_control(
			'featured_image_size',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Featured image size", 'medicenter'),
				'options' => $image_sizes_array,
				'default' => 'default'
			]
		);
		$this->add_control(
			'layout_type',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Layout type", 'medicenter'),
				'options' => [
					'1' => esc_html__("Type 1", 'medicenter'),
					'2' => esc_html__("Type 2 (2 columns)", 'medicenter'),
					'3' => esc_html__("Type 3 (simple)", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'layout_kind',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Layout kind", 'medicenter'),
				'options' => [
					'column' => esc_html__("Columns layout", 'medicenter'),
					'row' => esc_html__("Rows layout", 'medicenter')
				],
				'default' => 'column',
				'description' => esc_html__("How posts should be displayed: row by row or column by column", 'medicenter'),
				'condition' => [
					'layout_type' => "2"
				]
			]
		);
		$this->add_control(
			'ids',
			[
				'type' => (count($medicenter_posts_array) ? Controls_Manager::SELECT2 : Controls_Manager::TEXT),
				'label' => esc_html__("Display selected", 'medicenter'),
				'options' => (count($medicenter_posts_array) ? array_flip($medicenter_posts_array) : ''),
				'multiple' => true,
				'default' => (count($medicenter_posts_array) ? "-" : ""),
				'description' => (count($medicenter_posts_array) ? '' : esc_html__("Please provide post ids separated with commas, to display only selected posts", 'medicenter')),
			]
		);
		$this->add_control(
			'category',
			[
				'type' => Controls_Manager::SELECT2,
				'label' => esc_html__("Display from Category", 'medicenter'),
				'options' => $post_categories_array,
				'multiple' => true,
				'default' => "-"
			]
		);
		$this->add_control(
			'order_by',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Order by", 'medicenter'),
				'options' => [
					'date' => esc_html__("Date", 'medicenter'),
					'title menu_order' => esc_html__("Title, menu order", 'medicenter'),
					'menu_order' => esc_html__("Menu order", 'medicenter')
				],
				'default' => 'date'
			]
		);
		$this->add_control(
			'order',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Order", 'medicenter'),
				'options' => [
					'ASC' => esc_html__("ascending", 'medicenter'),
					'DESC' => esc_html__("descending", 'medicenter')
				],
				'default' => 'DESC'
			]
		);
		$this->add_control(
			'show_post_title',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show post title", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'show_post_excerpt',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show post excerpt", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'excerpt_length',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Excerpt length", 'medicenter'),
				'default' => 0,
				'description' => esc_html__("The excerpt length. Set 0 to use default WordPress excerpt length.", 'medicenter'),
				'condition' => [
					'show_post_excerpt' => "1"
				]
			]
		);
		$this->add_control(
			'read_more',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Read more button", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '0'
			]
		);
		$this->add_control(
			'show_post_categories',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show post categories", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'show_post_author',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show post author", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'show_post_date_box',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show post date in box above post", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
				'condition' => [
					'layout_type' => "2"
				]
			]
		);
		$this->add_control(
			'show_post_comments_box',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show comments number in box above/beside the post", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
				'condition' => [
					'layout_type' => ["1", "2"]
				]
			]
		);
		$this->add_control(
			'show_post_comments_label',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show comments number label in box above/beside the post", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '0',
				'condition' => [
					'layout_type' => ["1", "2"]
				]
			]
		);
		$this->add_control(
			'post_date_animation',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Post date box animation", 'medicenter'),
				'options' => [
					'' => esc_html__("none", 'medicenter'),
					'fadeIn' => esc_html__("fade in", 'medicenter'),
					'scale' => esc_html__("scale", 'medicenter'),
					'slideRight' => esc_html__("slide right", 'medicenter'),
					'slideRight200' => esc_html__("slide right 200%", 'medicenter'),
					'slideLeft' => esc_html__("slide left", 'medicenter'),
					'slideLeft50' => esc_html__("slide left 50%", 'medicenter'),
					'slideDown' => esc_html__("slide down", 'medicenter'),
					'slideDown200' => esc_html__("slide down 200%", 'medicenter'),
					'slideUp' => esc_html__("slide up", 'medicenter')
				],
				'default' => '',
				'condition' => [
					'layout_type' => ["1", "2"]
				]
			]
		);
		$this->add_control(
			'post_date_animation_duration',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Post date box animation duration (ms)", 'medicenter'),
				'default' => 600,
				'condition' => [
					'layout_type' => ["1", "2"]
				]
			]
		);
		$this->add_control(
			'post_date_animation_delay',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Post date box animation delay (ms)", 'medicenter'),
				'default' => 0,
				'condition' => [
					'layout_type' => ["1", "2"]
				]
			]
		);
		$this->add_control(
			'post_comments_animation',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Post comments box animation", 'medicenter'),
				'options' => [
					'' => esc_html__("none", 'medicenter'),
					'fadeIn' => esc_html__("fade in", 'medicenter'),
					'scale' => esc_html__("scale", 'medicenter'),
					'slideRight' => esc_html__("slide right", 'medicenter'),
					'slideRight200' => esc_html__("slide right 200%", 'medicenter'),
					'slideLeft' => esc_html__("slide left", 'medicenter'),
					'slideLeft50' => esc_html__("slide left 50%", 'medicenter'),
					'slideDown' => esc_html__("slide down", 'medicenter'),
					'slideDown200' => esc_html__("slide down 200%", 'medicenter'),
					'slideUp' => esc_html__("slide up", 'medicenter')
				],
				'default' => '',
				'condition' => [
					'layout_type' => ["1", "2"]
				]
			]
		);
		$this->add_control(
			'post_comments_animation_duration',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Post comments box animation duration (ms)", 'medicenter'),
				'default' => 600,
				'condition' => [
					'layout_type' => ["1", "2"]
				]
			]
		);
		$this->add_control(
			'post_comments_animation_delay',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Post comments box animation delay (ms)", 'medicenter'),
				'default' => 0,
				'condition' => [
					'layout_type' => ["1", "2"]
				]
			]
		);
		$this->add_control(
			'show_post_date_footer',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show post date in post footer", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '0'
			]
		);
		$this->add_control(
			'show_post_comments_footer',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show comments number in post footer", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '0'
			]
		);
		$this->add_control(
			'is_search_results',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Is search results component", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '0'
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		if(is_array($settings["ids"]))
		{
			$ids = "";
			foreach($settings["ids"] as $key => $value)
			{
				$ids .= $value . ($value!=end($settings["ids"]) ? ',' : '');
			}
			$settings["ids"] = $ids;
		}
		if(is_array($settings["category"]))
		{
			$category = "";
			foreach($settings["category"] as $key => $value)
			{
				$category .= $value . ($value!=end($settings["category"]) ? ',' : '');
			}
			$settings["category"] = $category;
		}
		echo mc_theme_blog($settings);
	}

	protected function content_template(){}
}
?>
