<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;

class MediCenterWidget_Carousel extends Widget_Base 
{

	public function get_name()
	{
		return 'mc_carousel';
	}

	public function get_title()
	{
		return esc_html__("Carousel", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-carousel';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'carousel_id',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Id", 'medicenter'),
				'label_block' => true
			]
		);
		$this->add_control(
			'header',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Header", 'medicenter'),
				'label_block' => true
			]
		);
		$this->add_control(
			'header_border_animation',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Header border animation", 'medicenter'),
				'options' => [
					'1' => esc_html__("yes", 'medicenter'),
					'0' => esc_html__("no", 'medicenter')
				],
				'default' => '0'
			]
		);
		$this->add_control(
			'images_repeater',
			[
				'label' => esc_html__("Images", 'medicenter'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name' => 'image_title',
						'label' => esc_html__("Image title", 'medicenter'),
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__("Sample Title", 'medicenter')
					],
					[
						'name' => 'image_subtitle',
						'label' => esc_html__("Image subtitle", 'medicenter'),
						'type' => Controls_Manager::TEXT,
						'default' => ''
					],
					[
						'name' => 'image',
						'label' => esc_html__("Image", 'medicenter'),
						'type' => Controls_Manager::MEDIA,
						'default' => [
							'url' => Utils::get_placeholder_image_src(),
						]
					],
					[
						'name' => 'video_url',
						'label' => esc_html__("Video url", 'medicenter'),
						'type' => Controls_Manager::TEXT
					],
					[
						'name' => 'iframe_url',
						'label' => esc_html__("Iframe url", 'medicenter'),
						'type' => Controls_Manager::TEXT
					],
					[
						'name' => 'external_url',
						'label' => esc_html__("External url", 'medicenter'),
						'type' => Controls_Manager::TEXT
					]
				],
				'default' => [
					[
						'image_title' => esc_html__("Sample Title #1", 'medicenter')
					],
					[
						'image_title' => esc_html__("Sample Title #2", 'medicenter')
					],
					[
						'image_title' => esc_html__("Sample Title #3", 'medicenter')
					]
				],
				'title_field' => '{{{ image_title }}}',
			]
		);
		$this->add_control(
			'features_images_loop',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Lightbox images loop", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'hover_icons',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Hover icons", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'autoplay',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Autoplay", 'medicenter'),
				'options' => [
					'0' => esc_html__("No", 'medicenter'),
					'1' => esc_html__("Yes", 'medicenter')
				],
				'default' => '0'
			]
		);
		$this->add_control(
			'pause_on_hover',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Pause on hover", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
				'condition' => [
					'autoplay' => "1",
				]
			]
		);
		$this->add_control(
			'scroll',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Scroll", 'medicenter'),
				'default' => '1',
				'description' => esc_html__("Number of items to scroll in one step", 'medicenter')
			]
		);
		$this->add_control(
			'effect',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Effect", 'medicenter'),
				'options' => [
					'none' => esc_html__("none", 'medicenter'),
					'scroll' => esc_html__("scroll", 'medicenter'),
					'directscroll' => esc_html__("directscroll", 'medicenter'),
					'_fade' => esc_html__("fade", 'medicenter'),
					'crossfade' => esc_html__("crossfade", 'medicenter'),
					'cover' => esc_html__("cover", 'medicenter'),
					'uncover' => esc_html__("uncover", 'medicenter')
				],
				'default' => 'scroll'
			]
		);
		$this->add_control(
			'easing',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Sliding easing", 'medicenter'),
				'options' => [
					'swing' => esc_html__("swing", 'medicenter'),
					'linear' => esc_html__("linear", 'medicenter'),
					'easeInQuad' => esc_html__("easeInQuad", 'medicenter'),
					'easeOutQuad' => esc_html__("easeOutQuad", 'medicenter'),
					'easeInOutQuad' => esc_html__("easeInOutQuad", 'medicenter'),
					'easeInCubic' => esc_html__("easeInCubic", 'medicenter'),
					'easeOutCubic' => esc_html__("easeOutCubic", 'medicenter'),
					'easeInOutCubic' => esc_html__("easeInOutCubic", 'medicenter'),
					'easeInQuart' => esc_html__("easeOutQuart", 'medicenter'),
					'easeOutQuart' => esc_html__("easeOutQuart", 'medicenter'),
					'easeInOutQuart' => esc_html__("easeInOutQuart", 'medicenter'),
					'easeInSine' => esc_html__("easeInSine", 'medicenter'),
					'easeOutSine' => esc_html__("easeOutSine", 'medicenter'),
					'easeInOutSine' => esc_html__("easeInOutSine", 'medicenter'),
					'easeInExpo' => esc_html__("easeInExpo", 'medicenter'),
					'easeOutExpo' => esc_html__("easeOutExpo", 'medicenter'),
					'easeInOutExpo' => esc_html__("easeInOutExpo", 'medicenter'),
					'easeInQuint' => esc_html__("easeInQuint", 'medicenter'),
					'easeOutQuint' => esc_html__("easeOutQuint", 'medicenter'),
					'easeInOutQuint' => esc_html__("easeInOutQuint", 'medicenter'),
					'easeInCirc' => esc_html__("easeInCirc", 'medicenter'),
					'easeOutCirc' => esc_html__("easeOutCirc", 'medicenter'),
					'easeInOutCirc' => esc_html__("easeInOutCirc", 'medicenter'),
					'easeInElastic' => esc_html__("easeInElastic", 'medicenter'),
					'easeOutElastic' => esc_html__("easeOutElastic", 'medicenter'),
					'easeInOutElastic' => esc_html__("easeInOutElastic", 'medicenter'),
					'easeInBack' => esc_html__("easeInBack", 'medicenter'),
					'easeOutBack' => esc_html__("easeOutBack", 'medicenter'),
					'easeInOutBack' => esc_html__("easeInOutBack", 'medicenter'),
					'easeInBounce' => esc_html__("easeInBounce", 'medicenter'),
					'easeOutBounce' => esc_html__("easeOutBounce", 'medicenter'),
					'easeInOutBounce' => esc_html__("easeInOutBounce", 'medicenter')
				],
				'default' => 'swing'
			]
		);
		$this->add_control(
			'duration',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Sliding transition speed (ms)", 'medicenter'),
				'default' => 500
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$settings["animation"] = $settings["header_border_animation"];
		if(!empty($settings["carousel_id"]))
		{
			$settings["id"] = $settings["carousel_id"];
		}
		echo mc_theme_carousel_shortcode($settings);
	}

	protected function content_template(){}
}
?>
