<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class MediCenterWidget_Google_Map extends Widget_Base 
{

	public function get_name()
	{
		return 'medicenter_map';
	}

	public function get_title()
	{
		return esc_html__("Google Map", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-google-maps';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return true;
	}

	protected function register_controls()
	{
		global $theme_options;
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'api_key',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Google API Key", 'medicenter'),
				'default' => $theme_options["google_api_code"],
				'description' => sprintf(__("Please provide valid Google API Key under <a href='%s' title='Theme Options'>Theme Options</a>", 'medicenter'), esc_url(admin_url("themes.php?page=ThemeOptions"))),
				'classes' => "medicenter-elementor-readonly"
			]
		);
		$this->add_control(
			'map_id',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Id", 'medicenter'),
				'label_block' => false,
				'default' => 'map',
				'description' => esc_html__("Please provide unique id for each map on the same page/post.<br/>Use only lowercase letters from a to z and underscores, don't use spaces and dashes as they will cause issues.", 'medicenter')
			]
		);
		$this->add_control(
			'width',
			[
				'type' => Controls_Manager::SLIDER,
				'label' => esc_html__("Width", 'medicenter'),
				'size_units' => ['px', '%', 'em', 'rem', 'custom'],
				'range' => [
					'px' => [
						'min' => 0,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				]
			]
		);
		$this->add_control(
			'height',
			[
				'type' => Controls_Manager::SLIDER,
				'label' => esc_html__("Height", 'medicenter'),
				'size_units' => ['px', '%', 'em', 'rem', 'custom'],
				'range' => [
					'px' => [
						'min' => 0,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 400,
				]
			]
		);
		$this->add_control(
			'map_type',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Map type", 'medicenter'),
				'options' => [
					'ROADMAP' => esc_html__("Roadmap", 'medicenter'),
					'SATELLITE' => esc_html__("Satellite", 'medicenter'),
					'HYBRID' => esc_html__("Hybrid", 'medicenter'),
					'TERRAIN' => esc_html__("Terrain", 'medicenter')
				],
				'default' => 'ROADMAP'
			]
		);
		$this->add_control(
			'zoom',
			[
				'type' => Controls_Manager::SLIDER,
				'label' => esc_html__("Map Zoom", 'medicenter'),
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 20,
						'step' => 1
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 12
				]
			]
		);
		$this->add_control(
			'coordinates',
			[
				'label' => esc_html__("Coordinates", 'medicenter'),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);
		$this->add_control(
			'coordinates_description',
			[
				'type' => Controls_Manager::ALERT,
				'alert_type' => 'info',
				'content' => sprintf(__("You can use this <a href='%s' target='_blank'>%s</a> tool to designate coordinates", 'medicenter'), esc_url("http://www.birdtheme.org/useful/v3tool.html"), esc_url("http://www.birdtheme.org/useful/v3tool.html"))
			]
		);
		$this->add_control(
			'lat',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Latitude", 'medicenter'),
				'label_block' => false,
				'default' => '-37.732304'
			]
		);
		$this->add_control(
			'lng',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Longitude", 'medicenter'),
				'label_block' => false,
				'default' => '144.868641'
			]
		);
		$this->add_control(
			'marker_lat',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Marker/Point Latitude", 'medicenter'),
				'label_block' => false,
				'default' => '-37.732304'
			]
		);
		$this->add_control(
			'marker_lng',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Marker/point Longitude", 'medicenter'),
				'label_block' => false,
				'default' => '144.868641',
				'separator' => 'after'
			]
		);
		$this->add_control(
			'streetviewcontrol',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Street view control", 'medicenter'),
				'options' => [
					'true' => esc_html__("Yes", 'medicenter'),
					'false' => esc_html__("No", 'medicenter')
				],
				'default' => 'false'
			]
		);
		$this->add_control(
			'maptypecontrol',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Map type control", 'medicenter'),
				'options' => [
					'true' => esc_html__("Yes", 'medicenter'),
					'false' => esc_html__("No", 'medicenter')
				],
				'default' => 'false'
			]
		);
		$this->add_control(
			'map_icon_url',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Marker/Point icon url", 'medicenter'),
				'label_block' => false,
				'default' => get_template_directory_uri() . "/images/map_pointer.png"
			]
		);
		$this->add_control(
			'icon_width',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Icon width", 'medicenter'),
				'label_block' => false,
				'default' => 38
			]
		);
		$this->add_control(
			'icon_height',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Icon height", 'medicenter'),
				'label_block' => false,
				'default' => 48
			]
		);
		$this->add_control(
			'icon_anchor_x',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Icon anchor x", 'medicenter'),
				'label_block' => false,
				'default' => 18
			]
		);
		$this->add_control(
			'icon_anchor_y',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Icon anchor y", 'medicenter'),
				'label_block' => false,
				'default' => 48
			]
		);
		$this->add_control(
			'scrollwheel',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Mouse scroll wheel", 'medicenter'),
				'options' => [
					'true' => esc_html__("Yes", 'medicenter'),
					'false' => esc_html__("No", 'medicenter')
				],
				'default' => 'true'
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		if(!empty($settings["width"]["size"]))
		{
			$settings["width"] = $settings["width"]["size"] . $settings["width"]["unit"];
		}
		else
		{
			$settings["width"] = "100%";
		}
		if(!empty($settings["height"]["size"]))
		{
			$settings["height"] = $settings["height"]["size"] . $settings["height"]["unit"];
		}
		else
		{
			$settings["height"] = "400px";
		}
		if(!empty($settings["zoom"]["size"]))
		{
			$settings["zoom"] = $settings["zoom"]["size"];
		}
		else
		{
			$settings["zoom"] = 12;
		}
		if(!empty($settings["map_id"]))
		{
			$settings["id"] = $settings["map_id"];
		}
		if((int)\Elementor\Plugin::$instance->editor->is_edit_mode())
		{
			$settings["is_elementor_edit_mode"] = 1;
		}
		echo mc_theme_map_shortcode($settings);
	}

	protected function content_template(){}
}
?>
