<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class MediCenterWidget_Icon extends Widget_Base 
{

	public function get_name()
	{
		return 'mc_icon';
	}

	public function get_title()
	{
		return esc_html__("Icon", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-icon';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'type',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Type", 'medicenter'),
				'options' => [
					'features' => esc_html__("Feature", 'medicenter'),
					'social' => esc_html__("Social", 'medicenter'),
					'template' => esc_html__("Template", 'medicenter')
				],
				'default' => 'features'
			]
		);
		$this->add_control(
			'style',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Style", 'medicenter'),
				'options' => [
					'simple' => esc_html__("Simple", 'medicenter'),
					'hexagon' => esc_html__("Hexagon", 'medicenter'),
					'circle' => esc_html__("Circle", 'medicenter')
				],
				'default' => 'simple',
				'condition' => [
					'type' => 'features'
				]
			]
		);
		$this->add_control(
			'hexagon_size',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Size", 'medicenter'),
				'options' => [
					'big' => esc_html__("Big", 'medicenter'),
					'small' => esc_html__("Small", 'medicenter')
				],
				'default' => 'big',
				'condition' => [
					'style' => ['hexagon', 'circle']
				]
			]
		);
		$this->add_control(
			'hexagon_style',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Style", 'medicenter'),
				'options' => [
					'default' => esc_html__("Default", 'medicenter'),
					'light' => esc_html__("Light", 'medicenter')
				],
				'default' => 'default',
				'condition' => [
					'style' => ['hexagon', 'circle']
				]
			]
		);
		$this->add_control(
			'icon_feature',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Icon", 'medicenter'),
				'options' => [
					'address' => esc_html__("address", 'medicenter'),
					'ambulance' => esc_html__("ambulance", 'medicenter'),
					'app' => esc_html__("app", 'medicenter'),
					'baby' => esc_html__("baby", 'medicenter'),
					'baby-bed' => esc_html__("baby-bed", 'medicenter'),
					'baby-bottle' => esc_html__("baby-bottle", 'medicenter'),
					'bacteria' => esc_html__("bacteria", 'medicenter'),
					'balance' => esc_html__("balance", 'medicenter'),
					'battery' => esc_html__("battery", 'medicenter'),
					'book' => esc_html__("book", 'medicenter'),
					'box' => esc_html__("box", 'medicenter'),
					'brain' => esc_html__("brain", 'medicenter'),
					'briefcase' => esc_html__("briefcase", 'medicenter'),
					'burns' => esc_html__("burns", 'medicenter'),
					'cart' => esc_html__("cart", 'medicenter'),
					'cat' => esc_html__("cat", 'medicenter'),
					'certificate' => esc_html__("certificate", 'medicenter'),
					'chart' => esc_html__("chart", 'medicenter'),
					'chat' => esc_html__("chat", 'medicenter'),
					'clock' => esc_html__("clock", 'medicenter'),
					'config' => esc_html__("config", 'medicenter'),
					'credit-card' => esc_html__("credit-card", 'medicenter'),
					'cross' => esc_html__("cross", 'medicenter'),
					'dental-shield' => esc_html__("dental-shield", 'medicenter'),
					'dentist' => esc_html__("dentist", 'medicenter'),
					'diary' => esc_html__("diary", 'medicenter'),
					'dna' => esc_html__("dna", 'medicenter'),
					'doctor' => esc_html__("doctor", 'medicenter'),
					'document' => esc_html__("document", 'medicenter'),
					'document-missing' => esc_html__("document-missing", 'medicenter'),
					'dog' => esc_html__("dog", 'medicenter'),
					'drip' => esc_html__("drip", 'medicenter'),
					'ear' => esc_html__("ear", 'medicenter'),
					'email' => esc_html__("email", 'medicenter'),
					'eye' => esc_html__("eye", 'medicenter'),
					'facebook' => esc_html__("facebook", 'medicenter'),
					'first-aid' => esc_html__("first-aid", 'medicenter'),
					'fitness' => esc_html__("fitness", 'medicenter'),
					'frostbite' => esc_html__("frostbite", 'medicenter'),
					'gallery' => esc_html__("gallery", 'medicenter'),
					'glasses' => esc_html__("glasses", 'medicenter'),
					'graph' => esc_html__("graph", 'medicenter'),
					'healthcare' => esc_html__("healthcare", 'medicenter'),
					'heart' => esc_html__("heart", 'medicenter'),
					'heart-beat' => esc_html__("heart-beat", 'medicenter'),
					'home' => esc_html__("home", 'medicenter'),
					'hospital' => esc_html__("hospital", 'medicenter'),
					'id' => esc_html__("id", 'medicenter'),
					'image' => esc_html__("image", 'medicenter'),
					'keyboard' => esc_html__("keyboard", 'medicenter'),
					'lab' => esc_html__("lab", 'medicenter'),
					'laptop' => esc_html__("laptop", 'medicenter'),
					'leaf' => esc_html__("leaf", 'medicenter'),
					'lifeline' => esc_html__("lifeline", 'medicenter'),
					'list' => esc_html__("list", 'medicenter'),
					'location' => esc_html__("location", 'medicenter'),
					'lock' => esc_html__("lock", 'medicenter'),
					'map' => esc_html__("map", 'medicenter'),
					'medical-bed' => esc_html__("medical-bed", 'medicenter'),
					'medical-cast' => esc_html__("medical-cast", 'medicenter'),
					'medical-cross' => esc_html__("medical-cross", 'medicenter'),
					'medical-document' => esc_html__("medical-document", 'medicenter'),
					'medical-results' => esc_html__("medical-results", 'medicenter'),
					'medical-scissors' => esc_html__("medical-scissors", 'medicenter'),
					'medical-staff' => esc_html__("medical-staff", 'medicenter'),
					'minus' => esc_html__("minus", 'medicenter'),
					'mobile' => esc_html__("mobile", 'medicenter'),
					'molecule' => esc_html__("molecule", 'medicenter'),
					'money' => esc_html__("money", 'medicenter'),
					'mortar' => esc_html__("mortar", 'medicenter'),
					'movie' => esc_html__("movie", 'medicenter'),
					'network' => esc_html__("network", 'medicenter'),
					'paypal' => esc_html__("paypal", 'medicenter'),
					'pen' => esc_html__("pen", 'medicenter'),
					'people' => esc_html__("people", 'medicenter'),
					'pet-box' => esc_html__("pet-box", 'medicenter'),
					'phone' => esc_html__("phone", 'medicenter'),
					'piano' => esc_html__("piano", 'medicenter'),
					'pill' => esc_html__("pill", 'medicenter'),
					'pin' => esc_html__("pin", 'medicenter'),
					'plaster' => esc_html__("plaster", 'medicenter'),
					'play' => esc_html__("play", 'medicenter'),
					'plus' => esc_html__("plus", 'medicenter'),
					'printer' => esc_html__("printer", 'medicenter'),
					'pulse' => esc_html__("pulse", 'medicenter'),
					'quote' => esc_html__("quote", 'medicenter'),
					'science' => esc_html__("science", 'medicenter'),
					'screen' => esc_html__("screen", 'medicenter'),
					'signpost' => esc_html__("signpost", 'medicenter'),
					'spa' => esc_html__("spa", 'medicenter'),
					'spa-bamboo' => esc_html__("spa-bamboo", 'medicenter'),
					'spa-lotion' => esc_html__("spa-lotion", 'medicenter'),
					'speaker' => esc_html__("speaker", 'medicenter'),
					'stethoscope' => esc_html__("stethoscope", 'medicenter'),
					'syringe' => esc_html__("syringe", 'medicenter'),
					'tablet' => esc_html__("tablet", 'medicenter'),
					'tags' => esc_html__("tags", 'medicenter'),
					'teddy-bear' => esc_html__("teddy-bear", 'medicenter'),
					'test-tube' => esc_html__("test-tube", 'medicenter'),
					'tick' => esc_html__("tick", 'medicenter'),
					'time' => esc_html__("time", 'medicenter'),
					'toothbrush' => esc_html__("toothbrush", 'medicenter'),
					'twitter' => esc_html__("twitter", 'medicenter'),
					'video' => esc_html__("video", 'medicenter'),
					'wallet' => esc_html__("wallet", 'medicenter'),
					'x-ray' => esc_html__("x-ray", 'medicenter')
				],
				'default' => 'address',
				'condition' => [
					'type' => 'features'
				]
			]
		);
		$this->add_control(
			'icon_social',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Icon", 'medicenter'),
				'options' => [
					'angies-list' => esc_html__("angi", 'medicenter'),
					'app-store' => esc_html__("app-store", 'medicenter'),
					'behance' => esc_html__("behance", 'medicenter'),
					'bluesky' => esc_html__("bluesky", 'medicenter'),
					'bing' => esc_html__("bing", 'medicenter'),
					'buymeacoffee' => esc_html__("buymeacoffee", 'medicenter'),
					'deviantart' => esc_html__("deviantart", 'medicenter'),
					'discord' => esc_html__("discord", 'medicenter'),
					'dribbble' => esc_html__("dribbble", 'medicenter'),
					'dropbox' => esc_html__("dropbox", 'medicenter'),
					'email' => esc_html__("email", 'medicenter'),
					'envato' => esc_html__("envato", 'medicenter'),
					'facebook' => esc_html__("facebook", 'medicenter'),
					'facebook-messenger' => esc_html__("facebook-messenger", 'medicenter'),
					'figma' => esc_html__("figma", 'medicenter'),
					'flickr' => esc_html__("flickr", 'medicenter'),
					'foursquare' => esc_html__("foursquare", 'medicenter'),
					'github' => esc_html__("github", 'medicenter'),
					'google' => esc_html__("google", 'medicenter'),
					'google-play' => esc_html__("google-play", 'medicenter'),
					'houzz' => esc_html__("houzz", 'medicenter'),
					'instagram' => esc_html__("instagram", 'medicenter'),
					'line' => esc_html__("line", 'medicenter'),
					'linkedin' => esc_html__("linkedin", 'medicenter'),
					'location' => esc_html__("location", 'medicenter'),
					'medium' => esc_html__("medium", 'medicenter'),
					'microsoft-teams' => esc_html__("microsoft-teams", 'medicenter'),
					'mobile' => esc_html__("mobile", 'medicenter'),
					'mastodon' => esc_html__("mastodon", 'medicenter'),
					'patreon' => esc_html__("patreon", 'medicenter'),
					'pinterest' => esc_html__("pinterest", 'medicenter'),
					'podcast' => esc_html__("podcast", 'medicenter'),
					'paypal' => esc_html__("paypal", 'medicenter'),
					'qq' => esc_html__("qq", 'medicenter'),
					'qzone' => esc_html__("qzone", 'medicenter'),
					'reddit' => esc_html__("reddit", 'medicenter'),
					'rss' => esc_html__("rss", 'medicenter'),
					'share' => esc_html__("share", 'medicenter'),
					'signal' => esc_html__("signal", 'medicenter'),
					'skype' => esc_html__("skype", 'medicenter'),
					'slack' => esc_html__("slack", 'medicenter'),
					'snapchat' => esc_html__("snapchat", 'medicenter'),
					'soundcloud' => esc_html__("soundcloud", 'medicenter'),
					'spotify' => esc_html__("spotify", 'medicenter'),
					'stripe' => esc_html__("stripe", 'medicenter'),
					'substack' => esc_html__("substack", 'medicenter'),
					'telegram' => esc_html__("telegram", 'medicenter'),
					'tiktok' => esc_html__("tiktok", 'medicenter'),
					'tinder' => esc_html__("tinder", 'medicenter'),
					'twitter' => esc_html__("twitter-x", 'medicenter'),
					'tumblr' => esc_html__("tumblr", 'medicenter'),
					'threads' => esc_html__("threads", 'medicenter'),
					'twitch' => esc_html__("twitch", 'medicenter'),
					'viber' => esc_html__("viber", 'medicenter'),
					'vimeo' => esc_html__("vimeo", 'medicenter'),
					'vk' => esc_html__("vk", 'medicenter'),
					'wechat' => esc_html__("wechat", 'medicenter'),
					'weibo' => esc_html__("weibo", 'medicenter'),
					'whatsapp' => esc_html__("whatsapp", 'medicenter'),
					'xing' => esc_html__("xing", 'medicenter'),
					'yelp' => esc_html__("yelp", 'medicenter'),
					'youtube' => esc_html__("youtube", 'medicenter'),
					'zoom' => esc_html__("zoom", 'medicenter')
				],
				'default' => 'angies-list',
				'condition' => [
					'type' => 'social'
				]
			]
		);
		$this->add_control(
			'icon_template',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Icon", 'medicenter'),
				'options' => [
					'arrow-circle' => esc_html__("arrow-circle", 'medicenter'),
					'arrow-horizontal-1' => esc_html__("arrow-horizontal-1", 'medicenter'),
					'arrow-horizontal-2' => esc_html__("arrow-horizontal-2", 'medicenter'),
					'arrow-horizontal-3' => esc_html__("arrow-horizontal-3", 'medicenter'),
					'arrow-horizontal-4' => esc_html__("arrow-horizontal-4", 'medicenter'),
					'arrow-horizontal-5' => esc_html__("arrow-horizontal-5", 'medicenter'),
					'arrow-vertical-1' => esc_html__("arrow-vertical-1", 'medicenter'),
					'arrow-vertical-2' => esc_html__("arrow-vertical-2", 'medicenter'),
					'arrow-vertical-3' => esc_html__("arrow-vertical-3", 'medicenter'),
					'arrow-vertical-4' => esc_html__("arrow-vertical-4", 'medicenter'),
					'arrow-vertical-5' => esc_html__("arrow-vertical-5", 'medicenter'),
					'cart' => esc_html__("cart", 'medicenter'),
					'check' => esc_html__("check", 'medicenter'),
					'chevron' => esc_html__("chevron", 'medicenter'),
					'comment-1' => esc_html__("comment-1", 'medicenter'),
					'comment-2' => esc_html__("comment-2", 'medicenter'),
					'location' => esc_html__("location", 'medicenter'),
					'mail' => esc_html__("mail", 'medicenter'),
					'menu-1' => esc_html__("menu-1", 'medicenter'),
					'menu-2' => esc_html__("menu-2", 'medicenter'),
					'minus-1' => esc_html__("minus-1", 'medicenter'),
					'minus-2' => esc_html__("minus-2", 'medicenter'),
					'phone' => esc_html__("phone", 'medicenter'),
					'plus-1' => esc_html__("plus-1", 'medicenter'),
					'plus-2' => esc_html__("plus-2", 'medicenter'),
					'remove-1' => esc_html__("remove-1", 'medicenter'),
					'remove-2' => esc_html__("remove-2", 'medicenter'),
					'search' => esc_html__("search", 'medicenter'),
					'quote' => esc_html__("quote", 'medicenter'),
					'quote-2' => esc_html__("quote-2", 'medicenter'),
					'tick-1' => esc_html__("tick-1", 'medicenter'),
					'tick-2' => esc_html__("tick-2", 'medicenter')
				],
				'default' => 'arrow-circle',
				'condition' => [
					'type' => 'template'
				]
			]
		);
		$this->add_control(
			'url',
			[
				'label' => esc_html__("Url", 'medicenter'),
				'type' => Controls_Manager::URL,
				'options' => false,
				'label_block' => true
			]
		);
		$this->add_control(
			'url_target',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Url target", 'medicenter'),
				'options' => [
					'new_window' => esc_html__("new window", 'medicenter'),
					'same_window' => esc_html__("same window", 'medicenter')
				],
				'default' => 'new_window'
			]
		);
		$this->add_control(
			'title',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Title", 'medicenter')
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$settings["url"] = $settings["url"]["url"];
		echo mc_theme_mc_icon($settings);
	}

	protected function content_template(){}
}
?>
