<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class MediCenterWidget_MediCenter_Menu extends Widget_Base 
{

	public function get_name()
	{
		return 'medicenter_menu';
	}

	public function get_title()
	{
		return esc_html__("Menu", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-nav-menu';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return true;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$menus = wp_get_nav_menus();
		$options = [];
		foreach($menus as $menu)
		{
			$options[$menu->slug] = $menu->name;
		}
		$menus = $options;

		if(!empty($menus))
		{
			$this->add_control(
				'menu',
				[
					'label' => esc_html__("Menu", 'medicenter'),
					'type' => Controls_Manager::SELECT,
					'options' => $menus,
					'default' => array_keys($menus)[0],
					'save_default' => true,
					'separator' => 'after',
					'description' => sprintf(
						/* translators: 1: Link opening tag, 2: Link closing tag. */
						esc_html__('Go to the %1$sMenus screen%2$s to manage your menus.', 'medicenter'),
						sprintf('<a href="%s" target="_blank">', admin_url('nav-menus.php')),
						'</a>'
					)
				]
			);
		}
		else
		{
			$this->add_control(
				'menu',
				[
					'type' => Controls_Manager::ALERT,
					'alert_type' => 'info',
					'heading' => esc_html__("There are no menus in your site.", 'medicenter'),
					'content' => sprintf(
						/* translators: 1: Link opening tag, 2: Link closing tag. */
						esc_html__('Go to the %1$sMenus screen%2$s to create one.', 'medicenter'),
						sprintf('<a href="%s" target="_blank">', admin_url('nav-menus.php?action=edit&menu=0')),
						'</a>'
					),
					'separator' => 'after'
				]
			);
		}
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$args = [
			"container" => "nav",
			'menu' => $settings['menu'],
			'menu_class' => 'elementor-nav-menu',
			'container_class' => 'vertical-menu'
		];
		wp_nav_menu($args);
	}

	protected function content_template(){}
}
?>
