<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class MediCenterWidget_Notification_Box extends Widget_Base 
{

	public function get_name()
	{
		return 'notification_box';
	}

	public function get_title()
	{
		return esc_html__("Notification Box", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-notification';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'header',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Header", 'medicenter'),
				'label_block' => true,
				'default' => esc_html__("Sample header", 'medicenter')
			]
		);
		$this->add_control(
			'info_text',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Info text", 'medicenter'),
				'label_block' => true
			]
		);
		$this->add_control(
			'type',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Type", 'medicenter'),
				'options' => [
					'success' => esc_html__("Success", 'medicenter'),
					'error' => esc_html__("Error", 'medicenter'),
					'info' => esc_html__("Info", 'medicenter')
				],
				'default' => 'success'
			]
		);
		$this->add_control(
			'closing_time',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Auto closing time (in seconds)", 'medicenter')
			]
		);
		$this->add_control(
			'close_icon',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Close icon", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'custom_background_color',
			[
				'type' => Controls_Manager::COLOR,
				'label' => esc_html__("Custom background color", 'medicenter')
			]
		);
		$this->add_control(
			'header_color',
			[
				'type' => Controls_Manager::COLOR,
				'label' => esc_html__("Header text color", 'medicenter')
			]
		);
		$this->add_control(
			'content_text_color',
			[
				'type' => Controls_Manager::COLOR,
				'label' => esc_html__("Content text color", 'medicenter')
			]
		);
		$this->add_control(
			'top_margin',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Top margin", 'medicenter'),
				'options' => [
					'none' => esc_html__("None", 'medicenter'),
					'page-margin-top' => esc_html__("Page (small)", 'medicenter'),
					'page-margin-top-section' => esc_html__("Section (large)", 'medicenter')
				],
				'default' => 'none'
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		echo mc_theme_notification_box($settings);
	}

	protected function content_template(){}
}
?>
