<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class MediCenterWidget_Our_Clients_List extends Widget_Base 
{

	public function get_name()
	{
		return 'our_clients';
	}

	public function get_title()
	{
		return esc_html__("Our Clients List", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-form-vertical';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'images',
			[
				'label' => esc_html__("Images", 'medicenter'),
				'type' => Controls_Manager::GALLERY,
				'show_label' => false,
				'default' => []
			]
		);
		$this->add_control(
			'onclick',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("On click action", 'medicenter'),
				'options' => [
					'link_image' => esc_html__("Open prettyPhoto", 'medicenter'),
					'link_no' => esc_html__("None", 'medicenter'),
					'custom_link' => esc_html__("Open custom links", 'medicenter')
				],
				'default' => 'link_image',
			]
		);
		$this->add_control(
			'custom_links',
			[
				'type' => Controls_Manager::TEXTAREA,
				'label' => esc_html__("Custom links", 'medicenter'),
				'rows' => 10,
				'description' => esc_html__("Enter links for each slide (Note: divide links with linebreaks (Enter)).", 'medicenter'),
				'condition' => [
					'onclick' => "custom_link",
				]
			]
		);
		$this->add_control(
			'custom_links_target',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Custom link target", 'medicenter'),
				'options' => [
					'_self' => esc_html__("Same window", 'medicenter'),
					'_blank' => esc_html__("New window", 'medicenter')
				],
				'default' => '_self',
				'condition' => [
					'onclick' => "custom_link",
				]
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$images = "";
		foreach($settings["images"] as $image)
		{
			$images .= $image["id"] . (end($settings["images"])!=$image ? ", " : "");
		}
		$settings["images"] = $images;
		if(!empty($settings["custom_links"]))
		{
			$settings["custom_links"] = str_replace("\n", ",", $settings["custom_links"]);
		}
		echo mc_theme_our_clients($settings);
	}

	protected function content_template(){}
}
?>
