<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class MediCenterWidget_Sentence extends Widget_Base 
{

	public function get_name()
	{
		return 'sentence';
	}

	public function get_title()
	{
		return esc_html__("Sentence", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-editor-quote';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Title", 'medicenter'),
				'default' => esc_html__("Sample Sentence Text", 'medicenter')
			]
		);
		$this->add_control(
			'author',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Author", 'medicenter')
			]
		);
		$this->add_control(
			'title_animation',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Title animation", 'medicenter'),
				'options' => [
					'' => esc_html__("none", 'medicenter'),
					'fadeIn' => esc_html__("fade in", 'medicenter'),
					'scale' => esc_html__("scale", 'medicenter'),
					'slideRight' => esc_html__("slide right", 'medicenter'),
					'slideRight200' => esc_html__("slide right 200%", 'medicenter'),
					'slideLeft' => esc_html__("slide left", 'medicenter'),
					'slideLeft50' => esc_html__("slide left 50%", 'medicenter'),
					'slideDown' => esc_html__("slide down", 'medicenter'),
					'slideDown200' => esc_html__("slide down 200%", 'medicenter'),
					'slideUp' => esc_html__("slide up", 'medicenter')
				],
				'default' => ''
			]
		);
		$this->add_control(
			'title_animation_duration',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Title animation duration", 'medicenter'),
				'default' => 600
			]
		);
		$this->add_control(
			'title_animation_delay',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Title animation delay", 'medicenter'),
				'default' => 0
			]
		);
		$this->add_control(
			'author_animation',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Author animation", 'medicenter'),
				'options' => [
					'' => esc_html__("none", 'medicenter'),
					'fadeIn' => esc_html__("fade in", 'medicenter'),
					'scale' => esc_html__("scale", 'medicenter'),
					'slideRight' => esc_html__("slide right", 'medicenter'),
					'slideRight200' => esc_html__("slide right 200%", 'medicenter'),
					'slideLeft' => esc_html__("slide left", 'medicenter'),
					'slideLeft50' => esc_html__("slide left 50%", 'medicenter'),
					'slideDown' => esc_html__("slide down", 'medicenter'),
					'slideDown200' => esc_html__("slide down 200%", 'medicenter'),
					'slideUp' => esc_html__("slide up", 'medicenter')
				],
				'default' => ''
			]
		);
		$this->add_control(
			'author_animation_duration',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Author animation duration", 'medicenter'),
				'default' => 600
			]
		);
		$this->add_control(
			'author_animation_delay',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Author animation delay", 'medicenter'),
				'default' => 0
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		echo mc_theme_sentence($settings);
	}

	protected function content_template(){}
}
?>
