<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Utils;

class MediCenterWidget_Service_Box extends Widget_Base 
{

	public function get_name()
	{
		return 'service_box';
	}

	public function get_title()
	{
		return esc_html__("Service Box", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-single-page';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return true;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'featured_image',
			[
				'label' => esc_html__("Alternative featured image", 'medicenter'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'headers',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Headers", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
			]
		);
		$this->add_control(
			'headers_links',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Header link", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
			]
		);
		$this->add_control(
			'show_excerpt',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show excerpt", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
			]
		);
		$this->add_control(
			'show_featured_image',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show featured image", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
			]
		);
		$this->add_control(
			'featured_image_links',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Featured image link", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
				'condition' => [
					'show_featured_image' => "1",
				]
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$settings["featured_image"] = $settings["featured_image"]["id"];
		echo mc_theme_service_box($settings);
	}

	protected function content_template(){}
}
?>
