<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class MediCenterWidget_Single_Post extends Widget_Base 
{

	public function get_name()
	{
		return 'single_post';
	}

	public function get_title()
	{
		return esc_html__("Single Post", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-single-post';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return true;
	}

	protected function register_controls()
	{
		global $theme_options;
		//image sizes
		$image_sizes_array = array();
		$image_sizes_array["default"] = esc_html__("Default", 'medicenter');
		global $_wp_additional_image_sizes;
		foreach(get_intermediate_image_sizes() as $s) 
		{
			if(isset($_wp_additional_image_sizes[$s])) 
			{
				$width = intval($_wp_additional_image_sizes[$s]['width']);
				$height = intval($_wp_additional_image_sizes[$s]['height']);
			}
			else
			{
				$width = get_option($s.'_size_w');
				$height = get_option($s.'_size_h');
			}
			$image_sizes_array[$s] = $s . " (" . $width . "x" . $height . ")";
		}
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'info',
			[
				'type' => Controls_Manager::ALERT,
				'alert_type' => 'info',
				'heading' => esc_html__("Single Post content", 'medicenter'),
				'content' => __('This widget does not have a visual representation. The content of the specific post will be displayed in its place.<br><br>For the page where you\'re using this component, you need to set the \'Page Layout\' option to \'Single post\' under <a class="route-page-settings" title="Go to Page Settings" href="#" rel="nofollow">Page Settings</a>', 'medicenter')
			]
		);
		$this->add_control(
			'featured_image_size',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Featured image size", 'medicenter'),
				'options' => $image_sizes_array,
				'default' => 'default'
			]
		);
		$this->add_control(
			'columns',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Layout type", 'medicenter'),
				'options' => [
					'1' => esc_html__("Type 1", 'medicenter'),
					'2' => esc_html__("Type 2", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'show_post_title',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show post title", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'show_post_featured_image',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show post featured image", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'featured_image_action',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Featured image action", 'medicenter'),
				'options' => [
					'lightbox' => esc_html__("Lightbox", 'medicenter'),
					'no_action' => esc_html__("No action", 'medicenter')
				],
				'default' => 'lightbox',
				'condition' => [
					'show_post_featured_image' => "1"
				]
			]
		);
		$this->add_control(
			'show_post_categories',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show post categories", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'show_post_author',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show post author", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'comments',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Comments", 'medicenter'),
				'options' => [
					'1' => esc_html__("Enabled", 'medicenter'),
					'0' => esc_html__("Disabled", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'terms_checkbox',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Terms and conditions checkbox", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '0',
				'condition' => [
					'comments' => "1",
				]
			]
		);
		$this->add_control(
			'terms_message',
			[
				'type' => Controls_Manager::TEXTAREA,
				'label' => esc_html__("Terms and conditions message", 'medicenter'),
				'rows' => 5,
				'default' => esc_html__("Please accept terms and conditions", 'medicenter'),
				'condition' => [
					'comments' => "1",
					'terms_checkbox' => "1",
				]
			]
		);
		$this->add_control(
			'recaptcha',
			[
				'label' => esc_html__("reCaptcha", 'medicenter'),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => '<div class="elementor-control-input-wrapper elementor-control-unit-5 elementor-control-dynamic-switcher-wrapper">
					<input type="text" class="tooltip-target elementor-control-tag-area" data-tooltip="" data-setting="recaptcha" placeholder="" original-title="" value="' . ((int)$theme_options["google_recaptcha_comments"] ? esc_html__("Yes", 'medicenter') : esc_html__("No", 'medicenter')) . '">
				</div><div class="elementor-control-field-description">' . sprintf(__("You can change this setting under <a href='%s' title='Theme Options'>Theme Options</a>", 'medicenter'), esc_url(admin_url("themes.php?page=ThemeOptions"))) . '</div>',
				'classes' => "medicenter-elementor-readonly",
				'condition' => [
					'comments' => "1"
				]
			]
		);
		$this->add_control(
			'comments_form_animation',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Comments form box animation", 'medicenter'),
				'options' => [
					'' => esc_html__("none", 'medicenter'),
					'fadeIn' => esc_html__("fade in", 'medicenter'),
					'scale' => esc_html__("scale", 'medicenter'),
					'slideRight' => esc_html__("slide right", 'medicenter'),
					'slideRight200' => esc_html__("slide right 200%", 'medicenter'),
					'slideLeft' => esc_html__("slide left", 'medicenter'),
					'slideLeft50' => esc_html__("slide left 50%", 'medicenter'),
					'slideDown' => esc_html__("slide down", 'medicenter'),
					'slideDown200' => esc_html__("slide down 200%", 'medicenter'),
					'slideUp' => esc_html__("slide up", 'medicenter')
				],
				'default' => '',
				'condition' => [
					'comments' => "1",
				]
			]
		);
		$this->add_control(
			'comments_form_animation_duration',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Comments form box animation duration (ms)", 'medicenter'),
				'default' => 600,
				'condition' => [
					'comments' => "1",
				]
			]
		);
		$this->add_control(
			'comments_form_animation_delay',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Comments form box animation delay (ms)", 'medicenter'),
				'default' => 0,
				'condition' => [
					'comments' => "1",
				]
			]
		);
		$this->add_control(
			'show_post_date_box',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show post date in box above post", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
				'condition' => [
					'columns' => "2",
				]
			]
		);
		$this->add_control(
			'show_post_comments_box',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show comments number in box above post", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
				'condition' => [
					'columns' => "2",
				]
			]
		);
		$this->add_control(
			'show_post_comments_label',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show comments number label in box above post", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '0'
			]
		);
		$this->add_control(
			'post_date_animation',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Post date box animation", 'medicenter'),
				'options' => [
					'' => esc_html__("none", 'medicenter'),
					'fadeIn' => esc_html__("fade in", 'medicenter'),
					'scale' => esc_html__("scale", 'medicenter'),
					'slideRight' => esc_html__("slide right", 'medicenter'),
					'slideRight200' => esc_html__("slide right 200%", 'medicenter'),
					'slideLeft' => esc_html__("slide left", 'medicenter'),
					'slideLeft50' => esc_html__("slide left 50%", 'medicenter'),
					'slideDown' => esc_html__("slide down", 'medicenter'),
					'slideDown200' => esc_html__("slide down 200%", 'medicenter'),
					'slideUp' => esc_html__("slide up", 'medicenter')
				],
				'default' => ''
			]
		);
		$this->add_control(
			'post_date_animation_duration',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Post date box animation duration (ms)", 'medicenter'),
				'default' => 600
			]
		);
		$this->add_control(
			'post_date_animation_delay',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Post date box animation delay (ms)", 'medicenter'),
				'default' => 0
			]
		);
		$this->add_control(
			'post_comments_animation',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Post comments box animation", 'medicenter'),
				'options' => [
					'' => esc_html__("none", 'medicenter'),
					'fadeIn' => esc_html__("fade in", 'medicenter'),
					'scale' => esc_html__("scale", 'medicenter'),
					'slideRight' => esc_html__("slide right", 'medicenter'),
					'slideRight200' => esc_html__("slide right 200%", 'medicenter'),
					'slideLeft' => esc_html__("slide left", 'medicenter'),
					'slideLeft50' => esc_html__("slide left 50%", 'medicenter'),
					'slideDown' => esc_html__("slide down", 'medicenter'),
					'slideDown200' => esc_html__("slide down 200%", 'medicenter'),
					'slideUp' => esc_html__("slide up", 'medicenter')
				],
				'default' => ''
			]
		);
		$this->add_control(
			'post_comments_animation_duration',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Post comments box animation duration (ms)", 'medicenter'),
				'default' => 600
			]
		);
		$this->add_control(
			'post_comments_animation_delay',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Post comments box animation delay (ms)", 'medicenter'),
				'default' => 0
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		if(!(int)\Elementor\Plugin::$instance->editor->is_edit_mode() && (get_post_type()=="post" || get_post_type()=="features" || get_post_type()=="medicenter_gallery"))
		{
			$settings = $this->get_settings_for_display();
			echo mc_theme_single_post($settings);
		}
	}

	protected function content_template(){}
}
?>
