<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class MediCenterWidget_Single_Service extends Widget_Base 
{

	public function get_name()
	{
		return 'single_service';
	}

	public function get_title()
	{
		return esc_html__("Single Service", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-single-post';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return true;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'info',
			[
				'type' => Controls_Manager::ALERT,
				'alert_type' => 'info',
				'heading' => esc_html__("Single Service content", 'medicenter'),
				'content' => __('This widget does not have a visual representation. The content of the specific service will be displayed in its place.<br><br>For the page where you\'re using this component, you need to set the \'Page Layout\' option to \'Service\' under <a class="route-page-settings" title="Go to Page Settings" href="#" rel="nofollow">Page Settings</a>', 'medicenter')
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		if(!(int)\Elementor\Plugin::$instance->editor->is_edit_mode() && get_post_type()=="ql_services")
		{
			echo mc_theme_single_service(array());
		}
	}

	protected function content_template(){}
}
?>
