<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class MediCenterWidget_Testimonials extends Widget_Base 
{

	public function get_name()
	{
		return 'testimonials';
	}

	public function get_title()
	{
		return esc_html__("Testimonials", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-testimonial-carousel';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'testimonials_id',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Id", 'medicenter'),
				'default' => 'testimonials',
				'description' => esc_html__("Please provide unique id for each testimonials carousel on the same page/post", 'medicenter')
			]
		);
		$this->add_control(
			'controls_position',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Controls position", 'medicenter'),
				'options' => [
					'default' => esc_html__("Default", 'medicenter'),
					'bottom' => esc_html__("Bottom", 'medicenter')
				],
				'default' => 'default'
			]
		);
		$this->add_control(
			'header',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Header", 'medicenter'),
				'default' => "",
				'condition' => [
					'controls_position' => "default",
				]
			]
		);
		$this->add_control(
			'header_border_animation',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Header border animation", 'medicenter'),
				'options' => [
					'1' => esc_html__("yes", 'medicenter'),
					'0' => esc_html__("no", 'medicenter')
				],
				'default' => '0',
				'condition' => [
					'controls_position' => "default",
				]
			]
		);
		$this->add_control(
			'layout',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Layout", 'medicenter'),
				'options' => [
					'sm-6' => esc_html__("2 columns", 'medicenter'),
					'sm-12' => esc_html__("1 column", 'medicenter')
				],
				'default' => 'sm-6'
			]
		);
		$this->add_control(
			'testimonials',
			[
				'label' => esc_html__("Testimonials", 'medicenter'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name' => 'title',
						'label' => esc_html__("Text", 'medicenter'),
						'type' => Controls_Manager::WYSIWYG,
						'default' => esc_html__("Sample Sentence Text", 'medicenter'),
						'label_block' => true
					],
					[
						'name' => 'author',
						'label' => esc_html__("Author", 'medicenter'),
						'type' => Controls_Manager::TEXT,
						'default' => esc_html("&#8212;  Sample Author", 'medicenter')
					]
				],
				'default' => [
					[
						'title' => esc_html__("Sample Sentence Text #1", 'medicenter')
					],
					[
						'title' => esc_html__("Sample Sentence Text #2", 'medicenter')
					],
					[
						'title' => esc_html__("Sample Sentence Text #3", 'medicenter')
					]
				],
				'title_field' => '{{{ title }}}'
			]
		);
		$this->add_control(
			'icon',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Quote icon", 'medicenter'),
				'options' => [
					'0' => esc_html__("No", 'medicenter'),
					'1' => esc_html__("Yes", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'autoplay',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Autoplay", 'medicenter'),
				'options' => [
					'0' => esc_html__("No", 'medicenter'),
					'1' => esc_html__("Yes", 'medicenter')
				],
				'default' => '0'
			]
		);
		$this->add_control(
			'pause_on_hover',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Pause on hover", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
				'condition' => [
					'autoplay' => "1",
				]
			]
		);
		$this->add_control(
			'scroll',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Scroll", 'medicenter'),
				'default' => '1',
				'description' => esc_html__("Number of items to scroll in one step", 'medicenter')
			]
		);
		$this->add_control(
			'effect',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Effect", 'medicenter'),
				'options' => [
					'none' => esc_html__("none", 'medicenter'),
					'scroll' => esc_html__("scroll", 'medicenter'),
					'directscroll' => esc_html__("directscroll", 'medicenter'),
					'_fade' => esc_html__("fade", 'medicenter'),
					'crossfade' => esc_html__("crossfade", 'medicenter'),
					'cover' => esc_html__("cover", 'medicenter'),
					'uncover' => esc_html__("uncover", 'medicenter')
				],
				'default' => 'scroll'
			]
		);
		$this->add_control(
			'easing',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Sliding easing", 'medicenter'),
				'options' => [
					'swing' => esc_html__("swing", 'medicenter'),
					'linear' => esc_html__("linear", 'medicenter'),
					'easeInQuad' => esc_html__("easeInQuad", 'medicenter'),
					'easeOutQuad' => esc_html__("easeOutQuad", 'medicenter'),
					'easeInOutQuad' => esc_html__("easeInOutQuad", 'medicenter'),
					'easeInCubic' => esc_html__("easeInCubic", 'medicenter'),
					'easeOutCubic' => esc_html__("easeOutCubic", 'medicenter'),
					'easeInOutCubic' => esc_html__("easeInOutCubic", 'medicenter'),
					'easeInQuart' => esc_html__("easeOutQuart", 'medicenter'),
					'easeOutQuart' => esc_html__("easeOutQuart", 'medicenter'),
					'easeInOutQuart' => esc_html__("easeInOutQuart", 'medicenter'),
					'easeInSine' => esc_html__("easeInSine", 'medicenter'),
					'easeOutSine' => esc_html__("easeOutSine", 'medicenter'),
					'easeInOutSine' => esc_html__("easeInOutSine", 'medicenter'),
					'easeInExpo' => esc_html__("easeInExpo", 'medicenter'),
					'easeOutExpo' => esc_html__("easeOutExpo", 'medicenter'),
					'easeInOutExpo' => esc_html__("easeInOutExpo", 'medicenter'),
					'easeInQuint' => esc_html__("easeInQuint", 'medicenter'),
					'easeOutQuint' => esc_html__("easeOutQuint", 'medicenter'),
					'easeInOutQuint' => esc_html__("easeInOutQuint", 'medicenter'),
					'easeInCirc' => esc_html__("easeInCirc", 'medicenter'),
					'easeOutCirc' => esc_html__("easeOutCirc", 'medicenter'),
					'easeInOutCirc' => esc_html__("easeInOutCirc", 'medicenter'),
					'easeInElastic' => esc_html__("easeInElastic", 'medicenter'),
					'easeOutElastic' => esc_html__("easeOutElastic", 'medicenter'),
					'easeInOutElastic' => esc_html__("easeInOutElastic", 'medicenter'),
					'easeInBack' => esc_html__("easeInBack", 'medicenter'),
					'easeOutBack' => esc_html__("easeOutBack", 'medicenter'),
					'easeInOutBack' => esc_html__("easeInOutBack", 'medicenter'),
					'easeInBounce' => esc_html__("easeInBounce", 'medicenter'),
					'easeOutBounce' => esc_html__("easeOutBounce", 'medicenter'),
					'easeInOutBounce' => esc_html__("easeInOutBounce", 'medicenter')
				],
				'default' => 'swing'
			]
		);
		$this->add_control(
			'duration',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Sliding transition speed (ms)", 'medicenter'),
				'default' => 500
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		
		if(!empty($settings["testimonials_id"]))
		{
			$settings["id"] = $settings["testimonials_id"];
		}
		$settings["animation"] = $settings["header_border_animation"];
		echo mc_theme_testimonials_shortcode($settings);
	}

	protected function content_template(){}
}
?>
