<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class MediCenterWidget_Timeline_Item extends Widget_Base 
{

	public function get_name()
	{
		return 'timeline_item';
	}

	public function get_title()
	{
		return esc_html__("Timeline Item", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-time-line';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Label", 'medicenter'),
				'label_block' => false
			]
		);
		$this->add_control(
			'label_position',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Label position", 'medicenter'),
				'label_block' => false,
				'default' => '0',
				'description' => esc_html__("Default: 0 - label centered. To move it bottom please set positive value (for example: 10). To move it top, please set negative value (for example: -10).", 'medicenter')
			]
		);
		$this->add_control(
			'title',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Title", 'medicenter')
			]
		);
		$this->add_control(
			'subtitle',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Subtitle", 'medicenter')
			]
		);
		$this->add_control(
			'content',
			[
				'type' => Controls_Manager::WYSIWYG,
				'label' => esc_html__("Text", 'medicenter')
			]
		);
		$this->add_control(
			'animations',
			[
				'label' => esc_html__("Animations", 'medicenter'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'medicenter'),
				'label_off' => esc_html__('No', 'medicenter'),
				'return_value' => '1',
				'default' => '1'
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		echo mc_theme_timeline_item($settings, $settings["content"]);
	}

	protected function content_template(){}
}
?>
