
(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			novaInteractiveProductCategoriesInteractiveList.init();
		}
	);

	var novaInteractiveProductCategoriesInteractiveList = {
		init: function () {
			this.holder = $( '.nova-interactive-product-categories.nova-layout--interactive-list' );
			if ( this.holder.length ) {
				this.holder.each(
					function () {
						novaInteractiveProductCategoriesInteractiveList.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			var $links            = $currentItem.find( '.nova-m-item' ),
				x                 = 0,
				y                 = 0,
				currentXCPosition = 0,
				currentYCPosition = 0;

			if ( $links.length ) {
				$links.on(
					'mouseenter',
					function () {
						$links.removeClass( 'nova--active' );
						$( this ).addClass( 'nova--active' );
					}
				).on(
					'mousemove',
					function ( event ) {
						var $thisLink         = $( this ),
							$followInfoHolder = $thisLink.find( '.nova-list-follow-content' ),
							$followImage      = $followInfoHolder.find( '.nova-list-follow-image' ),
							$followImageItem  = $followImage.find( 'img' ),
							followImagesCount = parseInt(
								$followImage.data( 'images-count' ),
								10
							),
							followImagesSrc   = $followImage.data( 'images' ),
							itemWidth         = $thisLink.outerWidth(),
							itemHeight        = $thisLink.outerHeight(),
							itemOffsetTop     = $thisLink.offset().top - $( window ).scrollTop(),
							itemOffsetLeft    = $thisLink.offset().left;

						x = (event.clientX - itemOffsetLeft) >> 0;
						y = (event.clientY - itemOffsetTop) >> 0;

						if ( x > itemWidth ) {
							currentXCPosition = itemWidth;
						} else if ( x < 0 ) {
							currentXCPosition = 0;
						} else {
							currentXCPosition = x;
						}

						if ( y > itemHeight ) {
							currentYCPosition = itemHeight;
						} else if ( y < 0 ) {
							currentYCPosition = 0;
						} else {
							currentYCPosition = y;
						}

						if ( followImagesCount > 1 ) {
							var imagesUrl    = followImagesSrc.split( '|' ),
								itemPartSize = itemWidth / followImagesCount;

							$followImageItem.removeAttr( 'srcset' );

							if ( currentXCPosition < itemPartSize ) {
								$followImageItem.attr(
									'src',
									imagesUrl[0]
								);
							}

							// -2 is constant - to remove first and last item from the loop
							for ( var index = 1; index <= (followImagesCount - 2); index++ ) {
								if ( currentXCPosition >= itemPartSize * index && currentXCPosition < itemPartSize * (index + 1) ) {
									$followImageItem.attr(
										'src',
										imagesUrl[index]
									);
								}
							}

							if ( currentXCPosition >= itemWidth - itemPartSize ) {
								$followImageItem.attr(
									'src',
									imagesUrl[followImagesCount - 1]
								);
							}
						}

						$followImage.css(
							{
								'top': itemHeight / 2
							}
						);

						$followInfoHolder.css( { 'top': currentYCPosition, 'left': currentXCPosition } );
					}
				).on(
					'mouseleave',
					function () {
						$links.removeClass( 'nova--active' );
					}
				);
			}

			$currentItem.addClass( 'nova--init' );
		}
	};
})( jQuery );