<?php
/**
 * PLS Theme Options
 */

if ( ! class_exists( 'Redux' ) ) {
	return;
}

    $opt_name 			= 'pls_modave_options';
    $theme				= wp_get_theme( PLS_THEME_NAME );
	$product_attributes	= pls_get_product_attributes();
	$custom_blocks 		= pls_get_posts_by_post_type( 'block', esc_html__( 'Select Block', 'modave' ) );
	$form_list			= pls_get_wpcf7_contact_form( esc_html__( 'Select Contact Form', 'modave' ) );
    $args = array(
        'opt_name'             		=> $opt_name,
        'display_name'         		=> apply_filters( 'pls_theme_name', $theme->get( 'Name' ) ),
        'display_version'      		=> $theme->get( 'Version' ),
        'menu_type'            		=> 'submenu',
        'allow_sub_menu'       		=> true,
        'menu_title'           		=> esc_html__( 'Theme Options', 'modave' ),
        'page_title'           		=> esc_html__( 'Theme Options', 'modave' ),
		'google_api_key'       		=> '',
        'google_update_weekly' 		=> true,
        'async_typography'     		=> false,
        'global_variable'      		=> '',
        'dev_mode'             		=> false,
        'customizer'          		=> false,
        'page_priority'       		=> null,
        'page_parent'          		=> 'pls-theme',
        'page_permissions'     		=> 'manage_options',
        'menu_icon'            		=> '',
        'page_icon'            		=> 'icon-themes',
        'page_slug'            		=> 'pls-theme-option',
        'save_defaults'        		=> true,
        'default_show'         		=> false,
        'default_mark'         		=> '',
        'show_import_export'   		=> true,
        'transient_time'       		=> 60 * MINUTE_IN_SECONDS,
        'output'               		=> true,
        'output_tag'           		=> true,
		'font_display'              => 'swap',
		'footer_credit'             => ' ',
    );

    Redux::setArgs( $opt_name, $args );
	
	/*
	* General
	*/
    Redux::setSection( $opt_name, array(
        'title'            	=> esc_html__( 'General', 'modave' ),
        'id'               	=> 'general-options',
        'desc'             	=> '',
		'fields'           	=> array(
			array(
                'id'       			=> 'theme-layout',
                'type'     			=> 'image_select',
                'title'    			=> esc_html__( 'Theme Layout', 'modave' ),
				'subtitle' 			=> esc_html__( 'Select layout of site.', 'modave' ),
                'options'  			=> array(
					'wide' => array(
                        'title' 	=> esc_html__( 'Wide', 'modave' ),
                        'alt' 		=> esc_html__( 'Wide', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/wide.png',
                    ),  
					'full' => array(
                        'title' 	=> esc_html__( 'Full', 'modave' ),
                        'alt' 		=> esc_html__( 'Full', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/full.png',
                    ),                   
                    'boxed' => array(
                        'title' 	=> esc_html__( 'Boxed', 'modave' ),
                        'alt' 		=> esc_html__( 'Boxed', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/box.png',
                    ),
                ),
                'default'  		=> 'full',
            ),
			array(
                'id'            	=> 'theme-container-width',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Container Width (px)', 'modave' ),
				'subtitle'          => esc_html__( 'Theme container width in pixels', 'modave' ),
                'default'       	=> 1320,
                'min'           	=> 1025,
                'step'          	=> 1,
                'max'           	=> 1920,
				'required' 			=> array( 'theme-layout', '=', array( 'full', 'boxed' ) ),
            ),
			array(
                'id'            	=> 'theme-container-wide-width',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Container Width (px)', 'modave' ),
				'subtitle'          => esc_html__( 'Theme container wide layout width in pixels', 'modave' ),
                'default'       	=> 1820,
                'min'           	=> 1200,
                'step'          	=> 1,
                'max'           	=> 2400,
				'required' 			=> array( 'theme-layout', '=', array( 'wide' ) ),
            ),
			array(
                'id'            	=> 'theme-grid-gap',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Grid Gap', 'modave' ),
				'subtitle'          => esc_html__( 'Theme grid gapping/spacing between two columns. Like 5px, 10px, 15px, etc...', 'modave' ),
                'default'       	=> 15,
                'min'           	=> 5,
                'step'          	=> 1,
                'max'           	=> 30,
            ),
			array(
                'id'       			=> 'header-logo',
                'type'     			=> 'media',
                'url'      			=> false,
                'title'    			=> esc_html__( 'Logo', 'modave' ),
                'compiler' 			=> 'true',
                'subtitle' 			=> esc_html__( 'Upload header logo.', 'modave' ),
                'default'  			=> array(),
            ),
			array(
                'id'       			=> 'header-logo-light',
                'type'     			=> 'media',
                'url'      			=> false,
                'title'    			=> esc_html__( 'Logo Light Version', 'modave' ),
				'subtitle'          => esc_html__( 'Upload an alternative light logo that will be used on dark and transparent header.', 'modave' ),
                'compiler' 			=> 'true',
               'default'  			=> array(),
			),
			array(
                'id'            	=> 'header-logo-width',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Logo Width', 'modave' ),
				'subtitle'          => esc_html__( 'Logo width in pixels', 'modave' ),
                'default'       	=> 170,
                'min'           	=> 50,
                'step'          	=> 1,
                'max'           	=> 500,
                'display_value' 	=> 'text',
            ),
			array(
                'id'      			=> 'mobile-header-logo',
                'type'     			=> 'media',
                'url'      			=> false,
                'title'    			=> esc_html__( 'Mobile Header Logo', 'modave' ),
				'subtitle'          => esc_html__( 'Upload mobile header logo', 'modave' ),
                'compiler' 			=> 'true',
				'default'  			=> array(),
			),
			array(
                'id'            	=> 'mobile-header-logo-width',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Mobile Header Logo Width', 'modave' ),				
				'subtitle'          => esc_html__( 'Logo max width in pixels', 'modave' ),
                'default'       	=> 148,
                'min'           	=> 50,
                'step'          	=> 1,
                'max'           	=> 500,
                'display_value' 	=> 'text',
            ),
		)
    ) );
	
	/**
	* Site Preloader
	*/
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'Site Preloader', 'modave' ),
        'id'         		=> 'section-site-preloader',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       			=> 'site-preloader',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Site Preloader', 'modave' ),
                'subtitle'    		=> esc_html__( 'Show site preloader on your website.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
                'off'      			=> esc_html__( 'No', 'modave' ),
                'default'  			=> 0,
            ),
			array(
                'id'       			=> 'preloader-background',
                'type'    			=> 'color',
				'title'   			=> esc_html__( 'Preloader Background', 'modave' ),
				'subtitle'			=> esc_html__( 'Set preloader background color.', 'modave' ),				
				'transparent'		=> false,
				'default'    		=> '#181818',
				'required' 			=> array( 'site-preloader', '=', 1 ),
            ),
			array(
				'id'      			=> 'preloader-image',
				'type'    			=> 'button_set',
				'title'   			=> esc_html__( 'Preloader Image', 'modave' ),
				'subtitle'			=> esc_html__( 'Set preloader type as per your need.', 'modave' ),
				'options' 			=> array(
					'predefine-loader'	=> esc_html__( 'Predefined Loader', 'modave' ),
					'custom'         	=> esc_html__( 'Custom', 'modave' ),
				),
				'default' 			=> 'predefine-loader',
				'required' 			=> array( 'site-preloader', '=', 1 ),
			),
			array(
                'id'       			=> 'predefine-loader-style',
                'type'     			=> 'select',
				'title'   			=> esc_html__( 'Choose Preloader Style', 'modave' ),
				'subtitle'			=> esc_html__( 'Set preloader type as per your need.', 'modave' ),
                'options'  			=> array(
                    '1' => 'Style 1',
                    '2' => 'Style 2',
                    '3' => 'Style 3',
                    '4' => 'Style 4',
                    '5' => 'Style 5',
                ),
                'default'  			=> '1',
				'required' 			=> array( 'site-preloader', '=', 1 ),
            ),
			array(
				'id'      			=> 'preloader-custom-image',
				'type'    			=> 'media',
				'url'     			=> false,
				'title'   			=> esc_html__( 'Upload Preloader Image', 'modave' ),   
				'subtitle'			=> esc_html__( 'Upload preloader image.', 'modave' ),
				'library_filter'	=> array( 'gif', 'jpg', 'jpeg', 'png' ),
				'required'      	=> array( 'preloader-image', '=', 'custom' ),
			),
		)
	) );
	
	/*
	* Back to top options
	*/
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'Back To Top Button', 'modave' ),
        'id'         		=> 'section-back-to-top',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       			=> 'back-to-top',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Button', 'modave' ),
				'subtitle'			=> esc_html__( 'Show back to top button.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
                'off'      			=> esc_html__( 'No', 'modave' ),
                'default'  			=> 1,
            ),
			array(
                'id'       			=> 'back-to-top-mobile',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Button In Mobile', 'modave' ),
				'subtitle'			=> esc_html__( 'Show back to top button in mobile device.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
                'off'      			=> esc_html__( 'No', 'modave' ),
                'default'  			=> 1,
            ),
		)
	) );
	
	/*
	* Promo Bar
	*/
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'Promo Bar', 'modave' ),
        'id'         		=> 'section-promo-bar',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       			=> 'promo-bar',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Promo Bar', 'modave' ),
				'subtitle'			=> esc_html__( 'Show promo bar.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
                'off'      			=> esc_html__( 'No', 'modave' ),
                'default'  			=> 0,
			),			
			array(
                'id'            	=> 'promo-bar-height',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Height', 'modave' ),
				'subtitle'          => esc_html__( 'Promo bar height in pixels.', 'modave' ),
				'output' 			=> array( '.promo-bar-wrapper' ),
                'default'       	=> 60,
                'min'           	=> 10,
                'step'          	=> 1,
                'max'           	=> 200,
                'display_value' 	=> 'text',
				'required' 			=> array( 'promo-bar', '=', 1 ),
            ),
			array(
                'id'       			=> 'promo-bar-position',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Position', 'modave' ),
                'subtitle' 			=> esc_html__( 'Select location for promo bar.', 'modave' ),
                'options'  			=> array(
                    'top' 		=> esc_html__( 'Top', 'modave' ),
                    'bottom' 	=> esc_html__( 'Bottom', 'modave' ),
                ),
                'default'  			=> 'top',
				'required' 			=> array( 'promo-bar', '=', 1 ),
            ),
			array(
                'id'       			=> 'promo-bar-position-type',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Position Type', 'modave' ),
                'subtitle' 			=> esc_html__( 'Select position type for promo bar.', 'modave' ),
                'options'  			=> array(
                    'absolute' 		=> esc_html__( 'Absolute', 'modave' ),
                    'fixed' 		=> esc_html__( 'Fixed', 'modave' ),
                ),
                'default'  			=> 'absolute',
				'required' 			=> array( 'promo-bar', '=', 1 ),
            ),
			array(
                'id'       			=> 'promo-bar-message-text',
                'type'     			=> 'editor',
                'title'    			=> esc_html__( 'Message', 'modave' ),
				'subtitle' 			=> esc_html__( 'Enter promo message.', 'modave' ),
				'default'  			=> esc_html__( 'New customers save 10% with the code GET10', 'modave' ),
				'required' 			=> array( 'promo-bar', '=', 1 ),
            ),
			array(
                'id'       			=> 'promo-bar-link-btn',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Button', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'subtitle' 			=> esc_html__( 'Show link button in promo bar.', 'modave' ),
				'default'  			=> 0,
				'required' 			=> array( 'promo-bar', '=', 1 ),
            ),
			array(
                'id'       			=> 'promo-bar-link-btn-text',
                'type'     			=> 'text',
                'title'    			=>  esc_html__( 'Button Text', 'modave' ),
                'subtitle' 			=> esc_html__( 'The text of the more info button.', 'modave' ),
				'default'  			=> esc_html__( 'Click Here', 'modave' ),
				'required' 			=> array( 'promo-bar-link-btn', '=', 1 ),
            ),
			array(
                'id'       			=> 'promo-bar-link-btn-url',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Enter Url', 'modave' ),
                'subtitle' 			=> esc_html__( 'The text of the more info button.', 'modave' ),
				'default'  			=> '#',
				'required' 			=> array( 'promo-bar-link-btn', '=', 1 ),
            ),
			array(
                'id'       			=> 'promo-bar-link-open-new-tab',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Open link in New Tab', 'modave' ),
                'subtitle' 			=> esc_html__( 'Select the link target for more info page.', 'modave' ),
				'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
                'default'  			=> 0,
				'required' 			=> array( 'promo-bar-link-btn', '=', 1 ),
            ),
			array(
                'id'       			=> 'promo-bar-close-btn',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Close Button', 'modave' ),
				'subtitle' 			=> esc_html__( 'Show close button.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
				'required' 			=> array( 'promo-bar', '=', 1 ),
            ),
			array(
                'id'       			=> 'promo-bar-dismiss',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Promo Bar Dismissing', 'modave' ),
				'subtitle' 			=> esc_html__( 'Show promo bar dismissing close button.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
				'required' 			=> array( 'promo-bar-close-btn', '=', 1 ),
            ),
			array(
                'id'    	=> 'promo-notice1',
                'type'   	=> 'info',
                'notice' 	=> false,
                'title' 	=> esc_html__( 'Promo Bar Colors', 'modave' ),
            ),
			array (
				'id'       			=> 'promo-bar-background',
				'type'     			=> 'background',
				'title'    			=> esc_html__( 'Background', 'modave' ),
				'subtitle' 			=> esc_html__( 'Promo bar background image or color', 'modave' ),
				'output' 			=> array( '.pls-promo-bar' ),
				'default'  			=> array(
					'background-color'	 	=> '#181818',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> '',
					'background-attachment' => '',
					'background-position' 	=> ''
				),
			),
			array(
                'id'       			=> 'promo-button-text-color',
                'type'     			=> 'link_color',
                'title'    			=> esc_html__( 'Button Text Color', 'modave' ),
                'subtitle' 			=> esc_html__( 'Set button text color.', 'modave' ),
                'active'    		=> false,
                'default'  			=> array(
                    'regular' 		=> '#181818',
                    'hover'   		=> '#181818',
                )
            ),
			array(
                'id'       			=> 'promo-button-background',
                'type'     			=> 'link_color',
                'title'    			=> esc_html__( 'Button Background Color', 'modave' ),
                'subtitle' 			=> esc_html__( 'Set button background color.', 'modave' ),
                'active'    		=> false,
                'default'  			=> array(
                    'regular' 		=> '#FFFFFF',
                    'hover'   		=> '#FFFFFF',
                )
            ),
			array(
                'id'       			=> 'promo-link-color',
                'type'     			=> 'link_color',
                'title'    			=> esc_html__( 'Link Color', 'modave' ),
                'subtitle' 			=> esc_html__( 'Promobar link and hover color.', 'modave' ),
                'active'    		=> false,
				'output' 			=> array( '.promo-bar-msg a' ),
                'default'  			=> array(
                    'regular' 		=> '#FFFFFF',
                    'hover'   		=> '#FFFFFF',
                )
            ),
			array(
				'id'          		=> 'promo-bar-font',
				'type'        		=> 'typography',
				'title'       		=> esc_html__( 'Promo Bar Font', 'modave' ),
				'all_styles'  		=> true,
				'font-backup' 		=> true,
				'text-align'  		=> false,
				'line-height' 		=> false,
				'letter-spacing' 	=> true,
				'text-transform'	=> true,
				'units'       		=>'px',
				'subtitle'    		=> esc_html__( 'These settings control the typography for promo bar.', 'modave' ),
				'output' 			=> array( '.promo-bar-msg, .promo-bar-close' ),
				'default'     		=> array(
					'color'       		=> '#FFFFFF', 
					'font-weight'  		=> '400', 
					'font-family' 		=> 'Kumbh Sans', 
					'google'      		=> true,
					'font-backup' 		=> '',
					'font-size'   		=> '14px', 
					'letter-spacing'	=> '',
				),
			),
		)
	) );
	
	/*
	* Lazyload Options
	*/
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'Lazy Load Images', 'modave' ),
        'id'         		=> 'section-lazy-load',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       			=> 'lazy-load',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Lazy Load Images', 'modave' ),
				'subtitle'			=> esc_html__( 'Enables lazy load to reduce page requests.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
                'off'      			=> esc_html__( 'No', 'modave' ),
                'default'  			=> 0,
            ),
		)
	) );
	
	/*
	* Google Map API
	*/
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'API Key', 'modave' ),
        'id'         		=> 'section-api-key',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'   				=> 'google-map-api',
                'type'      		=> 'text',
                'title'     		=> esc_html__( 'Google Map API Key', 'modave' ),
				'subtitle'			=> wp_kses( 
					sprintf( 
						__( 'You should create an API for yourself and put code here. read below link to more info: <a href="%s" target="_blank">here</a>.', 'modave' ),
						esc_url('https://developers.google.com/maps/documentation/javascript/get-api-key')
					),
					array( 
						'a'	=> array( 
							'href' 		=> array(), 
							'target'	=> array() 
						) 
					) 
				),
				'default'  			=> '',
            ),
			array(
                'id'   				=> 'instagram-access-token',
                'type'      		=> 'text',
                'title'     		=> esc_html__( 'Instagram Access Token', 'modave' ),
				'subtitle'			=> wp_kses( 
					sprintf( 
						__( 'You should create an API for yourself and put code here. read below link to more info: <a href="%s" target="_blank">here</a>.', 'modave' ),
						esc_url('https:/presslayouts.com/')
					),
					array( 
						'a'	=> array( 
							'href' 		=> array(), 
							'target'	=> array() 
						) 
					) 
				),
				'default'  			=> '',
            ),
		),
	) );
	
	/*
	* Mobile
	*/
	Redux::setSection( $opt_name, array(
        'title'      	=> esc_html__( 'Mobile', 'modave' ),
        'id'         	=> 'section-mobile',
		'icon'		 	=> 'el el-iphone-home',
        'fields'     	=> array(
			array(
                'id'       			=> 'header-mobile-search',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Search', 'modave' ),
                'subtitle' 			=> esc_html__( 'Show search field in mobile menu.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'mobile-categories-menu',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Categories Menu', 'modave' ),
                'subtitle' 			=> esc_html__( 'Show categories menu in mobile.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'mobile-menu-social-profile',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Social Profile', 'modave' ),
                'subtitle' 			=> esc_html__( 'Show social profile in mobile menu.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),
			array(
                'id'       			=> 'mobile-product-hover-image',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Hover Image In Mobile', 'modave' ),
                'subtitle' 			=> esc_html__( 'Show product hover image in mobile layout.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'product-hover-mobile',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Product Hover', 'modave' ),
                'subtitle' 			=> esc_html__( 'By default display product hover in mobile.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'slider-navigation-mobile',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Slider Navigation', 'modave' ),
                'subtitle' 			=> esc_html__( 'By default display slider navigation in mobile.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
            ),
		),
	) );
	
	/*
	* Mobile Header
	*/
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'Mobile Header', 'modave' ),
        'id'         		=> 'section-mobile-header',
		'subsection'   		=> true,
        'fields'     		=> array(
			array(
                'id'    		=> 'header-mobile-notice',
                'type'   		=> 'info',
                'notice' 		=> false,
                'title' 		=> esc_html__( 'Mobile Header', 'modave' ),
            ),
			array(
                'id'       			=> 'pls-mobile-header-style',
                'type'     			=> 'image_select',
                'title'    			=> esc_html__( 'Header Style', 'modave' ),
				'subtitle' 			=> esc_html__( 'Select mobile header style.', 'modave' ),
                'options'  			=> array(					
					'1' => array( 'title' => 'Header style 1', 'img' => PLS_ADMIN_IMAGES.'header/mobile-header-1.png', ),
                    '2' => array( 'title' => 'Header style 2', 'img' => PLS_ADMIN_IMAGES.'header/mobile-header-2.png', ),
                ),
                'default'  		=> '1',
            ),			
			array(
                'id'       			=> 'header-sticky-tablet',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Header Sticky On Tablet', 'modave' ),
                'subtitle' 	  		=> esc_html__( 'Header sticky on tablet width < 992px.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),
			array(
                'id'       			=> 'header-sticky-mobile',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Header Sticky On Mobile', 'modave' ),
                'subtitle' 	 		=> esc_html__( 'Header sticky mobile width < 480px.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),
			array(
                'id'          		=> 'header-mobile-height',
                'type'          	=> 'dimensions',
                'title'          	=> esc_html__( 'Height', 'modave' ),
				'subtitle'    		=> esc_html__( 'Set mobile header height (for header style 1).', 'modave' ),
				'units_extended'	=> false,
                'width'        	 	=> false,
                'default'        	=> array(
                    'height' 		=> 64,
                )
            ),	
			
			array(
                'id'    		=> 'header-mobile-notice',
                'type'   		=> 'info',
                'notice' 		=> false,
                'title' 		=> esc_html__( 'Mobile Header Colors', 'modave' ),
            ),
			array(
                'id'       			=> 'header-mobile-background',
                'type'     			=> 'color',
                'title'    			=> esc_html__( 'Background', 'modave' ),
				'subtitle' 			=> esc_html__( 'Mobile header background color.', 'modave' ),
                'default'  			=> '#ffffff',
            ),	
			array(
                'id'       			=> 'header-mobile-text-color',
                'type'     			=> 'color',
                'title'    			=> esc_html__( 'Text Color', 'modave' ),
				'subtitle' 			=> esc_html__( 'Mobile header text color.', 'modave' ),
                'default'  			=> '#4D4E4F',
            ),			
			array(
                'id'       			=> 'header-mobile-link-color',
                'type'     			=> 'link_color',
                'title'    			=> esc_html__( 'Link Color', 'modave' ),
                'subtitle' 			=> esc_html__( 'Mobile header link and hover color.', 'modave' ),
                'active'    		=> false,
                'default'  			=> array(
                    'regular' 		=> '#181818',
                    'hover'   		=> '#E43131',
                )
            ),
			array(
                'id'       			=> 'header-mobile-border',
                'type'     			=> 'border',
                'title'    			=> esc_html__( 'Border', 'modave' ),                
                'subtitle' 			=> esc_html__( 'Mobile  header border color, style and width.', 'modave' ),
                'default'  			=> array(
                    'border-color'  	=> '#e9e9e9',
                    'border-style'  	=> 'solid',
                    'border-top'    	=> '1px',
                    'border-right'  	=> '1px',
                    'border-bottom' 	=> '1px',
                    'border-left'   	=> '1px'
                )
            ),
			array(
				'id'       			=> 'google-theme-color',
				'type'     			=> 'color',
				'title'    			=> esc_html__( 'Google Theme Color', 'modave' ), 				
				'subtitle'   		=> wp_kses( sprintf( __( 'Applied only on mobile devices Android on chrome browser toolbar, <a href="%s" target="_blank">click here</a> plugin.', 'modave' ), esc_url( 'http://updates.html5rocks.com/2014/11/Support-for-theme-color-in-Chrome-39-for-Android/' ) ),
				array(
						'a' 	=> array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),
				'validate' 			=> 'color',
				'default'  			=> '#181818'
			),
		),
	) );
	
	/*
	* Mobile Navbar
	*/
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'Footer Navbar', 'modave' ),
        'id'         		=> 'section-mobile-navbar',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       			=> 'mobile-bottom-navbar',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Mobile Bottom Navbar', 'modave' ),
				'subtitle'    		=> esc_html__( 'Show mobile bottom navbar in mobile device.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0
            ),
			array(
                'id'       			=> 'mobile-navbar-label',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Navbar Label', 'modave' ),
				'subtitle'    		=> esc_html__( 'Show navbar label.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'mobile-product-page-button',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Product Page Button', 'modave' ),
				'subtitle'    		=> esc_html__( 'Show Sticky Add to Cart/Buy Now button on single product page.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'mobile-cart-page-button',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Cart Page Button', 'modave' ),
				'subtitle'    		=> esc_html__( 'Show Sticky Proceed To Checkout button on cart page.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'mobile-checkout-page-button',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Checkout Page Button', 'modave' ),
				'subtitle'    		=> esc_html__( 'Show Sticky Place Order button on checkout page.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'mobile-navbar-elements',
                'type'     			=> 'sorter',
                'title'    			=> esc_html__( 'Navbar Elements', 'modave' ),
                'compiler' 			=> 'true',
                'options'  			=> array(
                    'enabled'  		=> array(
						'shop'  		=> esc_html__( 'Shop', 'modave' ),
						'category'  	=> esc_html__( 'Category', 'modave' ),
						'sidebar'  		=> esc_html__( 'Sidebar/Filters', 'modave' ),
						'wishlist' 		=> esc_html__( 'Wishlist', 'modave' ),
						'cart'     		=> esc_html__( 'Cart', 'modave' ),
                    ),
                    'disabled' 		=> array(
                        'home'     		=> esc_html__( 'Home', 'modave' ),
						'account'  		=> esc_html__( 'Account', 'modave' ),
						'search'  		=> esc_html__( 'Search', 'modave' ),
						'compare'  		=> esc_html__( 'Compare', 'modave' ),
						'order'			=> esc_html__( 'Order', 'modave' ),
						'order-tracking'=> esc_html__( 'Order Tracking', 'modave' ),
						'blog'  		=> esc_html__( 'Blog', 'modave' ),
						'custom_link1'  => esc_html__( 'Custom Link 1', 'modave' ),
						'custom_link2'  => esc_html__( 'Custom Link 2', 'modave' ),
						'custom_link3'  => esc_html__( 'Custom Link 3', 'modave' ),
					),
                ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-shop',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Shop Label', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter shop navbar label', 'modave' ),
				'default'  			=> esc_html__( 'Shop', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-shop',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Shop Label Icon', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-grid', 'modave' ),
				'default'  			=> esc_html__( 'picon-grid', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-category',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Category Label', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter shop navbar label', 'modave' ),
				'default'  			=> esc_html__( 'Category', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-category',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Category Label Icon', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-align-left', 'modave' ),
				'default'  			=> esc_html__( 'picon-align-left', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-wishlist',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Wishlist Label', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter wishlist navbar label', 'modave' ),
				'default'  			=> esc_html__( 'Wishlist', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-wishlist',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Wishlist Label Icon', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-heart-atl', 'modave' ),
				'default'  			=> esc_html__( 'picon-heart-atl', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-cart',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Cart Label', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter cart navbar label', 'modave' ),
				'default'  			=> esc_html__( 'Cart', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-cart',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Cart Label Icon', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-shopping-bag', 'modave' ),
				'default'  			=> esc_html__( 'picon-shopping-bag', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-account',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Account Label', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter account navbar label', 'modave' ),
				'default'  			=> esc_html__( 'Account', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-account',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Account Label Icon', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-user-atl', 'modave' ),
				'default'  			=> esc_html__( 'picon-user-atl', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-home',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Home Label', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter home navbar label', 'modave' ),
				'default'  			=> esc_html__( 'Home', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-home',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Home Label Icon', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-home', 'modave' ),
				'default'  			=> esc_html__( 'picon-home', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-menu',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Menu Label', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter menu navbar label', 'modave' ),
				'default'  			=> esc_html__( 'Menu', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-menu',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Menu Label Icon', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-menu', 'modave' ),
				'default'  			=> esc_html__( 'picon-menu', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-compare',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Compare Label', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter compare navbar label', 'modave' ),
				'default'  			=> esc_html__( 'Compare', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-compare',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Compare Label Icon', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-repeat-atl', 'modave' ),
				'default'  			=> esc_html__( 'picon-repeat-atl', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-filter',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Filter Label', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter filter navbar label', 'modave' ),
				'default'  			=> esc_html__( 'Filters', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-filter',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Filter Label Icon', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-sliders', 'modave' ),
				'default'  			=> esc_html__( 'picon-sliders', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-order',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Order Label', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter order navbar label', 'modave' ),
				'default'  			=> esc_html__( 'Order', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-order',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Order Label Icon', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-note', 'modave' ),
				'default'  			=> esc_html__( 'picon-note', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-order-tracking',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Order Tracking Label', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter order tracking navbar label', 'modave' ),
				'default'  			=> esc_html__( 'Order Tracking', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-order-tracking',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Order Tracking Label Icon', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-rocket', 'modave' ),
				'default'  			=> esc_html__( 'picon-rocket', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-sidebar',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Sidebar Label', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter sidebar navbar label', 'modave' ),
				'default'  			=> esc_html__( 'Sidebar', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-sidebar',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Sidebar Label Icon', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-sidebar-left', 'modave' ),
				'default'  			=> esc_html__( 'picon-sidebar-left', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-blog',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Blog Label', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter blog navbar label', 'modave' ),
				'default'  			=> esc_html__( 'Blog', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-blog',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Blog Label Icon', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-pencil', 'modave' ),
				'default'  			=> esc_html__( 'picon-pencil', 'modave' ),
            ),
			
			array(
                'id'       			=> 'mobile-navbar-label-search',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Search Label', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter blog navbar label', 'modave' ),
				'default'  			=> esc_html__( 'Search', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-search',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Search Label Icon', 'modave' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-search-alt', 'modave' ),
				'default'  			=> esc_html__( 'picon-search-alt', 'modave' ),
            ),
			array(
                'id'    => 'custom-link-options',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Custom Links', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-custom-link1-label',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Custom Link 1 Label','modave'),
                'subtitle'     		=> esc_html__('Enter custom link 1 label.','modave'),
				'default'  			=> esc_html__( 'Custom 1', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-custom-link1-icon',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Custom Link 1 Icon','modave'),
                'subtitle'     		=> esc_html__('Enter pls font icon class.','modave'),
				'default'  			=> 'lnr lnr-user',
            ),
			array(
                'id'       			=> 'mobile-navbar-custom-link1-url',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Custom Link 1 URL','modave'),
                'subtitle'     		=> esc_html__('Enter custom link 1 url.','modave'),
				'default'  			=> '#',
            ),
			array(
                'id'       			=> 'mobile-navbar-custom-link2-label',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Custom Link 2 Label','modave'),
                'subtitle'     		=> esc_html__('Enter custom link 2 label.','modave'),
				'default'  			=> esc_html__( 'Custom 2', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-custom-link2-icon',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Custom Link 2 Icon','modave'),
                'subtitle'     		=> esc_html__('Enter pls font icon class.','modave'),
				'default'  			=> 'lnr lnr-user',
            ),
			array(
                'id'       			=> 'mobile-navbar-custom-link2-url',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Custom Link 2 URL','modave'),
                'subtitle'     		=> esc_html__('Enter custom link 2 url.','modave'),
				'default'  			=> '#',
            ),
			array(
                'id'       			=> 'mobile-navbar-custom-link3-label',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Custom Link 3 Label','modave'),
                'subtitle'     		=> esc_html__('Enter custom link 3 label.','modave'),
				'default'  			=> esc_html__( 'Custom 3', 'modave' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-custom-link3-icon',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Custom Link 3 Icon','modave'),
                'subtitle'     		=> esc_html__('Enter pls font icon class.','modave'),
				'default'  			=> 'lnr lnr-user',
            ),
			array(
                'id'       			=> 'mobile-navbar-custom-link3-url',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Custom Link 3 URL','modave'),
                'subtitle'     		=> esc_html__('Enter custom link 3 url.','modave'),
				'default'  			=> '#',
            ),
		)
	) );
	
	/*
	* Theme Typography
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Typography', 'modave' ),
        'id'         => 'section-typography',
		'icon'		 => 'el el-font',
        'fields'     => array(
			array(
				'id'          		=> 'body-font',
				'type'        		=> 'typography',
				'title'       		=> esc_html__( 'Primary Font', 'modave' ),
				'all_styles'  		=> true,
				'font-backup' 		=> true,
				'text-align'  		=> false,
				'color'  			=> false,
				'line-height' 		=> false,
				'letter-spacing' 	=> true,
				'units'       		=>'px',
				'subtitle'    		=> esc_html__( 'Use the primary font for body text and all related content.', 'modave' ),
				'default'     		=> array(
					'font-weight'  		=> '400', 
					'font-family' 		=> 'Kumbh Sans', 
					'google'      		=> true,
					'font-backup' 		=> 'sans-serif',
					'font-size'   		=> '16px',
					'letter-spacing'	=> '',
				),
			),
			array(
				'id'          		=> 'secondary-font',
				'type'        		=> 'typography',
				'title'       		=> esc_html__( 'Secondary Font', 'modave' ),
				'all_styles'  		=> true,
				'font-backup' 		=> true,
				'text-align'  		=> false,
				'line-height' 		=> false,
				'font-size'   		=> false,
				'letter-spacing' 	=> false,
				'units'       		=>'px',
				'subtitle'    		=> esc_html__( 'Use the secondary font for all secondary or alternate text.', 'modave' ),
				'output' 			=> array( '.secondary-font' ),
				'default'     		=> array(
					'color'       		=> '#181818',
					'font-weight'  		=> '400', 
					'font-family' 		=> 'Kumbh Sans', 
					'google'      		=> true,
					'font-backup' 		=> 'sans-serif',
				),
			),
			array(
				'id'          		=> 'headings-font',
				'type'        		=> 'typography',
				'title'       		=> esc_html__( 'H1 to H6 Headings Font', 'modave' ),
				'all_styles'  		=> true,
				'font-backup' 		=> true,
				'font-size' 		=> false,
				'text-align'  		=> false,
				'line-height' 		=> false,
				'letter-spacing' 	=> true,
				'text-transform'	=> true,
				'units'       		=>'px',
				'subtitle'    		=> esc_html__( 'Use this font for all H1 to H6 headings.', 'modave' ),
				'output' 			=> array( 'h1, .h1, h2, .h2, h3, .h3, h4, .h4, h5, .h5, h6, .h6' ),
				'default'     		=> array(
					'color'       		=> '#181818', 
					'font-weight'  		=> '500', 
					'font-family' 		=> 'Kumbh Sans', 
					'google'      		=> true,
					'font-backup' 		=> 'sans-serif',
					'letter-spacing'	=> '',
					'text-transform'	=> 'capitalize'
				),
			),
			array(
				'id'          		=> 'main-menu-font',
				'type'        		=> 'typography',
				'title'       		=> esc_html__( 'Main Menu Font', 'modave' ),
				'all_styles'  		=> true,
				'font-backup' 		=> true,
				'color'				=> false,
				'text-align'  		=> false,
				'line-height' 		=> false,
				'letter-spacing' 	=> true,
				'text-transform'	=> true,
				'units'       		=>'px',
				'subtitle'    		=> esc_html__( 'Use this typography for header main navigation.', 'modave' ),
				'output' 			=> array( '.pls-main-navigation ul.menu > li > a' ),
				'default'     		=> array(
					'font-weight'  		=> '600', 
					'font-family' 		=> 'Kumbh Sans', 
					'google'      		=> true,
					'font-backup' 		=> 'sans-serif',
					'font-size'   		=> '16px', 
					'letter-spacing'	=> '',
					'text-transform'	=> 'capitalize'
				),
			),
			array(
				'id'          		=> 'categories-menu-title-font',
				'type'        		=> 'typography',
				'title'       		=> esc_html__( 'Categories Menu Title', 'modave' ),
				'all_styles'  		=> true,
				'font-backup' 		=> true,
				'color'				=> false,
				'text-align'  		=> false,
				'line-height' 		=> false,
				'letter-spacing' 	=> true,
				'text-transform'	=> true,
				'units'       		=>'px',
				'subtitle'    		=> esc_html__( 'Use this typography for categories menu title.', 'modave' ),
				'output' 			=> array( '.pls-categories-menu-title' ),
				'default'     		=> array(
					'font-weight'  		=> '600', 
					'font-family' 		=> 'Kumbh Sans', 
					'google'      		=> true,
					'font-backup' 		=> 'sans-serif',
					'font-size'   		=> '12px', 
					'letter-spacing'	=> '',
					'text-transform'	=> 'uppercase'
				),
			),
			array(
				'id'          		=> 'categories-menu-font',
				'type'        		=> 'typography',
				'title'       		=> esc_html__( 'Categories Menu Font', 'modave' ),
				'all_styles'  		=> true,
				'font-backup' 		=> true,
				'color'				=> false,
				'text-align'  		=> false,
				'line-height' 		=> false,
				'letter-spacing' 	=> true,
				'text-transform'	=> true,
				'units'       		=>'px',
				'subtitle'    		=> esc_html__( 'Use this typography for categories parent menu.', 'modave' ),
				'output' 			=> array( '.pls-categories-menu ul.menu > li > a, .pls-categories-menu > .maxlist-more' ),
				'default'     		=> array(
					'font-weight'  		=> '400', 
					'font-family' 		=> 'Kumbh Sans', 
					'google'      		=> true,
					'font-backup' 		=> 'sans-serif',
					'font-size'   		=> '16px', 
					'letter-spacing'	=> '',
					'text-transform'	=> 'inherit'
				),
			),
		),
	) );
	
	/*
	* Custom Fonts
	*/
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'Custom Fonts', 'modave' ),
        'id'         		=> 'section-custom-font',
		'desc'  			=> esc_html__( 'After uploading your fonts,you will have to save Theme Settings and RELOAD this page , Then you should select font family (custom font family)from dropdown list in (Body/Paragraph/Headings/Navigation) Typography section.', 'modave' ),
        'subsection'   		=> true,
        'fields'     		=> array(
			array(
                'id'       			=> 'custom-font1',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Custom Font1', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Please enable this option to use Custom Font 1.', 'modave' ),
                'on'       			=> esc_html__( 'Enable', 'modave' ),
				'off'      			=> esc_html__( 'Disable', 'modave' ),
				'default'  			=> 0,
            ),
			array(
                'type'      		=> 'text',
                'id'        		=> 'custom-font1-name',
                'title'     		=> esc_html__( 'Font1 Name', 'modave' ),
                'required'  		=> array( 'custom-font1', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font1-woff',
                'title'     		=> esc_html__( 'Font1 (.woff)', 'modave' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font1', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font1-woff2',
                'title'     		=> esc_html__( 'Font1 (.woff2)', 'modave' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font1', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font1-ttf',
                'title'     		=> esc_html__( 'Font1 (.ttf)', 'modave' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font1', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font1-svg',
                'title'     		=> esc_html__( 'Font1 (.svg)', 'modave' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font1', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font1-eot',
                'title'     		=> esc_html__( 'Font1 (.eot)', 'modave' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font1', '=', '1' ),
            ),
			array(
                'id'       			=> 'custom-font2',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Custom Font2', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Please enable this option to use Custom Font 2.', 'modave' ),
                'on'       			=> esc_html__( 'Enable', 'modave' ),
				'off'      			=> esc_html__( 'Disable', 'modave' ),
				'default'  			=> 0,
            ),
			array(
                'type'      		=> 'text',
                'id'        		=> 'custom-font2-name',
                'title'     		=> esc_html__( 'Font2 Name', 'modave' ),
                'required'  		=> array( 'custom-font2', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font2-woff',
                'title'     		=> esc_html__( 'Font2 (.woff)', 'modave' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font2', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font2-woff2',
                'title'     		=> esc_html__( 'Font2 (.woff2)', 'modave' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font2', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font2-ttf',
                'title'     		=> esc_html__( 'Font2 (.ttf)', 'modave' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font2', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font2-svg',
                'title'     		=> esc_html__( 'Font2 (.svg)', 'modave' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font2', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font2-eot',
                'title'     		=> esc_html__( 'Font2 (.eot)', 'modave' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font2', '=', '1' ),
            ),
			array(
                'id'       			=> 'custom-font3',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Custom Font3', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Please enable this option to use Custom Font 3.', 'modave' ),
                'on'       			=> esc_html__( 'Enable', 'modave' ),
				'off'      			=> esc_html__( 'Disable', 'modave' ),
				'default'  			=> 0,
            ),
			array(
                'type'      		=> 'text',
                'id'        		=> 'custom-font3-name',
                'title'     		=> esc_html__( 'Font3 Name', 'modave' ),
                'required'  		=> array( 'custom-font3', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font3-woff',
                'title'     		=> esc_html__( 'Font3 (.woff)', 'modave' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font3', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font3-woff2',
                'title'     		=> esc_html__( 'Font3 (.woff2)', 'modave' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font3', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font3-ttf',
                'title'     		=> esc_html__( 'Font3 (.ttf)', 'modave' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font3', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font3-svg',
                'title'     		=> esc_html__( 'Font3 (.svg)', 'modave' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font3', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font3-eot',
                'title'     		=> esc_html__( 'Font3 (.eot)', 'modave' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font3', '=', '1' ),
            ),
		),
	) );
	
	/*
	* Typekit Font
	*/
	Redux::setSection( $opt_name, array(
        'title'      	=> esc_html__( 'Adobe Typekit Font', 'modave' ),
        'id'         	=> 'section-typekit-font',
        'subsection'   	=> true,
        'fields'     	=> array(
			array(
                'id'       			=> 'typekit-font',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Adobe Typekit Font', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Please enable this option to use Adobe Typekit.', 'modave' ),
                'on'       			=> esc_html__( 'Enable', 'modave' ),
				'off'      			=> esc_html__( 'Disable', 'modave' ),
				'default'  			=> 0,
            ),
			array(
                'id'   				=> 'typekit-kit-id',
                'type'      		=> 'text',
                'title'     		=> esc_html__( 'Typekit Kit ID', 'modave' ),
				'subtitle' 			=> esc_html__( 'Enter your ', 'modave' ) . '<a target="_blank" href="https://typekit.com/account/kits">Typekit Kit ID</a>.',
				'required'  		=> array( 'typekit-font', '=', '1' ),
            ),
			array(
                'id'   				=> 'typekit-kit-family',
                'type'      		=> 'text',
                'title'     		=> esc_html__( 'Typekit Font Family', 'modave' ),
				'subtitle' 			=> esc_html__( 'Enter all custom fonts you will use separated with coma.', 'modave' ),
				'required'  		=> array( 'typekit-font', '=', '1' ),
            ),
		),
	) );
	
	// Theme Styling Options
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Theme Styling', 'modave' ),
        'id'               => 'theme-styling',
        'desc'             => '',
        'icon'		 	   => 'el el-brush',
		'fields'           => array(
		)
	) );
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'Body', 'modave' ),
        'id'         		=> 'body-styling',
        'subsection' 		=> true,		
        'fields'     		=> array(
            array(
                'id'       			=> 'primary-color',
                'type'     			=> 'color',
                'title'    			=> esc_html__( 'Primary Color', 'modave' ),
				'subtitle' 			=> esc_html__( 'Primary color', 'modave' ),
                'default'  			=> '#E43131',
            ),
			array(
				'id'       			=> 'primary-inverse-color',
				'type'     			=> 'color',
				'title'    			=> esc_html__( 'Primary Inverse Color', 'modave' ), 
				'subtitle' 			=> esc_html__( 'Primary inverse color', 'modave' ),
				'validate' 			=> 'color',
				'default'  			=> '#FFFFFF'
			),
			array(
                'id'       			=> 'secondary-color',
                'type'     			=> 'color',
                'title'    			=> esc_html__( 'Secondary Color', 'modave' ),
				'subtitle' 			=> esc_html__( 'Secondary color', 'modave' ),
                'default'  			=> '#181818',
            ),
			array(
				'id'       			=> 'secondary-inverse-color',
				'type'     			=> 'color',
				'title'    			=> esc_html__( 'Secondary Inverse Color', 'modave' ),
				'subtitle' 			=> esc_html__( 'Secondary inverse color', 'modave' ),
				'validate' 			=> 'color',
				'default'  			=> '#FFFFFF'
			),
			array(
                'id'       			=> 'secondary-color2',
                'type'     			=> 'color',
                'title'    			=> esc_html__( 'Secondary Color 2', 'modave' ),
				'subtitle' 			=> esc_html__( 'Secondary color 2', 'modave' ),
                'default'  			=> '#A0A0A0',
            ),
			array(
				'id'       			=> 'theme-heading-color',
				'type'     			=> 'color',
				'title'    			=> esc_html__( 'Heading Color', 'modave' ),
				'subtitle' 			=> esc_html__( 'Select heading color.', 'modave' ),
				'validate' 			=> 'color',
				'default'  			=> '#181818'
			),
			array(
				'id'       			=> 'theme-background-color',
				'type'     			=> 'color',
				'title'    			=> esc_html__( 'Theme Background Color', 'modave' ), 
				'subtitle' 			=> esc_html__( 'Apply theme background color for section, content, ul, li, menu, list, etc...', 'modave' ),
				'validate' 			=> 'color',
				'default'  			=> '#f7f7f7'
			),
			array(
                'id'       			=> 'body-background',
                'type'     			=> 'background',
                'title'    			=> esc_html__( 'Body Background', 'modave' ),
				'subtitle' 			=> esc_html__( 'Body background image or color. Only for work in Boxed layout', 'modave' ),
				'output'   			=> array( 'body' ),
                'default' 			=> array(
					'background-color' 		=> '#ffffff',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> '',
					'background-attachment' => '',
					'background-position' 	=> '',
				),
            ),
			array (
				'id'       			=> 'site-wrapper-background',
				'type'     			=> 'background',
				'title'    			=> esc_html__('Body Wrapper Background', 'modave'),
				'output' 			=> array('.pls-site-wrapper'),
				'default'  			=> array(
					'background-color'	 	=> '#ffffff',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> '',
					'background-attachment' => '',
					'background-position' 	=> ''
				),
			),
			array(
                'id'       			=> 'body-text-color',
                'type'     			=> 'color',
                'title'    			=> esc_html__( 'Text Color', 'modave' ),
				'subtitle' 			=> esc_html__( 'Site text color.', 'modave' ),
                'default'  			=> '#4D4E4F',
            ),
			array(
                'id'       			=> 'body-link-color',
                'type'     			=> 'link_color',
                'title'    			=> esc_html__( 'Link Color', 'modave' ),
                'subtitle' 			=> esc_html__( 'Site link and hover color.', 'modave' ),
				'active'   			=> false,
                'default'  			=> array(
                    'regular' 	=> '#181818',
                    'hover'   	=> '#E43131',
                )
            ),
			array(
                'id'       			=> 'theme-border',
                'type'     			=> 'border',
                'title'    			=> esc_html__( 'Border', 'modave' ),
                'subtitle' 			=> esc_html__( 'Site border color, style and width.', 'modave' ),
                'all' 				=> false,
				'default'  			=> array(
                    'border-color'  	=> '#E9E9E9',
                    'border-style'  	=> 'solid',
                    'border-top'    	=> '1px',
                    'border-right'  	=> '1px',
                    'border-bottom' 	=> '1px',
                    'border-left'   	=> '1px'
                )
            ),
			array(
                'id'            	=> 'theme-border-radius',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Border Radius', 'modave' ),
				'subtitle' 			=> esc_html__( 'site border radius.', 'modave' ),
                'default'       	=> 8,
                'min'           	=> 0,
                'step'          	=> 1,
                'max'           	=> 24,
                'display_value' 	=> 'label'
            ),			
			array(
                'id'       			=> 'body-input-background',
                'type'     			=> 'color',
                'title'    			=> esc_html__( 'Input Field Background', 'modave' ),
                'subtitle' 			=> esc_html__( 'Set background input field like TextBox, Textarea, SelectBox, etc..', 'modave' ),
                'default'  			=> '#ffffff',
            ),
			array(
                'id'       			=> 'body-input-color',
                'type'     			=> 'color',
                'title'    			=> esc_html__( 'Input Field Color', 'modave' ),
                'subtitle' 			=> esc_html__( 'Set color input field like TextBox, Textarea, SelectBox, etc..', 'modave' ),
                'default'  			=> '#4D4E4F',
            ),
			array(
                'id'       			=> 'theme-skin-color',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Theme Skin Color', 'modave' ),
				'subtitle'     		=> esc_html__( 'Select theme skin color mode.', 'modave' ),
                'options'  			=> array(
                    'light' 		=> esc_html__( 'Light', 'modave' ),
                    'dark'			=> esc_html__( 'Dark', 'modave' ),
                ),
                'default'  			=> 'light',
            ),
        )
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'      	=> esc_html__( 'Topbar', 'modave' ),
        'id'         	=> 'topbar-styling',
        'subsection' 	=> true,
        'fields'     	=> array(
			array(
                'id'       			=> 'topbar-background',
                'type'     			=> 'background',
                'title'    			=> esc_html__( ' Background', 'modave' ),
                'subtitle' 			=> esc_html__( 'Topbar background image or color.', 'modave' ),
				'output' 			=> array( '.pls-header-topbar' ),
				'default'  			=> array(
					'background-color'	 	=> '#181818',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> '',
					'background-attachment' => '',
					'background-position' 	=> ''
				),
            ),
            array(
                'id'       			=> 'topbar-text-color',
                'type'     			=> 'color',
                'title'    			=> esc_html__( 'Text Color', 'modave' ),
				'subtitle' 			=> esc_html__( 'Topbar text color', 'modave' ),
                'default'  			=> '#ffffff',
            ),
			array(
                'id'       			=> 'topbar-link-color',
                'type'     			=> 'link_color',
                'title'    			=> esc_html__( 'Link Color', 'modave' ),
				'subtitle' 			=> esc_html__( 'Topbar link and hover color.', 'modave' ),
				'active'    		=> false,
                'default'  			=> array(
                    'regular' 	=> '#FFFFFF',
                    'hover'   	=> '#FFFFFF',
                )
            ),
			array(
                'id'       			=> 'topbar-border',
                'type'     			=> 'border',
                'title'    			=> esc_html__( 'Border', 'modave' ),                
                'subtitle' 			=> esc_html__( 'Topbar border color, style and width.', 'modave' ),
                'default'  			=> array(
                    'border-color'  	=> '#181818',
                    'border-style'  	=> 'solid',
                    'border-top'    	=> '1px',
                    'border-right'  	=> '1px',
                    'border-bottom' 	=> '1px',
                    'border-left'   	=> '1px'
                )
            ),
			array(
                'id'          		=> 'topbar-height',
                'type'          	=> 'dimensions',
                'title'          	=> esc_html__( 'Max Height', 'modave' ),
				'subtitle'    		=> esc_html__( 'Set max height for topbar.', 'modave' ),
                'units_extended'	=> false,
                'width'        	 	=> false,
                'default'        	=> array(
                    'height' 		=> 44,
                )
            ),
		)
	) );
	
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'Header', 'modave' ),
        'id'         		=> 'header-styling',
        'subsection' 		=> true,
        'fields'     		=> array(
			array(
                'id'    	=> 'header-notice1',
                'type'   	=> 'info',
                'notice' 	=> false,
                'title' 	=> esc_html__( 'Header Colors', 'modave' ),
            ),
			array(
                'id'       			=> 'header-background',
                'type'     			=> 'background',
                'title'    			=> esc_html__( 'Background', 'modave' ),
				'subtitle' 			=> esc_html__( 'Header background image or color', 'modave' ),
				'output' 			=> array( '.pls-header-main' ),
                'default' 			=> array(
					'background-color' 		=> '#ffffff',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> '',
					'background-attachment' => '',
					'background-position' 	=> '',
				),
            ),
            array(
                'id'       			=> 'header-text-color',
                'type'     			=> 'color',
                'title'    			=> esc_html__( 'Text Color', 'modave' ),
				'subtitle' 			=> esc_html__( 'Header text color', 'modave' ),
                'default'  			=> '#4D4E4F',
            ),
			array(
                'id'       			=> 'header-link-color',
                'type'     			=> 'link_color',
                'title'    			=> esc_html__( 'Link Color', 'modave' ),
                'subtitle' 			=> esc_html__( 'Header link and hover color.', 'modave' ),
				'active'   			=> false,
                'default'  			=> array(
                    'regular' 	=> '#181818',
                    'hover'   	=> '#dd3333',
                ),
            ),
			array(
                'id'       			=> 'header-border',
                'type'     			=> 'border',
                'title'    			=> esc_html__( 'Border', 'modave' ),
                'subtitle' 			=> esc_html__( 'Header border color, style and width.', 'modave' ),
                'default'  			=> array(
                    'border-color'  	=> '#e9e9e9',
                    'border-style'  	=> 'solid',
                    'border-top'    	=> '1px',
                    'border-right'  	=> '1px',
                    'border-bottom' 	=> '1px',
                    'border-left'   	=> '1px'
                )
            ),
			array(
                'id'          		=> 'header-height',
                'type'          	=> 'dimensions',
                'title'          	=> esc_html__( 'Height', 'modave' ),
				'subtitle'    		=> esc_html__( 'Set min height for header.', 'modave' ),
				'units_extended'	=> false,
                'width'        	 	=> false,
                'default'        	=> array(
                    'height' 		=> 82,
                )
            ),
		)
	) );
		
	Redux::setSection( $opt_name, array(
        'title'      	=> esc_html__( 'Navigation', 'modave' ),
        'id'         	=> 'navigation-styling',
        'subsection' 	=> true,
        'fields'     	=> array(
			array(
                'id'       			=> 'navigation-background',
                'type'     			=> 'background',
                'title'    			=> esc_html__( 'Background Color', 'modave' ),
				'subtitle' 			=> esc_html__( 'Navigation bar background image or color', 'modave' ),
				'output' 			=> array( '.pls-header-navigation' ),
                'default'  			=> array(
					'background-color' 		=> '#181818',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> '',
					'background-attachment' => '',
					'background-position' 	=> '',
				),
            ),
            array(
                'id'       			=> 'navigation-text-color',
                'type'     			=> 'color',
                'title'    			=> esc_html__( 'Text Color', 'modave' ),
				'subtitle' 			=> esc_html__( 'Navigation bar text color', 'modave' ),
                'default'  			=> '#ffffff',
            ),
			array(
                'id'       			=> 'navigation-link-color',
                'type'     			=> 'link_color',
                'title'    			=> esc_html__( 'Link Color', 'modave' ),
                'subtitle' 			=> esc_html__( 'Navigation bar link and hover color.', 'modave' ),
				'active'   			=> false,
                'default'  			=> array(
                    'regular' 	=> '#ffffff',
                    'hover'   	=> '#e43131',
                )
            ),			 
			array(
                'id'       			=> 'navigation-border',
                'type'     			=> 'border',
                'title'    			=> esc_html__( 'Navigation Border', 'modave' ),
                'subtitle' 			=> esc_html__( 'Navigation bar border color, style and width.', 'modave' ),
                'default'  			=> array(
                    'border-color'  	=> '#181818',
                    'border-style'  	=> 'solid',
                    'border-top'    	=> '1px',
                    'border-right'  	=> '1px',
                    'border-bottom' 	=> '1px',
                    'border-left'   	=> '1px'
                )
            ),
			array(
                'id'          		=> 'navigation-height',
                'type'          	=> 'dimensions',
                'title'          	=> esc_html__( 'Height', 'modave' ),
				'subtitle'    		=> esc_html__( 'Set min height for navigation bar.', 'modave' ),
                'units_extended'	=> false,
                'width'        	 	=> false,
                'default'        	=> array(
                    'height' 		=> 58,
                )
            ),	
		)
	) );
	
	Redux::setSection( $opt_name, array(
        'title'      	=> esc_html__( 'Menu & Categories Menu', 'modave' ),
        'id'         	=> 'menu-styling',
        'subsection' 	=> true,
        'fields'     	=> array(
			array(
                'id'    	=> 'categories-menu-title-notice',
                'type'   	=> 'info',
                'notice' 	=> false,
                'title' 	=> esc_html__( 'Categories Menu Title Colors', 'modave' ),
            ),
			array(
                'id'       			=> 'categories-menu-title-background',
                'type'     			=> 'color',
                'title'    			=> esc_html__( 'Background Color', 'modave' ),
				'subtitle' 			=> esc_html__( 'Categories menu title background color.', 'modave' ),
                'validate' 			=> 'color',
                'default' 			=> '#181818',
            ),
			array(
                'id'       			=> 'categories-menu-title-color',
                'type'     			=> 'color',
                'title'    			=> esc_html__( 'Categories Title Color', 'modave' ),
                'subtitle' 			=> esc_html__( 'Select categories title color.', 'modave' ),
                'validate' 			=> 'color',
                'default' 			=> '#ffffff',
            ),
			array(
                'id'    	=> 'categories-menu-notice',
                'type'   	=> 'info',
                'notice' 	=> false,
                'title' 	=> esc_html__( 'Categories Area & Menu Colors', 'modave' ),
            ),
			array (
				'id'       			=> 'categories-menu-wrapper-background',
				'type'     			=> 'color',
				'title'    			=> esc_html__( 'Background Color', 'modave' ),
				'subtitle' 			=> esc_html__( 'Categories menu wrapper/area background color', 'modave' ),
				'default'  			=> '#ffffff',
			),
			array(
                'id'       			=> 'categories-menu-hover-background',
                'type'     			=> 'color',
                'title'    			=> esc_html__( 'Hover Background Color', 'modave' ),
				'subtitle' 			=> esc_html__( 'Categories menu hover background color', 'modave' ),
                'validate' 			=> 'color',
                'default' 			=> '#f7f7f7',
            ),
			array(
                'id'       			=> 'categories-menu-link-color',
                'type'     			=> 'link_color',
                'title'    			=> esc_html__( 'Link Color', 'modave' ),
                'subtitle' 			=> esc_html__( 'Categories menu link and hover color.', 'modave' ),
                'active'    		=> false,
                'default'  			=> array(
                    'regular' 		=> '#181818',
                    'hover'   		=> '#E43131',
                )
            ),
			array(
                'id'       			=> 'categories-menu-border',
                'type'     			=> 'border',
                'title'   	 		=> esc_html__( 'Border', 'modave' ),
                'subtitle' 			=> esc_html__( 'Categories menu border color, style and width.', 'modave' ),
                'default'  			=> array(
                    'border-color'  	=> '#e9e9e9',
                    'border-style'  	=> 'solid',
					'border-top'    	=> '1px',
					'border-right'  	=> '1px',
					'border-bottom' 	=> '1px',
					'border-left'   	=> '1px'
                )
            ),
			array(
                'id'    	=> 'menu-popup-notice',
                'type'   	=> 'info',
                'notice' 	=> false,
                'title' 	=> esc_html__( 'Main & Categories menu Popup Colors', 'modave' ),
            ),
			array (
				'id'       			=> 'popup-menu-background',
				'type'     			=> 'background',
				'title'    			=> esc_html__( 'Background', 'modave' ),
				'subtitle' 			=> esc_html__( 'Popup menu background image or color', 'modave' ),
				'output' 			=> array( '.pls-navigation ul.menu ul.sub-menu, .pls-navigation .pls-megamenu-wrapper' ),
				'default'  			=> array(
					'background-color'	 	=> '#ffffff',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> '',
					'background-attachment' => '',
					'background-position' 	=> ''
				),
			),
			array(
                'id'       			=> 'popup-menu-text-color',
                'type'     			=> 'color',
                'title'    			=> esc_html__( 'Text Color', 'modave' ),
				'subtitle' 			=> esc_html__( 'Popup menu text color', 'modave' ),
                'default'  			=> '#4D4E4F',
            ),
			array(
                'id'       			=> 'popup-menu-heading-color',
                'type'     			=> 'color',
                'title'    			=> esc_html__( 'Heading Color', 'modave' ),
				'subtitle' 			=> esc_html__( 'Popup menu heading color.', 'modave' ),
                'default'  			=> '#181818',
            ),
			array(
                'id'       			=> 'popup-menu-link-color',
                'type'     			=> 'link_color',
                'title'    			=> esc_html__( 'Link Color', 'modave' ),
                'subtitle' 			=> esc_html__( 'Popup menu link and hover color.', 'modave' ),
                'active'    		=> false,
                'default'  			=> array(
                    'regular' 	=> '#4D4E4F',
                    'hover'   	=> '#E43131',
                )
            ),	
		)
	) );
	
	/*
	* Buttons colors
	*/
	Redux::setSection( $opt_name, array(
        'title'      	=> esc_html__( 'Buttons', 'modave' ),
        'id'         	=> 'section-buttons',
		'subsection'   	=> true,
        'fields'     	=> array(
			array(
                'id'    	=> 'site-button-color-info',
                'type'   	=> 'info',
                'notice' 	=> false,
                'title' 	=> esc_html__( 'Site Buttons Colors', 'modave' ),
            ),
			array(
                'id'       			=> 'button-background',
                'type'     			=> 'link_color',
                'title'    			=> esc_html__( 'Button Background', 'modave' ),
                'subtitle' 			=> esc_html__( 'Set button background and hover color.', 'modave' ),
                'active'    		=> false,
                'default'  			=> array(
                    'regular' 		=> '#181818',
                    'hover'   		=> '#E43131',
                )
            ),
			array(
                'id'       			=> 'button-color',
                'type'     			=> 'link_color',
                'title'    			=> esc_html__( 'Button Color', 'modave' ),
                'subtitle' 			=> esc_html__( 'Set button text color and hover color.', 'modave' ),
                'active'    		=> false,
                'default'  			=> array(
                    'regular' 		=> '#FFFFFF',
                    'hover'   		=> '#FFFFFF',
                )
            ),
			
			//Shop Page Buttons Colors
			array(
                'id'    	=> 'shop-page-button-color-info',
                'type'   	=> 'info',
                'notice' 	=> false,
                'title' 	=> esc_html__( 'Shop Page Buttons Colors', 'modave' ),
            ),
			array(
                'id'       			=> 'shop-cart-button-background',
                'type'     			=> 'link_color',
                'title'    			=> esc_html__( 'Add To Cart Background', 'modave' ),
                'subtitle' 			=> esc_html__( 'Set add to cart button background and hover color.', 'modave' ),
                'active'    		=> false,
                'default'  			=> array(
                    'regular' 		=> '#FFFFFF',
                    'hover'   		=> '#181818',
                )
            ),
			array(
                'id'       			=> 'shop-cart-button-color',
                'type'     			=> 'link_color',
                'title'    			=> esc_html__( 'Add To Cart Color', 'modave' ),
                'subtitle' 			=> esc_html__( 'Set add to cart button text color and hover color.', 'modave' ),
                'active'    		=> false,
                'default'  			=> array(
                    'regular' 		=> '#181818',
                    'hover'   		=> '#FFFFFF',
                )
            ),
			
			//Product Page Buttons Colors
			array(
                'id'    	=> 'product-page-button-color-info',
                'type'   	=> 'info',
                'notice' 	=> false,
                'title' 	=> esc_html__( 'Product Page Buttons Colors', 'modave' ),
            ),
			array(
                'id'       		=> 'product-cart-button-background',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Add To Cart Background', 'modave' ),
                'subtitle' 		=> esc_html__( 'Set add to cart button background and hover color.', 'modave' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#181818',
                    'hover'   	=> '#181818',
                )
            ),
			array(
                'id'       		=> 'product-cart-button-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Add To Cart Color', 'modave' ),
                'subtitle' 		=> esc_html__( 'Set add to cart button text color and hover color.', 'modave' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#FFFFFF',
                    'hover'   	=> '#FFFFFF',
                )
            ),
			array(
                'id'       		=> 'buy-now-button-background',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Buy Now Background', 'modave' ),
                'subtitle' 		=> esc_html__( 'Set buy now button background and hover color.', 'modave' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#E43131',
                    'hover'   	=> '#E43131',
                )
            ),
			array(
                'id'       		=> 'buy-now-button-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Buy Now Color', 'modave' ),
                'subtitle' 		=> esc_html__( 'Set buy now button text color and hover color.', 'modave' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#FFFFFF',
                    'hover'   	=> '#FFFFFF',
                )
            ),
			array(
                'id'    => 'checkout-button-color-info',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Checkout Buttons Colors', 'modave' ),
            ),
			array(
                'id'       		=> 'checkout-button-background',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Checkout & Place Order Background', 'modave' ),
                'subtitle' 		=> esc_html__( 'Set checkout button background and hover color.', 'modave' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#181818',
                    'hover'   	=> '#E43131',
                )
            ),
			array(
                'id'       		=> 'checkout-button-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Checkout & Place Order Color', 'modave' ),
                'subtitle' 		=> esc_html__( 'Set checkout button text color and hover color.', 'modave' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#FFFFFF',
                    'hover'   	=> '#FFFFFF',
                )
            ),
			
		),
	) );
	
	/*
	* Header
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Header', 'modave' ),
        'id'         => 'header',
		'icon'		 => 'el el-photo',
        'fields'     => array(
			array(
                'id'   				=> 'header-phone-number',
                'type'      		=> 'text',
                'title'     		=> esc_html__( 'Phone Number', 'modave' ),
                'subtitle'     		=> esc_html__( 'Leave empty for hide phone number on header.', 'modave' ),
				'default'  			=> '315-666-6688',
            ),			
			array(
                'id'   				=> 'header-email',
                'type'      		=> 'text',
                'title'     		=> esc_html__( 'Email Address', 'modave' ),
                'subtitle'     		=> esc_html__( 'Leave empty for hide email address on header.', 'modave' ),
				'default'  			=> 'support@domain.com',
            ),
			array(
                'id'   				=> 'header-store-location',
                'type'      		=> 'text',
                'title'     		=> esc_html__( 'Store Location Text', 'modave' ),
                'subtitle'     		=> esc_html__( 'Leave empty for hide store location on header.', 'modave' ),
				'default'  			=> 'Our Store',
            ),
			array(
				'id'       			=> 'header-store-location-page',
				'type'     			=> 'select',
				'data' 	   			=> 'posts',
				'args' 				=> array( 'post_type'=>'page','posts_per_page' => -1 ),
				'title'    			=> esc_html__('Store Location Page', 'modave' ),
				'subtitle'   	=> wp_kses( sprintf( __( 'You create store page from <a href="%s" target="_blank">here</a> and select it.', 'modave' ), esc_url( admin_url( 'post-new.php?post_type=page' ) ) ), array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),
				'placeholder' 		=> esc_attr__('Choose page', 'modave' ),
			),
			array(
                'id'   				=> 'header-text-message',
                'type'      		=> 'editor',
                'title'     		=> esc_html__( 'Text Message', 'modave' ),
                'subtitle'     		=> esc_html__( 'Leave empty for hide text message on header topbar.', 'modave' ),
				'default'  			=> 'Free shipping on all orders over <span class="primary-color">$20.00</span>',
            ),
			array(
                'id'   				=> 'header-text-slider',
                'type'				=> 'multi_text',
                'title'     		=> esc_html__( 'Text Slider Item', 'modave' ),
                'subtitle'     		=> esc_html__( 'This slider show in topbar heder style 3,5 and 8.', 'modave' ),
				'default'  			=> array(
					'Free shipping on all orders over <span class="primary-color">$20.00</span>',
					'Free shipping on all orders over <span class="primary-color">$50.00</span>',
					'Free shipping on all orders over <span class="primary-color">$80.00</span>'
				),
            ),
			array(
                'id'   				=> 'header-newsletter',
                'type'      		=> 'text',
                'title'     		=> esc_html__( 'Newsletter', 'modave' ),
                'subtitle'     		=> esc_html__( 'Leave empty for hide newsletter on header.', 'modave' ),
				'default'  			=> 'Newsletter',
            ),
			array(
                'id'       			=> 'header-language-switcher',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Language Switcher', 'modave' ),
                'subtitle' 			=> esc_html__( 'Show language switcher on header topbar or not.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'header-currency-switcher',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Currency Switcher', 'modave' ),
                'subtitle' 			=> esc_html__( 'Show currency switcher on header topbar or not.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
                'id'      			=> 'header-language-switcher-style',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Language Switcher Style', 'modave' ),
				'subtitle'   		=> wp_kses( sprintf( __( 'This option will work if you have used <a href="%1$s" target="_blank">Polylang</a> Or <a href="%2$s" target="_blank">TranslatePress</a> plugin.', 'modave' ), esc_url( 'https://wordpress.org/plugins/polylang/' ),esc_url( 'https://wordpress.org/plugins/translatepress-multilingual/' ) ), array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),
                'options'  			=> array(
					'dropdown'		=> esc_html__( 'Dropdown', 'modave' ),
                    'horizontal' 	=> esc_html__( 'Horizontal List', 'modave' ),
                ),
                'default'  			=> 'dropdown',
            ),
			array(
                'id'       			=> 'header-language-switcher-view',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Language Country', 'modave' ),
				'subtitle'   		=> wp_kses( sprintf( __( 'This option will work if you have used <a href="%1$s" target="_blank">Polylang</a> Or <a href="%2$s" target="_blank">TranslatePress</a> plugin.', 'modave' ), esc_url( 'https://wordpress.org/plugins/polylang/' ),esc_url( 'https://wordpress.org/plugins/translatepress-multilingual/' ) ), array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),
                'options'  			=> array(
					'both'		=> esc_html__( 'Flag & Name', 'modave' ),
                    'name' 		=> esc_html__( 'Name', 'modave' ),
                    'flag' 		=> esc_html__( 'Flag', 'modave' ),
                ),
                'default'  			=> 'both',
            ),
			array(
                'id'       => 'header-social-profile-style',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Social Icons Style', 'modave' ),
				'subtitle' => esc_html__( 'Select social icons style for header.', 'modave' ),
                'options'  => array(
					'icons-default' 	=> array(
                        'title' 	=> esc_html__( 'Default', 'modave' ),
                        'alt' 		=> esc_html__( 'Default', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/social-icon/default.png',
                    ), 
					'icons-theme-colour' => array(
                        'title' 	=> esc_html__( 'Theme Colour', 'modave' ),
                        'alt' 		=> esc_html__( 'Theme Colour', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/social-icon/theme-color.png',
                    ), 
					'icons-fill-colour' => array(
                        'title' 	=> esc_html__( 'Fill Colour', 'modave' ),
                        'alt' 		=> esc_html__( 'Fill Colour', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/social-icon/fill-color.png',
                    ),
                ),
                'default'  => 'icons-theme-colour',
            ),
			array(
                'id'       => 'header-social-profile-icons-size',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Social Icons Size', 'modave' ),
				'subtitle' => esc_html__( 'Select social icons size for header.', 'modave' ),
                'options'  => array(
                    'icons-size-default'=> esc_html__( 'Default', 'modave' ),
					'icons-size-small' 	=> esc_html__( 'Small', 'modave' ),
					'icons-size-large' 	=> esc_html__( 'Large', 'modave' ),
                ),
                'default'  => 'icons-size-small',
            ),
			array(
				'id'       => 'header-myaccount',
                'type'     => 'switch',
                'title'    => esc_html__( 'My Account', 'modave' ),
                'subtitle'     => esc_html__( 'Show my account on header.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
            ),
			array(
                'id'       			=> 'login-register-popup',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Login/Register Popup', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Show header login/register popup.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'header-cart',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Cart', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Show cart with Icon on header.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'header-minicart-popup',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Mini Cart Popup', 'modave' ),
				'subtitle'     		=> esc_html__( 'Show header mini cart popup when added product in the cart.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
				'required' 			=> array( 'header-cart', '=', 1 ),
            ),
			array(
                'id'       			=> 'header-wishlist',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Wishlist', 'modave' ),
                'subtitle' 			=> esc_html__( 'Show wishlist icon on header.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'header-compare',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Compare', 'modave' ),
                'subtitle' 			=> esc_html__( 'Show compare icon on header.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'header-icon-text',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Icon Text', 'modave' ),
                'subtitle' 			=> esc_html__( 'Show icon text on header.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),
			array(
                'id'       			=> 'categories-menu',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Categories Menu', 'modave' ),
                'subtitle'     		=> esc_html__( 'Show shopping categories menu on header or not. This option work in header style 5', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'categories-menu-title',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Categories Menu Title', 'modave' ),
                'subtitle' 			=> esc_html__( 'Enter categories menu title.', 'modave' ),
				'default'  			=> 'Browse Categories',
            ),
			array(
                'id'       			=> 'categories-menu-icon',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Categories Menu Icon', 'modave' ),
                'subtitle' 			=> esc_html__( 'Enter categories menu icon class. (ex. picon-grid)', 'modave' ),
				'default'  			=> '',
            ),
			array(
                'id'       			=> 'open-categories-menu',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Categories(Vertical) Menu On Home Page', 'modave' ),
                'subtitle' 			=> esc_html__( 'You always want to keep the categories (vertical) menu open on the home page.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),
			array(
                'id'       			=> 'cats-max-menu-items',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Enable Max Menu Items', 'modave' ),
                'subtitle' 			=> esc_html__( 'Show max menu items for categories menu.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),
			array(
                'id'            	=> 'number-of-cats-max-menu-items',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Number Of Max Menu Items', 'modave' ),
                'subtitle' 			=> esc_html__( 'How many menu items show for categories menu?', 'modave' ),
                'default'       	=> 8,
                'min'           	=> 3,
                'step'          	=> 1,
                'max'           	=> 20,
                'display_value' 	=> 'text',
				'required' 			=> array( 'cats-max-menu-items', '=', 1 ),
            ),
		)
	) );
	
	/*
	* Header Manager options
	*/
    Redux::setSection( $opt_name, array(
        'title'     	 	=> esc_html__( 'Header Manager', 'modave' ),
        'id'         		=> 'header-manager',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       			=> 'header-topbar',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Topbar', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Show header topbar or not.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'mobile-header-topbar',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Mobile Topbar', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Show topbar in mobile.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
				'required' 			=> array( 'header-topbar', '=', 1 ),
            ),
			array(
                'id'       			=> 'header-transparent',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Header Transparent', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Make the header transparent/overlay the content.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),
			array(
                'id'       			=> 'header-transparent-on',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Header Transparent On', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Make the header transparent/overlay the content on front page or all pages.', 'modave' ),
                'options'  			=> array(
                    'front-page' 	=> esc_html__( 'Front Page', 'modave' ),
                    'inner-pages' 	=> esc_html__( 'Inner Pages', 'modave' ),
                    'all-pages' 	=> esc_html__( 'All Pages', 'modave' ),
                ),
                'default'  			=> 'front-page',
				'required' 			=> array( 'header-transparent', '=', 1 ),
            ),
			array(
                'id'       			=> 'header-transparent-color',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Header Transparent Color', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'This color will work when header transparent/overlay enable.', 'modave' ),
                'options'  			=> array(
                    'light' 	=> esc_html__( 'Light', 'modave' ),
                    'dark' 		=> esc_html__( 'Dark', 'modave' ),
                ),
                'default'  			=> 'dark',
				'required' 			=> array( 'header-transparent', '=', 1 ),
            ),
			array(
                'id'       			=> 'header-full-width',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Header Full Width', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Display header in full width.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),
			array(
                'id'       			=> 'header-select',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Select Header', 'modave' ),
                'options'  			=> array(
                    'style' 		=> esc_html__( 'Header Style', 'modave' ),
                    'builder' 		=> esc_html__( 'Header Builder', 'modave' ),
                ),
                'default'  			=> 'style',
            ),
			array(
                'id'       			=> 'header-style',
                'type'     			=> 'image_select',
                'title'    			=> esc_html__( 'Header Style', 'modave' ),
                'subtitle' 			=> esc_html__( 'Select a header style.', 'modave' ),
                'description' 		=> esc_html__( 'Select a header style.', 'modave' ),
				'full_width' 		=> true,
				'options'  			=> array(
					'1' => array( 'title' => '1', 'alt' => 'Header 1', 'img' => PLS_ADMIN_IMAGES.'header/header-1.png' ),
                    '2' => array( 'title' => '2', 'alt' => 'Header 2', 'img' => PLS_ADMIN_IMAGES.'header/header-2.png' ),
                    '3' => array( 'title' => '3', 'alt' => 'Header 3', 'img' => PLS_ADMIN_IMAGES.'header/header-3.png' ),
                    '4' => array( 'title' => '4', 'alt' => 'Header 4', 'img' => PLS_ADMIN_IMAGES.'header/header-4.png' ),
                    '5' => array( 'title' => '5', 'alt' => 'Header 5', 'img' => PLS_ADMIN_IMAGES.'header/header-5.png' ),
                    '6' => array( 'title' => '6', 'alt' => 'Header 6', 'img' => PLS_ADMIN_IMAGES.'header/header-6.png' ),
                    '7' => array( 'title' => '7', 'alt' => 'Header 7', 'img' => PLS_ADMIN_IMAGES.'header/header-7.png' ),
                    '8' => array( 'title' => '8', 'alt' => 'Header 8', 'img' => PLS_ADMIN_IMAGES.'header/header-8.png' ),
                    '9' => array( 'title' => '9', 'alt' => 'Header 9', 'img' => PLS_ADMIN_IMAGES.'header/header-9.png' ),
                    '10' => array( 'title' => '10', 'alt' => 'Header 10', 'img' => PLS_ADMIN_IMAGES.'header/header-10.png' ),
                    '11' => array( 'title' => '11', 'alt' => 'Header 11', 'img' => PLS_ADMIN_IMAGES.'header/header-11.png' ),
                    '12' => array( 'title' => '12', 'alt' => 'Header 12', 'img' => PLS_ADMIN_IMAGES.'header/header-12.png' ),
                    '13' => array( 'title' => '13', 'alt' => 'Header 13', 'img' => PLS_ADMIN_IMAGES.'header/header-13.png' ),
                    '14' => array( 'title' => '14', 'alt' => 'Header 14', 'img' => PLS_ADMIN_IMAGES.'header/header-14.png' ),
                    '15' => array( 'title' => '15', 'alt' => 'Header 15', 'img' => PLS_ADMIN_IMAGES.'header/header-15.png' ),
                ),
                'default'  			=> '1',				
				'required' 			=> array( 'header-select', '=', 'style' ),
            ),
			array(
                'id'    			=> 'header-topbar-info1',
                'type'  			=> 'info',
				'notice' 			=> false,
                'title' 			=> esc_html__( 'Header Topbar Manager', 'modave' ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),			
			array(
                'id'       			=> 'header-topbar-manager',
                'type'     			=> 'sorter',
                'title'    			=> esc_html__( 'Topbar Manager', 'modave' ),
				'subtitle'			=> esc_html__( 'Organize how you want the layout to appear on the header topbar', 'modave' ),
				'full_width' 		=> true,
                'options'  			=> array(
                    'left'  	=> array(
						'email-address' 	=> esc_html__( 'Email', 'modave' ),
                        'phone-number'		=> esc_html__( 'Phone Number', 'modave' ),						
						'store-location'	=> esc_html__( 'Location', 'modave' ),
                    ),
					'center' 	=> array( ), 
					'right' 	=> array(
						'language-switcher'	=> esc_html__( 'Language Switcher', 'modave' ),
						'currency-switcher'	=> esc_html__( 'Currency Switcher', 'modave' ),
					),
					'disabled' 	=> array(
						'text-message'		=> esc_html__( 'Welcome Message', 'modave' ),
						'text-slider'		=> esc_html__( 'Text Slider', 'modave' ),
						'topbar-menu'		=> esc_html__( 'Topbar Menu', 'modave' ),
						'mini-search'		=> esc_html__( 'Mini Search', 'modave' ),
						'social-profile'	=> esc_html__( 'Social Profile', 'modave' ),
					),
                ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
				'id'       			=> 'header-topbar-left',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Topbar Left', 'modave' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'modave' ),
					'2'  => esc_html__( '2 columns - 1/6', 'modave' ),
					'3'  => esc_html__( '3 columns - 1/4', 'modave' ),
					'4'  => esc_html__( '4 columns - 1/3', 'modave' ),
					'5'  => esc_html__( '5 columns - 5/12', 'modave' ),
					'6'  => esc_html__( '6 columns - 1/2', 'modave' ),
					'7'  => esc_html__( '7 columns - 7/12', 'modave' ),
					'8'  => esc_html__( '8 columns - 2/3', 'modave' ),
					'9'  => esc_html__( '9 columns - 3/4', 'modave' ),
					'10' => esc_html__( '10 columns - 5/6', 'modave' ),
					'11' => esc_html__( '11 columns - 11/12', 'modave' ),
					'12' => esc_html__( '12 columns - 1/1', 'modave' ),
				),
				'default'  			=> '6',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
				'id'       			=> 'header-topbar-center',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Topbar Center', 'modave' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'modave' ),
					'2'  => esc_html__( '2 columns - 1/6', 'modave' ),
					'3'  => esc_html__( '3 columns - 1/4', 'modave' ),
					'4'  => esc_html__( '4 columns - 1/3', 'modave' ),
					'5'  => esc_html__( '5 columns - 5/12', 'modave' ),
					'6'  => esc_html__( '6 columns - 1/2', 'modave' ),
					'7'  => esc_html__( '7 columns - 7/12', 'modave' ),
					'8'  => esc_html__( '8 columns - 2/3', 'modave' ),
					'9'  => esc_html__( '9 columns - 3/4', 'modave' ),
					'10' => esc_html__( '10 columns - 5/6', 'modave' ),
					'11' => esc_html__( '11 columns - 11/12', 'modave' ),
					'12' => esc_html__( '12 columns - 1/1', 'modave' ),
				),
				'default'  			=> '',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
				'id'       			=> 'header-topbar-right',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Topbar Right', 'modave' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'modave' ),
					'2'  => esc_html__( '2 columns - 1/6', 'modave' ),
					'3'  => esc_html__( '3 columns - 1/4', 'modave' ),
					'4'  => esc_html__( '4 columns - 1/3', 'modave' ),
					'5'  => esc_html__( '5 columns - 5/12', 'modave' ),
					'6'  => esc_html__( '6 columns - 1/2', 'modave' ),
					'7'  => esc_html__( '7 columns - 7/12', 'modave' ),
					'8'  => esc_html__( '8 columns - 2/3', 'modave' ),
					'9'  => esc_html__( '9 columns - 3/4', 'modave' ),
					'10' => esc_html__( '10 columns - 5/6', 'modave' ),
					'11' => esc_html__( '11 columns - 11/12', 'modave' ),
					'12' => esc_html__( '12 columns - 1/1', 'modave' ),
				),
				'default'  			=> '6',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
                'id'    			=> 'header-main-info1',
                'type'  			=> 'info',
				'notice' 			=> false,
                'title' 			=> esc_html__( 'Header Main Manager', 'modave' ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
                'id'       			=> 'header-main-manager',
                'type'     			=> 'sorter',
                'title'    			=> 'Header Main Manager',
				'subtitle'			=> esc_html__( 'Organize how you want the layout to appear on the header main', 'modave' ),
				'full_width' 		=> true,
                'options'  			=> array(
                    'left'  	=> array(
                        'logo' 			=> esc_html__( 'Logo', 'modave' ),
                    ),
                    'center' 	=> array(
						'primary-menu'		=> esc_html__( 'Primary Menu', 'modave' ),
						
					),
					'right' 	=> array(
						'mini-search'		=> esc_html__( 'Mini Search', 'modave' ),
						'myaccount'			=> esc_html__( 'My Account', 'modave' ),					
						'wishlist'			=> esc_html__( 'Wishlist', 'modave' ),
						'cart'				=> esc_html__( 'Cart', 'modave' ),						
					),
					'disabled' 	=> array(						
						'secondary-menu'	=> esc_html__( 'Secondary Menu', 'modave' ),
						'ajax-search'		=> esc_html__( 'Ajax Search', 'modave' ),						
						'compare'			=> esc_html__( 'Compare', 'modave' ),						
						'currency-switcher'	=> esc_html__( 'Currency Switcher', 'modave' ),
						'language-switcher'	=> esc_html__( 'Language Switcher', 'modave' ),
						'customer-support'	=> esc_html__( 'Customer Support', 'modave' ),
						'custom-html'		=> esc_html__( 'Custom HTML', 'modave' ),
					),
                ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
				'id'       			=> 'header-main-left',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Header Main Left', 'modave' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'modave' ),
					'2'  => esc_html__( '2 columns - 1/6', 'modave' ),
					'3'  => esc_html__( '3 columns - 1/4', 'modave' ),
					'4'  => esc_html__( '4 columns - 1/3', 'modave' ),
					'5'  => esc_html__( '5 columns - 5/12', 'modave' ),
					'6'  => esc_html__( '6 columns - 1/2', 'modave' ),
					'7'  => esc_html__( '7 columns - 7/12', 'modave' ),
					'8'  => esc_html__( '8 columns - 2/3', 'modave' ),
					'9'  => esc_html__( '9 columns - 3/4', 'modave' ),
					'10' => esc_html__( '10 columns - 5/6', 'modave' ),
					'11' => esc_html__( '11 columns - 11/12', 'modave' ),
					'12' => esc_html__( '12 columns - 1/1', 'modave' ),
				),
				'default'  			=> '3',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
				'id'       			=> 'header-main-center',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Header Main Center', 'modave' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'modave' ),
					'2'  => esc_html__( '2 columns - 1/6', 'modave' ),
					'3'  => esc_html__( '3 columns - 1/4', 'modave' ),
					'4'  => esc_html__( '4 columns - 1/3', 'modave' ),
					'5'  => esc_html__( '5 columns - 5/12', 'modave' ),
					'6'  => esc_html__( '6 columns - 1/2', 'modave' ),
					'7'  => esc_html__( '7 columns - 7/12', 'modave' ),
					'8'  => esc_html__( '8 columns - 2/3', 'modave' ),
					'9'  => esc_html__( '9 columns - 3/4', 'modave' ),
					'10' => esc_html__( '10 columns - 5/6', 'modave' ),
					'11' => esc_html__( '11 columns - 11/12', 'modave' ),
					'12' => esc_html__( '12 columns - 1/1', 'modave' ),
				),
				'default'  			=> '6',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
                'id'       			=> 'header-main-align',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Align Center', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Align center for above section.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
				'id'       			=> 'header-main-right',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Header Main Right', 'modave' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'modave' ),
					'2'  => esc_html__( '2 columns - 1/6', 'modave' ),
					'3'  => esc_html__( '3 columns - 1/4', 'modave' ),
					'4'  => esc_html__( '4 columns - 1/3', 'modave' ),
					'5'  => esc_html__( '5 columns - 5/12', 'modave' ),
					'6'  => esc_html__( '6 columns - 1/2', 'modave' ),
					'7'  => esc_html__( '7 columns - 7/12', 'modave' ),
					'8'  => esc_html__( '8 columns - 2/3', 'modave' ),
					'9'  => esc_html__( '9 columns - 3/4', 'modave' ),
					'10' => esc_html__( '10 columns - 5/6', 'modave' ),
					'11' => esc_html__( '11 columns - 11/12', 'modave' ),
					'12' => esc_html__( '12 columns - 1/1', 'modave' ),
				),
				'default'  			=> '3',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
				'id'      			=> 'header-main-custom-html',
				'type'    		 	=> 'editor',
                'title'    			=> esc_html__( 'Custom HTML', 'modave' ),
				'default'  			=>'',
				'subtitle' 			=> esc_html__( 'Add your custom html here.', 'modave' ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
                'id'    			=> 'header-navigation-info1',
                'type'  			=> 'info',
				'notice' 			=> false,
                'title' 			=> esc_html__( 'Header Navigation Manager', 'modave' ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
                'id'       			=> 'header-navigation',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Header Navigation', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Show header navigation.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
                'id'       			=> 'header-navigation-manager',
                'type'     			=> 'sorter',
                'title'    			=> esc_html__( 'Header Navigation Manager', 'modave' ),
                'subtitle'			=> esc_html__( 'Organize how you want the layout to appear on the header navigation', 'modave' ),
				'full_width' 		=> true,
                'options'  			=> array(
                   'left'  		=> array(
                       'category-menu'		=> esc_html__( 'Category Menu', 'modave' ),
                    ),
                    'center' 	=> array(
						'primary-menu'			=> esc_html__( 'Primary Menu', 'modave' ),
					),
					'right' 	=> array(
					),
					'disabled' => array(
						'secondary-menu'	=> esc_html__( 'Secondary Menu', 'modave' ),	
						'ajax-search'		=> esc_html__( 'Ajax Search', 'modave' ),
						'myaccount'			=> esc_html__( 'My Account', 'modave' ),
						'cart'				=> esc_html__( 'Cart', 'modave' ),					
						'wishlist'			=> esc_html__( 'Wishlist', 'modave' ),
						'customer-support'	=> esc_html__( 'Customer Support', 'modave' ),
						'custom-html'		=> esc_html__( 'Custom HTML', 'modave' ),
					),
                ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
				'id'       			=> 'header-navigation-left',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Header Navigation Left', 'modave' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'modave' ),
					'2'  => esc_html__( '2 columns - 1/6', 'modave' ),
					'3'  => esc_html__( '3 columns - 1/4', 'modave' ),
					'4'  => esc_html__( '4 columns - 1/3', 'modave' ),
					'5'  => esc_html__( '5 columns - 5/12', 'modave' ),
					'6'  => esc_html__( '6 columns - 1/2', 'modave' ),
					'7'  => esc_html__( '7 columns - 7/12', 'modave' ),
					'8'  => esc_html__( '8 columns - 2/3', 'modave' ),
					'9'  => esc_html__( '9 columns - 3/4', 'modave' ),
					'10' => esc_html__( '10 columns - 5/6', 'modave' ),
					'11' => esc_html__( '11 columns - 11/12', 'modave' ),
					'12' => esc_html__( '12 columns - 1/1', 'modave' ),
				),
				'default'  			=> '3',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
				'id'       			=> 'header-navigation-center',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Header Navigation Center', 'modave' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'modave' ),
					'2'  => esc_html__( '2 columns - 1/6', 'modave' ),
					'3'  => esc_html__( '3 columns - 1/4', 'modave' ),
					'4'  => esc_html__( '4 columns - 1/3', 'modave' ),
					'5'  => esc_html__( '5 columns - 5/12', 'modave' ),
					'6'  => esc_html__( '6 columns - 1/2', 'modave' ),
					'7'  => esc_html__( '7 columns - 7/12', 'modave' ),
					'8'  => esc_html__( '8 columns - 2/3', 'modave' ),
					'9'  => esc_html__( '9 columns - 3/4', 'modave' ),
					'10' => esc_html__( '10 columns - 5/6', 'modave' ),
					'11' => esc_html__( '11 columns - 11/12', 'modave' ),
					'12' => esc_html__( '12 columns - 1/1', 'modave' ),
				),
				'default'  			=> '9',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
                'id'       			=> 'header-navigation-align',
				'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Align Center', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Align center for above section.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
				'id'       			=> 'header-navigation-right',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Header Navigation Right', 'modave' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'modave' ),
					'2'  => esc_html__( '2 columns - 1/6', 'modave' ),
					'3'  => esc_html__( '3 columns - 1/4', 'modave' ),
					'4'  => esc_html__( '4 columns - 1/3', 'modave' ),
					'5'  => esc_html__( '5 columns - 5/12', 'modave' ),
					'6'  => esc_html__( '6 columns - 1/2', 'modave' ),
					'7'  => esc_html__( '7 columns - 7/12', 'modave' ),
					'8'  => esc_html__( '8 columns - 2/3', 'modave' ),
					'9'  => esc_html__( '9 columns - 3/4', 'modave' ),
					'10' => esc_html__( '10 columns - 5/6', 'modave' ),
					'11' => esc_html__( '11 columns - 11/12', 'modave' ),
					'12' => esc_html__( '12 columns - 1/1', 'modave' ),
				),
				'default'  			=> '',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
				'id'      			=> 'header-navigation-custom-html',
				'type'    		 	=> 'editor',
                'title'    			=> esc_html__( 'Custom HTML', 'modave' ),
				'default'  			=> '',
				'subtitle' 			=> esc_html__( 'Add your custom html here.', 'modave' ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
		)
	) );

	/*
	* Header Sticky Manager options
	*/
    Redux::setSection( $opt_name, array(
        'title'     	 	=> esc_html__( 'Header Sticky Manager', 'modave' ),
        'id'         		=> 'header-sticky-manager',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       			=> 'header-sticky',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Header Sticky', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Enable header sticky.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),
			array(
                'id'       			=> 'header-sticky-part',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Make Header Sticky', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Select header section and make header sticky.', 'modave' ),
                'options'  			=> array(
					'main'			=>	esc_html__( 'Middle(Main)', 'modave' ),
					'navigation'	=>	esc_html__( 'Navigation', 'modave' ),					
				),
                'default'  			=> 'main',
				'required' 			=> array( 'header-sticky', '=', 1 )
            ),
			array(
                'id'          		=> 'header-sticky-main-height',
                'type'          	=> 'dimensions',
                'title'          	=> esc_html__( 'Middle(Main) Height', 'modave' ),
				'subtitle'    		=> esc_html__( 'Set middle(|Main) header sticky height.', 'modave' ),
				'units_extended'	=> false,
                'width'        	 	=> false,
                'default'        	=> array( 
                    'height' 		=> 82,
                ),
				'required' 			=> array( 'header-sticky-part', '=', 'main' ),
            ),	
			array(
                'id'       			=> 'header-sticky-scroll-up',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Header Sticky Scroll-up', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Show header sticky on scroll up.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
				'required' 			=> array( 'header-sticky', '=', 1 ),
            ),
		)
	) );
	
	// Header Ajax Search
    Redux::setSection( $opt_name, array(
        'title'     	 	=> esc_html__( 'Ajax Search', 'modave' ),
        'id'         		=> 'header-ajax-search',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       => 'header-search',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Header Search', 'modave' ),
                'subtitle'     => esc_html__( 'Enable/Disable header search.', 'modave' ),
                'on'       => esc_html__( 'Enable', 'modave' ),
				'off'      => esc_html__( 'Disable', 'modave' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'product-ajax-search',
                'type'     => 'switch',
                'title'    => esc_html__( 'Product Live/Ajax Search', 'modave' ),
                'subtitle'     => esc_html__( 'Live product search or not on header.', 'modave' ),
                'on'       => esc_html__( 'Enable', 'modave' ),
				'off'      => esc_html__( 'Disable', 'modave' ),
				'default'  => 1,
            ),
			array(
                'id'       			=> 'header-ajax-search-style',
                'type'     			=> 'image_select',
                'title'    			=> esc_html__( 'Ajax Search Style', 'modave' ),
				'subtitle' 	   		=> esc_html__( 'Select ajax search box style.', 'modave' ),
                'options'  			=> array(
					'1' 	=> array( 'alt' => '1', 'img' => PLS_ADMIN_IMAGES.'layout/search/1.png' ),
					'2' 	=> array( 'alt' => '2', 'img' => PLS_ADMIN_IMAGES.'layout/search/2.png' ),
					'3' 	=> array( 'alt' => '3', 'img' => PLS_ADMIN_IMAGES.'layout/search/3.png' ),
                ),
                'default'  			=> '3',
            ),
			array(
                'id'       			=> 'search-content-type',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Search Content Type', 'modave' ),
				'subtitle'     		=> esc_html__( 'Select content type you want to use in the search box.', 'modave' ),
                'options'  			=> array(
                    'all'			=> esc_html__( 'All', 'modave' ),
                    'product' 		=> esc_html__( 'Product', 'modave' ),
                    'post' 			=> esc_html__( 'Post', 'modave' ),
                ),
                'default'  			=> 'product',
            ),
			array(
                'id'       => 'show-categories-dropdow',
                'type'     => 'switch',
                'title'    => esc_html__( 'Categories Dropdown', 'modave' ),
                'subtitle' 	   => esc_html__( 'Show categories dropdow in product search.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'search-categories',
                'type'     => 'radio',
                'title'    => esc_html__( 'Search Categories Dropdown', 'modave' ),
                'subtitle'     => esc_html__( 'Display categories in search categories dropdow.', 'modave' ),
                'options'  => array(
								'all' 	 => esc_html__( 'Show All Categories', 'modave' ),
								'parent' => esc_html__( 'Only Parent(top level) Categories', 'modave' ),
							),
				'default'  => 'all',
				'required' => array( 'show-categories-dropdow', '=', 1 ),
            ),
			array(
                'id'       => 'categories-hierarchical',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show Categories Hierarchical', 'modave' ),
                'subtitle' 	   => esc_html__( 'Show categories in hierarchical (Must be need to select above option Show All Categories).', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
				'required' => array( 'search-categories', '=', 'all' )
            ),
			array(
                'id'       			=> 'search-placeholder-text',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Search Palceholder Text', 'modave' ),
                'subtitle'     		=> esc_html__('Enter search palceholder text', 'modave' ),
				'default'  			=> esc_html__('What are you looking for?', 'modave' ),
            ),
			array(
                'id'       			=> 'header-search-image',
                'type'     			=> 'switch',
                'title'    			=> esc_html__('Search Image', 'modave' ),
                'subtitle' 	   		=> esc_html__('Show product Image in search results.', 'modave' ),
                'on'       			=> esc_html__('Yes', 'modave' ),
				'off'      			=> esc_html__('No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'header-search-price',
                'type'     			=> 'switch',
                'title'    			=> esc_html__('Search Price', 'modave' ),
                'subtitle' 	   		=> esc_html__('Show product price in search results.', 'modave' ),
                'on'       			=> esc_html__('Yes', 'modave' ),
				'off'      			=> esc_html__('No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'header-search-rating',
                'type'     			=> 'switch',
                'title'    			=> esc_html__('Search Rating', 'modave' ),
                'subtitle' 	   		=> esc_html__('Show product raing in search results.', 'modave' ),
                'on'       			=> esc_html__('Yes', 'modave' ),
				'off'      			=> esc_html__('No', 'modave' ),
				'default'  			=> 0,
            ),
			array(
                'id'       			=> 'feature-keywords-search',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Feature Keywords', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Show feature keywords search.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 1,
            ),
			array(
				'id'       			=> 'search-categories-keywords',
				'type'     			=> 'select',
				'multi'    			=> true,
				'data' 	   			=> 'terms',
				'args' 				=> array( 'taxonomies' => 'product_cat' ),
				'title'    			=> esc_html__( 'Categories Keywords', 'modave' ),
				'subtitle'     		=> esc_html__( 'Search feature keywords using categories keywords.', 'modave' ),
				'placeholder' 		=> esc_attr__( 'Choose product categories', 'modave' ),
				'required' 			=> array( 'feature-keywords-search', '=', 1 ),
			),
			array(
                'id'       			=> 'extra-search-content',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Extra Search Content', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Show extra content in search popup area.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),
			array(
                'id'       			=> 'extra-search-content-block',
                'type'     			=> 'select',
				'title'    			=> esc_html__('Select Block', 'modave' ),
				'subtitle'   		=> wp_kses( sprintf( __( 'You can add custom block from <a href="%s" target="_blank">here</a>', 'modave' ), esc_url( admin_url( 'post-new.php?post_type=block' ) ) ), array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),
				'options'    	=> $custom_blocks,
				'default' 		=> ' ',
				'placeholder' 		=> esc_attr__('Choose block', 'modave' ),
				'required' 			=> array( 'extra-search-content', '=', 1 ),
            ),
		)
	) );
	
	/*
	* Page Heading options
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Page Heading', 'modave' ),
        'id'         => 'page-heading',
		'icon'		 => 'el el-icon-website',
        'fields'     => array(
			array(
                'id'       		=> 'page-title-layout',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Page Title Layout', 'modave' ),
				'subtitle'    	=> esc_html__( 'Select page title layout.', 'modave' ),
                'options'  		=> array(
					'center' => array(
                        'title' 	=> esc_html__( 'Centered', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/page-title-centered.png',
                    ),
                    'left' => array(
                        'title' 	=> esc_html__( 'Left', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/page-title-default.png',
                    ),
					'disable' => array(
                        'title' 	=> esc_html__( 'Disable', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/page-title-none.png',
                    )
                ),
                'default'  		=> 'center',
            ),
			array(
                'id'       		=> 'page-heading',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Page Title', 'modave' ),
				'subtitle'    	=> esc_html__( 'Show page title.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
                'off'      		=> esc_html__( 'No', 'modave' ),
                'default'  		=> 1,
            ),
			array(
                'id'       		=> 'page-breadcrumb',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Breadcrumbs', 'modave' ),
                'subtitle'    	=> esc_html__( 'Show breadcrumbs.', 'modave' ),
                'on'      		=> esc_html__( 'Yes', 'modave' ),
                'off'      		=> esc_html__( 'No', 'modave' ),
                'default'  		=> 1,
            ),
			array(
                'id'       		=> 'breadcrumb-delimiter',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Breadcrumb Delimiter', 'modave' ),
				'subtitle'    	=> esc_html__( 'Select breadcrumb seperator', 'modave' ),
                'options'  		=> array(
                    'greater-than'		=> esc_html__( '>', 'modave' ),
                    'forward-slash' 	=> esc_html__( '/', 'modave' ),
                ),
                'default'  		=> 'greater-than',
            ),
			
			array(
                'id'    	=> 'page-heading-notice',
                'type'   	=> 'info',
                'notice' 	=> false,
                'title' 	=> esc_html__( 'Page Heading Colors', 'modave' ),
            ),
			array(
                'id'       			=> 'page-heading-background',
                'type'     			=> 'background',
                'title'    			=>  esc_html__( 'Background Color', 'modave' ),
				'subtitle' 			=> esc_html__( 'Page title background image or color', 'modave' ),
				'output' 			=> array( '.pls-page-title' ),
                'default' 			=> array(
					'background-color' 		=> '#F5F3EE',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> 'cover',
					'background-attachment' => '',
					'background-position' 	=> 'center center'
				),
            ),
			array(
                'id'       			=> 'page-title-color',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Title Color', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Page title color.', 'modave' ),
                'options'  			=> array(
                    'default' 	=> esc_html__( 'Default', 'modave' ),
                    'light' 	=> esc_html__( 'Light', 'modave' ),
                    'dark' 		=> esc_html__( 'Dark', 'modave' ),
                ),
                'default'  			=> 'dark',
            ),
			array(
                'id'       			=> 'page-title-size',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Title Size', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Page title size.', 'modave' ),
                'options'  			=> array(
                    'default' 		=> esc_html__( 'Default', 'modave' ),
                    'small' 		=> esc_html__( 'Small', 'modave' ),
                    'large' 		=> esc_html__( 'Large', 'modave' ),
                ),
                'default'  			=> 'default',
            ),
			array(
				'id'             	=> 'page-title-padding',
				'type'           	=> 'spacing',
				'title'          	=> esc_html__( 'Padding', 'modave' ),
				'subtitle'       	=> esc_html__( 'Set top bottom padding for page title.', 'modave' ),
				'mode'           	=> 'padding',
				'units_extended' 	=> 'false',
				'left'        	 	=> false,
                'right'        	 	=> false,
				'output' 			=> array( '.pls-page-title' ),
				'default'            => array(
					'padding-top'     	=> '82', 
					'padding-bottom'  	=> '82',
					'units'          	=> 'px', 
				)
			),			
		)
	) );
	
	//Footer Options
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Footer', 'modave' ),
        'id'         => 'footer',
		'icon'		 => 'el el-photo',
        'fields'     => array(
			array(
                'id'       		=> 'site-footer-style',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Footer', 'modave' ),
                'subtitle'    	=> esc_html__( 'Select footer style.', 'modave' ),
                'options'  		=> array(
					'predefined'	=> esc_html__( 'Predefined', 'modave' ),
                    'custom-footer'	=> esc_html__( 'Custom Footer', 'modave' ),	
					'none'			=> esc_html__( 'None', 'modave' ),
				),
				'default'  		=> 'predefined',
            ),
			array(
				'id'       			=> 'footer-block-id',
				'type'     			=> 'select',				
				'title'    			=> esc_html__('Select Block', 'modave' ),
				'subtitle'   	=> wp_kses( sprintf( __( 'You can build your own footer using Elementor from <a href="%s" target="_blank">here</a>.', 'modave' ), esc_url( admin_url( 'post-new.php?post_type=block' ) ) ), array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),
				'options'    	=> $custom_blocks,
				'default' 		=> ' ',
				'placeholder' 		=> esc_attr__('Choose block', 'modave' ),
				'required'			=> array( 'site-footer-style', '=', 'custom-footer' )
			),
			array(
				'id'             	=> 'footer-padding',
				'type'           	=> 'spacing',
				'title'          	=> esc_html__( 'Padding', 'modave' ),
				'subtitle'       	=> esc_html__( 'Set top bottom padding for footer section.', 'modave' ),
				'mode'           	=> 'padding',
				'units_extended' 	=> 'false',
				'units'          	=> array('rem', '%', 'px'),
				'left'        	 	=> false,
                'right'        	 	=> false,
				'output' 			=> array( '.pls-site-footer .pls-footer-main' ),
				'default'            => array(
					'padding-top'     	=> '5', 
					'padding-bottom'  	=> '5',
					'units'          	=> 'rem', 
				),
				'required'			=> array( 'site-footer-style', '=', 'predefined' )
			),
			array(
                'id'       		=> 'footer-widget-alignment',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Widget Alignment Center', 'modave' ),
				'subtitle'    	=> esc_html__( 'Display footer widget alignment center.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
				'required'			=> array( 'site-footer-style', '=', 'predefined' )
            ),
			array(
                'id'       		=> 'footer-widget-collapse',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Collapse Widgets on Mobile', 'modave' ),
				'subtitle'    	=> esc_html__( 'Yes/No collapse footer widgets on mobile device.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
				'required'			=> array( 'site-footer-style', '=', 'predefined' )
            ),
			
			array(
                'id'    => 'footer-notice1',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Footer Colors', 'modave' ),
            ),			
			array(
                'id'       		=> 'footer-background',
                'type'     		=> 'background',
                'title'    		=> esc_html__( 'Background Color', 'modave' ),
				'subtitle' 		=> esc_html__( 'Footer background image or color.', 'modave' ),
				'output'  	 	=> array( '.pls-site-footer .pls-footer-main' ),
                'default' 		=> array(
					'background-color' 		=> '#FFFFFF',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> '',
					'background-attachment' => '',
					'background-position' 	=> '',
				),
            ),
			array(
                'id'       => 'footer-heading-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Heading Color', 'modave' ),
				'subtitle' 		=> esc_html__( 'Footer heading color like widget, etc.', 'modave' ),
                'default'  => '#181818',
            ),
            array(
                'id'       => 'footer-text-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Text Color', 'modave' ),
				'subtitle' => esc_html__( 'Footer text color', 'modave' ),
                'default'  => '#4D4E4F',
            ),
			array(
                'id'       => 'footer-link-color',
                'type'     => 'link_color',
                'title'    => esc_html__( 'Link Color', 'modave' ),
                'subtitle' => esc_html__( 'Footer link and hover color.', 'modave' ),
				'active'   => false,
                'default'  => array(
                    'regular' => '#4D4E4F',
                    'hover'   => '#E43131',
                )
            ),
			array(
                'id'       => 'footer-border',
                'type'     => 'border',
                'title'    => esc_html__( 'Border', 'modave' ),
                'subtitle' => esc_html__( 'Footer border color, style and width.', 'modave' ),
                'default'  => array(
                    'border-color'  => '#E9E9E9',
                    'border-style'  => 'solid',
                    'border-top'    => '1px',
                    'border-right'  => '1px',
                    'border-bottom' => '1px',
                    'border-left'   => '1px'
                )
            ),			
		)
	) );	
			
	/*
	* Footer Copyright
	*/
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'Footer Copyright', 'modave' ),
        'id'         		=> 'section-footer-copyright',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       		=> 'footer-copyright',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Copyright', 'modave' ),
				'subtitle'    	=> esc_html__( 'Show website copyright.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1
            ),
			array(
                'id'       		=> 'copyright-layout',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Copyright Layout', 'modave' ),
				'subtitle'    	=> esc_html__( 'Select copyright layout.', 'modave' ),
                'options'  		=> array(
                    'centered'		=> esc_html__( 'Centered', 'modave' ),
                    'columns' 		=> esc_html__( 'Columns', 'modave' ),
                ),
                'default'  		=> 'columns',
				'required'		=> array( 'footer-copyright', '=', 1 )
            ),
			array(
                'id'       => 'copyright-text',
                'type'     => 'textarea',
                'title'    => esc_html__( 'Copyright', 'modave' ),
				'subtitle' => esc_html__( 'Enter copyright text. Use {current_year} for get dynamic current year.', 'modave' ),
				'default'  => wp_kses( sprintf( __( '&copy; {current_year} <a href="%s" target="_blank">Modave</a>. All Rights Reserved.', 'modave' ), esc_url( 'https://presslayouts.com' ) ),
						array(
							'a' => array(
								'href'   => array(),
								'target' => array(),
							),
						) 
				),
				'required'		=> array( 'footer-copyright', '=', 1 )
            ),
			array(
                'id'       => 'show-payments-logo',
                'type'     => 'switch',
                'title'    => esc_html__( 'Payments Logo', 'modave' ),
				'subtitle' => esc_html__( 'Show payment logo.', 'modave' ),
                'default'  => 0,
                'on'       => esc_html__( 'Yes', 'modave' ),
                'off'      => esc_html__( 'No', 'modave' ),
				'required'		=> array( 'footer-copyright', '=', 1 )
            ),
			array(
                'id'       => 'payments-logo',
                'type'     => 'media',
                'url'      => false,
                'title'    => esc_html__( 'Payments Logo Image', 'modave' ),
                'subtitle' => esc_html__( 'Upload payments logo image.', 'modave' ),
				'required' => array( 'show-payments-logo', '=', 1 )
            ),
			array(
				'id'             	=> 'footer-copyright-padding',
				'type'           	=> 'spacing',
				'title'          	=> esc_html__( 'Padding', 'modave' ),
				'subtitle'       	=> esc_html__( 'Set top bottom padding for footer copyright section.', 'modave' ),
				'mode'           	=> 'padding',
				'units_extended' 	=> 'false',
				'units'          	=> array('rem', '%', 'px'),
				'left'        	 	=> false,
                'right'        	 	=> false,
				'output' 			=> array( '.pls-site-footer .pls-footer-copyright' ),
				'default'            => array(
					'padding-top'     	=> '1', 
					'padding-bottom'  	=> '1',
					'units'          	=> 'rem', 
				)
			),
			
			array(
                'id'    => 'copyright-notice1',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Copyright Colors', 'modave' ),
            ),
			array(
                'id'       => 'copyright-background',
                'type'     => 'background',
                'title'    => esc_html__( 'Background Color', 'modave' ),
				'subtitle' => esc_html__( 'Copyright background image or color', 'modave' ),
				'output'   => array( '.pls-site-footer .pls-footer-copyright' ),
                'default'  => array(
					'background-color' => '#FFFFFF',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> '',
					'background-attachment' => '',
					'background-position' 	=> '',
				),
            ),
            array(
                'id'       => 'copyright-text-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Text Color', 'modave' ),
				'subtitle' => esc_html__( 'Copyright text color', 'modave' ),
                'default'  => '#4D4E4F',
            ),
			array(
                'id'       => 'copyright-link-color',
                'type'     => 'link_color',
                'title'    => esc_html__( 'Link Color', 'modave' ),
                'subtitle' => esc_html__( 'Copyright link and hover color.', 'modave' ),
				'active'   => false,
                'default'  => array(
                    'regular' => '#4D4E4F',
                    'hover'   => '#181818',
                )
            ),
			array(
                'id'       => 'copyright-border',
                'type'     => 'border',
                'title'    => esc_html__( 'Copyright Border', 'modave' ),
                'subtitle' => esc_html__( 'Copyright border color, style and width.', 'modave' ),
                'default'  => array(
                    'border-color'  => '#E9E9E9',
                    'border-style'  => 'solid',
                    'border-top'    => '1px',
                    'border-right'  => '1px',
                    'border-bottom' => '1px',
                    'border-left'   => '1px'
                )
            ),
		)
	) );
	
	/*
	* Shop Options
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__('Shop','modave'),
        'id'         => 'section-shop',
		'icon'		 => 'el el-shopping-cart',
		'fields'     => array(
			array(
                'id'       		=> 'order-tracking-page',
                'type'     		=> 'select',
                'data'     		=> 'pages',
                'title'    		=> esc_html__( 'Order Tracking Page', 'modave' ),
                'subtitle' 		=> esc_html__( 'Set your order tracking page.', 'modave' ),
                'desc' 			=> esc_html__( 'Page contents: [woocommerce_order_tracking]', 'modave' ),
            ),
			array(
                'id'       => 'product-search-by-sku',
                'type'     => 'switch',
                'title'    => esc_html__( 'Search By Product SKU', 'modave' ),
				'subtitle' => esc_html__( 'Ajax search product by  sku.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'manage-password-strength',
                'type'     => 'switch',
                'title'    => esc_html__( 'Manage Password Strength', 'modave' ),
				'subtitle' => esc_html__( 'Reduce the strength requirement on the woocommerce user login/signup password', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'user-password-strength',
                'type'     => 'button_set',
                'title'    => esc_html__( 'User Password Strength', 'modave' ),
                'options'  => array(
                    '3' => esc_html__( 'Strong (default)', 'modave' ),
                    '2' => esc_html__( 'Medium', 'modave' ),
					'1' => esc_html__( 'Weak', 'modave' ),
					'0' => esc_html__( 'Very Weak', 'modave' ),
                ),
                'default'  => '3',
				'required' => array( 'manage-password-strength', '=', 1 )
            ),
			array(
                'id'       		=> 'product-image-ratio',
                'type'     		=> 'button_set',
                'title'   	 	=> esc_html__( 'Products Image Ratio', 'modave' ),
				'subtitle' 		=> esc_html__( 'Select product images ratio for display.', 'modave' ),
                'options'  		=> array(
                    'default' 	=> esc_html__( 'Default', 'modave' ),
                    'radio3x4'	=> esc_html__( ' 3 x 4', 'modave' ),
                ),
                'default'  		=> 'default',
            ),
			array(
                'id'       		=> 'single-line-product-title',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Single Line Title', 'modave' ),
				'subtitle' 	   	=> esc_html__( 'Show product/category/widget  title in single line.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'product-price-color',
                'type'     		=> 'color',
                'title'    		=> esc_html__( 'Product Price Color', 'modave' ),
                'subtitle'     	=> esc_html__( 'Select product price color.', 'modave' ),
                'default'  		=> '#181818',
            ),
			array(
                'id'       		=> 'product-sale-price-color',
                'type'     		=> 'color',
                'title'    		=> esc_html__( 'Product Sale Price Color', 'modave' ),
                'subtitle'     	=> esc_html__( 'Select product sale price color.', 'modave' ),
                'default'  		=> '#181818',
            ),
			array(
                'id'       		=> 'product-rating-color',
                'type'     		=> 'color',
                'title'    		=> esc_html__( 'Product Rating Color', 'modave' ),
                'subtitle'     	=> esc_html__( 'Select product rating color.', 'modave' ),
                'default'  		=> '#181818',
            ),
		),
	) );
	
	/*
	* Product labels		
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Product labels', 'modave' ),
        'id'         => 'section-product-labels',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       		=> 'product-labels',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Labels', 'modave' ),
                'subtitle' 		=> esc_html__( 'Show labels sale, featured, new and out of stock on product.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'product-new-label',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'New Product Label', 'modave' ),
                'subtitle' 		=> esc_html__( 'Show new product label on product.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
				'required' 		=> array( 'product-labels', '=', 1 )
            ),
			array(
                'id'       		=> 'new-product-label-text',
                'type'     		=> 'text',
                'desc'    		=> esc_html__( 'New product label text.', 'modave' ),
				'default'  		=> esc_html__( 'New', 'modave' ),
				'required' 		=> array( 'product-new-label', '=', 1 )
            ),
			array(
                'id'            => 'product-newness-days',
                'type'          => 'slider',
                'desc'          => esc_html__( 'Enter number of days to newness.', 'modave' ),
                'default'       => 30,
                'min'           => 1,
                'step'          => 1,
                'max'           => 90,
                'display_value' => 'text',
				'required' => array( 'product-new-label', '=', 1 )
            ),
			array(
                'id'       		=> 'new-product-label-color',
                'type'     		=> 'color',
                'subtitle'    	=> esc_html__( 'New product label color.', 'modave' ),
                'default'  		=> '#3DAB25',
				'required' 		=> array( 'product-new-label', '=', 1 )
            ),
			array(
                'id'       		=> 'sale-product-label',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Sale Product Label', 'modave' ),
                'subtitle' 		=> esc_html__( 'Show sale label on product.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
				'required' 		=> array( 'product-labels', '=', 1 )
            ),
			array(
                'id'       		=> 'sale-product-label-text-options',
                'type'     		=> 'button_set',
				'desc' 			=> esc_html__( 'sale product label in percentage or text.', 'modave' ),
                'options'  		=> array(
                    'percentage' 	=> esc_html__( 'Percentage', 'modave' ),
                    'text' 			=> esc_html__( 'Text', 'modave' ),
                ),
                'default'  		=> 'percentage',
				'required' 		=> array( 'sale-product-label', '=', 1 )
            ),
			array(
                'id'       		=> 'sale-product-label-percentage-text',
                'type'     		=> 'text',
                'subtitle'    	=> esc_html__( 'Sale product label text.', 'modave' ),
                'desc'    		=> esc_html__( 'Sale product label text(Ex. Off). Leave blank to hide text.', 'modave' ),
				//'default'  		=> esc_html__( 'Off', 'modave' ),
				'required' 		=> array( 'sale-product-label-text-options', '=', 'percentage' )
            ),
			array(
                'id'       		=> 'sale-product-label-text',
                'type'     		=> 'text',
                'subtitle'    	=> esc_html__( 'Sale product label text.', 'modave' ),
				'default'  		=> esc_html__( 'Sale', 'modave' ),
				'required' 		=> array( 'sale-product-label-text-options', '=', 'text' )
            ),
			array(
                'id'       		=> 'sale-product-label-color',
                'type'     		=> 'color',
                'desc'    		=> esc_html__( 'Sale product label color.', 'modave' ),
                'default'  		=> '#F03E3E',
				'required' 		=> array( 'sale-product-label', '=', 1 ),
            ),
			array(
                'id'       		=> 'product-price-discount-label',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Discount Label', 'modave' ),
                'subtitle' 		=> esc_html__( 'Show discount label after product price in single product page.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
				'required' 		=> array( 'sale-product-label', '=', 1 ),
            ),
			array(
                'id'       		=> 'product-sale-marquee',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Sale Marquee', 'modave' ),
                'subtitle' 		=> esc_html__( 'Show sale marquee text on product image.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
				'required' 		=> array( 'sale-product-label', '=', 1 ),
            ),
			array(
                'id'       		=> 'product-sale-marquee-text',
                'type'     		=> 'text',
				'desc' 			=> esc_html__( 'Product Marquee text. Here {per} is sale percentage.', 'modave' ),
              	'default'  		=> esc_html__( 'Hot Sale {per} off.', 'modave' ),		
				
				'required' 		=> array( 'product-sale-marquee', '=', 1 )
            ),
			array(
                'id'       		=> 'featured-product-label',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Featured Product Label', 'modave' ),
                'subtitle' 		=> esc_html__( 'Show featured label on product.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
				'required' 		=> array( 'product-labels', '=', 1 )
            ),
			array(
                'id'       		=> 'featured-product-label-text',
                'type'     		=> 'text',
                'desc'    		=> esc_html__( 'Featured product label text.', 'modave' ),
				'default'  		=> esc_html__( 'Hot', 'modave' ),
				'required' 		=> array( 'featured-product-label', '=', 1 )
            ),
			array(
                'id'       		=> 'featured-product-label-color',
                'type'     		=> 'color',
                'desc'     		=> esc_html__( 'Featured product label color.', 'modave' ),
                'default'  		=> '#F0A750',
				'required' 		=> array( 'featured-product-label', '=', 1 )
            ),
			array(
                'id'       		=> 'pre-order-product-label',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Pre Order Product Label', 'modave' ),
                'subtitle' 		=> esc_html__( 'Show pre-order label on product.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
				'required' 		=> array( 'product-labels', '=', 1 )
            ),
			array(
                'id'       		=> 'pre-order-product-label-text',
                'type'     		=> 'text',
                'desc'    		=> esc_html__( 'Pre-order product label text.', 'modave' ),
				'default'  		=> esc_html__( 'Pre Order', 'modave' ),
				'required' 		=> array( 'pre-order-product-label', '=', 1 )
            ),
			array(
                'id'       		=> 'pre-order-product-label-color',
                'type'     		=> 'color',
                'desc'     		=> esc_html__( 'Pre-order product label color.', 'modave' ),
                'default'  		=> '#F0A750',
				'required' 		=> array( 'pre-order-product-label', '=', 1 )
            ),
			array(
                'id'       		=> 'outofstock-product-label',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Out Of Stock Product Label', 'modave' ),
                'subtitle' 		=> esc_html__( 'Show out of stock label on product.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
				'required' 		=> array( 'product-labels', '=', 1 )
            ),
			array(
                'id'       		=> 'outofstock-product-label-text',
                'type'     		=> 'text',
                'desc'     		=> esc_html__( 'out of stock product label text.', 'modave' ),
				'default'  		=> esc_html__( 'Out Of Stock', 'modave' ),
				'required' 		=> array( 'outofstock-product-label', '=', 1 )
            ),
			array(
                'id'       		=> 'outofstock-product-label-color',
                'type'     		=> 'color',
                'desc'    		=> esc_html__( 'Out of stock product label color.', 'modave' ),
                'default'  		=> '#F4407D',
				'required' 		=> array( 'outofstock-product-label', '=', 1 )
            ),		
		),
	) );
		
	/*
	* Free Shipping Bar		
	*/
	Redux::setSection( $opt_name, array(
        'title'      	=> esc_html__( 'Free Shipping Bar', 'modave' ),
        'id'         	=> 'section-freeshipping',
		'subsection' 	=> true,
        'fields'     	=> array(
			array(
                'id'       		=> 'free-shipping-bar',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Free Shipping Bar', 'modave' ),
				'subtitle' 		=> esc_html__( 'You want to enable free shipping bar or not?', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
				'id'      		=> 'free-shipping-amount',
				'type'    		=> 'text',
				'title'   		=> esc_html__( 'Enter Required Amount', 'modave' ), 
				'subtitle'   	=> wp_kses( sprintf( __( 'You can set frees hipping method amount from Woocommerce => settings => shipping => shipping zones => manage shipping method.For more read <a href="%s" target="_blank"> WooCommerce documentation </a> guide.', 'modave' ), esc_url( 'https://docs.woocommerce.com/document/free-shipping/' ) ),
				array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),     
				'default' 		=> '200',								  
			),
			array(
				'id'      		=> 'free-shipping-msg',
				'type'    		=> 'textarea',
				'subtitle'    	=> esc_html__( 'Enter free shipping message text. Use {missing_amount} - The remaing amount for free shipping.', 'modave' ),
				'title'  		=> esc_html__( 'Free Shipping Message', 'modave' ),               
				'default' 		=> 'Buy {missing_amount} more get <span>Free Shipping</span>',
			),
			array(
				'id'      		=> 'free-shipping-complete-msg',
				'type'    		=> 'textarea',
				'title'   		=> esc_html__( 'Free Shipping Success Message', 'modave' ), 
				'subtitle'    	=> esc_html__( 'Message show after reaching progress bar 100%.', 'modave' ),
				'default' 		=> esc_html__( 'Congratulations! You\'ve got free shipping!', 'modave' ),	  
			),
		),
	) );
	
	/*
	* Sale Notification	
	*/
	Redux::setSection( $opt_name, array(
        'title'      	=> esc_html__( 'Sale Notification', 'modave' ),
        'id'         	=> 'section-sale-notification',
		'subsection' 	=> true,
        'fields'     	=> array(
			array(
                'id'       		=> 'sale-notification',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Enable Sale Notification', 'modave' ),
				'subtitle' 		=> esc_html__( 'Enable sale notification popup?', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'sale-notification-product-type',
                'type'     		=> 'select',
				'title'    		=> esc_html__( 'Products List', 'modave' ),
				'desc' 			=> esc_html__( 'sale product label in percentage or text.', 'modave' ),
                'options'  		=> array(
                    'recent_products'		=> esc_html__( 'Recent Products', 'modave' ),
					'featured_products'		=> esc_html__( 'Featured Products', 'modave' ),
					'sale_products'			=> esc_html__( 'On Sale Products', 'modave' ),
					'best_seller_products'	=> esc_html__( 'Best Seller Products', 'modave' ),
					'top_rated_products'	=> esc_html__( 'Top Rated Products', 'modave' ),
					'custom_products'		=> esc_html__( 'List of Products', 'modave' ),
					'recent_orders'			=> esc_html__( 'Recent Order', 'modave' ),
                ),
                'default'  		=> 'recent_products',
				'required' 		=> array( 'sale-notification', '=', 1 )
            ),
			array(
                'id'       		=> 'sale-notification-order-time-value',
                'type'     		=> 'text',
				'title'    		=> esc_html__( 'How much Older Order Show', 'modave' ),
				'default'  		=> 1,
				'required' 		=> array( 'sale-notification-product-type', '=', 'recent_orders' )
            ),
			array(
                'id'       		=> 'sale-notification-order-time-unit',
                'type'     		=> 'select',                
				'options'  		=> array(
					'hour'		=> esc_html__( 'Hours', 'modave' ),
					'day'		=> esc_html__( 'Day', 'modave' ),
					'week'		=> esc_html__( 'Week', 'modave' )
                ),
				'default'  		=> 'week',
				'required' 		=> array( 'sale-notification-product-type', '=', 'recent_orders' )
            ),
			array(
                'id'			=> 'sale-notification-custom-products',
                'type'			=> 'select',
				'multi'			=> true,
				'title'			=> esc_html__( 'Select Specific Products', 'modave' ), 
				'data'			=> 'posts',
				'args'			=> array(
								'post_type'      => 'product',
								'posts_per_page' => -1,
								'orderby'        => 'title',
								'order'          => 'ASC',
				),
				'required' 		=> array( 'sale-notification-product-type', '=', 'custom_products' )
            ),
			array(
                'id'       		=> 'sale-notification-name',
                'type'     		=> 'textarea',
                'title'    		=> esc_html__( 'Virtual Name', 'modave' ),
				'subtitle' 		=> esc_html__( 'Please enter each name on a separate line.', 'modave' ),
				'default'  		=> "James Brown\r\nDavid Anderson\r\nEmily Davis\r\nPeter Jackson\r\nMary Green",
				'required' 		=> array( 'sale-notification', '=', 1 ),
            ),
			array(
                'id'       		=> 'sale-notification-purchase-time',
                'type'     		=> 'select',
                'title'    		=> esc_html__( 'Time Passed', 'modave' ),
				'subtitle' 		=> esc_html__( 'Show random time.', 'modave' ),
				'options'  		=> array(
                    'second'	=> esc_html__( 'Seconds', 'modave' ),
					'hours'		=> esc_html__( 'Hours', 'modave' ),
					'days'		=> esc_html__( 'Days', 'modave' )
                ),
				'default'  		=> 'hours',
				'required' 		=> array( 'sale-notification', '=', 1 ),
            ),
			array(
                'id'            => 'sale-notification-start',
                'type'          => 'slider',
                'title'         => esc_html__( 'Popup Start Time', 'modave' ),
				'subtitle'      => esc_html__( 'When to start showing popup in second', 'modave' ),
                'default'       => 10,
                'min'           => 1,
                'step'          => 1,
                'max'           => 120,
				'required' 		=> array( 'sale-notification', '=', 1 ),
            ),
			array(
                'id'            => 'sale-notification-stay-time',
                'type'          => 'slider',
                'title'         => esc_html__( 'Popup Stay Time', 'modave' ),
				'subtitle'		=> esc_html__( 'How long keep notification in second.', 'modave' ),
                'default'       => 7,
                'min'           => 1,
                'step'          => 1,
                'max'           => 60,
				'required' 		=> array( 'sale-notification', '=', 1 ),
            ),
			array(
                'id'            => 'sale-notification-show-again',
                'type'          => 'slider',
                'title'         => esc_html__( 'Popup Time Interval', 'modave' ),
				'subtitle'		=> esc_html__( 'Time between notification in second', 'modave' ),
                'default'       => 15,
                'min'           => 1,
                'step'          => 1,
                'max'           => 120,
				'required' 		=> array( 'sale-notification', '=', 1 ),
            ),
			array(
                'id'       		=> 'sale-notification-loop',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Loop', 'modave' ),
				'subtitle' 		=> esc_html__( 'Repeat popup once all loaded popups are shown once.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
				'required' 		=> array( 'sale-notification', '=', 1 ),
            ),
			array(
                'id'       		=> 'sale-notification-close-btn',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Close Button', 'modave' ),
				'subtitle' 		=> esc_html__( 'Show close button.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
				'required' 		=> array( 'sale-notification', '=', 1 ),
            ),
			array(
                'id'       		=> 'sale-notification-dismiss',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Sale Popup Dismissing', 'modave' ),
				'subtitle' 		=> esc_html__( 'Show promobar dismissing close button.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
				'required' 		=> array( 'sale-notification-close-btn', '=', 1 ),
            ),
		),
	) );
	
	/*
	* MiniCart Feature
	*/
	Redux::setSection( $opt_name, array(
        'title'      	=> esc_html__( 'MiniCart', 'modave' ),
        'id'         	=> 'section-minicart',
		'subsection' 	=> true,
        'fields'     	=> array(			
			array(
                'id'       => 'mini-cart-quantity',
                'type'     => 'switch',
                'title'    => esc_html__( 'Quantity Field in Mini Cart', 'modave' ),
				'subtitle'     => esc_html__( 'Show quantity field in mini cart. ', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
            ),
			array(
                'id'		=> 'mini-cross-sells',
                'type'		=> 'switch',
                'title'		=> esc_html__( 'Cross Sells Products', 'modave' ),
				'subtitle'	=> esc_html__( 'Show cross sells products in mini cart. ', 'modave' ),
                'on'		=> esc_html__( 'Yes', 'modave' ),
				'off'		=> esc_html__( 'No', 'modave' ),
				'default'	=> 0,
            ),
			array(
                'id'       => 'mini-cart-note',
                'type'     => 'switch',
                'title'    => esc_html__( 'Mini Cart Note', 'modave' ),
				'subtitle'     => esc_html__( 'Show note option in minicart. ', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'mini-cart-shipping',
                'type'     => 'switch',
                'title'    => esc_html__( 'Mini Cart Shipping', 'modave' ),
				'subtitle'     => esc_html__( 'Enable shipping. ', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'mini-cart-coupon',
                'type'     => 'switch',
                'title'    => esc_html__( 'Mini Cart Coupon', 'modave' ),
				'subtitle'     => esc_html__( 'Enable coupon. ', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 0,
            ),
		),
	) );
	
	/*
	* Login to See Price
	*/
	Redux::setSection( $opt_name, array(
        'title'      	=> esc_html__( 'Login To See Price', 'modave' ),
        'id'         	=> 'section-login-to-see-price',
		'subsection' 	=> true,
        'fields'     	=> array(
			array(
                'id'       		=> 'login-to-see-price',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Login To See Price', 'modave' ),
				'subtitle' 		=> esc_html__( 'Only logged in users can see the pricing.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
                'default'  		=> 0,
            ),
		),
	) );		
	
	/*
	* Cart Page
	*/
	Redux::setSection( $opt_name, array(
        'title'      	=> esc_html__( 'Cart', 'modave' ),
        'id'         	=> 'section-cart-page',
		'subsection' 	=> true,
        'fields'     	=> array(
			array(
                'id'       		=> 'cart-auto-update',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Auto Update Cart ', 'modave' ),
				'subtitle'    	=> esc_html__( 'Auto update cart when change product quantity.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
                'off'      		=> esc_html__( 'No', 'modave' ),
                'default'  		=> 1,
            ),
		)
	) );
	
	/*
	* Checkout Page
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Checkout', 'modave' ),
        'id'         => 'section-checkout-page',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       		=> 'checkout-product-image',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Image', 'modave' ),
				'subtitle'    	=> esc_html__( 'Show product image on checkout page.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
                'off'      		=> esc_html__( 'No', 'modave' ),
                'default'  		=> 1,
            ),
			array(
                'id'       		=> 'checkout-product-quantity',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Quantity Field', 'modave' ),
				'subtitle'    	=> esc_html__( 'Show product quantity field on checkout page.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
                'off'      		=> esc_html__( 'No', 'modave' ),
                'default'  		=> 0,
            ),
		)
	) );
	
	/*
	* Shop Archive Options
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Archive(Shop) Pages', 'modave' ),
        'id'         => 'section-shop-page',
		'icon'		 => 'el el-shopping-cart',
        'fields'     => array(			
			array(
                'id'       		=> 'shop-page-layout',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Page Layout', 'modave' ),
                'subtitle' 		=> esc_html__( 'Select shop/archive page layout with sidebar postion.', 'modave' ),
                'options'  			=> array(
                    'full-width' 	=> array(
                        'title' 	=> esc_html__( 'Full Width', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/sidebar-none.png',
                    ),                   
                    'left-sidebar' 	=> array(
                        'title' 	=> esc_html__( 'Left Sidebar', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/sidebar-left.png',
                    ), 
					'right-sidebar' => array(
                        'title' 	=> esc_html__( 'Right Sidebar', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/sidebar-right.png',
                    ), 
                ),
                'default'  		=> 'left-sidebar'
            ),
			array(
                'id'       		=> 'shop-page-sidebar',
                'type'     		=> 'select',
                'title'    		=> esc_html__( 'Sidebar', 'modave' ),
				'subtitle' 		=> esc_html__( 'Select sidebar for shop page.', 'modave' ),
                'data'     		=> 'sidebars',
                'default'  		=> 'shop-page-sidebar',
                'required' 		=> array( 'shop-page-layout', '=', array( 'left-sidebar', 'right-sidebar' ) )
            ),
			array(
                'id'       		=> 'shop-page-off-canvas-sidebar',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Off Canvas Sidebar', 'modave' ),
				'subtitle'    	=> esc_html__( 'Display off canvas sidebar.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
                'off'      		=> esc_html__( 'No', 'modave' ),
                'default'  		=> 0,
                'required' 		=> array( 'shop-page-layout', '=', array( 'left-sidebar', 'right-sidebar' ) ),
            ),
			array(
                'id'       		=> 'shop-page-wide-layout',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Wide Layout', 'modave' ),
				'subtitle'    	=> esc_html__( 'Display shop page in wide(full) layout.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
                'off'      		=> esc_html__( 'No', 'modave' ),
                'default'  		=> 0,
            ),
			array(
                'id'       		=> 'off-canvas-button-text',
                'type'     		=> 'text',
                'title'    		=> esc_html__( 'Off Canvas Button Text', 'modave' ),
				'subtitle'    	=> esc_html__( 'Enter off canvas button text.', 'modave' ),
                'default'  		=> esc_html__( 'Filters', 'modave' ),
                'required' 		=> array( 'shop-page-off-canvas-sidebar', '=', 1 )
            ),
			array(
				'id'      		=> 'shop-page-top-content',
				'type'    		=> 'select',
				'title'   		=> esc_html__( 'Page Top Custom Content', 'modave' ),
				'subtitle'		=> esc_html__( 'Select block that display on shop page top area. You can create new block from Blocks => Add New', 'modave' ),
				'options'    	=> $custom_blocks,
				'default' 		=> ' ',
			),
			array(
				'id'      		=> 'shop-page-bottom-content',
				'type'    		=> 'select',
				'title'   		=> esc_html__( 'Page Bottom Custom Content', 'modave' ),
				'subtitle'		=> esc_html__( 'Select block that display on shop page bottom area. You can create new block from Blocks => Add New', 'modave' ),
				'options'    	=> $custom_blocks,
				'default' 		=> ' ',
			),
			array(
                'id'       		=> 'shop-page-categories',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Shop Loop Categories', 'modave' ),
				'subtitle' 		=> esc_html__( 'Display Categories in the Shop Page.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'shop-page-categories-style',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Categories Style', 'modave' ),
				'subtitle' 		=> esc_html__( 'Select categories style.', 'modave' ),
                'options'  		=> array(
					'circle' 		=> esc_html__( 'Circle', 'modave' ),
                    'rounded' 		=> esc_html__( 'Rounded', 'modave' ),
				),
				'default'  => 'circle',
                'required' 		=> array( 'shop-page-categories', '=', 1 )
            ),
			array(
                'id'            => 'shop-page-categories-columns',
                'type'          => 'slider',
                'title'         => esc_html__( 'Categories Columns', 'modave' ),
                'subtitle'      => esc_html__( 'Display number of categories columns.', 'modave' ),
                'min'           => 4,
                'step'          => 1,
                'max'           => 10,
                'display_value' => 'text',
                'default'       => 6,
                'required' 		=> array( 'shop-page-categories', '=', 1 )
            ),
			array(
                'id'       		=> 'shop-page-current-child-cat',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Current Child Categories', 'modave' ),
				'subtitle' 		=> esc_html__( 'Enable this option for show child categories of current category', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
                'required' 		=> array( 'shop-page-categories', '=', 1 )
            ),
			array(
				'id'       			=> 'shop-page-selected-categories',
				'type'     			=> 'select',
				'multi'    			=> true,
				'data' 	   			=> 'terms',
				'args' 				=> array( 'taxonomies'=>'product_cat' ),
				'title'    			=> esc_html__('Select Categories', 'modave' ),
				'subtitle'     		=> esc_html__( 'Select specific categories.', 'modave' ),
				'placeholder' 		=> esc_attr__('Choose product categories', 'modave' ),
				'required' 		=> array( 'shop-page-categories', '=', 1 )
			),
			array(
				'id'       			=> 'shop-page-exculde-categories',
				'type'     			=> 'select',
				'multi'    			=> true,
				'data' 	   			=> 'terms',
				'args' 				=> array( 'taxonomies'=>'product_cat' ),
				'title'    			=> esc_html__('Exculde Categories', 'modave' ),
				'placeholder' 		=> esc_attr__('Choose product categories', 'modave' ),
				'required' 		=> array( 'shop-page-categories', '=', 1 )
			),			
			array(
                'id'       		=> 'shop-page-hide-empty-category',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Hide Empty Categories', 'modave' ),
				'subtitle' 		=> esc_html__( 'Enable this option for hide empty categories', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
                'required' 		=> array( 'shop-page-categories', '=', 1 )
            ),
			array(
                'id'            => 'shop-page-categories-limit',
                'type'          => 'slider',
                'title'         => esc_html__( 'Category Limit', 'modave' ),
                'subtitle'      => esc_html__( 'Show Number of category.', 'modave' ),
                'min'           => 4,
                'step'          => 1,
                'max'           => 24,
                'display_value' => 'text',
                'default'       => 12,
                'required' 		=> array( 'shop-page-categories', '=', 1 )
            ),
			array(
                'id'       		=> 'products-header',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Products Header', 'modave' ),
				'subtitle'    	=> esc_html__( 'Show products header.', 'modave' ),
                'default'  		=> 1,
                'on'       		=> esc_html__( 'Yes', 'modave' ),
                'off'      		=> esc_html__( 'No', 'modave' ),
            ),
			array(
                'id'       		=> 'shop-top-filter',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Header Filter', 'modave' ),
				'subtitle'    	=> esc_html__( 'Show shop page filters on products header.', 'modave' ),
                'default'  		=> 0,
                'on'       		=> esc_html__( 'Yes', 'modave' ),
                'off'      		=> esc_html__( 'No', 'modave' ),
            ),
			array(
                'id'       		=> 'products-view-icon',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Product View Mode Icon', 'modave' ),
				'subtitle' 		=> esc_html__( 'Show Product view mode icon on product header', 'modave' ),
				'multi'    		=> true,
                'options'  		=> array(
					'grid-list' 		=> esc_html__( 'List View', 'modave' ),
                    'grid-two-col' 		=> esc_html__( 'Two Columns', 'modave' ),	
					'grid-three-col' 	=> esc_html__( 'Three Columns', 'modave' ),
					'grid-four-col' 	=> esc_html__( 'Four Columns', 'modave' ),
					'grid-five-col' 	=> esc_html__( 'Five Columns', 'modave' ),
					'grid-six-col' 		=> esc_html__( 'Six Columns', 'modave' ),
					'grid-seven-col' 	=> esc_html__( 'Seven Columns', 'modave' ),
				),
				'default'  => array( 'grid-list', 'grid-two-col', 'grid-three-col', 'grid-four-col' ),
            ),
			array(
                'id'       		=> 'product-onsale',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product On Sale', 'modave' ),
				'subtitle'    	=> esc_html__( 'Show/hide products on sale filter option.', 'modave' ),
                'default'  		=> 0,
                'on'       		=> esc_html__( 'Yes', 'modave' ),
                'off'      		=> esc_html__( 'No', 'modave' ),
            ),
			array(
                'id'            => 'products-per-page',
                'type'          => 'slider',
                'title'         => esc_html__( 'Products Per Page', 'modave' ),
                'subtitle'      => esc_html__( 'Show number of products per page.', 'modave' ),
                'min'           => 6,
                'step'          => 1,
                'max'           => 120,
                'display_value' => 'text',
                'default'       => 12,
            ),
			array(
                'id'       		=> 'products-per-page-dropdown',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Products Per Page Dropdown', 'modave' ),
				'subtitle' 		=> esc_html__( 'Show products per page dropdown on products header', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'products-per-page-number',
                'type'     		=> 'text',
                'title'    		=> esc_html__( 'Products Per Page Variations', 'modave' ),
				'subtitle'     	=> esc_html__( 'Add product variations by comma. Ex. 9,12,24,36,48', 'modave' ),
                'default'  		=> '6,9,12,24,36,48',
				'required' 		=> array( 'products-per-page-dropdown', '=', 1 )
            ),			
			array(
                'id'       		=> 'products-sorting',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Products Sorting', 'modave' ),
				'subtitle' 	   	=> esc_html__( 'Show products sorting on shop page and archive pages.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),	
			array(
                'id'       		=> 'ajax-filter',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Ajax Filter', 'modave' ),
				'subtitle' 	   	=> esc_html__( 'Enable ajax filter on shop and product archive pages.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'products-columns',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Products Per Row', 'modave' ),
				'subtitle'      => esc_html__( 'How many products should be shown per row in large device?', 'modave' ),
                'options'  		=> array(
                    2		=> esc_html__( '2', 'modave' ),
                    3	 	=> esc_html__( '3', 'modave' ),
					4	 	=> esc_html__( '4', 'modave' ),
					5	 	=> esc_html__( '5', 'modave' ),
					6	 	=> esc_html__( '6', 'modave' ),
					7	 	=> esc_html__( '7', 'modave' ),
                ),
                'default'  		=> 3,
            ),
			array(
                'id'       		=> 'products-columns-small-device',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Products Per Row Small Device', 'modave' ),
				'subtitle'      => esc_html__( 'How many products should be shown per row in small device?', 'modave' ),
                'options'  		=> array(
                    1		=> esc_html__( '1', 'modave' ),
                    2		=> esc_html__( '2', 'modave' ),
                    3	 	=> esc_html__( '3', 'modave' ),
					4	 	=> esc_html__( '4', 'modave' ),
					5	 	=> esc_html__( '5', 'modave' ),
                ),
                'default'  		=> 3,
            ),
			array(
                'id'       		=> 'products-columns-tablet',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Products Per Row Tablet', 'modave' ),
				'subtitle'      => esc_html__( 'How many products should be shown per row in tablet?', 'modave' ),
                'options'  		=> array(
                    1		=> esc_html__( '1', 'modave' ),
                    2		=> esc_html__( '2', 'modave' ),
                    3	 	=> esc_html__( '3', 'modave' ),
					4	 	=> esc_html__( '4', 'modave' ),
                ),
                'default'  		=> 3,
            ),
			array(
                'id'       		=> 'products-columns-mobile',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Products Per Row Mobile', 'modave' ),
				'subtitle'      => esc_html__( 'How many products should be shown per row in mobile?', 'modave' ),
                'options'  		=> array(
                    1		=> esc_html__( '1', 'modave' ),
                    2		=> esc_html__( '2', 'modave' ),
                ),
                'default'  		=> 2,
            ),
			array(
                'id'       		=> 'products-pagination-style',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Products Pagination', 'modave' ),
				'subtitle' 		=> esc_html__( 'Select product pagination type.', 'modave' ),
                'options'  		=> array(
					'default'				=> esc_html__( 'Default', 'modave' ),
					'infinity-scroll'		=> esc_html__( 'Infinity Scroll', 'modave' ),
					'load-more-button'		=> esc_html__( 'Load More', 'modave' ),
				),
                'default'  		=> 'default',
            ),
			array(
                'id'       		=> 'products-pagination-load-more-button-text',
                'type'     		=> 'text',
                'title'    		=> esc_html__( 'Load More Button Text', 'modave' ),
				'subtitle' 		=> esc_html__( 'Enter load more button text.', 'modave' ),
                'default'  		=> 'Load More',
				'required' 		=> array( 'products-pagination-style', '=', array( 'infinity-scroll', 'load-more-button' ) ),
            ),
			array(
                'id'       		=> 'products-pagination-finished-message',
                'type'     		=> 'text',
                'title'    		=> esc_html__( 'Finished Message', 'modave' ),
				'subtitle' 		=> esc_html__( 'Text to display when no additional products are available.', 'modave' ),
                'default'  		=> 'No More Products Available',
				'required' 		=> array( 'products-pagination-style', '=', array( 'infinity-scroll', 'load-more-button' ) ),
            ),
		)
	) );
	
	/*
	* Shop Archive Page Title
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Page Title', 'modave' ),
        'id'         => 'shop-page-title-section',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       		=> 'shop-page-title-layout',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Page Title Layout', 'modave' ),
				'subtitle'    	=> esc_html__( 'Select shop page title layout.', 'modave' ),
                'options'  		=> array(
					'center' => array(
                        'title' 	=> esc_html__( 'Centered', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/page-title-centered.png',
                    ),
                    'left' => array(
                        'title' 	=> esc_html__( 'Left', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/page-title-default.png',
                    ),
					'disable' => array(
                        'title' 	=> esc_html__( 'Disable', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/page-title-none.png',
                    )
                ),
                'default'  		=> 'center',
            ),
			array(
                'id'       		=> 'shop-page-heading',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Page Title', 'modave' ),
				'subtitle'    	=> esc_html__( 'Show page title.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
                'off'      		=> esc_html__( 'No', 'modave' ),
                'default'  		=> 1,
            ),
			array(
                'id'       		=> 'shop-page-breadcrumb',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Breadcrumbs', 'modave' ),
                'subtitle'    	=> esc_html__( 'Show breadcrumbs.', 'modave' ),
                'on'      		=> esc_html__( 'Yes', 'modave' ),
                'off'      		=> esc_html__( 'No', 'modave' ),
                'default'  		=> 1,
            ),
			
			array(
                'id'    	=> 'shop-page-title-notice',
                'type'   	=> 'info',
                'notice' 	=> false,
                'title' 	=> esc_html__( 'Page Title Colors', 'modave' ),
            ),
			array(
                'id'       			=> 'shop-page-title-background',
                'type'     			=> 'background',
                'title'    			=>  esc_html__( 'Background Color', 'modave' ),
				'subtitle' 			=> esc_html__( 'Page title background image or color', 'modave' ),
				'output' 			=> array( '.pls-catalog-page .pls-page-title' ),
                'default' 			=> array(
					'background-color' 		=> '#f9f3f1',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> 'cover',
					'background-attachment' => '',
					'background-position' 	=> 'center center'
				),
            ),
			array(
                'id'       			=> 'shop-page-title-color',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Title Color', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Page title color.', 'modave' ),
                'options'  			=> array(
                    'default' 	=> esc_html__( 'Default', 'modave' ),
                    'light' 	=> esc_html__( 'Light', 'modave' ),
                    'dark' 		=> esc_html__( 'Dark', 'modave' ),
                ),
                'default'  			=> 'dark',
            ),
			array(
                'id'       			=> 'shop-page-title-size',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Title Size', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Page title size.', 'modave' ),
                'options'  			=> array(
                    'default' 		=> esc_html__( 'Default', 'modave' ),
                    'small' 		=> esc_html__( 'Small', 'modave' ),
                    'large' 		=> esc_html__( 'Large', 'modave' ),
                ),
                'default'  			=> 'default',
            ),
			array(
				'id'             	=> 'shop-page-title-padding',
				'type'           	=> 'spacing',
				'title'          	=> esc_html__( 'Padding', 'modave' ),
				'subtitle'       	=> esc_html__( 'Set top bottom padding for page title.', 'modave' ),
				'mode'           	=> 'padding',
				'units_extended' 	=> 'false',
				'left'        	 	=> false,
                'right'        	 	=> false,
				'output' 			=> array( '.pls-catalog-page .pls-page-title' ),
				'default'            => array(
					'padding-top'     	=> '82', 
					'padding-bottom'  	=> '82',
					'units'          	=> 'px', 
				)
			),
		)
	) );
			
	/*
	* Product Styles
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Product Styles', 'modave' ),
        'id'         => 'product-styles',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       		=> 'product-style',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Product Style', 'modave' ),
                'subtitle'  	=> esc_html__( 'Choose product style.', 'modave' ),
				'full_width' 	=> true,
                'options'  		=> array(
                    'product-style-1' 	=> array(
                        'title' 	=> esc_html__( 'Product Style 1', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'product-style-1.png',
                    ),
					'product-style-2' 	=> array(
                        'title' 	=> esc_html__( 'Product Style 2', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'product-style-2.png',
                    ),
					'product-style-3' 	=> array(
                        'title' 	=> esc_html__( 'Product Style 3', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'product-style-3.png',
                    ),
					'product-style-4' 	=> array(
                        'title' 	=> esc_html__( 'Product Style 4', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'product-style-4.png',
                    ),
					'product-style-5' 	=> array(
                        'title' 	=> esc_html__( 'Product Style 5', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'product-style-5.png',
                    ),
					'product-style-6' 	=> array(
                        'title' 	=> esc_html__( 'Product Style 6', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'product-style-6.png',
                    ),
                ),
                'default'  	=> 'product-style-1',
            ),
			array(
                'id'       		=> 'product-hover-image',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Hover Image', 'modave' ),
				'subtitle'      => esc_html__( 'Show product hover image on products.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),		
			array(
                'id'       		=> 'product-countdown',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Countdown', 'modave' ),
				'subtitle' 		=> esc_html__( 'Show product countdown.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'product-category',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Category', 'modave' ),
				'subtitle' 		=> esc_html__( 'Show product category.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'product-title',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Title', 'modave' ),
				'subtitle' 		=> esc_html__( 'Show product title.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'product-rating',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Rating', 'modave' ),
				'subtitle' 		=> esc_html__( 'Show product rating.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'product-rating-count',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Rating Count', 'modave' ),
				'subtitle' 		=> esc_html__( 'Show product rating count.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
				'required' 		=> array( 'product-rating', '=', 1 )
            ),
			array(
                'id'       		=> 'product-price',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Price', 'modave' ),
				'subtitle' 		=> esc_html__( 'Show product price.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'product-quick-shop',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Quick Shop', 'modave' ),
				'subtitle' 		=> esc_html__( 'Show quick shop popup for variable product. Note :- It\'s work for product style 1,2 and 5', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'product-variation-size',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Variation Size', 'modave' ),
				'subtitle' 		=> esc_html__( 'Show product size variations on the image when hovering over the product.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'product-loop-variation',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Variation', 'modave' ),
				'subtitle' 		=> esc_html__( 'Show product variation(attribute). Like Color, Size, ...', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
				'id'      		=> 'product-variation',
				'type'    		=> 'select',
				'title'   		=> esc_html__( 'Select Variation', 'modave' ),
				'subtitle'		=> esc_html__( 'Select any one variation that you want to show in product loop. If empty then doesn\'t show any variation.', 'modave' ),
				'options'    	=> $product_attributes,
				'default' 		=> '',
				'required' 		=> array( 'product-loop-variation', '=', 1 )
			),
			array(
                'id'       		=> 'product-limit-swatch',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Limit Swatch', 'modave' ),
				'subtitle' 		=> esc_html__( 'Enable show variation limit.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
				'required' 		=> array( 'product-loop-variation', '=', 1 )
            ),
			array(
                'id'       		=> 'product-number-of-swatch',
                'type'     		=> 'slider',
                'title'    		=> esc_html__( 'Number of Swatch', 'modave' ),
				'subtitle' 		=> esc_html__( 'Number of varation to display.', 'modave' ),
                'min'           => 1,
                'step'          => 1,
                'max'           => 8,
				'default'  		=> 4,
				'required' 		=> array( 'product-limit-swatch', '=', 1 )
            ),
			array(
                'id'       		=> 'product-short-description',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Short Description', 'modave' ),
				'subtitle' 		=> esc_html__( 'Show product short description in list view.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'product-tooltip',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Tooltip', 'modave' ),
				'subtitle'  	=> esc_html__( 'Show product tooltip on hover icons in shop page.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
		)
	) );
		
	/*
	* Product Catalog Mode
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Catalog Mode', 'modave' ),
        'id'         => 'product-catalog-mode',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       		=> 'catalog-mode',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Catalog Mode', 'modave' ),
                'subtitle'  	=> esc_html__( 'Enable catalog mode.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'open-product-page-new-tab',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Open Product In New Tab', 'modave' ),
				'subtitle'      => esc_html__( 'Open product page in new tab.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'product-buttons',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Buttons', 'modave' ),
                'subtitle'      => esc_html__( 'Show product buttons cart, wishlist, compare and quick view in shop page.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'product-cart-button',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Cart Button', 'modave' ),
                'subtitle'  	=> esc_html__( 'Show cart button on shop page.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
				'required' 		=> array( 'product-buttons', '=', 1 )
            ),
			array(
                'id'       		=> 'product-wishlist-button',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Wishlist Button', 'modave' ),
                'subtitle'  	=> esc_html__( 'Show wishlist button on shop page.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
				'required' 		=> array( 'product-buttons', '=', 1 )
            ),
			array(
                'id'       		=> 'product-compare-button',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Compare Button', 'modave' ),
                'subtitle'  	=> esc_html__( 'Show compare button on shop page.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
				'required'		=> array( 'product-buttons', '=', 1 )
            ),
			array(
                'id'       		=> 'product-quickview-button',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Quick View Button', 'modave' ),
                'subtitle'  	=> esc_html__( 'Show quick view button on shop page.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
				'required' 		=> array( 'product-buttons', '=', 1 )
            ),
			array(
                'id'       		=> 'single-product-quick-buy',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Quick Buy Button', 'modave' ),
                'subtitle'  	=> esc_html__( 'Show quick buy button on product page.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'type'      	=> 'text',
                'id'        	=> 'product-quickbuy-button-text',
                'title'     	=> esc_html__( 'Quick Buy Button Text', 'modave' ),
                'subtitle'  	=> esc_html__( 'Enter quick buy button text.', 'modave' ),
                'default'     	=> 'Buy It Now',
                'required'  	=> array( 'single-product-quick-buy', '=', 1 ),
            ),
		)
	) );

	/*
	* Single Product Page
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Single Product', 'modave' ),
        'id'         => 'pls-single-product',
		'icon'		 => 'el el-shopping-cart',
        'fields'     => array(
			array(
                'id'       		=> 'product-page-layout',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Page Layout', 'modave' ),
                'subtitle' 		=> esc_html__( 'Select product page layout with sidebar postion.', 'modave' ),
				'options'  		=> array(
                    'full-width' 	=> array(
                        'title' 	=> esc_html__( 'Full Width', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/sidebar-none.png',
                    ),                   
                    'left-sidebar' 	=> array(
                        'title' 	=> esc_html__( 'Left Sidebar', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/sidebar-left.png',
                    ), 
					'right-sidebar' => array(
                        'title' 	=> esc_html__( 'Right Sidebar', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/sidebar-right.png',
                    ), 
                ),
                'default'  		=> 'full-width'				
            ),
			array(
                'id'       		=> 'product-page-sidebar',
                'type'     		=> 'select',
                'title'    		=> esc_html__( 'Sidebar', 'modave' ),
				'subtitle' 		=> esc_html__( 'Select sidebar for product page.', 'modave' ),
                'data'     		=> 'sidebars',
                'default'  		=> 'single-product-sidebar',
                'required' 		=> array( 'product-page-layout', '=', array( 'left-sidebar', 'right-sidebar' ) )
            ),
			array(
				'id'       		=> 'product-content-fullwidth',
				'type'     		=> 'switch',
				'title'    		=> esc_html__( 'Product Content Full Width', 'modave' ),
				'subtitle' 		=> esc_html__( 'You want to display product content area in full width?', 'modave' ),
				'desc' 			=> esc_html__( 'Note: This option only works when the page layout is full width (no sidebar).', 'modave' ),
				'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
			),
			array(
                'id'       		=> 'product-content-background',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Content Background Color', 'modave' ),
				'subtitle' 		=> esc_html__( 'You want to display content background color?', 'modave' ),
				'desc' 			=> esc_html__( 'Note: This option only works when the page layout is full width (no sidebar).', 'modave' ),
				'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
				'id'       		=> 'product-content-background-color',
                'type'     		=> 'color',
				'title'    		=> esc_html__( 'Background Color', 'modave' ),
				'subtitle' 		=> esc_html__( 'Set product content background color.', 'modave' ),
                'default'  		=> '#FAF7F1',
				'required'  	=> array( 'product-content-background', '=', 1 ),
            ),
			array(
                'id'       		=> 'sticky-product-image',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Sticky Product Image', 'modave' ),
				'subtitle' 		=> esc_html__( 'When you scroll the product page at this time you want to stick product image part or not.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
                'default'  		=> 0,
            ),
			array(
                'id'       		=> 'sticky-product-summary',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Sticky Product Summary', 'modave' ),
				'subtitle' 		=> esc_html__( 'When you scroll the product page at this time you want to stick product summary part or not.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
                'default'  		=> 0,
            ),
			array(
                'id'       		=> 'sticky-add-to-cart-button',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Sticky Add to Cart Button', 'modave' ),
				'subtitle' 		=> esc_html__( 'Sticky add to cart button on bottom when scroll the page.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
                'default'  		=> 0,
            ),
		)
	));
		
	/*
	* Product Images/Gallery
	*/
	Redux::setSection( $opt_name, array(
		'title'      => esc_html__( 'Images/Gallery', 'modave' ),
		'id'         => 'product-images-gallery',
		'subsection' => true,
		'fields'     => array(
			array(
				'id'       	=> 'product-gallery-style',
				'type'     	=> 'image_select',
				'title'    	=> esc_html__( 'Gallery Style', 'modave' ),
				'subtitle' 	=> esc_html__( 'Select product gallery style.', 'modave' ),
				'options'  	=> array(
					'product-thumbnail-left' 	=> array(
						'title' 	=> esc_html__( 'Thumbnail Left', 'modave' ),
						'img' 	=> PLS_ADMIN_IMAGES . 'product-page/thumbnail-left.png',
					),
					'product-thumbnail-right' 	=> array(
						'title' 	=> esc_html__( 'Thumbnail Right', 'modave' ),
						'img' 	=> PLS_ADMIN_IMAGES . 'product-page/thumbnail-left.png',
					),
					'product-thumbnail-bottom' 	=> array(
						'title' 	=> esc_html__( 'Thumbnail Bottom', 'modave' ),
						'img' 	=> PLS_ADMIN_IMAGES . 'product-page/thumbnail-bottom.png',
					),
					'product-thumbnail-none' 	=> array(
						'title' 	=> esc_html__( 'No Thumbnail', 'modave' ),
						'img' 	=> PLS_ADMIN_IMAGES . 'product-page/thumbnail-none.png',
					),
					'product-gallery-column-1' 	=> array(
						'title' 	=> esc_html__( 'Gallery Column One', 'modave' ),
						'img' 	=> PLS_ADMIN_IMAGES . 'product-page/gallery-column-1.png',
					),
					'product-gallery-column-2' 	=> array(
						'title' 	=> esc_html__( 'Gallery Columns Two', 'modave' ),
						'img' 	=> PLS_ADMIN_IMAGES . 'product-page/gallery-column-2.png',
					),
					'product-gallery-column-alternate' 	=> array(
						'title' 	=> esc_html__( 'Gallery Column Alternate', 'modave' ),
						'img' 	=> PLS_ADMIN_IMAGES . 'product-page/gallery-column-alternate.png',
					),
					'product-gallery-horizontal' 	=> array(
						'title' 	=> esc_html__( 'Gallery Horizontal', 'modave' ),
						'img' 	=> PLS_ADMIN_IMAGES . 'product-page/gallery-horizontal.png',
					),
					'product-gallery-horizontal-2' 	=> array(
						'title' 	=> esc_html__( 'Gallery Horizontal 2', 'modave' ),
						'img' 	=> PLS_ADMIN_IMAGES . 'product-page/gallery-horizontal-2.png',
					),
				),
				'default'  	=> 'product-thumbnail-left'
			),
			array(
				'id'       		=> 'product-gallery-zoom',
				'type'     		=> 'switch',
				'title'    		=> esc_html__( 'Product Gallery Zoom', 'modave' ),
				'subtitle' 		=> esc_html__( 'Enable product gallery zoom.', 'modave' ),
				'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
			),
			array(
                'id'       		=> 'product-gallery-zoom-style',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Zoom Style', 'modave' ),
				'subtitle' 	    => esc_html__( 'Select zoom style.', 'modave' ),
                'options'  		=> array(
					'inner'  		=> esc_html__( 'Inner', 'modave' ),
					'bounding'		=> esc_html__( 'Bounding Box', 'modave' ),					
					'magnifier'  		=> esc_html__( 'Magnifier', 'modave' ),
				),
                'default'  		=> 'inner',
				'required' 		=> array( 'product-gallery-zoom', '=', 1 )
            ),
			array(
				'id'       		=> 'product-gallery-lightbox',
				'type'     		=> 'switch',
				'title'    		=> esc_html__( 'Product Gallery Lightbox', 'modave' ),
				'subtitle' 		=> esc_html__( 'Enable product gallery lightbox.', 'modave' ),
				'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
			),
			array(
				'id'       => 'product-video',
				'type'     => 'switch',
				'title'    => esc_html__( 'Product Video', 'modave' ),
				'subtitle' => esc_html__( 'You want to show product video?', 'modave' ),
				'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
			),
			array(
				'id'       => 'product-360-degree',
				'type'     => 'switch',
				'title'    => esc_html__( 'Product 360 degree Image', 'modave' ),
				'subtitle' => esc_html__( 'You want to show product image in 360 degree view?', 'modave' ),
				'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
			),
			array(
				'id'       => 'product-gallery-slider-nav',
				'type'     => 'switch',
				'title'    => esc_html__( 'Gallery Slider Navigation', 'modave' ),
				'subtitle' => esc_html__( 'Show gallery slider navigation.', 'modave' ),
				'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
			),
			array(
				'id'       => 'product-thumbnail-slider-nav',
				'type'     => 'switch',
				'title'    => esc_html__( 'Thumbnail Slider Navigation', 'modave' ),
				'subtitle' => esc_html__( 'Show thumbnail slider navigation.', 'modave' ),
				'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 0,
			),
		),
	) );
		
	/*
	* Product Summary
	*/
	Redux::setSection( $opt_name, array(
		'title'      => esc_html__( 'Summary', 'modave' ),
		'id'         => 'product-summary',
		'subsection' => true,
		'fields'     => array(
			array(
                'id'       		=> 'single-product-breadcrumb',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Breadcrumb', 'modave' ),
				'subtitle'  	=> esc_html__( 'Show product breadcrumb.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'single-product-navigation',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Navigation', 'modave' ),
				'subtitle'  	=> esc_html__( 'Show product navigation.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'single-product-rating',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Rating', 'modave' ),
				'subtitle'  	=> esc_html__( 'Show product rating.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'single-product-countdown',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Countdown', 'modave' ),
				'subtitle'  	=> esc_html__( 'Show product countdown.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'single-product-stock-progress-bar',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Stock Progress Bar', 'modave' ),
				'subtitle'  	=> esc_html__( 'Show product stock progress bar.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'single-product-availability',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Availability', 'modave' ),
				'subtitle'     	=> esc_html__( 'Show Product availability message like In Stock, Out Of Stock, Hurry left, etc...', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'        	=> 'single-product-availability-instock-msg',
                'type'      	=> 'text',
                'title'     	=> esc_html__( 'In Stock Message', 'modave' ),
                'default' 		=> 'In Stock',
				'required' 		=> array( 'single-product-availability', '=', 1 )
            ),
			array(
                'id'            => 'single-product-availability-lowstock-qty',
                'type'          => 'slider',
                'title'         => esc_html__( 'Low Stock Qty', 'modave' ),
                'subtitle'		=> esc_html__( 'How many numbers you want to display below low stock messages. like Hurry, Only {qty} left.', 'modave' ),
                'default'       => 5,
                'min'           => 1,
                'step'          => 1,
                'max'           => 25,
                'display_value' => 'text',
				'required' 		=> array( 'single-product-availability', '=', 1 )
            ),
			array(
                'id'        	=> 'single-product-availability-hurry-left-msg',
                'type'      	=> 'text',
                'title'     	=> esc_html__( 'Stock Hurry Left Message', 'modave' ),
				'subtitle'		=> esc_html__( 'Default template is: Hurry, Only {qty} left.Here {qty} is number of item available in stock', 'modave' ),
                'default' 		=> 'Hurry, Only {qty} left.',
				'required' 		=> array( 'single-product-availability', '=', 1 )
            ),
			array(
                'id'        	=> 'single-product-availability-outstock-msg',
                'type'      	=> 'text',
                'title'     	=> esc_html__( 'Out of Stock Message', 'modave' ),
                'default' 		=> 'Out of Stock',
				'required' 		=> array( 'single-product-availability', '=', 1 )
            ),
			array(
                'id'       		=> 'single-product-brands',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Brand', 'modave' ),
				'subtitle'  	=> esc_html__( 'Show product brand.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'single-product-short-description',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Short Description.', 'modave' ),
				'subtitle'  	=> esc_html__( 'Show product short description.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'product-add-to-cart-ajax',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Add to Cart Using Ajax', 'modave' ),
				'subtitle'    	 => esc_html__( 'Add to cart product using ajax without load page. ', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'single-product-size-chart',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Size Guide Chart', 'modave' ),
				'subtitle' 		=> esc_html__( 'Show product size guide chart.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
				'id'      		=> 'size-chart-attribute',
				'type'    		=> 'select',
				'title'   		=> esc_html__( 'Select Attribute', 'modave' ),
				'subtitle'		=> esc_html__( 'Select any attribute where you want to show size chart. If empty then display size chart below add to cart button.', 'modave' ),
				'options'    	=> $product_attributes,
				'default' 		=> '',
				'required' 		=> array( 'single-product-size-chart', '=', 1 )
			),
			array(
                'id'       		=> 'single-product-share',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Share', 'modave' ),
				'subtitle'  	=> esc_html__( 'Show product share.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'single-product-meta',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Meta', 'modave' ),
				'subtitle'  	=> esc_html__( 'Show product brand, category, tag, etc...', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
		)
	) );
	
	/*
	* Product Bought Together
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Frequently Bought Together', 'modave' ),
        'id'         => 'product-bought-together',
		'subsection' => true,
        'fields'     => array(
			
			array(
                'id'       		=> 'single-product-bought-together',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Frequently Bought Together', 'modave' ),
				'subtitle'  	=> esc_html__( 'Show frequently bought together products.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'type'     		=> 'text',
                'id'			=> 'product-bought-together-title',
                'title'			=> esc_html__( 'Title', 'modave' ),
				'subtitle'  	=> esc_html__( 'Enter your title here.', 'modave' ),
				'default'  		=> 'Frequently Bought Together',
                'required' 		=> array( 'single-product-bought-together', '=', 1 )
            ),
			array(
                'type'     		=> 'text',
                'id'			=> 'product-fbt-button-text',
                'title'			=> esc_html__( 'Button Text', 'modave' ),
				'subtitle'  	=> esc_html__( 'Enter your button text.', 'modave' ),
				'default'  		=> 'Add Selected to Cart',
                'required' 		=> array( 'single-product-bought-together', '=', 1 )
            ),
			array(
                'id'       		=> 'product-bought-together-location',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Location', 'modave' ),
				'subtitle'  	=> esc_html__( 'Choose location to display Bought Together Products.', 'modave' ),
                'options'  		=> array(
					'summary-bottom'  	=> esc_html__( 'Summary Bottom', 'modave' ),
					'gallery-bottom'	=> esc_html__( 'Gallery Bottom', 'modave' ),
				),
                'default'  		=> 'summary-bottom',
				'required' 		=> array( 'single-product-bought-together', '=', 1 )
            ),			
		),
	) );
	
	/*
	* Product Tags
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Tabs', 'modave' ),
        'id'         => 'product-tabs',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       		=> 'single-product-tabs',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Tabs', 'modave' ),
				'subtitle' 	    => esc_html__( 'Show product tabs.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'single-product-tabs-style',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Product Tabs Style', 'modave' ),
				'subtitle' 	    => esc_html__( 'Select product tabs style.', 'modave' ),
                'options'  		=> array(
					'tabs'  		=> esc_html__( 'Tabs', 'modave' ),
					'accordion'		=> esc_html__( 'Accordion', 'modave' ),					
					'toggle'  		=> esc_html__( 'Toggle', 'modave' ),
					'vtabs'  		=> esc_html__( 'Vertical Tabs', 'modave' ),
				),
                'default'  		=> 'tabs',
				'required' 		=> array( 'single-product-tabs', '=', 1 )
            ),
			array(
                'id'       		=> 'single-product-tabs-location',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Product Tabs Location', 'modave' ),
				'subtitle' 	    => esc_html__( 'Choose location to display product tabs.', 'modave' ),
                'options'  		=> array(
					'after-summary'		=> esc_html__( 'After Summary', 'modave' ),	
					'summary-bottom'  	=> esc_html__( 'Summary Bottom', 'modave' ),
				),
                'default'  		=> 'after-summary',
				'required' 		=> array( 'single-product-tabs', '=', 1 )
            ),
			array(
                'id'       		=> 'single-product-tabs-titles',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Tabs Titles', 'modave' ),
				'subtitle' 	    => esc_html__( 'Show product tabs title in section.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
				'required' 		=> array( 'single-product-tabs', '=', 1 )
            ),
			array(
                'id'    			=> 'single-product-custom-tab-notice',
                'type'   			=> 'info',
                'notice' 			=> false,
                'title' 			=> esc_html__( 'Product Custom Tab', 'modave' ),
            ),
			array(
                'id'       			=> 'single-product-custom-tabs',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Product Custom Tabs', 'modave' ),
				'subtitle'			=> esc_html__( 'Enable Custom tabs.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),
			array(
				'id'				=> 'single-product-custom-tab-list',
				'type'				=> 'repeater',
				'title'				=> esc_html__( 'Product Custom Tabs', 'modave' ),
				'subtitle'			=> esc_html__( 'Add globally applied custom tabs to all products.', 'modave' ),
				'bind_title'		=> 'tab_title',
				'group_values'		=> true,
				'fields'     		=> array(
					array(
						'id'          	=> 'tab_title',
						'title'   		=> esc_html__( 'Enter Tab Title', 'modave' ),
						'type'        	=> 'text',
						'placeholder' 	=> esc_html__( 'Tab Title', 'modave' ),
					),
					array(
						'id'      		=> 'tab_block',
						'type'    		=> 'select',
						'title'   		=> esc_html__( 'Select Block', 'modave' ),
						'options' 		=> pls_get_posts_by_post_type( 'block', esc_html__( 'Select Block', 'modave' ) ),
						'placeholder' 	=> esc_html__( 'Select Block', 'modave' ),
					),
					array(
						'id'          	=> 'tab_priority',
						'title'   		=> esc_html__( 'Tab priority', 'modave' ),
						'type'        	=> 'text',
						'placeholder' 	=> esc_html__( '40', 'modave' ),
					),
				),
				'default'			=> array(
					'redux_repeater_data' 	=> array(
						array(
							'title' => '',
						),
					),
					'tab_title'      	=> array(
						'Shipping',
					),
					'tab_block'          => array(
						'',
					),					
					'tab_priority'      	=> array(
						'40',
					),		
				),
			),
		),
	) );
	
	/*
	* Product Reviews
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Reviews', 'modave' ),
        'id'         => 'product-reviews',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       		=> 'single-product-reviews-graph',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Product Reviews Graph', 'modave' ),
                'options'  		=> array(
					'default'  		=> esc_html__( 'Default', 'modave' ),
					'histogram'		=> esc_html__( 'Histogram', 'modave' ),	
				),
                'default'  		=> 'histogram',
            ),
		),
	) );
	
	/*
	* Product Related/Up-Sells/Recently-Viewed
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Related/Up-Sells/Rviewed', 'modave' ),
        'id'         => 'product-related-upsells-rv',
		'subsection' => true,
        'fields'     => array(			
			array(
                'id'       		=> 'layout-upsells-related-recently',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Select Products Layout', 'modave' ),
				'subtitle'      => esc_html__( 'Display products layout in either the default view or in tabs', 'modave' ),
                'options'  		=> array(
                    'default'		=> esc_html__( 'Default', 'modave' ),
                    'tabs'	 		=> esc_html__( 'Tabs', 'modave' ),
                ),
                'default'  		=> 'default',
            ),
			array(
                'id'       		=> 'upsells-products',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Up Sells Products', 'modave' ),
				'subtitle'      => esc_html__( 'Show Up sells products.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'related-products',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Related Products', 'modave' ),
				'subtitle'      => esc_html__( 'Show related products.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'recently-viewed-products',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Recently Viewed Products', 'modave' ),
				'subtitle'      => esc_html__( 'Show Recently viewed products.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
                'id'            => 'related-upsells-products',
                'type'          => 'slider',
                'title'         => esc_html__( 'Show Number Of Products', 'modave' ),
				'subtitle'     	=> esc_html__( 'How many products you want to display?', 'modave' ),
                'default'       => 6,
                'min'           => 1,
                'step'          => 1,
                'max'           => 24,
                'display_value' => 'text',
            ),
			array(
                'id'       		=> 'related-upsell-auto-play',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Slider Autoplay', 'modave' ),
				'subtitle'      => esc_html__( 'Autoplay.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'related-upsell-loop',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Slider Inifnity Loop', 'modave' ),
                'subtitle' 		=> esc_html__( 'Enables related/up sells products slider Inifnity loop. Duplicate last and first products to get loop illusion.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'related-upsell-navigation',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Slider Navigation', 'modave' ),
				'subtitle'      => esc_html__( 'Show next/prev navigation.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'related-upsell-product-dots',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Slider Pagination(Dots)', 'modave' ),
				'subtitle'      => esc_html__( 'Show dots pagination.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),			
			array(
                'id'       		=> 'related-upsell-products-columns',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Products Per Row', 'modave' ),
				'subtitle'      => esc_html__( 'How many products should be shown per row?', 'modave' ),
                'options'  		=> array(
                    2		=> esc_html__( '2', 'modave' ),
                    3	 	=> esc_html__( '3', 'modave' ),
					4	 	=> esc_html__( '4', 'modave' ),
					5	 	=> esc_html__( '5', 'modave' ),
					6	 	=> esc_html__( '6', 'modave' ),
                ),
                'default'  		=> 4,
            ),
			array(
                'id'       		=> 'related-upsell-products-columns-tablet',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Products Per Row Tablet', 'modave' ),
				'subtitle'      => esc_html__( 'How many products should be shown per row?', 'modave' ),
                'options'  		=> array(
                    1		=> esc_html__( '1', 'modave' ),
                    2		=> esc_html__( '2', 'modave' ),
                    3	 	=> esc_html__( '3', 'modave' ),
					4	 	=> esc_html__( '4', 'modave' ),
                ),
                'default'  		=> 3,
            ),
			array(
                'id'       		=> 'related-upsell-products-columns-mobile',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Products Per Row Mobile', 'modave' ),
				'subtitle'      => esc_html__( 'How many products should be shown per row?', 'modave' ),
                'options'  		=> array(
                    1		=> esc_html__( '1', 'modave' ),
                    2		=> esc_html__( '2', 'modave' ),
                ),
                'default'  		=> 2,
            ),
		),
	) );
	
	/**
	* Advance Features
	*/ 
    Redux::setSection( $opt_name, array(
        'title'   		=> esc_html__( 'Advance Features ', 'modave' ),
		'id'         	=> 'section-advance-features',
		'subsection' 	=> true,
        'fields'  		=> array(
			array(
                'id'    			=> 'product-sold-count-notice',
                'type'   			=> 'info',
                'notice' 			=> false,
                'title' 			=> esc_html__( 'Product Fake Sold Count', 'modave' ),
            ),
			array(
                'id'       			=> 'product-sold-count',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Sold Count', 'modave' ),
				'subtitle'			=> esc_html__( 'Show fake sold count on product page.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),
			array(
                'id'       			=> 'product-sold-specific-products',
                'type'     			=> 'select',
				'multi'				=> true,
				'data'				=> 'posts',
				'args'				=> array(
									'post_type'      => 'product',
									'posts_per_page' => -1,
									'orderby'        => 'title',
									'order'          => 'ASC',
				),
                'title'    			=> esc_html__( 'Specific Products', 'modave' ),
				'subtitle'			=> esc_html__( 'Allow sold count for specific products.', 'modave' ),
				'required' 			=> array( 'product-sold-count', '=', 1 ),
				
            ),
			array(
                'id'       			=> 'product-sold-specific-categories',
                'type'     			=> 'select',
				'multi'    			=> true,
				'data' 	   			=> 'terms',
				'args' 				=> array( 'taxonomies' => 'product_cat' ),
                'title'    			=> esc_html__( 'Specific Categories', 'modave' ),
				'subtitle'			=> esc_html__( 'Allow sold count for specific categories.', 'modave' ),
				'required' 			=> array( 'product-sold-count', '=', 1 ),
            ),
			array(
				'id' 				=> 'product-sold-count-number',
				'type' 				=> 'slider',
				'title' 			=> esc_html__( 'Sold Count Number', 'modave' ),
				'subtitle' 			=> esc_html__( 'Set min and max range to get random number between these value.', 'modave' ),
				'min' 				=> 1,
				'step' 				=> 1,
				'max' 				=> 50,
				'display_value' 	=> 'text',
				'handles' 			=> 2,
				'default' 			=> array(
					1 		=> 5,
					2 		=> 12,
				),
				'required' 			=> array( 'product-sold-count', '=', 1 ),
			),
			array(
				'id' 				=> 'product-sold-count-time',
				'type' 				=> 'slider',
				'title' 			=> esc_html__( 'Set Sold Time Preriod', 'modave' ),
				'subtitle' 			=> esc_html__( 'Set min and max range to get random number between these value.', 'modave' ),
				'min' 				=> 1,
				'step' 				=> 1,
				'max' 				=> 48,
				'display_value' 	=> 'text',
				'handles' 			=> 2,
				'default' 			=> array(
					1 		=> 1,
					2 		=> 10,
				),
				'required' 			=> array( 'product-sold-count', '=', 1 ),
			),
			array(
				'id'       			=> 'product-sold-count-cache',
				'type'     			=> 'slider', 
				'title'    			=> esc_html__( 'Cache Lifetime(Time in Second).', 'modave' ),
				'subtitle' 			=> esc_html__( 'When clear product sold count cache.', 'modave' ),
				'default'  			=> 3600,
				'min'      			=> 60,
				'step'     			=> 60,
				'max'      			=> 7200,
				'display_value' 	=> 'text',
				'required' 			=> array( 'product-sold-count', '=', 1 ),
			),
			array(
                'id'    			=> 'product-visitor-count-notice',
                'type'   			=> 'info',
                'notice' 			=> false,
                'title' 			=> esc_html__( 'Visitor Count', 'modave' ),
            ),
			array(
                'id'       			=> 'single-product-visitor-count',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Visitor Count', 'modave' ),
				'subtitle'			=> esc_html__( 'Show the number of fake visitors currently viewing a product on product page.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),
			array(
				'id' 				=> 'random-visitor-number',
				'type' 				=> 'slider',
				'title' 			=> esc_html__( 'Set Random Number', 'modave' ),
				'subtitle' 			=> esc_html__( 'Set min and max range to get random number between these value.', 'modave' ),
				'min' 				=> 1,
				'step' 				=> 1,
				'max' 				=> 200,
				'display_value' 	=> 'text',
				'handles' 			=> 2,
				'default' 			=> array(
					1 		=> 20,
					2 		=> 50,
				),
				'required' 			=> array( 'single-product-visitor-count', '=', 1 ),
			),
			array(
                'id'       			=> 'visitor-count-text',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Enter Visitor Text', 'modave' ),
				'subtitle' 			=> esc_html__( 'Enter visitor text. Use {visitor_count} for display visitor count number.', 'modave' ),
				'default'  			=> '{visitor_count} People viewing this product right now!',
				'required' 			=> array( 'single-product-visitor-count', '=', 1 ),
            ),
			array(
				'id'       			=> 'visitor-count-delay-time',
				'type'     			=> 'slider', 
				'title'    			=> esc_html__( 'Update Visitors Count Number', 'modave' ),
				'subtitle' 			=> esc_html__( 'Select seconds to delay update the number of visitors count.', 'modave' ),
				'default'  			=> 5,
				'min'      			=> 1,
				'step'     			=> 1,
				'max'      			=> 60,
				'display_value' 	=> 'text',
				'required' 			=> array( 'single-product-visitor-count', '=', 1 ),
			),
			array(
                'id'    			=> 'delivery-return-notice',
                'type'   			=> 'info',
                'notice' 			=> false,
                'title' 			=> esc_html__( 'Delivery & Return', 'modave' ),
            ),
			array(
                'id'       			=> 'product-delivery-return',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Delivery & Return', 'modave' ),
				'subtitle'			=> esc_html__( 'Show delivery & return terms on product page.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),			
			array(
                'id'       			=> 'delivery-return-label',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Delivery & Return Label', 'modave' ),
				'subtitle' 			=> esc_html__( 'Enter your own delivery & return label.', 'modave' ),
				'default'  			=> 'Delivery & Return',
				'required'			=> array( 'product-delivery-return', '=', 1 )
            ),
			array(
				'id'       			=> 'delivery-return-terms',
				'type'     			=> 'select',				
				'title'    			=> esc_html__('Select Terms Block', 'modave' ),
				'subtitle'   		=> wp_kses( sprintf( __( 'Choose delivery & retund terms block. You can add custom block from <a href="%s" target="_blank">here</a>', 'modave' ), esc_url( admin_url( 'post-new.php?post_type=block' ) ) ), array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),
				'options'    	=> $custom_blocks,
				'default' 		=> ' ',
				'placeholder' 		=> esc_attr__( 'Choose terms block', 'modave' ),
				'required'			=> array( 'product-delivery-return', '=', 1 )
			),
			array(
                'id'    			=> 'ask-quetion-notice',
                'type'   			=> 'info',
                'notice' 			=> false,
                'title' 			=> esc_html__( 'Ask a Question', 'modave' ),
            ),
			array(
                'id'       			=> 'product-ask-quetion',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Ask a Question', 'modave' ),
				'subtitle'			=> esc_html__( 'Show ask a question form on product page.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),			
			array(
                'id'       			=> 'ask-quetion-label',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Ask a Question Label', 'modave' ),
				'subtitle' 			=> esc_html__( 'Enter ask a question label text.', 'modave' ),
				'default'  			=> 'Ask a Question',
				'required'			=> array( 'product-ask-quetion', '=', 1 )
            ),
			array(
                'id'       			=> 'ask-quetion-form-title',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Ask a Question Form Title', 'modave' ),
				'subtitle' 			=> esc_html__( 'Enter ask a question form(popup) title.', 'modave' ),
				'default'  			=> 'Ask a Question',
				'required'			=> array( 'product-ask-quetion', '=', 1 )
            ),
			array(
				'id'       			=> 'ask-question-form',
				'type'     			=> 'select',
				'options'    		=> $form_list,
				'title'    			=> esc_html__('Select Ask Question Form', 'modave' ),
				'subtitle'   		=> wp_kses( sprintf( __( 'Choose ask a question form. You can add custom form  from <a href="%s" target="_blank">here</a>', 'modave' ), esc_url( admin_url( 'admin.php?page=wpcf7-new' ) ) ), array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),
				'placeholder' 		=> esc_attr__( 'Choose form block', 'modave' ),
				'required'			=> array( 'product-ask-quetion', '=', 1 )
			),
			array(
                'id'    			=> 'estimated-delivery-notice',
                'type'   			=> 'info',
                'notice' 			=> false,
                'title' 			=> esc_html__( 'Estimated Delivery Time', 'modave' ),
            ),
			array(
                'id'       			=> 'product-estimated-delivery',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Estimated Delivery', 'modave' ),
				'subtitle'			=> esc_html__( 'Show estimated delivery on product page.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),			
			array(
                'id'       			=> 'estimated-delivery-text',
                'type'     			=> 'textarea',
				'rows'     			=> '2',
                'title'    			=> esc_html__( 'Estimated Delivery Text', 'modave' ),
				'subtitle' 			=> esc_html__( 'Enter your own estimated delivery text.', 'modave' ),
				'default'  			=> 'Estimated Delivery: <span>12-26 days</span> (International), <span>3-6 days</span> (United States)',
				'required'			=> array( 'product-estimated-delivery', '=', 1 )
            ),
			array(
                'id'    			=> 'product-return-notice',
                'type'   			=> 'info',
                'notice' 			=> false,
                'title' 			=> esc_html__( 'Return & Refund', 'modave' ),
            ),
			array(
                'id'       			=> 'product-return-refund',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Return Refund', 'modave' ),
				'subtitle'			=> esc_html__( 'Show return and refund information on product page.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),			
			array(
                'id'       			=> 'product-return-refund-text',
                'type'     			=> 'textarea',
				'rows'     			=> '2',
                'title'    			=> esc_html__( 'Return & Refund Text', 'modave' ),
				'subtitle' 			=> esc_html__( 'Enter product return and refund text.', 'modave' ),
				'default'  			=> 'Return within <span>45 days</span> of purchase. Duties &amp; taxes are non-refundable.',
				'required'			=> array( 'product-return-refund', '=', 1 )
            ),
			array(
                'id'    			=> 'store-location-notice',
                'type'   			=> 'info',
                'notice' 			=> false,
                'title' 			=> esc_html__( 'Store Location', 'modave' ),
            ),
			array(
                'id'       			=> 'product-store-location',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Store Location', 'modave' ),
				'subtitle'			=> esc_html__( 'Show store location on product page.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),			
			array(
                'id'       			=> 'store-location-label',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Store Location Label', 'modave' ),
				'subtitle' 			=> esc_html__( 'Enter your own store location label.', 'modave' ),
				'default'  			=> 'View Store Information',
				'required'			=> array( 'product-store-location', '=', 1 )
            ),
			array(
				'id'       			=> 'store-locatation-block',
				'type'     			=> 'select',				
				'title'    			=> esc_html__('Select Terms Block', 'modave' ),
				'subtitle'   		=> wp_kses( sprintf( __( 'Choose store lcation block. You can add custom block from <a href="%s" target="_blank">here</a>', 'modave' ), esc_url( admin_url( 'post-new.php?post_type=block' ) ) ), array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),
				'options'    	=> $custom_blocks,
				'default' 		=> ' ',
				'placeholder' 		=> esc_attr__( 'Choose block', 'modave' ),
				'required'			=> array( 'product-store-location', '=', 1 )
			),
			array(
                'id'    		=> 'product-trust-badge-notice',
                'type'   		=> 'info',
                'notice' 		=> false,
                'title' 		=> esc_html__( 'Trust Badge Image', 'modave' ),
            ),
			array(
                'id'       			=> 'single-product-trust-badge',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Trust Badge', 'modave' ),
				'subtitle'			=> esc_html__( 'Show trust badge image on product page.', 'modave' ),
                'on'       			=> esc_html__( 'Yes', 'modave' ),
				'off'      			=> esc_html__( 'No', 'modave' ),
				'default'  			=> 0,
            ),
			array(
                'id'       			=> 'trust-badge-label',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Trust Badge Label', 'modave' ),
				'subtitle' 			=> esc_html__( 'Enter your own trust badge label.', 'modave' ),
				'default'  			=> 'Guaranteed Safe Checkout:',
				'required'			=> array( 'single-product-trust-badge', '=', 1 )
            ),
			array(
                'id'       		=> 'trust-badge-image',
                'type'     		=> 'media',
                'url'      		=> true,
                'title'    		=> esc_html__( 'Trust Badge Image', 'modave' ),
                'compiler' 		=> 'true',
                'subtitle' 		=>  esc_html__( 'Upload trust badge image.', 'modave' ),
                'default'  		=> array(),
				'required' 		=> array( 'single-product-trust-badge', '=', 1 ),
            ),
		)
    ));
	
	if ( function_exists( 'pls_vendor_theme_options' ) && ( class_exists( 'WeDevs_Dokan' ) || class_exists( 'WC_Vendors' ) || class_exists( 'WCMp' ) || class_exists( 'WCFMmp' ) ) ) {
		/*
		* Vendor Options
		*/
		$vendor_options = pls_vendor_theme_options();
		Redux::setSection( $opt_name, array(
			'title'      => esc_html__( 'Vendor Options', 'modave' ),
			'id'         => 'vendor-options',
			'icon'		 => 'el-icon-broom',
			'fields'     => $vendor_options,
		) );
	}
	
	/*
	* Page Options
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Page', 'modave' ),
        'id'         => 'page',
		'icon'		 => 'el el-list-alt',
        'fields'     => array(
			array(
                'id'       		=> 'page-layout',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Page Layout', 'modave' ),
                'subtitle' 		=> esc_html__( 'Select page layout with sidebar postion.', 'modave' ),
				'options'  		=> array(
                    'full-width' 	=> array(
                        'title' 	=> esc_html__( 'Full Width', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/sidebar-none.png',
                    ),                   
                    'left-sidebar' 	=> array(
                        'title' 	=> esc_html__( 'Left Sidebar', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/sidebar-left.png',
                    ), 
					'right-sidebar' => array(
                        'title' 	=> esc_html__( 'Right Sidebar', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/sidebar-right.png',
                    ), 
                ),
                'default'  		=> 'full-width'
            ),
			array(
                'id'       => 'page-sidebar',
                'type'     => 'select',
                'title'    => esc_html__( 'Sidebar', 'modave' ),
				'subtitle' 	=> esc_html__( 'Select sidebar for page.', 'modave' ),
                'data'     => 'sidebars',
                'default'  => 'sidebar-1',
                'required' => array( 'page-layout', '=', array( 'left-sidebar', 'right-sidebar' ) )
            ),
			array(
                'id'       => 'page-comments',
                'type'     => 'switch',
                'title'    => esc_html__( 'Page Comment', 'modave' ),
                'subtitle' => esc_html__( 'Show page comments and comment form or not.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
            ),
		)
	) );
	
	/*
	* Page Widget Options
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Sidebar Widget', 'modave' ),
        'id'         => 'page-widget',
        'subsection' => true,
        'fields'     => array(
			array(
                'id'       		=> 'sticky-sidebar',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Sidebar Sticky', 'modave' ),
                'subtitle' 		=> esc_html__( 'When you scroll the page at this time you want to sticky sidebar part in all pages or not.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'widget-toggle',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Widget Toggle', 'modave' ),
                'subtitle'     	=> esc_html__( 'Enable page widget toggle or not.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
                'id'       => 'widget-menu-toggle',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Widget Menu Toggle', 'modave' ),
                'subtitle'     => esc_html__( 'Enable page widget menu toggle or not.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'sidebar-canvas-mobile',
                'type'     => 'switch',
                'title'    => esc_html__( 'Sidebar Canvas In Mobile', 'modave' ),
                'subtitle' => esc_html__( 'Display sidebar canvas in mobile.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 0,
            ),
		)
	) );
	
	/*
	* 404 Page
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( '404 Page', 'modave' ),
        'id'         => '404-page',
		'subsection' => true,
        'fields'     => array(
			array(
				'id'      		=> '404-page-content',
				'type'    		=> 'select',
				'title'   		=> esc_html__( '404 Page Content', 'modave' ),
				'subtitle'   	=> wp_kses( sprintf( __( 'Select 404 page custom content block that display on 404 page. You can add custom block from <a href="%s" target="_blank">here</a>', 'modave' ), esc_url( admin_url( 'post-new.php?post_type=block' ) ) ), array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),
				'options'    	=> $custom_blocks,
				'default' 		=> ' ',
			),
		)
	) );

	/*
	* Post options
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Blog / Post', 'modave' ),
        'id'         => 'blog',
		'icon'		 => 'el el-edit',
        'fields'     => array(
			array(
                'id'       	=> 'post-single-line-title',
                'type'     	=> 'switch',
                'title'    	=> esc_html__( 'Single Line Post Title', 'modave' ),
                'subtitle'   => esc_html__( 'Enable/Disable single line post title', 'modave' ),
                'on'       	=> esc_html__( 'Yes', 'modave' ),
				'off'      	=> esc_html__( 'No', 'modave' ),
				'default'  	=> 0,
            ),
			array(
                'id'       => 'sticky-post-icon',
                'type'     => 'switch',
                'title'    => esc_html__( 'Sticky Post Icon', 'modave' ),
                'subtitle'    => esc_html__( 'Show sticky post icon.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'post-format-icon',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Format Icon', 'modave' ),
                'subtitle'    => esc_html__( 'show post format icon.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'post-meta',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Meta', 'modave' ),
                'subtitle'    => esc_html__( 'Show post meta.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'specific-post-meta',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Specific Post Meta', 'modave' ),
                'subtitle' => esc_html__( 'Select specific post meta to dispaly on post.', 'modave' ),
                'multi'    => true,
                'options'  => array(
                    'post-date' 		=> esc_html__( 'Date', 'modave' ),	
					'post-author' 		=> esc_html__( 'Author', 'modave' ),
					'post-comments' 	=> esc_html__( 'Comments', 'modave' ),
					'post-views' 		=> esc_html__( 'Views', 'modave' ),
				),
                'default'  => array( 'post-date', 'post-author' ),
				'required' => array( 'post-meta', '=', 1 )
            ),
		)
	) );
	
	/*
	* Blog/Archives options
	*/
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Blog/Archive Page', 'modave' ),
        'id'         => 'blog-archive',
		'subsection'	 => true,
        'fields'     => array(
			array(
                'id'       		=> 'blog-page-layout',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Page Layout', 'modave' ),
                'subtitle' 		=> esc_html__( 'Select blog/archive page layout with sidebar postion.', 'modave' ),
				'options'  		=> array(
                    'full-width' 	=> array(
                        'title' 	=> esc_html__( 'Full Width', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/sidebar-none.png',
                    ),                   
                    'left-sidebar' 	=> array(
                        'title' 	=> esc_html__( 'Left Sidebar', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/sidebar-left.png',
                    ), 
					'right-sidebar' => array(
                        'title' 	=> esc_html__( 'Right Sidebar', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/sidebar-right.png',
                    ), 
                ),
                'default'  		=> 'right-sidebar'
            ),
			array(
                'id'       => 'blog-page-sidebar',
                'type'     => 'select',
                'title'    => esc_html__( 'Sidebar', 'modave' ),
                'subtitle'    => esc_html__( 'Select sidebar for blog page.', 'modave' ),
                'data'     => 'sidebars',
                'default'  => 'sidebar-1',
                'required' => array( 'blog-page-layout', '=', array( 'left-sidebar', 'right-sidebar' ) )
            ),
			array(
                'id'       		=> 'blog-page-title',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Page Title', 'modave' ),
                'subtitle' 		=> esc_html__( 'Show blog page title.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'          	=> 'blog-page-title-text',
                'type'        	=> 'text',
                'title'       	=> esc_html__( 'Page Title', 'modave' ),
                'subtitle' 	  	=> esc_html__( 'Enter blog page title text.', 'modave' ),
                'default'       => esc_html__( 'Blog', 'modave' ),
                'placeholder' 	=> esc_attr__( 'Enter blog post title here', 'modave' ),
				'required' 		=> array( 'blog-page-title', '=', 1 )
            ),
			array(
                'id'       		=> 'blog-page-breadcrumb',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Page Breadcrumb', 'modave' ),
                'subtitle' 		=> esc_html__( 'Show blog page breadcrumb.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'blog-archive-categories',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Top Archive Categories', 'modave' ),
                'subtitle' 		=> esc_html__( 'Show archive categories on blog top.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'blog-post-style',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Post Style', 'modave' ),
                'subtitle'    	=> esc_html__( 'Select post style.', 'modave' ),
                'options'  		=> array(
					'blog-classic' => array(
                        'title' 	=> esc_html__( 'Blog Classic', 'modave' ),
                        'alt' 		=> esc_html__( 'Blog Classic', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/blog-classic.png',
                    ),
					'blog-listing' => array(
                        'title' 	=> esc_html__( 'Blog Listing', 'modave' ),
                        'alt' 		=> esc_html__( 'Blog Listing', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/blog-listing.png',
                    ),
					'blog-grid' => array(
                        'title' 	=> esc_html__( 'Blog Grid', 'modave' ),
                        'alt' 		=> esc_html__( 'Blog Grid', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/blog-grid.png',
                    ),
                ),
                'default'  	=> 'blog-classic',
            ),
			array(
                'id'       		=> 'blog-grid-columns',
                'type'    		=> 'button_set',
                'title'    		=> esc_html__( 'Gird Columns', 'modave' ),
                'subtitle' 		=> esc_html__( 'If you have choosed post style as grid layout, so you can manage here number of grid columns display.', 'modave' ),
                'options'  		=> array(
                    2 			=> esc_html__( '2', 'modave' ),
                    3 			=> esc_html__( '3', 'modave' ),
					4 			=> esc_html__( '4', 'modave' ),
                ),
                'default'  		=> 2,
				'required' 		=> array( 'blog-post-style', '=', 'blog-grid' )
            ),			
			array(
                'id'       		=> 'blog-grid-columns-tablet',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Gird Columns Tablet', 'modave' ),
				'subtitle'      => esc_html__( 'How many post should be shown per row?', 'modave' ),
                'options'  		=> array(
                    1		=> esc_html__( '1', 'modave' ),
                    2		=> esc_html__( '2', 'modave' ),
                    3	 	=> esc_html__( '3', 'modave' ),
                ),
                'default'  		=> 2,
				'required' => array( 'blog-post-style', '=', 'blog-grid' )
            ),
			array(
                'id'       		=> 'blog-grid-columns-mobile',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Gird Columns Mobile', 'modave' ),
				'subtitle'      => esc_html__( 'How many post should be shown per row?', 'modave' ),
                'options'  		=> array(
                    1		=> esc_html__( '1', 'modave' ),
                    2		=> esc_html__( '2', 'modave' ),
                ),
                'default'  		=> 1,
				'required' => array( 'blog-post-style', '=', 'blog-grid' )
            ),			
			array(
                'id'       => 'blog-post-thumbnail',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Thumbnail', 'modave' ),
                'subtitle'    => esc_html__( 'Show post thumbnail', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'blog-post-title',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Title', 'modave' ),
                'subtitle'    => esc_html__( 'Show post title', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
                'off'      => esc_html__( 'No', 'modave' ),
                'default'  => 1,
            ),
			array(
                'id'       => 'show-blog-post-content',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Content', 'modave' ),
                'subtitle' => esc_html__( 'Show blog post content.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
                'off'      => esc_html__( 'No', 'modave' ),
                'default'  => 1,
            ),
			array(
                'id'       		=> 'blog-post-content',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Post Content', 'modave' ),
                'subtitle'    	=> esc_html__( 'Select post content', 'modave' ),
                'options'  		=> array(
					'excerpt-content' 	=> esc_html__( 'Excerpt Content', 'modave' ),
					'full-content' 		=> esc_html__( 'Full Content', 'modave' ),
				),
                'default'  		=> 'full-content',
				'required' 		=> array( 'show-blog-post-content', '=', 1 )
            ),
			array(
                'id'            => 'blog-excerpt-length',
                'type'          => 'slider',
                'title'         => esc_html__( 'Excerpt Length (words)', 'modave' ),
                'subtitle'      => esc_html__( 'Show blog listing excerpt content length (words).', 'modave' ),
                'default'       => 30,
                'min'           => 10,
                'step'          => 1,
                'max'           => 100,
                'display_value' => 'text',
				'required' => array( 'blog-post-content', '=', 'excerpt-content' )
            ),
			array(
                'id'       => 'read-more-button',
                'type'     => 'switch',
                'title'    => esc_html__( 'Read More Button', 'modave' ),
                'subtitle'    => esc_html__( 'Show read more button', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
            ),			
			array(
                'id'       => 'read-more-button-style',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Read More Button Style', 'modave' ),
                'subtitle'    => esc_html__( 'Select read more button style', 'modave' ),
                'options'  => array(
					'read-more-link' => esc_html__( 'Link', 'modave' ),
					'read-more-button-fill' => esc_html__( 'Button Fill', 'modave' ),
					'read-more-button' => esc_html__( 'Button', 'modave' ),
				),
                'default'  => 'read-more-link',
				'required' => array( 'read-more-button', '=', 1 )
            ),
			array(
                'id'       => 'post-readmore-text',
                'type'     => 'text',
                'title'    => esc_html__( 'Read More Button Text', 'modave' ),
                'subtitle'    => esc_html__( 'Enter read more button text', 'modave' ),
				'default'  => 'Read More',
				'required' => array( 'read-more-button', '=', 1 )
            ),
			array(
                'id'       => 'blogs-pagination-type',
                'type'     => 'button_set',
                'title'    => esc_html__( ' Pagination Style', 'modave' ),
                'subtitle'    => esc_html__( ' Select pagination style', 'modave' ),
                'options'  => array(
					'default' 				=> esc_html__( 'Default', 'modave' ),
					'infinity-scroll'		=> esc_html__( 'Infinity Scroll', 'modave' ),
					'load-more-button' 		=> esc_html__( 'Load More', 'modave' ),
				),
                'default'  => 'default',
            ),
			array(
                'id'       => 'blog-pagination-load-more-button-text',
                'type'     => 'text',
                'title'    => esc_html__( 'Load More Button Text', 'modave' ),
				'subtitle' => esc_html__( 'Enter load more button text.', 'modave' ),
                'default'  => 'Load More',
				'required' => array( 'blogs-pagination-type', '=', array( 'infinity-scroll', 'load-more-button' ) ),
            ),
			array(
                'id'       => 'blog-pagination-finished-message',
                'type'     => 'text',
                'title'    => esc_html__( 'Finished Message', 'modave' ),
				'subtitle' => esc_html__( 'Text to display when no additional items are available.', 'modave' ),
                'default'  => 'No More Posts Available',
				'required' => array( 'blogs-pagination-type', '=', array( 'infinity-scroll', 'load-more-button' ) ),
            ),			
		)
	) );
	
	/*
	* Single Post options
	*/
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Single Post', 'modave' ),
        'id'         => 'single-post',
		'subsection'	 => true,
        'fields'     => array(
			array(
                'id'       		=> 'single-post-layout',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Page Layout', 'modave' ),
                'subtitle' 		=> esc_html__( 'Select single post page layout with sidebar postion.', 'modave' ),
				'options'  		=> array(
                    'full-width' 	=> array(
                        'title' 	=> esc_html__( 'Full Width', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/sidebar-none.png',
                    ),                   
                    'left-sidebar' 	=> array(
                        'title' 	=> esc_html__( 'Left Sidebar', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/sidebar-left.png',
                    ), 
					'right-sidebar' => array(
                        'title' 	=> esc_html__( 'Right Sidebar', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/sidebar-right.png',
                    ), 
                ),
                'default'  		=> 'right-sidebar'
            ),
			array(
                'id'       => 'single-post-sidebar',
                'type'     => 'select',
                'title'    => esc_html__( 'Sidebar', 'modave' ),
				'subtitle' 	=> esc_html__( 'Select sidebar for single post.', 'modave' ),
                'data'     => 'sidebars',
                'default'  => 'sidebar-1',
                'required' => array( 'single-post-layout', '=', array( 'left-sidebar', 'right-sidebar' ) )
            ),
			array(
                'id'       => 'single-post-thumbnail',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Thumbnail', 'modave' ),
                'subtitle' => esc_html__( 'Show post thumbnail or not.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'Hide', 'modave' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'single-post-gallery-style',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Post Gallery Style', 'modave' ),
                'options'  => array(
					'slider'		=>esc_html__( 'Slider', 'modave' ),
					'grid'			=>esc_html__( 'Grid', 'modave' ),
					'one-column'	=>esc_html__( 'One Column', 'modave' ),					
				),
                'default'  => 'slider',
				'required' => array( 'single-post-thumbnail', '=', 1 )
            ),
			array(
                'id'       	=> 'post-category',
                'type'     	=> 'switch',
                'title'    	=> esc_html__( 'Post Categories', 'modave' ),
                'subtitle'   => esc_html__( 'Show post categories.', 'modave' ),
                'on'       	=> esc_html__( 'Yes', 'modave' ),
				'off'      	=> esc_html__( 'No', 'modave' ),
				'default'  	=> 1,
            ),
			array(
                'id'       => 'single-post-title',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Title', 'modave' ),
                'default'  => 1,
                'on'       => esc_html__( 'Yes', 'modave' ),
                'off'      => esc_html__( 'No', 'modave' ),
            ),
			array(
                'id'       => 'single-post-author-info',
                'type'     => 'switch',
                'title'    => esc_html__( 'Author Info', 'modave' ),
                'default'  => 1,
                'on'       => esc_html__( 'Yes', 'modave' ),
                'off'      => esc_html__( 'No', 'modave' ),
            ),
			array(
                'id'       => 'single-post-tag',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Tags', 'modave' ),
                'default'  => 1,
                'on'       => esc_html__( 'Yes', 'modave' ),
                'off'      => esc_html__( 'No', 'modave' ),
            ),
			array(
                'id'       => 'single-post-social-share-link',
                'type'     => 'switch',
                'title'    => esc_html__( 'Social Share Links', 'modave' ),
                'default'  => 1,
                'on'       => esc_html__( 'Yes', 'modave' ),
                'off'      => esc_html__( 'No', 'modave' ),
            ),
			array(
                'id'       => 'single-post-navigation',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Navigation', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'single-post-comment',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Comment', 'modave' ),
                'subtitle' => esc_html__( 'Show post comments and comment form or not.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'single-post-related',
                'type'     => 'switch',
                'title'    => esc_html__( 'Related Post', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 0,
            ),
			array(
                'id'       	=> 'single-posts-related',
                'type'     	=> 'slider',
                'title'    	=> esc_html__( 'Show Related Posts', 'modave' ),
				'subtitle'  => esc_html__( 'Show/display number of related posts.', 'modave' ),
                'default'   => 6,
                'min'       => 2,
                'step'      => 1,
                'max'       => 12,
                'display_value' => 'text',
				'required' => array( 'single-post-related', '=', 1 ),
            ),
			array(
                'id'       => 'related-posts-taxonomy',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Taxonomy', 'modave' ),
				'subtitle' => esc_html__( 'Get related posts by post taxonomy category or tag.', 'modave' ),
                'options'  => array(
					'post_tag'=>esc_html__( 'Tag', 'modave' ),
					'category'=>esc_html__( 'Category', 'modave' ),					
				),
                'default'  => 'post_tag',
				'required' => array( 'single-post-related', '=', 1 ),
            ),
			array(
                'id'       => 'related-posts-orderby',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Post Orderby', 'modave' ),
                'options'  => array(
					'none'=>esc_html__( 'None', 'modave' ),
					'rand'=>esc_html__( 'Random', 'modave' ),
					'ID'=>esc_html__( 'ID', 'modave' ),
					'name'=>esc_html__( 'Name', 'modave' ),
					'date'=>esc_html__( 'Date', 'modave' ),
					'modified'=>esc_html__( 'Modified Date', 'modave' ),					
					'comment_count'=>esc_html__( 'Comment Count', 'modave' ),
				),
                'default'  => 'rand',
				'required' => array( 'single-post-related', '=', 1 ),
            ),
			array(
                'id'       => 'related-posts-order',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Post Order', 'modave' ),
                'options'  => array(
					'DESC'=>esc_html__( 'DESC', 'modave' ),
					'ASC'=>esc_html__( 'ASC', 'modave' ),					
				),
                'default'  => 'DESC',
				'required' => array( 'single-post-related', '=', 1 ),
            ),			
		)
	) );
			
	/*
	* Social
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Social', 'modave' ),
        'id'         => 'social',
		'icon'		 => 'el el-group',
        'fields'     => array(
		)
	) );
	
	/*
	* Social Profile
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Social Profile', 'modave' ),
        'id'         => 'social-profile-section',
		'icon'		 => '',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       => 'social-profile',
                'type'     => 'switch',
                'title'    => esc_html__( 'Social Profile Icon', 'modave' ),
				'subtitle' => esc_html__( 'Show social profile icon in header and footer.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'social-profile-icons-style',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Icons Style', 'modave' ),
				'subtitle' => esc_html__( 'Select icons style.', 'modave' ),
                'options'  => array(
					'icons-default' 	=> array(
                        'title' 	=> esc_html__( 'Default', 'modave' ),
                        'alt' 		=> esc_html__( 'Default', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/social-icon/default.png',
                    ), 
					'icons-theme-colour' => array(
                        'title' 	=> esc_html__( 'Theme Colour', 'modave' ),
                        'alt' 		=> esc_html__( 'Theme Colour', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/social-icon/theme-color.png',
                    ), 
					'icons-fill-colour' => array(
                        'title' 	=> esc_html__( 'Fill Colour', 'modave' ),
                        'alt' 		=> esc_html__( 'Fill Colour', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/social-icon/fill-color.png',
                    ),
                ),
                'default'  => 'icons-theme-colour',
				'required' => array( 'social-profile', '=', 1 )
            ),
			array(
                'id'       => 'profile-icons-size',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Icons Size', 'modave' ),
				'subtitle' => esc_html__( 'Select icons size.', 'modave' ),
                'options'  => array(
                    'icons-size-default'=> esc_html__( 'Default', 'modave' ),
					'icons-size-small' 	=> esc_html__( 'Small', 'modave' ),
					'icons-size-large' 	=> esc_html__( 'Large', 'modave' ),
                ),
                'default'  => 'icons-size-small',
				'required' => array( 'social-profile', '=', 1 )
            ),
			array(
                'id'       => 'facebook-link',
                'type'     => 'text',
                'title'    => esc_html__( 'Facebook', 'modave' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the facebook icon. Leave blank to hide icon.', 'modave' ),
				'default'  => '#',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'instagram-link',
                'type'     => 'text',
                'title'    => esc_html__( 'Instagram', 'modave' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the instagram icon. Leave blank to hide icon.', 'modave' ),
				'default'  => '#',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'twitter-link',
                'type'     => 'text',
                'title'    => esc_html__( 'Twitter', 'modave' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the twitter icon. Leave blank to hide icon.', 'modave' ),
				'default'  => '#',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'linkedin-link',
                'type'     => 'text',
                'title'    => esc_html__( 'Linkedin', 'modave' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the linkedin icon. Leave blank to hide icon.', 'modave' ),
				'default'  => '',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'youtube-link',
                'type'     => 'text',
                'title'    => esc_html__( 'Youtube', 'modave' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the youtube icon. Leave blank to hide icon.', 'modave' ),
				'default'  => '#',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'pinterest-link',
                'type'     => 'text',
                'title'    => esc_html__( 'Pinterest', 'modave' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the pinterest icon. Leave blank to hide icon.', 'modave' ),
				'default'  => '#',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'flickr-link',
                'type'     => 'text',
                'title'    => esc_html__( 'Flickr', 'modave' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the flickr icon. Leave blank to hide icon.', 'modave' ),
				'default'  => '',
				'required' => array( 'social-profile', '=', 1 ),
            ),			
			array(
                'id'       => 'rss-link',
                'type'     => 'text',
                'title'    => esc_html__( 'RSS', 'modave' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the rss icon. Leave blank to hide icon.', 'modave' ),
				'default'  => '',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'tiktok-link',
                'type'     => 'text',
                'title'    => esc_html__( 'TikTok', 'modave' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the tiktok icon. Leave blank to hide icon.', 'modave' ),
				'default'  => '',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'github-link',
                'type'     => 'text',
                'title'    => esc_html__( 'Github', 'modave' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the github icon. Leave blank to hide icon.', 'modave' ),
				'default'  => '',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'whatsapp-link',
                'type'     => 'text',
                'title'    => esc_html__( 'WhatsApp', 'modave' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the whatsapp icon. Leave blank to hide icon.', 'modave' ),
				'default'  => '',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'telegram-link',
                'type'     => 'text',
                'title'    => esc_html__( 'Telegram', 'modave' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the telegram icon. Leave blank to hide icon.', 'modave' ),
				'default'  => '',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'vk-link',
                'type'     => 'text',
                'title'    => esc_html__( 'VK', 'modave' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the VK icon. Leave blank to hide icon.', 'modave' ),
				'default'  => '',
				'required' => array( 'social-profile', '=', 1 ),
            ),
		)
	) );
	
	/*
	* Social Share
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Social Share', 'modave' ),
        'id'         => 'social-share-section',
		'icon'		 => '',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       => 'social-sharing',
                'type'     => 'switch',
                'title'    => esc_html__( 'Share Icons', 'modave' ),
				'subtitle' => esc_html__( 'Show social share icons in blog, posts, products, etc...', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'social-sharing-icons-style',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Icons Style', 'modave' ),
                'options'  => array(
					'icons-default' 	=> array(
                        'title' 	=> esc_html__( 'Default', 'modave' ),
                        'alt' 		=> esc_html__( 'Default', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/social-icon/default.png',
                    ),                 
                    'icons-bordered'  	=> array(
                        'title' 	=> esc_html__( 'Bordered', 'modave' ),
                        'alt' 		=> esc_html__( 'Bordered', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/social-icon/bordered.png',
                    ), 
					'icons-fill-colour' => array(
                        'title' 	=> esc_html__( 'Fill Colour', 'modave' ),
                        'alt' 		=> esc_html__( 'Fill Colour', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/social-icon/fill-color.png',
                    ),
					'icons-theme-colour' => array(
                        'title' 	=> esc_html__( 'Theme Colour', 'modave' ),
                        'alt' 		=> esc_html__( 'Theme Colour', 'modave' ),
                        'img' 		=> PLS_ADMIN_IMAGES . 'layout/social-icon/theme-color.png',
                    ),								
                ),
                'default'  => 'icons-theme-colour',
				'required' => array( 'social-sharing', '=', 1 )
            ),
			array(
                'id'       => 'sharing-icons-size',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Icons Size', 'modave' ),
                'options'  => array(
                    'icons-size-default'=> esc_html__( 'Default', 'modave' ),
					'icons-size-small' 	=> esc_html__( 'Small', 'modave' ),
					'icons-size-large' 	=> esc_html__( 'Large', 'modave' ),
                ),
                'default'  => 'icons-size-default',
				'required' => array( 'social-sharing', '=', 1 )
            ),
			array(
                'id'       => 'social-share-manager',
                'type'     => 'sorter',
                'title'    => 'Share Icons Manager',
                'compiler' => 'true',
                'options'  => array(
                    'enabled'  => array(
                        'facebook' 		=> 'Facebook',
                        'linkedin'   	=> 'Linkedin',
                        'twitter'     	=> 'Twitter',
						'pinterest'		=> 'Pinterest',
						'telegram'		=> 'Telegram',
                    ),
                    'disabled' => array(
						'stumbleupon'	=> 'StumbleUpon',
						'tumblr'   		=> 'Tumblr',
						'reddit'   		=> 'Reddit',
						'vk'   			=> 'VK',
						'odnoklassniki' => 'Odnoklassniki',
						'pocket'   		=> 'Pocket',
						'whatsapp'  	=> 'WhatsApp',
						'email'   		=> 'Email',
						'print'   		=> 'Print',
					),
                ),
				'required' => array( 'social-sharing', '=', 1 )
            ),			
		)
	) );/* End Social sections */
	
	/*
	* Newsletter Options
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Newsletter', 'modave' ),
        'id'         => 'newsletter',
		'icon'       => 'el el-envelope',
        'fields'     => array(
			array(
                'id'       => 'newsletter-popup',
                'type'     => 'switch',
                'title'    => esc_html__( 'Newsletter', 'modave' ),
                'on'       => esc_html__( 'Enable', 'modave' ),
				'off'      => esc_html__( 'Disable', 'modave' ),
				'subtitle' => esc_html__( 'Newsletter popup enable or disable in your site.', 'modave' ),
				'default'  => 0,
            ),
			array(
                'id'       			=> 'newsletter-popup-on',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Newsletter Popup On', 'modave' ),
                'subtitle' 	   		=> esc_html__( 'Show newsletter popup on front page or all pages.', 'modave' ),
                'options'  			=> array(
                    'front-page' 	=> esc_html__( 'Front Page', 'modave' ),
                    'all-pages' 	=> esc_html__( 'All Pages', 'modave' ),
                ),
                'default'  			=> 'all-pages',
            ),
			array(
                'id'       => 'newsletter-show-mobile',
                'type'     => 'switch',
                'title'    => esc_html__( 'Mobile', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'subtitle' => esc_html__( 'You want to show newsletter for mobile devices.', 'modave' ),
				'default'  => 1,
            ),
			array(
				'id'      	=> 'newsletter-when-appear',
				'type'    	=> 'button_set',
				'title'   	=> esc_html__( 'When Popup Appear?', 'modave' ),                    
				'options' 	=> array(
					'page_load' 	=> esc_html__( 'On Page Load', 'modave' ),
					'scroll' 		=> esc_html__( 'When Page Scroll', 'modave' ),
					'exit' 			=> esc_html__( 'On Exit Intent', 'modave' ),
				), 
				'default' 	=> 'page_load',
			),
			array(
				'id'       => 'newsletter-delay',
				'type'     => 'text',
				'title'    => esc_html__( 'Popup Delay', 'modave' ),
				'default'  => '5',
				'subtitle' =>  esc_html__( 'Enter no of second to open popup after page load.', 'modave' ),
				'required' => array( 'newsletter-when-appear', '=', 'page_load' ),
			),
			array(
				'id'       => 'newsletter-version',
				'type'     => 'text',
				'title'    => esc_html__( 'Popup Version', 'modave' ),
				'default'  => '1',
				'subtitle' =>  esc_html__( 'Increase version number, for show forcefully popup who already closed it.', 'modave' ),
			),
			array(
				'id'       => 'newsletter-x-scroll',
				'type'     => 'text',
				'title'    => esc_html__( 'Open When User Scroll % of Page', 'modave' ),
				'default'  => '30',
				'subtitle' =>  esc_html__( '100% - For end of page', 'modave' ),
				'required' => array( 'newsletter-when-appear', '=', 'scroll' ),
			),
			array(
				'id'       			=> 'newsletter-block-id',
				'type'     			=> 'select',
				'title'    			=> esc_html__('Select Block', 'modave' ),
				'subtitle'   	=> wp_kses( sprintf( __( 'You can add custom block from <a href="%s" target="_blank">here</a>', 'modave' ), esc_url( admin_url( 'post-new.php?post_type=block' ) ) ), array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),
				'options'    	=> $custom_blocks,
				'default' 		=> ' ',
				'placeholder' 		=> esc_attr__('Choose block', 'modave' ),
			),
			array(
                'id'            	=> 'newsletter-popup-width',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Newsletter Width (px)', 'modave' ),
				'subtitle'          => esc_html__( 'Newsletter popup width in pixels.', 'modave' ),
                'default'       	=> 660,
                'min'           	=> 300,
                'step'          	=> 1,
                'max'           	=> 960,
            ),
			array(
                'id'            	=> 'newsletter-popup-radius',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Newsletter Popup Radius (px)', 'modave' ),
				'subtitle'          => esc_html__( 'Newsletter popup border radius in pixels.', 'modave' ),
                'default'       	=> 32,
                'min'           	=> 0,
                'step'          	=> 1,
                'max'           	=> 60,
            ),
		)
	) );

	/*
	* Cookie Options
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Cookie Notice', 'modave' ),
        'id'         => 'section-cookie-notice',
		'icon'       => 'el el-dashboard',
        'fields'     => array(
			array(
                'id'       => 'cookie-notice',
                'type'     => 'switch',
                'title'    => esc_html__( 'Cookie', 'modave' ),
                'on'       => esc_html__( 'Enable', 'modave' ),
				'off'      => esc_html__( 'Disable', 'modave' ),
				'subtitle' => esc_html__( 'Cookie notice enable or disable in your site.', 'modave' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'cookie-title',
                'type'     => 'text',
                'title'    => 'Cookie Title',
                'subtitle' => esc_html__( 'Enter the Cookie Title/Name.', 'modave' ),
				'default'  => esc_html__( 'Cookies Notice', 'modave' ),
            ),
			array(
                'id'       => 'cookie-message-text',
                'type'     => 'textarea',
                'title'    => esc_html__( 'Message', 'modave' ),
				'subtitle' => esc_html__( 'Enter the cookie notice message.', 'modave' ),
				'default'  => esc_html__( 'We use cookies to ensure that we give you the best experience on our website. If you continue to use this site we will assume that you are happy with it.', 'modave' ),
            ),
			array(
                'id'       => 'cookie-accept-text',
                'type'     => 'text',
                'title'    => esc_html__( 'Button Text', 'modave' ),
                'subtitle' => esc_html__( 'The text of the option to accept the usage of the cookies and make the notification disappear.', 'modave' ),
				'default'  => esc_html__( 'Yes, I\'m Accept', 'modave' ),
            ),
			array(
                'id'       => 'cookie-see-more-opt',
                'type'     => 'switch',
                'title'    => esc_html__( 'More Info Link', 'modave' ),
                'on'       => esc_html__( 'Enable', 'modave' ),
				'off'      => esc_html__( 'Disable', 'modave' ),
				'subtitle' => esc_html__( 'Enable Read more link.', 'modave' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'cookie-see-more-text',
                'type'     => 'text',
                'title'    => '',
                'subtitle' => esc_html__( 'The text of the more info button.', 'modave' ),
				'default'  => esc_html__( 'Read more', 'modave' ),
				'required' => array( 'cookie-see-more-opt', '=', 1 ),
            ),
			array(
                'id'       => 'cookie-see-more-link-type',
                'type'     => 'radio',
                'title'    => '',
                'subtitle' => esc_html__( 'Select where to redirect user for more information about cookies.', 'modave' ),
                'options'  => array(
								'custom' 	 => esc_html__( 'Custom link', 'modave' ),
								'page' => esc_html__( 'Page link', 'modave' ),
							),
				'default'  => 'custom',
				'required' => array( 'cookie-see-more-opt', '=', 1 ),
            ),
			array(
                'id'       => 'cookie-see-more-link-custom',
                'type'     => 'text',
                'title'    => '',
                'subtitle' => esc_html__( 'Enter the full URL starting with http://', 'modave' ),
				'default'  => 'http://empty',
				'placeholder' => esc_attr( 'http://#' ),
				'required' => array( 'cookie-see-more-link-type', '=', 'custom' ),
            ),
			array(
                'id'       => 'cookie-see-more-link-pages',
                'type'     => 'select',
                'data'     => 'pages',
                'title'    => '',
                'subtitle' => esc_html__( 'Select from one of your site\'s pages', 'modave' ),
				'required' => array( 'cookie-see-more-link-type', '=', 'page' ),
            ),
			array(
                'id'       => 'cookie-see-more-link-target',
                'type'     => 'select',
                'title'    => esc_html__( 'Link Target', 'modave' ),
                'subtitle' => esc_html__( 'Select the link target for more info page.', 'modave' ),
                'options'  => array(
                    '_blank' 	=> esc_html__( 'New Page', 'modave' ),
                    '_self' 	=> esc_html__( 'This page', 'modave' ),
                ),
                'default'  => '_blank',
            ),
			array(
                'id'       => 'cookie-refuse-opt',
                'type'     => 'switch',
                'title'    => esc_html__( 'Refuse Button', 'modave' ),
                'on'       => esc_html__( 'Enable', 'modave' ),
				'off'      => esc_html__( 'Disable', 'modave' ),
				'subtitle' => esc_html__( 'Give to the user the possibility to refuse third party non functional cookies.', 'modave' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'cookie-refuse-text',
                'type'     => 'text',
                'title'    => '',
                'subtitle' => esc_html__( 'The text of the option to refuse the usage of the cookies. To get the cookie notice status use pls_cn_cookies_accepted() function.', 'modave' ),
				'default'  => esc_html__( 'Dismiss', 'modave' ),
				'required' => array( 'cookie-refuse-opt', '=', 1 ),
            ),
			array(
                'id'       => 'cookie-refuse-code',
                'type'     => 'textarea',
                'title'    => '',
				'subtitle' => esc_html__( 'Enter non functional cookies Javascript code here (for e.g. Google Analytics). It will be used after cookies are accepted.', 'modave' ),
				'required' => array( 'cookie-refuse-opt', '=', 1 ),
				
            ),
			array(
                'id'       => 'cookie-on-scroll',
                'type'     => 'switch',
                'title'    => esc_html__( 'On Scroll', 'modave' ),
                'on'       => esc_html__( 'Enable', 'modave' ),
				'off'      => esc_html__( 'Disable', 'modave' ),
				'subtitle' => esc_html__( 'Enable cookie notice acceptance when users scroll.', 'modave' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'cookie-on-scroll-offset',
                'type'     => 'text',
                'title'    => '',
                'subtitle' => esc_html__( 'Number of pixels user has to scroll to accept the usage of the cookies and make the notification disappear.', 'modave' ),
				'default'  => 100,
				'required' => array( 'cookie-on-scroll', '=', 1 ),
            ),
			array(
                'id'       => 'cookie-expiry-times',
                'type'     => 'select',
                'title'    => esc_html__( 'Cookie Expiry', 'modave' ),
                'subtitle' => esc_html__( 'Select the link target for more info page.', 'modave' ),
                'options'  => array(
					'86400'	 	=> esc_html__( '1 day', 'modave' ),
					'604800'	=> esc_html__( '1 week', 'modave' ),
					'2592000'	=> esc_html__( '1 month', 'modave' ),
					'7862400'	=> esc_html__( '3 months', 'modave' ),
					'15811200'	=> esc_html__( '6 months', 'modave' ),
					'31536000'	=> esc_html__( '1 year', 'modave' ),
					'31337313373' => esc_html__( 'infinity', 'modave' ),
                ),
                'default'  => '2592000',
            ),
			array(
                'id'       => 'cookie-script-placements',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Script Placement', 'modave' ),
                'subtitle' => esc_html__( 'Select where all the plugin scripts should be placed.', 'modave' ),
                'options'  => array(
                    'header' => esc_html__( 'Header', 'modave' ),
                    'footer' => esc_html__( 'Footer', 'modave' ),
                ),
                'default'  => 'footer',
            ),
			array(
                'id'       => 'cookie-positions',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Position', 'modave' ),
                'subtitle' => esc_html__( 'Select location for your cookie notice.', 'modave' ),
                'options'  => array(
                    'top' 		=> esc_html__( 'Top', 'modave' ),
                    'bottom' 	=> esc_html__( 'Bottom', 'modave' ),
                ),
                'default'  => 'bottom'
            ),
			array(
                'id'       => 'cookie-style',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Cookie Style', 'modave' ),
                'subtitle' => esc_html__( 'Select style of cookie notice on bottom.', 'modave' ),
                'options'  => array(
                    'bar' 		=> esc_html__( 'Bar', 'modave' ),
                    'box' 	=> esc_html__( 'Box', 'modave' ),
                ),
                'default'  => 'bar',
				'required' => array( 'cookie-positions', '=', 'bottom' ),
            ),
			array(
                'id'       => 'cookie-text-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Text Color', 'modave' ),
                'default'  => '#4D4E4F',
            ),
			array(
                'id'       => 'cookie-background-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Bar Background Color', 'modave' ),
                'default'  => '#ffffff',
            ),
		)
	) );
	
	
	/*
	* Slider Config
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Slider Config', 'modave' ),
        'id'         => 'slider-config',
		'icon'		 => 'el el-picture',
        'fields'     => array(
			array(
                'id'       => 'slider-loop',
                'type'     => 'switch',
                'title'    => esc_html__( 'Loop', 'modave' ),
				'subtitle' => esc_html__( 'Infinity loop. Duplicate last and first items to get loop illusion.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'slider-autoplay',
                'type'     => 'switch',
                'title'    => esc_html__( 'Autoplay', 'modave' ),
                'subtitle' => esc_html__( 'Autoplay.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 0,
            ),			
			array(
                'id'       => 'slider-autoplay-hover-pause',
                'type'     => 'switch',
                'title'    => esc_html__( 'autoplayHoverPause', 'modave' ),
				'subtitle' => esc_html__( 'Pause on mouse hover.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
				'required' => array( 'slider-autoplay', '=', 1 )
            ),
			array(
                'id'       => 'slider-autoplay-delay',
                'type'     => 'text',
                'title'    => esc_html__( 'Autoplay Delay', 'modave' ),
                'default'  => 1500,
				'validate' => 'numeric',
				'required' => array( 'slider-autoplay', '=', 1 )
            ),	
			array(
                'id'       => 'slider-autoplay-speed',
                'type'     => 'text',
                'title'    => esc_html__( 'Autoplay Speed', 'modave' ),
                'default'  => 1500,
				'validate' => 'numeric',
				'required' => array( 'slider-autoplay', '=', 1 )
            ),			
			array(
                'id'       => 'slider-rewind',
                'type'     => 'switch',
                'title'    => esc_html__( 'Rewind', 'modave' ),
				'subtitle' => esc_html__( 'Go backwards when the boundary has reached.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'slider-autoHeigh',
                'type'     => 'switch',
                'title'    => esc_html__( 'AutoHeight', 'modave' ),
                'subtitle' => esc_html__( 'AutoHeight.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'slider-navigation',
                'type'     => 'switch',
                'title'    => esc_html__( 'Navigation', 'modave' ),
				'subtitle' => esc_html__( 'Show next/prev navigation.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'slider-nav-style',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Navigation Style', 'modave' ),
				'subtitle' => esc_html__( 'Select navigation style.', 'modave' ),
                'options'  => array(
					'circle'	=> esc_html__( 'Circle', 'modave' ),
					'arrow'		=> esc_html__( 'Arrow', 'modave' ),
				),
                'default'  => 'arrow',
				'required' => array( 'slider-navigation', '=', 1 )
            ),
			array(
                'id'       => 'slider-pagination',
                'type'     => 'switch',
                'title'    => esc_html__( 'Pagination(Dots)', 'modave' ),
				'subtitle' => esc_html__( 'Show dots pagination.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'slider-touchDrag',
                'type'     => 'switch',
                'title'    => esc_html__( 'TouchDrag', 'modave' ),
				'subtitle' => esc_html__( 'Touch drag enabled.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'slider-touchDrag-mobile',
                'type'     => 'switch',
                'title'    => esc_html__( 'TouchDrag In Mobile', 'modave' ),
				'subtitle' => esc_html__( 'Touch drag enabled in mobile.', 'modave' ),
                'on'       => esc_html__( 'Yes', 'modave' ),
				'off'      => esc_html__( 'No', 'modave' ),
				'default'  => 1,
            ),
		)
	) );/* END SLIDER CONFIG SECTIONS */
	
	/*
	* Optimize
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Optimize(Performance)', 'modave' ),
        'id'         => 'site-optimize',
		'icon'		 => 'el el-dashboard',
        'fields'     => array(
			array(
                'id'       		=> 'disable-fontawesome',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Font Awesome', 'modave' ),
				'subtitle'		=> esc_html__( 'Disable font awesome style from plugins.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
                'off'      		=> esc_html__( 'No', 'modave' ),
                'default'  		=> 1,
            ),
			array(
                'id'       		=> 'disable-gutenberg',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Gutenberg', 'modave' ),
				'subtitle'		=> esc_html__( 'Disable gutenberg styles.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
                'off'      		=> esc_html__( 'No', 'modave' ),
                'default'  		=> 0,
            ),
			array(
                'id'       		=> 'disable-wc-blocks',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'WC Blocks', 'modave' ),
				'subtitle'		=> esc_html__( 'Disable default WooCommerce blocks styles.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
                'off'      		=> esc_html__( 'No', 'modave' ),
                'default'  		=> 0,
            ),
		)
	) );
	
	/*
	* Maintenance Mode
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Maintenance Mode', 'modave' ),
        'id'         => 'site-maintenance-mode',
		'icon'		 => 'el el-icon-website',
        'fields'     => array(
			array(
                'id'       		=> 'maintenance-mode',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Maintenance Mode', 'modave' ),
				'subtitle'		=> esc_html__( 'Status of Maintenance Mode.', 'modave' ),
                'default'  		=> 0,
                'on'       		=> esc_html__( 'On', 'modave' ),
                'off'      		=> esc_html__( 'Off', 'modave' ),
            ),
			array(
				'id'      	=> 'maintenance-page',
				'type'    	=> 'select',
				'title'   	=> esc_html__( 'Page', 'modave' ),
				'subtitle'	=> esc_html__( 'Select page to display as maintenance page.', 'modave' ),
				'data'    	=> 'pages',
			),
		)
	) );
	
	/*
	* White Label
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'White Label', 'modave' ),
        'id'         => 'white-label',
		'icon'       => 'el el-tag',
        'fields'     => array(
			array(
                'id'       			=> 'white-label-enable',
                'type'     			=> 'switch',
                'title'    			=> esc_html__('Enable White Label?','modave'),
                'on'       			=> esc_html__('Enable','modave'),
				'off'      			=> esc_html__('Disable','modave'),
				'default'  			=> 0,
            ),
			array(
                'id'       			=> 'theme-name',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Theme Name', 'modave' ),
                'subtitle'     		=> esc_html__( 'Replace all the theme name in admin dashboard.', 'modave' ),
            ),
			array(
                'id'       			=> 'theme-screenshot',
                'type'     			=> 'media',
                'url'      			=> false,
                'title'    			=> esc_html__( 'Theme Screenshot', 'modave' ),
                'subtitle'     		=> esc_html__( 'Replace the theme screenshot in Appearance > Themes. Recommended size 1200x900px.', 'modave' ),
				'default'  			=> array(),
			),
			array(
                'id'       			=> 'theme-menu-icon',
                'type'     			=> 'media',
                'url'      			=> false,
                'title'    			=> esc_html__( 'Theme Menu Icon', 'modave' ),
                'subtitle'     		=> esc_html__( 'Replace the theme menu icon. Recommended size 32x32px.', 'modave' ),
				'default'  			=> array(),
			),
			array(
                'id'       			=> 'theme-welcome-page-title',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Welcome Page Title', 'modave' ),
                'subtitle'     		=> esc_html__( 'Replace the theme welcome page title.', 'modave' ),
				'default'  			=> '',
			),
			array(
                'id'       			=> 'theme-welcome-page-description',
                'type'     			=> 'textarea',
                'title'    			=> esc_html__( 'Welcome Page Description','modave'),
                'subtitle'     		=> esc_html__( 'Replace the theme welcome page description.', 'modave' ),
				'default'  			=> '',
            ),
			array(
                'id'       			=> 'theme-welcome-page-icon',
                'type'     			=> 'media',
                'url'      			=> false,
                'title'    			=> esc_html__( 'Welcome Page Icon', 'modave' ),
                'subtitle'     		=> esc_html__( 'Replace the theme welcome page icon. Recommended size 150x150px.', 'modave' ),
				'default'  			=> array()
			),
			array(
                'id'       		=> 'disable-welcome-page',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Disable Welcome Menu','modave' ),
                'subtitle'     	=> esc_html__( 'Disable welcome/dashboard menu.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'disable-demo-import',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Disable Demo Import Menu','modave' ),
                'subtitle'     	=> esc_html__( 'Disable Demo Import Menu.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 0,
            ),
			array(
                'id'    	=> 'section-wodpress-login-page',
                'type'   	=> 'info',
                'notice' 	=> false,
                'title' 	=> esc_html__( 'WordPress Login Page Design', 'modave' ),
            ),
			array(
                'id'       			=> 'wp-login-page-logo',
                'type'     			=> 'media',
                'url'      			=> false,
                'title'    			=> esc_html__( 'Wordpress Logo', 'modave' ),
                'subtitle'     		=> esc_html__( 'Replace the wordpress logo.', 'modave' ),
				'default'  			=> array()
			),
			array(
                'id'            	=> 'wp-login-page-logo-width',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Logo Width', 'modave' ),
				'subtitle'          => esc_html__( 'Logo width in pixels', 'modave' ),
                'default'       	=> 150,
                'min'           	=> 50,
                'step'          	=> 1,
                'max'           	=> 300,
                'display_value' 	=> 'text',
            ),
			array(
                'id'            	=> 'wp-login-page-logo-height',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Logo Height', 'modave' ),
				'subtitle'          => esc_html__( 'Logo height in pixels', 'modave' ),
                'default'       	=> 84,
                'min'           	=> 25,
                'step'          	=> 1,
                'max'           	=> 250,
                'display_value' 	=> 'text',
            ),
			array(
                'id'       		=> 'wp-login-page-background',
                'type'    	 	=> 'background',
                'title'    		=> esc_html__( 'Page Background', 'modave' ),
                'subtitle'     	=> esc_html__( 'Set wordpress login page background.', 'modave' ),
                'default'  		=> array(
					'background-color' => '#f0f0f1'
				),
            ),
			
			array(
                'id'       		=> 'wp-login-form-background',
                'type'    	 	=> 'color',
                'title'    		=> esc_html__( 'Login Form Background', 'modave' ),
                'subtitle'     	=> esc_html__( 'Set wordpress login form background color.', 'modave' ),
                'default'  		=> '#ffffff',
            ),
			array(
                'id'       		=> 'wp-login-form-box-shadow',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Login Form Box Shadow','modave' ),
                'subtitle'     	=> esc_html__( 'Set login form box shadow.', 'modave' ),
                'on'       		=> esc_html__( 'Yes', 'modave' ),
				'off'      		=> esc_html__( 'No', 'modave' ),
				'default'  		=> 1,
            ),
			array(
				'id'             	=> 'wp-login-form-padding',
				'type'           	=> 'spacing',
				'title'          	=> esc_html__( 'Login Form Padding', 'modave' ),
				'subtitle'       	=> esc_html__( 'Add login form spacing using padding.', 'modave' ),
				'mode'           	=> 'padding',
				'units'          	=> array( 'em', '%', 'px' ),
				'default'           => array(
					'padding-top' 		=> '2',
					'padding-right' 	=> '2',
					'padding-bottom' 	=> '2',
					'padding-left' 		=> '2',
					'units'         	=> 'em', 
				)
			),
			array(
                'id'       => 'wp-login-text-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Text Color', 'modave' ),
				'subtitle' 		=> esc_html__( 'Set text color.', 'modave' ),
                'default'  => '#545454',
            ),
			array(
                'id'       => 'wp-login-link-color',
                'type'     => 'link_color',
                'title'    => esc_html__( 'Link Color', 'modave' ),
				'subtitle' 		=> esc_html__( 'Set link and hover color.', 'modave' ),
				'active'    	=> false,
                'default'  => array(
                    'regular' => '#181818',
                    'hover'   => '#181818',
                )
            ),
			array(
                'id'       => 'wp-login-border',
                'type'     => 'border',
                'title'    => esc_html__( 'Border', 'modave' ),                
                'subtitle' 		=> esc_html__( 'Set border color, style and width.', 'modave' ),
                'default'  => array(
                    'border-color'  => '#e5e5e5',
                    'border-style'  => 'solid',
                    'border-top'    => '1px',
                    'border-right'  => '1px',
                    'border-bottom' => '1px',
                    'border-left'   => '1px'
                )
            ),
			array(
                'id'            => 'wp-login-border-radius',
                'type'          => 'slider',
                'title'         => esc_html__( 'Border Radius', 'modave' ),
				'subtitle' 		=> esc_html__( 'site border radius.', 'modave' ),
                'default'       => 4,
                'min'           => 0,
                'step'          => 1,
                'max'           => 50,
                'display_value' => 'label'
            ),
			array(
                'id'       => 'wp-login-input-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Input Field Color( TextBox, SelectBox, etc..)', 'modave' ),
				'subtitle'    	=> esc_html__( 'Set color input field like TextBox, Textarea, SelectBox, etc..', 'modave' ),
                'default'  => '#545454',
            ),
			 array(
                'id'       => 'wp-login-input-background',
                'type'     => 'color',
                'title'    => esc_html__( 'Input Field Background( TextBox, SelectBox, etc..)', 'modave' ),
				'subtitle'    	=> esc_html__( 'Set background input field like TextBox, Textarea, SelectBox, etc..', 'modave' ),
                'default'  => '#ffffff',
            ),
			array(
                'id'       		=> 'wp-login-button-background',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Button Background', 'modave' ),
                'subtitle' 		=> esc_html__( 'Set button background color and hover color.', 'modave' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#181818',
                    'hover'   	=> '#181818',
                )
            ),
			array(
                'id'       		=> 'wp-login-button-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Button Color', 'modave' ),
                'subtitle' 		=> esc_html__( 'Set button text color and hover color.', 'modave' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#ffffff',
                    'hover'   	=> '#fcfcfc',
                )
            ),
		)
	) );
	
	/*
	* Custom CSS/JS Code
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Custom JS/CSS', 'modave' ),
        'id'         => 'custom-code',
		'icon'		 => 'el-icon-broom',
        'fields'     => array(
			array(
                'id'       => 'custom-css',
                'type'     => 'ace_editor',
                'title'    => esc_html__( 'CSS Code', 'modave' ),
                'subtitle' => esc_html__( 'Paste your CSS code here.', 'modave' ),
                'mode'     => 'css',
                'theme'    => 'monokai',
                'default'  => ""
            ),	
			array(
				'id'       => 'custom-js-header',
				'type'     => 'ace_editor',
				'title'    => esc_html__( 'JS Code before &lt;/head&gt;', 'modave' ),
				'subtitle' => esc_html__( 'Paste your JS code here.', 'modave' ),
				'mode'     => 'javascript',
				'theme'    => 'chrome',
				'default'  => '',
			),
            array(
                'id'       => 'custom_js',
                'type'     => 'ace_editor',
                'title'    => esc_html__( 'JS Code before &lt;/body&gt;', 'modave' ),
                'subtitle' => esc_html__( 'Paste your JS code here.', 'modave' ),
                'mode'     => 'javascript',
                'theme'    => 'chrome',
                'default'  => "jQuery(document).ready(function(){\n\n});"
            ),
		)
	) );
	
    /*
     * <--- END SECTIONS
     */


    /*
     *
     * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
     *
     */

      /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $field['msg']    = 'your custom error message';
                $return['error'] = $field;
            }

            if ( $warning == true ) {
                $field['msg']      = 'your custom warning message';
                $return['warning'] = $field;
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => esc_html__( 'Section via hook', 'modave' ),
                'subtitle'   => esc_html__( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'modave' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }