<?php  
if ( ! defined( 'PLS_DIR' ) ) exit( 'No direct script access allowed' );
/**
 * PLS Metabox
 * @package 	/inc
 */
 
if ( ! class_exists( 'PLS_Metabox' ) ) :

	/**
	 * PLS_Metabox
	 *
	 * @since 1.0
	 */
	class PLS_Metabox {
		
		/**
		 * Instance
		 *
		 * @access private
		 * @var object Class object.
		 */
		private static $instance;
		
		private $prefix = PLS_PREFIX;
		
		public $post_types;
		
		/**
		 * Initiator
		 *
		 * @return object initialized object of class.
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self;
			}
			return self::$instance;
		}
		
		/**
		 * Constructor
		 */
		public function __construct() {
			$this->post_types = array( 'post', 'page', 'product' );
			add_action( 'admin_init', array( $this, 'register_metaboxes' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_js_var' ) );
		}		
		
		public function meta_boxes(){
			/* Page Meta Options */
			$meta_boxes					= array();
			$meta_boxes['post_format']	= $this->post_format_options();						
			$meta_boxes['products_tab']	= $this->products_tab_options();
			$meta_boxes['products']		= $this->products_options();			
			$meta_boxes['page_layout']	= $this->page_layout_options();			
			$meta_boxes['header']		= $this->header_options();			
			$meta_boxes['page_title']	= $this->page_title_options();
			$meta_boxes['footer']		= $this->footer_options();
			
			return apply_filters( 'pls_page_meta_options' , $meta_boxes );
		}
		public function post_format_options(){
			$prefix = $this->prefix;
			$options = array(
				'title' 		=> esc_html__( 'Post Format', 'modave' ),
				'id' 			=> $prefix .'meta_box_post_format',
				'post_types' 	=> array( 'post' ),
				'tab'   		=> true,
				'fields' 		=> array(
					array(
						'name' 				=> esc_html__( 'Image', 'modave' ),
						'label_description' => esc_html__( 'Select images image for post', 'modave' ),
						'id' 				=> $prefix . 'post_format_image',
						'type' 				=> 'image_advanced',
						'max_file_uploads' 	=> 1,
					),
					array(
						'name' 				=> esc_html__( 'Gallery', 'modave' ),
						'label_description' => esc_html__( 'Select images gallery for post', 'modave' ),
						'id' 				=> $prefix . 'post_format_gallery',
						'type' 				=> 'image_advanced',
					),
					array(
						'name' 				=> esc_html__( 'Video URL or Embeded Code', 'modave' ),
						'label_description' => esc_html__( 'Enter the URL or embed code of Vimeo.com or YouTube.com streaming services.<br>To get the code, go to the external video page, click "share" button and copy the Embed code.This setting is used for your video post formats.', 'modave' ),
						'id'   				=> $prefix . 'post_format_video',
						'type' 				=> 'textarea',
					),
					array(
						'name' 				=> esc_html__( 'Audio URL or Embeded Code', 'modave' ),
						'label_description' => esc_html__( 'Enter the URL or Embeded code of the audio.This setting is used for your audio post formats.', 'modave' ),
						'id'   				=> $prefix . 'post_format_audio',
						'type' 				=> 'textarea',
					),
					array(
						'name' 				=> esc_html__( 'Quote', 'modave' ),
						'label_description' => esc_html__( 'Enter your quote.This setting is used for your quote post formats.', 'modave' ),
						'id'   				=> $prefix . 'post_format_quote',
						'type' 				=> 'textarea',
					),
					array(
						'name' 				=> esc_html__( 'Author', 'modave' ),
						'label_description' => esc_html__( 'Enter quote author.This setting is used for your quote post formats.', 'modave' ),
						'id'   				=> $prefix . 'post_format_quote_author',
						'type' 				=> 'text',
					),
					array(
						'name' 				=> esc_html__( 'Author URL', 'modave' ),
						'label_description' => esc_html__( 'Enter quote author url.This setting is used for your quote post formats.', 'modave' ),
						'id'   				=> $prefix . 'post_format_quote_author_url',
						'type' 				=> 'url',
					),
					array(
						'name' 				=> esc_html__( 'Link', 'modave' ),
						'label_description' => esc_html__( 'Enter your external url.This setting is used for your link post formats.', 'modave' ),
						'id'   				=> $prefix . 'post_format_link_url',
						'type' 				=> 'url',
					),					
					array(
						'name' 				=> esc_html__( 'Text', 'modave' ),
						'label_description' => esc_html__( 'Enter link text for link.This setting is used for your link post formats.', 'modave' ),
						'id'   				=> $prefix . 'post_format_link_text',
						'type' 				=> 'text',
					),
				),
			);	
			return apply_filters( 'pls_post_format_meta_options' , $options);
		}
		
		public function products_tab_options(){		
			$prefix = $this->prefix;
			$options = array(
				'id' 			=> $prefix . 'product_custom_tab_meta',
				'title' 		=> esc_html__( 'Product Custom Tab', 'modave' ),
				'post_types' 	=> array( 'product' ),
				'fields' 		=> array(
					array(
						'name'  			=> esc_html__( 'Enable Custom Tab.', 'modave' ),
						'label_description'	=> esc_html__( 'Check this for enable custom tab.', 'modave' ),
						'id'    			=> $prefix . 'enable_custom_tab',
						'type'  			=> 'checkbox',
						'std'				=> 0,
					),
					array (
						'name' 				=> esc_html__( 'Custom Tab Title', 'modave' ),
						'label_description' => esc_html__( 'Enter tab title.', 'modave' ),
						'id' 				=> $prefix . 'product_custom_tab_heading',
						'type' 				=> 'text',
						'std' 				=> '',
						'required-field' 	=> array( $prefix . 'enable_custom_tab', '=', array( '1' ) ),
					),
					array(
						'name'  			=> esc_html__( 'Custom Tab Content.', 'modave' ),
						'label_description' => esc_html__( 'Enter tab content.', 'modave' ),
						'id'    			=> $prefix . 'product_custom_tab_content',
						'type'  			=> 'wysiwyg',
						'raw'     			=> false,
						'options' 			=> array(
							'textarea_rows' 	=> 4,
							'teeny'         	=> true,
						),
						'required-field' 	=> array( $prefix . 'enable_custom_tab', '=', array( '1' ) ),
					), 
				)
			);
			return apply_filters( 'pls_product_tabs_meta_options' , $options);
		}
		
		public function products_options(){
			$prefix		= $this->prefix;
			$size_guide = pls_get_posts_by_post_type( 'pls_size_chart', esc_html__( 'Select Size Chart', 'modave' ) );
			
			$options = array(
				'id' 			=> $prefix . 'product_setting_meta_box',
				'title' 		=> esc_html__( 'Product Setting', 'modave' ),
				'post_types' 	=> array( 'product' ),
				'tab' 			=> true,
				'fields' 		=> array(											
					array(
						'name'  			=> esc_html__( 'Product Content Full Width', 'modave' ),
						'label_description'	=> esc_html__( 'You want to display product content area in full width? Note: This option only works when the Page Layout is full width (no sidebar).', 'modave' ),
						'id'    			=> $prefix . 'product_content_fullwidth',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'	=> esc_html__( 'Default', 'modave' ),
							'enable' 	=> esc_html__( 'Enable', 'modave' ),
							'disable'  	=> esc_html__( 'Disable', 'modave' ),
						),
						'std'			=> 'default',
						'multiple' 		=> false,
					),
					array(
						'name'  			=> esc_html__( 'Content Background Color', 'modave' ),
						'label_description'	=> esc_html__( 'You want to display content background color? Note: This option only works when the Page Layout is full width (no sidebar).', 'modave' ),
						'id'    			=> $prefix . 'product_content_background',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'		=> esc_html__( 'Default', 'modave' ),
							'none'			=> esc_html__( 'None', 'modave' ),
							'custom' 		=> esc_html__( 'Custom', 'modave' ),
							'dark'  		=> esc_html__( 'Dark', 'modave' ),
						),
						'std'			=> 'default',
						'multiple' 		=> false,
					),
					array(
						'name'  			=> esc_html__( 'Background Color', 'modave' ),
						'label_description' => esc_html__( 'Set product content background color. Note: This option only works when Content Background Color enable.', 'modave' ),
						'id'    			=> $prefix.'product_content_background_color',
						'type'  			=> 'color',
						'std'				=> '#f5f5f5',
					),
					array(
						'name'  			=> esc_html__( 'Product Gallery Style', 'modave' ),
						'label_description'	=> esc_html__( 'Select product gallery style.', 'modave' ),
						'id'    			=> $prefix.'product_gallery_style',
						'type'  			=> 'image_set',
						'allowClear' 		=> true,
						'options' 			=> array(
							'product-thumbnail-left'			=> PLS_ADMIN_IMAGES . 'product-page/thumbnail-left.png',
							'product-thumbnail-right'			=> PLS_ADMIN_IMAGES . 'product-page/thumbnail-left.png',
							'product-thumbnail-bottom' 			=> PLS_ADMIN_IMAGES . 'product-page/thumbnail-bottom.png',
							'product-thumbnail-none'			=> PLS_ADMIN_IMAGES . 'product-page/thumbnail-none.png',
							'product-gallery-column-1'			=> PLS_ADMIN_IMAGES . 'product-page/gallery-column-1.png',
							'product-gallery-column-2'			=> PLS_ADMIN_IMAGES . 'product-page/gallery-column-2.png',
							'product-gallery-column-alternate'	=> PLS_ADMIN_IMAGES . 'product-page/gallery-column-alternate.png',
							'product-gallery-horizontal'		=> PLS_ADMIN_IMAGES . 'product-page/gallery-horizontal.png',
							'product-gallery-horizontal-2' 		=> PLS_ADMIN_IMAGES . 'product-page/gallery-horizontal-2.png',
						),
						'std'				=> '',
						'multiple' 			=> false,
					),
					array(
						'name' 				=> esc_html__( 'Product Video url', 'modave' ),
						'id'   				=> $prefix . 'product_video',
						'label_description'	=> esc_html__( 'Youtube, Vimeo embaded link', 'modave' ),
						'type' 				=> 'text',
					),
					array(
						'name' 				=> esc_html__( 'Product Size Guide', 'modave' ),
						'label_description'	=> esc_html__( 'Select product size guide.', 'modave' ),
						'id'   				=> $prefix . 'size_guide',
						'type' 				=> 'select',
						'options'			=> $size_guide,
						'max_file_uploads' 	=> 1,
					),
					array(
						'name'             	=> esc_html__( 'Product 360 Degree Images', 'modave' ),
						'label_description'	=> esc_html__( 'Upload 360 degree images.', 'modave' ),
						'id'               	=> $prefix . 'product_360_degree_images',
						'type'             	=> 'image_advanced',
						'force_delete'     	=> false,
					),
					array(
						'name'  			=> esc_html__( 'Bought Together Location', 'modave' ),
						'label_description'	=> esc_html__( 'Select Bought Together Location.', 'modave' ),
						'id'    			=> $prefix . 'product_bought_together_location',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'			=> esc_html__( 'Default', 'modave' ),
							'summary-bottom' 	=> esc_html__( 'Summary Bottom', 'modave' ),
							'gallery-bottom'  	=> esc_html__( 'Gallery Bottom', 'modave' ),
						),
						'std'			=> 'default',
						'multiple' 		=> false,
					),						
					array(
						'name'  			=> esc_html__( 'Product Tabs Style', 'modave' ),
						'label_description' => esc_html__( 'Select Product Tabs Style.', 'modave' ),
						'id'    			=> $prefix . 'single_product_tabs_style',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'		=> esc_html__( 'Default', 'modave' ),
							'tabs' 			=> esc_html__( 'Tabs', 'modave' ),
							'accordion'  	=> esc_html__( 'Accordion', 'modave' ),
							'toggle'  		=> esc_html__( 'Toggle', 'modave' ),
							'vtabs'  		=> esc_html__( 'Vertical Tabs', 'modave' ),
						),
						'std'			=> 'default',
						'multiple' 		=> false,
					),
					array(
						'name'  			=> esc_html__( 'Product Tabs Location', 'modave' ),
						'label_description' => esc_html__( 'Select Product Tabs Location.', 'modave' ),
						'id'    			=> $prefix . 'single_product_tabs_location',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'			=> esc_html__( 'Default', 'modave' ),
							'after-summary' 	=> esc_html__( 'After Summary', 'modave' ),
							'summary-bottom'  	=> esc_html__( 'Summary Bottom', 'modave' ),
						),
						'std'			=> 'default',
						'multiple' 		=> false,
					),
				)
			);
			return apply_filters( 'pls_product_meta_options' , $options);
		}
		
		public function page_layout_options(){
			$prefix	= $this->prefix;			
			/* Page  Options */
			$options = array(
				'title' 		=> 	esc_html__( 'Page Layout', 'modave' ),
				'id' 			=> $prefix.'layout_options',
				'post_types' 	=> $this->post_types,
				'tab' 			=> 	true,
				'fields' 		=> 	array(
					array(
						'name'  		=> esc_html__( 'Page Sidebar', 'modave' ),
						'id'    		=> $prefix.'page_layout',
						'type'  		=> 'image_set',
						'allowClear' 	=> true,
						'options' 		=> array(
							'full-width'	  => PLS_ADMIN_IMAGES . 'layout/sidebar-none.png',
							'left-sidebar'	  => PLS_ADMIN_IMAGES . 'layout/sidebar-left.png',
							'right-sidebar'	  => PLS_ADMIN_IMAGES . 'layout/sidebar-right.png',
						),
						'std'			=> '',
						'multiple' 		=> false,
						'required' 		=> true,
					),
					array (
						'name' 				=> esc_html__( 'Sidebar Widget', 'modave' ),
						'label_description'	=> esc_html__( 'Select sidebar. If empty then it take value from theme options.', 'modave' ),
						'id' 				=> $prefix.'sidebar_widget',
						'type' 				=> 'sidebar',
						'field_type'  		=> 'select_advanced',
						'placeholder' 		=> esc_attr__( 'Select Sidebar', 'modave' ),
						'std' 				=> '',	
						'required-field' 	=> array($prefix . 'page_layout', '=', array( 'left-sidebar', 'right-sidebar' ) ),																
					),										
				),
			);
			return apply_filters( 'pls_page_layout_meta_options' , $options);
		}
		
		public function header_options(){		
			$prefix = $this->prefix;
			/* Header Options */
			$options = array(
				'title' 		=> esc_html__( 'Header', 'modave' ),
				'id' 			=> $prefix .'header_options',
				'post_types' 	=> array( 'post', 'page', 'product' ),
				'tab' 			=> true,
				'fields' 		=> 	array(
					array(
						'name'  			=> esc_html__( 'Header Top', 'modave' ),
						'label_description'	=> esc_html__( 'Enable or disable the top bar.', 'modave' ),
						'id'    			=> $prefix . 'header_top',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'	=> esc_html__( 'Default', 'modave' ),
							'enable' 	=> esc_html__( 'Enable', 'modave' ),
							'disable'  	=> esc_html__( 'Disable', 'modave' ),
						),
						'std'			=> 'default',
						'multiple' 		=> false,
					),
					array(
						'name'  			=> esc_html__( 'Header', 'modave' ),
						'label_description' => esc_html__( 'Enable or disable the header.', 'modave' ),
						'id'    			=> $prefix . 'header',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'	=> esc_html__( 'Default', 'modave' ),
							'enable' 	=> esc_html__( 'Enable', 'modave' ),
							'disable'  	=> esc_html__( 'Disable', 'modave' ),
						),
						'std'			=> 'default',
						'multiple' 		=> false,
					),
					array(
						'name'  			=> esc_html__( 'Select Header Style', 'modave' ),
						'label_description' => esc_html__( 'Select header style.', 'modave' ),
						'id'    			=> $prefix.'header_style',
						'type'     			=> 'select',
						'options'  			=> array(
							'default'		=> esc_html__( 'Default', 'modave' ),
							'1'      		=> esc_html__( 'Header 1', 'modave' ),
							'2'   			=> esc_html__( 'Header 2', 'modave' ),
							'3' 			=> esc_html__( 'Header 3', 'modave' ),
							'4'				=> esc_html__( 'Header 4', 'modave' ),
							'5'				=> esc_html__( 'Header 5', 'modave' ),
						),
						'inline'   			=> 	true,
						'multiple' 			=> 	false,
						'std'				=>	'default',
					),
					array(
						'name'  			=> esc_html__( 'Header Transparent', 'modave' ),
						'label_description' => esc_html__( 'Enable or disable the header transparent/overlay.', 'modave' ),
						'id'    			=> $prefix . 'header_transparent',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'	=> esc_html__( 'Default', 'modave' ),
							'enable' 	=> esc_html__( 'Enable', 'modave' ),
							'disable'  	=> esc_html__( 'Disable', 'modave' ),
						),
						'std'			=> 'default',
						'multiple' 		=> false,
					),
					array(
						'name'  			=> esc_html__( 'Header Transparent Color', 'modave' ),
						'label_description' => esc_html__( 'Select header color schema.', 'modave' ),
						'id'    			=> $prefix . 'header_transparent_color',
						'type'  			=> 'button_group',
						'options'  			=> array(
							'default'	=> esc_html__( 'Default', 'modave' ),
							'light'    	=> esc_html__( 'Light', 'modave' ),
							'dark' 		=> esc_html__( 'Dark', 'modave' ),
						),
						'std'			=> 'default',
						'multiple' 		=> false,
					),
				),
			);
			return apply_filters( 'pls_header_meta_options' , $options);
		}
		
		public function page_title_options(){		
			$prefix	= $this->prefix;
			/* Title Options */
			$options = array(
				'title' 		=> esc_html__( 'Page Title', 'modave' ),
				'id' 			=> $prefix.'page_title_options',
				'post_types' 	=> array( 'page' ),
				'tab' 			=> true,
				'fields' 		=> 	array(
					array(
						'name'  			=> esc_html__( 'Page Title', 'modave' ),
						'label_description' => esc_html__( 'Enable or disable the page title section.', 'modave' ),
						'id'    			=> $prefix.'page_title',
						'type'     			=> 'button_group',
						'options'  			=> array(
							'default'	=> esc_html__( 'Default', 'modave' ),
							'enable'	=> esc_html__( 'Enable', 'modave' ),
							'disable'	=> esc_html__( 'Disable', 'modave' ),
						),
						'inline'   		=> 	true,
						'multiple' 		=> 	false,
						'std' 			=> 'default',
					),
					array(
						'name'  			=> esc_html__( 'Heading', 'modave' ),
						'label_description' => esc_html__( 'Enable or disable the heading.', 'modave' ),
						'id'    			=> $prefix.'page_heading',
						'type'     			=> 'button_group',
						'options'  			=> array(
							'default'	=> esc_html__( 'Default', 'modave' ),
							'enable' 	=> esc_html__( 'Enable', 'modave' ),
							'disable'  	=> esc_html__( 'Disable', 'modave' ),
						),
						'inline'   		=> 	true,
						'multiple' 		=> 	false,
						'std' 			=> 'default',
					),
					array(
						'name' 				=> esc_html__( 'Custom Header Title', 'modave' ),
						'label_description'	=> esc_html__( 'Alter the main title display.', 'modave' ),
						'desc' 				=> '',
						'id' 				=> $prefix . 'custom_page_title',
						'type' 				=> 'text',
					),
					array(
						'name' 				=> esc_html__( 'Sub Title', 'modave' ),
						'label_description'	=> esc_html__( 'Enter page subtitle.', 'modave' ),
						'desc' 				=> '',
						'id' 				=> $prefix . 'page_subtitle',
						'type' 				=> 'text',
					),
					array(
						'name'  			=> esc_html__( 'Title Style', 'modave' ),
						'label_description' => esc_html__( 'Select a page title style.', 'modave' ),
						'id'    			=> $prefix.'page_title_layout',
						'type'     			=> 'button_group',
						'options'  			=> array(
							'default'	=> esc_html__( 'Default', 'modave' ),
							'title-centered' => esc_html__( 'Title Centered', 'modave' ),
							'center'	=> esc_html__( 'Centered', 'modave' ),
							'left' 		=> esc_html__( 'Left', 'modave' ),
						),
						'inline'   		=> 	true,
						'multiple' 		=> 	false,
						'std' 			=> 'default',
					),
					array(
						'name'  			=> esc_html__( 'Header Font Size', 'modave' ),
						'label_description' => esc_html__( 'Select page title font size.', 'modave' ),
						'id'    			=> $prefix.'title_font_size',
						'type'     			=> 'button_group',
						'options'  			=> array(
							'default'	=> esc_html__( 'Default', 'modave' ),
							'small'    	=> esc_html__( 'Small', 'modave' ),
							'large'		=> esc_html__( 'Large', 'modave' ),						
						),
						'inline'   		=> 	true,
						'multiple' 		=> 	false,
						'std'			=> 'default',
					),
					array(
						'name' 				=> esc_html__( 'Padding Top', 'modave' ),
						'label_description'	=> esc_html__( 'Enter padding top in pixel', 'modave' ),
						'id' 				=> $prefix.'title_padding_top',
						'type' 				=> 'number',
					),
					array(
						'name' 				=> esc_html__( 'Padding Bottom', 'modave' ),
						'label_description' => esc_html__( 'Enter padding bottom in pixel', 'modave' ),
						'id' 				=> $prefix.'title_padding_bottom',
						'type' 				=> 'number',
					),
					array(
						'name'  			=> esc_html__( 'Background Color', 'modave' ),
						'label_description' => esc_html__( 'Select a background color for title.', 'modave' ),
						'id'    			=> $prefix.'title_bg_color',
						'type'  			=> 'color',
					),
					array(
						'name' 				=> esc_html__( 'Color', 'modave' ),
						'label_description'	=> esc_html__( 'Select a title color.', 'modave' ),
						'desc' 				=> '',
						'id' 				=> $prefix.'title_color',
						'type'     			=> 'button_group',
						'options'  			=> array(
							'default'	=> esc_html__( 'Default', 'modave' ),
							'light'    	=> esc_html__( 'Light', 'modave' ),
							'dark' 		=> esc_html__( 'Dark', 'modave' ),
						),
						'inline'   		=> 	true,
						'multiple' 		=> 	false,
						'std' 			=> 'default',
					),
					array(
						'name'  			=> esc_html__( 'Background Image', 'modave' ),
						'label_description' => esc_html__( 'Select a custom image for your main title.', 'modave' ),
						'id'    			=> $prefix.'title_bg_img',
						'type'  			=> 'single_image',
					),
					array(
						'name'  			=> esc_html__( 'Position', 'modave' ),
						'label_description' => esc_html__( 'Select your background image position.', 'modave' ),
						'id'    			=> $prefix.'title_bg_position',
						'type'     			=> 'select',
						'options'  			=> array(
							'default'		=> esc_html__( 'Default', 'modave' ),
							'left-top'      => esc_html__( 'Left Top', 'modave' ),
							'left-center'   => esc_html__( 'Left Center', 'modave' ),
							'left-bottom' 	=> esc_html__( 'Left Bottom', 'modave' ),
							'right-top'		=> esc_html__( 'Right Top', 'modave' ),
							'right-center'	=> esc_html__( 'Right Center', 'modave' ),
							'right-bottom'	=> esc_html__( 'Right Bottom', 'modave' ),
							'center-top'	=> esc_html__( 'Center Top', 'modave' ),
							'center-center'	=> esc_html__( 'Center Center', 'modave' ),
							'center-bottom'	=> esc_html__( 'Center Bottom', 'modave' ),
						),
						'inline'   			=> 	true,
						'multiple' 			=> 	false,
						'std'				=>	'default',
					),
					array(
						'name'  			=> esc_html__( 'Attachment', 'modave' ),
						'label_description' => esc_html__( 'Select your background image attachment.', 'modave' ),
						'id'    			=> $prefix.'title_bg_attachment',
						'type'     			=> 'select',
						'options'  			=> array(
							'default'	=> esc_html__( 'Default', 'modave' ),
							'scroll'    => esc_html__( 'Scroll', 'modave' ),
							'fixed' 	=> esc_html__( 'Fixed', 'modave' ),
						),
						'inline'   			=> 	true,
						'multiple' 			=> 	false,
						'std'				=>	'default',
					),
					array(
						'name'  			=> esc_html__( 'Repeat', 'modave' ),
						'label_description' => esc_html__( 'Select your background image repeat.', 'modave' ),
						'id'    			=> $prefix.'title_bg_repeat',
						'type'     			=> 'select',
						'options'  			=> array(
							'default'	=> esc_html__( 'Default', 'modave' ),
							'no-repeat'	=> esc_html__( 'No-Repeat', 'modave' ),
							'repeat'    => esc_html__( 'Repeat', 'modave' ),
							'repeat-x'  => esc_html__( 'Repeat-X', 'modave' ),
							'repeat-y' 	=> esc_html__( 'Repeat-Y', 'modave' ),
						),
						'inline'   			=> 	true,
						'multiple' 			=> 	false,
						'std'				=>	'default',
					),
					array(
						'name'  			=> esc_html__( 'Size', 'modave' ),
						'label_description' => esc_html__( 'Select your background image size.', 'modave' ),
						'id'    			=> $prefix.'title_bg_size',
						'type'     			=> 'select',
						'options'  			=> array(
							'default'	=> esc_html__( 'Default', 'modave' ),
							'auto'		=> esc_html__( 'Auto', 'modave' ),
							'cover'     => esc_html__( 'Cover', 'modave' ),
							'contain'   => esc_html__( 'contain', 'modave' ),
						),
						'inline'   			=> 	true,
						'multiple' 			=> 	false,
						'std'				=>	'default',
					),
					array(
						'name' 				=> esc_html__( 'Background Opacity', 'modave' ),
						'label_description' => esc_html__( 'Enter a number between 0.1 to 1. Default is 0.5.', 'modave' ),
						'desc' 				=> '',
						'id' 				=> $prefix . 'title_bg_opacity',
						'type' 				=> 'number',
						'min'  				=> 0,
						'max'  				=> 1,
						'step' 				=> 0.1,
					),
					array(
						'type'     			=> 'button_group',
						'id'    			=> $prefix.'breadcrumb',
						'name'  			=> esc_html__( 'Show Breadcrubm', 'modave' ),
						'label_description' => esc_html__( 'Enable or disable the page title breadcrumbs.', 'modave' ),
						'options'  			=> array(
							'default'   => esc_html__( 'Default', 'modave' ),
							'enable' 	=> esc_html__( 'Enable', 'modave' ),
							'disable'  	=> esc_html__( 'Disable', 'modave' ),
						),
						'std' 				=> 'default',
					),	
				),
			);
			return apply_filters( 'pls_page_title_meta_options' , $options);
		}
		
		public function footer_options(){
			$prefix = $this->prefix;
			$custom_blocks	= pls_get_posts_by_post_type( 'block' );
			/* Footer Options */
			$options = array(
				'title' 		=> esc_html__( 'Footer', 'modave' ),
				'id' 			=> $prefix .'footer_options',
				'post_types' 	=> array( 'post', 'page', 'product' ),
				'tab' 			=> true,
				'fields' 		=> 	array(
					array(
						'name'  			=> esc_html__( 'Footer', 'modave' ),
						'label_description' => esc_html__( 'Select footer.', 'modave' ),
						'id'    			=> $prefix.'site_footer',
						'type'     			=> 'select',
						'options'  			=> array(
													'default'	=> esc_html__( 'Default', 'modave' ),
													'none'		=> esc_html__( 'None', 'modave' ) 
												) +
												$custom_blocks
						,
						'inline'   			=> 	true,
						'multiple' 			=> 	false,
						'std'				=>	'default',
					),
					array(
						'name'  			=> esc_html__( 'Copyright', 'modave' ),
						'label_description' => esc_html__( 'Enable or disable copyright.', 'modave' ),
						'id'    			=> $prefix.'footer_copyright',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'	=> esc_html__( 'Default', 'modave' ),
							'enable' 	=> esc_html__( 'Enable', 'modave' ),
							'disable'  	=> esc_html__( 'Disable', 'modave' ),
						),
						'std'				=> 'default',
					),
				),
			);
			return apply_filters( 'pls_footer_meta_options' , $options);
		}
		
		public function register_metaboxes(){
			$meta_boxes = $this->meta_boxes();
			// Make sure there's no errors when the plugin is deactivated or during upgrade
			if (class_exists( 'RW_Meta_Box' )) {
					foreach ($meta_boxes as $meta_box) {
							new RW_Meta_Box($meta_box);
					}
			}
		}
		public function admin_js_var(){
			$meta_boxes = $this->meta_boxes();
			$meta_box_id = '';
			foreach ($meta_boxes as $box) {
				if ( !isset($box['tab']) ) {
					continue;
				}
				if ( !empty( $meta_box_id ) ) {
					$meta_box_id .= ',';
				}
				$meta_box_id .= '#' . $box['id'];
			}
			$pls_option_string 	= apply_filters( 'pls_theme_name', PLS_THEME_NAME ).' '.esc_html__( 'Options', 'modave' );
			wp_enqueue_script( 'pls-meta-box', PLS_FRAMEWORK_URI . '/admin/assets/js/meta-box.js' );
			$pls_meta_data		= apply_filters( 'pls_meta_data_arg', array( 
									'meta_box_ids'		=> $meta_box_id,
									'meta_box_title'	=> $pls_option_string,
								) );
			
			wp_localize_script( 'pls-meta-box' , 'pls_meta_data', $pls_meta_data );
		}		
	}

	/**
	 * Initialize class object with 'get_instance()' method
	 */
	PLS_Metabox::get_instance();

endif;