<?php 
/**
 * Action/filter hooks used for woocommerce functions/templates.
 *
 * @package /inc
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

add_theme_support( 'woocommerce' );
add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );
add_filter( 'woocommerce_show_page_title', '__return_false' );
add_filter( 'body_class', 'pls_body_woocommerce_classes' );

/**
 * PLS Header
 *
 * @see pls_empty_mini_cart_button()
 */
add_action( 'pls_after_empty_mini_cart', 'pls_empty_mini_cart_button', 20 );

/**
 * Content Wrappers
 *
 * @see pls_output_content_wrapper()
 * @see pls_output_content_wrapper_end()
 * @see pls_reset_loop()
 */
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );

add_action( 'woocommerce_before_main_content', 'pls_output_content_wrapper', 10 );
add_action( 'woocommerce_after_main_content', 'pls_output_content_wrapper_end', 10 );

add_action( 'woocommerce_after_shop_loop', 'pls_reset_loop', 999 );

/**
 * Products Loop
 *
 * @see pls_woocommerce_before_shop_loop()
 * @see pls_wc_loop_product_view()
 * @see pls_wc_loop_show_product_per_page()
 * @see pls_wc_active_filter_widgets()
 * @see pls_woocommerce_clear_filters_btn()
 * @see pls_loop_product_wrapper()
 * @see pls_before_shop_loop_item_title()
 * @see pls_wc_product_labels()
 * @see pls_wc_product_loop_quick_view_button()
 * @see pls_wc_template_loop_product_thumbnail()
 * @see pls_woocommerce_shop_loop_item_title()
 * @see pls_woocommerce_loop_product_info_wrapper()
 * @see pls_wc_product_loop_categories()
 * @see woocommerce_template_loop_price()
 * @see pls_woocommerce_product_loop_wishlist_button()
 * @see pls_woocommerce_product_loop_compare_button()
 * @see pls_wc_stock_progress_bar()
 * @see pls_woocommerce_after_shop_loop_item()
 * @see pls_woocommerce_product_wrapper_end()
 */
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );

add_action( 'woocommerce_before_shop_loop', 'pls_wc_shop_loop_header', 20 );
add_action( 'pls_wc_shop_loop_header_filter', 'pls_wc_off_canvas_sidebar', 10 );
add_action( 'pls_wc_shop_loop_header_filter', 'pls_product_filter_top', 15 );
add_action( 'pls_wc_shop_loop_header_filter', 'pls_wc_onsale_product', 20 );
add_action( 'pls_wc_shop_loop_header_layout', 'pls_wc_loop_product_view', 10 );
add_action( 'pls_wc_shop_loop_header_sorting', 'pls_wc_loop_show_product_per_page', 10 );
add_action( 'pls_wc_shop_loop_header_sorting', 'woocommerce_catalog_ordering', 20 );
add_action( 'pls_wc_shop_loop_header_after', 'woocommerce_result_count', 10 );
add_action( 'pls_wc_shop_loop_header_after', 'pls_wc_active_filter_widgets', 20 );
add_action( 'pls_wc_shop_loop_header_after', 'pls_wc_clear_filters_btn', 25 );
add_action( 'pls_wc_shop_loop_header_bottom', 'pls_wc_shop_top_filter_widgets', 10 );
add_action( 'woocommerce_before_shop_loop_item_title', 'pls_wc_product_labels', 10 );
add_action( 'woocommerce_before_shop_loop_item_title', 'pls_wc_template_loop_product_thumbnail', 10 );
add_action( 'woocommerce_before_shop_loop_item_title', 'pls_wc_product_sale_countdown', 15 );
add_action( 'woocommerce_shop_loop_item_title', 'pls_wc_product_loop_categories', 9 );
add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 15 );
add_action( 'pls_wc_product_loop_cart_button', 'woocommerce_template_loop_add_to_cart', 10 );
add_action( 'woocommerce_after_shop_loop_item', 'pls_wc_stock_progress_bar', 15 );

/**
 * Categories Loop.
 */
add_action( 'woocommerce_before_subcategory_title', 'woocommerce_template_loop_category_link_close', 20 );
add_action( 'woocommerce_shop_loop_subcategory_title', 'woocommerce_template_loop_category_link_open', 5 );

/**
 * Single Product
 */
remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
//remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5);
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
 
/**
 * Single Products Summary Div.
 *
 * @see pls_wc_single_product_top()
 * @see pls_template_breadcrumb()
 * @see pls_wc_single_product_navigation()
 * @see pls_wc_single_product_share()
 * @see pls_output_product_labels()
 * @see pls_wc_single_product_video_btn()
 * @see pls_wc_single_product_degree360_btn()
 * @see pls_single_product_photoswipe_btn()
 * @see pls_single_product_before_price()
 * @see pls_product_navigation_share()
 * @see woocommerce_template_single_rating()
 * @see pls_wc_product_sale_countdown()
 * @see pls_single_product_after_price()
 * @see pls_single_product_price_discount()
 * @see pls_wc_single_product_brands()
 * @see pls_wc_single_product_size_chart()
 * @see pls_output_recently_viewed_products()
 */
 
add_action( 'pls_page_title', 'pls_wc_single_product_top', 10 );
add_action( 'pls_wc_single_product_top', 'pls_template_breadcrumb', 10 );
add_action( 'pls_wc_single_product_top', 'pls_wc_single_product_navigation', 20 );
add_action( 'pls_wc_product_gallery_bottom', 'pls_wc_single_product_video_btn', 10 );
add_action( 'pls_wc_product_gallery_bottom', 'pls_wc_single_product_degree360_btn', 15 );
add_action( 'woocommerce_single_product_summary', 'pls_wc_single_product_category', 4 ) ;
add_action( 'woocommerce_single_product_summary', 'pls_wc_single_product_rating_info', 8 ) ;
add_action( 'pls_wc_single_product_rating_info', 'woocommerce_template_single_rating', 5 ) ;
add_action( 'pls_wc_single_product_rating_info', 'pls_wc_single_product_sold_count', 10 );
add_action( 'woocommerce_single_product_summary', 'pls_wc_single_product_price_info', 10 ) ;
add_action( 'woocommerce_single_product_summary', 'pls_wc_single_product_availability', 10 ) ;
add_action( 'pls_wc_single_product_price_info', 'woocommerce_template_single_price', 5 ) ;
add_action( 'pls_wc_single_product_price_info', 'pls_wc_single_product_sale_label', 10 ) ;
add_action( 'woocommerce_single_product_summary', 'pls_wc_single_product_visitor_count', 21 );
add_action( 'woocommerce_single_product_summary', 'pls_single_product_summary_separator', 21 );
add_action( 'woocommerce_single_product_summary', 'pls_wc_product_sale_countdown', 25 );
add_action( 'woocommerce_single_product_summary', 'pls_wc_single_product_stock_progress_bar', 25 );
add_action( 'woocommerce_single_product_summary', 'pls_single_product_summary_separator', 25 );
add_action( 'woocommerce_after_add_to_cart_button', 'pls_wc_single_product_wishlist_button', 10 );
add_action( 'woocommerce_after_add_to_cart_button', 'pls_wc_single_product_compare_button', 10 );
add_action( 'woocommerce_single_product_summary', 'pls_wc_single_product_delivery_return', 36 );
add_action( 'woocommerce_single_product_summary', 'pls_wc_single_product_ask_question', 36 );
add_action( 'woocommerce_single_product_summary', 'pls_wc_single_product_size_chart', 36 );
add_action( 'woocommerce_single_product_summary', 'pls_wc_single_product_share', 36 );
add_action( 'woocommerce_single_product_summary', 'pls_wc_single_product_estimated_delivery', 37 );
add_action( 'woocommerce_single_product_summary', 'pls_wc_single_product_return_refund', 37 );
add_action( 'woocommerce_single_product_summary', 'pls_wc_single_product_store_location', 37 );
add_action( 'woocommerce_single_product_summary', 'pls_wc_single_product_trust_badge', 42 );
add_action( 'woocommerce_product_meta_end', 'pls_wc_single_product_brands', 15 );

/* Quick Buy*/
add_action( 'woocommerce_after_add_to_cart_button', 'pls_wc_add_quick_buy_pid');
add_action( 'woocommerce_after_add_to_cart_button', 'pls_wc_add_quick_buy_button', 99 );
add_filter( 'woocommerce_add_to_cart_redirect', 'pls_wc_quick_buy_redirect', 99 );

/**
 * Quantity Buttons
 *
 * @see pls_wc_quantity_button_minus()
 * @see pls_wc_quantity_button_plus()
 */
add_action( 'woocommerce_before_quantity_input_field', 'pls_wc_quantity_button_minus', 10 );
add_action( 'woocommerce_after_quantity_input_field', 'pls_wc_quantity_button_plus', 10 );

/**
 * Element Single Products Summary Div.
 *
 * @see pls_wc_single_product_category()
 * @see woocommerce_template_single_title()
 * @see pls_wc_single_product_rating_info()
 * @see woocommerce_template_single_rating()
 * @see pls_wc_single_product_sold_count()
 * @see pls_wc_single_product_availability()
 * @see pls_wc_single_product_price_info()
 * @see woocommerce_template_single_price()
 * @see pls_wc_single_product_sale_label()
 * @see woocommerce_template_single_add_to_cart()
 * @see pls_wc_single_product_view_full_details()
 */
add_action( 'pls_element_single_product_summary', 'pls_wc_single_product_category', 5 );
add_action( 'pls_element_single_product_summary', 'woocommerce_template_single_title', 10 );
add_action( 'pls_element_single_product_summary', 'pls_wc_single_product_rating_info', 15 ) ;
add_action( 'pls_wc_single_product_rating_info', 'woocommerce_template_single_rating', 5 ) ;
add_action( 'pls_wc_single_product_rating_info', 'pls_wc_single_product_sold_count', 10 );
add_action( 'pls_element_single_product_summary', 'pls_wc_single_product_availability', 20 ) ;
add_action( 'pls_element_single_product_summary', 'pls_wc_single_product_price_info', 25 ) ;
add_action( 'pls_wc_single_product_price_info', 'woocommerce_template_single_price', 5 ) ;
add_action( 'pls_wc_single_product_price_info', 'pls_wc_single_product_sale_label', 10 ) ;
add_action( 'pls_element_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
add_action( 'pls_element_single_product_summary', 'pls_wc_single_product_view_full_details', 35 );


/**
 * My Account Page
 *
 * @see pls_before_account_navigation()
 * @see pls_after_account_navigation()
 * @see pls_wc_before_account_orders()
 * @see pls_wc_before_account_downloads()
 * @see pls_wc_my_account_my_address_description()
 * @see pls_wc_myaccount_edit_account_heading()
 */
add_action( 'woocommerce_before_account_navigation', 'pls_before_account_navigation' );
add_action( 'woocommerce_after_account_navigation', 'pls_after_account_navigation' );
add_action( 'woocommerce_before_account_orders', 'pls_wc_before_account_orders', 10 );
add_action( 'woocommerce_before_account_downloads', 'pls_wc_before_account_downloads', 10 );
add_filter( 'woocommerce_my_account_my_address_description', 'pls_wc_my_account_my_address_description', 10 );
add_action( 'woocommerce_before_edit_account_form', 'pls_wc_myaccount_edit_account_heading', 10 );

/**
 * Cart Page
 *
 * @see pls_wc_free_shipping_bar()
 * @see pls_wc_cart_page_wrapper()
 * @see pls_wc_cart_page_wrapper_end()
 * @see woocommerce_cross_sell_display()
 */
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );

add_action( 'woocommerce_before_cart_table', 'pls_wc_free_shipping_bar', 5 );
add_action( 'woocommerce_before_cart', 'pls_wc_cart_page_wrapper', 10 );
add_action( 'woocommerce_after_cart', 'pls_wc_cart_page_wrapper_end', 10 );
add_action( 'woocommerce_after_cart', 'woocommerce_cross_sell_display', 20 );

 /**
 * Mini Cart
 *
 * @see pls_wc_free_shipping_bar()
 * @see pls_wc_mincart_footer_items()
 * @see pls_wc_mincart_totals()
 */
remove_action( 'woocommerce_widget_shopping_cart_total', 'woocommerce_widget_shopping_cart_subtotal', 10 );

add_action( 'pls_wc_before_mini_cart', 'pls_wc_free_shipping_bar', 10 );
add_action( 'woocommerce_widget_shopping_cart_before_buttons', 'pls_wc_mincart_footer_items', 10 );
add_action( 'woocommerce_widget_shopping_cart_before_buttons', 'pls_wc_mincart_totals', 20 );

/**
 * Footer
 *
 * @see pls_wc_login_signup_popup()
 * @see pls_wc_minicart_slide()()
 * @see pls_wc_canvas_sidebar()
 * @see pls_wc_single_product_360_degree_content()
 * @see pls_wc_sticky_add_to_cart_button()
 */
add_action( 'pls_body_bottom', 'pls_wc_login_signup_popup', 50 );
add_action( 'pls_body_bottom', 'pls_wc_minicart_slide', 55 );
add_action( 'pls_body_bottom', 'pls_wc_canvas_sidebar', 60 );
add_action( 'pls_body_bottom', 'pls_wc_quickview_popup', 62 );
add_action( 'pls_body_bottom', 'pls_wc_single_product_360_degree_content', 65 );
add_action( 'pls_body_bottom', 'pls_wc_sticky_add_to_cart_button', 70 );
add_action( 'pls_body_bottom', 'pls_wc_aks_question_popup_form', 80 );