<?php
/**
 * Template part for displaying text message with slider on header topbar
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @author 	PressLayouts
 * @package /template-parts/header
 * @since 1.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$text_sliders = pls_get_option( 'header-text-slider', array(
						'Free shipping on all orders over <span class="primary-color">$20.00</span>',
						'Free shipping on all orders over <span class="primary-color">$50.00</span>',
						'Free shipping on all orders over <span class="primary-color">$80.00</span>' 
					)
				);
if( empty( $text_sliders ) ){
	return;
}
$slider_settings['slider_navigation'] 		= false;
$slider_settings['slider_autoplay'] 		= 'yes';
$slider_settings['slider_loop'] 			= 'yes';
$slider_settings['slider_autoplay_speed'] 	= 2000;
$slider_settings['slider_autoplay_delay'] 	= 1000;
$slider_settings['slider_dots'] 			= 0;
$slider_settings['slides_to_show'] 			= 1;
$slider_settings['slides_to_show_tablet'] 	= 1;
$slider_settings['slides_to_show_mobile'] 	= 1;
$slider_options = pls_slider_attributes( $slider_settings );
?>	
<span class="pls-header-text-slider swiper pls-slider">
	<div class="pls-header-text-slider-content swiper-wrapper" data-slider_options="<?php echo esc_attr($slider_options); ?>">
		<?php foreach( $text_sliders as $slider_text ){
			if( empty( trim( $slider_text ) ) ){
				continue;
			} ?>
			<div class="swiper-slide">
				<div class="pls-slider-text"><?php echo wp_kses_post( $slider_text ); ?></div>
			</div>
		<?php } ?>
	</div>
</span>