<?php
/**
 * Displays the post entry header title
 *
 * @author 	PressLayouts
 * @package /template-parts/post-loop
 * @since 1.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! pls_get_loop_prop( 'blog-post-title' ) ) {
	return;
}

$title = get_the_title();

if ( ! empty( $title ) ) {
    echo '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . esc_html( $title ) . '</a></h2>';
} else {
    echo '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . esc_html__( 'Read More', 'modave' ). '</a></h2>';
}