<?php
/**
 * Displays the post entry highlight
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @author 	PressLayouts
 * @package /template-parts/single-post
 * @since 1.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$meta_values = pls_get_loop_prop( 'specific-post-meta' );

if( ! pls_get_loop_prop( 'post-meta' ) || empty( $meta_values ) ) {
	return;
}
?>
<div class="entry-meta">
	
	<?php foreach ( $meta_values as $meta_value ) :

		switch ( $meta_value ) {
			case 'post-author': ?>	
				<span class="author-link vcard">
					<?php esc_html_e( 'by', 'modave' ); ?>
					<?php echo the_author_posts_link(); ?>
				</span> 
				<?php					
				break;
			case 'post-date': 					
				$format = apply_filters( 'pls_post_date_format', 'M j, Y' );?>					
				<span class="posted-date">
					<a href="<?php echo esc_url( get_permalink() );?> "><?php echo get_the_date( $format ); ?></a>
				</span>	<?php					
				break;
			default:				
		}
	endforeach; ?>
</div>