<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Check if the product is a valid WooCommerce product and ensure its visibility before proceeding.
if ( ! is_a( $product, WC_Product::class ) || ! $product->is_visible() ) {
	return;
}

$product_style		= pls_get_loop_prop( 'product-style' );
$product_view_mode	= pls_get_loop_prop( 'product_view_mode' );
$product_view 		= pls_get_loop_prop( 'products_view' );
$count 				= (int) pls_get_loop_prop( 'count' );
$classes 			= pls_product_loop_classes();

if( 'horizontal' == $product_view_mode ){
	$product_style = 'product-horizontal';
}

if( 'grid-list' == $product_view ){
	$product_style = 'product-list-view';
}

if( 'products-widget' == $product_style || 'products-card' == $product_style ){
	$product_style = 'product-widget';
}
?>

<div <?php wc_product_class( $classes, $product ); ?>>	 
	<?php wc_get_template_part( 'content', $product_style ); ?>	 
</div>
<?php
pls_set_loop_prop( 'count', $count);