<?php
/**
 * Product header
 *
 * @package pls
 */

defined( 'ABSPATH' ) || exit;
$has_filter = pls_get_option( 'shop-page-off-canvas-sidebar', 0 ) ? ' pls-has-filter' : '';
?>

<div class="pls-products-header">
	<div class="pls-products-header-controls">		
		<div class="pls-phcol pls-products-header-filter<?php echo esc_attr($has_filter); ?>">
			<?php 
			/**
			 * Hook: pls_wc_shop_loop_header_filter.
			 *
			 * @hooked pls_wc_off_canvas_sidebar - 10
			 * @hooked pls_product_filter_top - 20
			 */
			do_action( 'pls_wc_shop_loop_header_filter' );
			?>
		</div>
		<div class="pls-phcol pls-products-header-layout">
			<?php 
			/**
			 * Hook: pls_wc_shop_loop_header_layout.
			 *
			 * @hooked pls_wc_loop_product_view - 10
			 */
			do_action( 'pls_wc_shop_loop_header_layout' );
			?>
		</div>
		<div class="pls-phcol pls-products-header-sorting">
			<?php 
			/**
			 * Hook: pls_wc_shop_loop_header_sorting.
			 *
			 * @hooked pls_wc_loop_show_product_per_page - 10
			 * @hooked woocommerce_catalog_ordering - 20
			 */
			do_action( 'pls_wc_shop_loop_header_sorting' );
			?>
		</div>
	</div>
	<div class="pls-products-active-filters">
		<?php 
		/**
		 * Hook: pls_woocommerce_shop_loop_header_after.
		 *
		 * @hooked woocommerce_result_count - 10
		 * @hooked pls_wc_woocommerce_result_count - 20
		 */
		do_action( 'pls_wc_shop_loop_header_after' );
		?>
	</div>
	<?php 
	/**
	 * Hook: pls_wc_shop_loop_header_bottom.
	 *
	 * @hooked woocommerce_result_count - 10
	 */
	do_action( 'pls_wc_shop_loop_header_bottom' );
	?>
</div>