"use strict";var AttributeValue=function(){function AttributeValue(id,name,color){this.id=id;this.name=name;this.color=color}return AttributeValue}();var Attribute=function(){function Attribute(id,name,values){if(values===void 0){values=[]}this.id=id;this.name=name;this.values=values}Attribute.all=function(){return colorizer.attributes};return Attribute}();
'use strict';Vue.directive('sortable',{inserted:function inserted(el,binding){new Sortable(el,binding.value||{})}});Vue.component('colorizer-editor',{data:function data(){return{model:new EditorModel}},template:'\n        <div class="colorizer-editor">\n            <resizable-canvas ref="canvas" :width="600" :height="500"></resizable-canvas>\n            <div class="panel">\n                <div class="background">\n                    <button type="button" @click="updateBackground">Select background</button>\n                </div>\n                <ul class="layers" v-sortable="{handle: \'.layer-bar\', onEnd: sorting }">\n                    <layer v-for="layer in model.layers"\n                           :item="layer"\n                           :key="layer.id"\n                           :model="layer"\n                           @partSelected="(layerId, partId) => model.selectPart(layerId, partId)"\n                           @deleteLayer="(id) => model.deleteLayer(id)"></layer>\n                </ul>\n                <button type="button" class="add-new" @click="(id) => model.addLayer(id)" ref="newLayer">Add a layer</button>\n                <span style="float: right">\n                  <button type="button" class="safe" @click="downloadExport">Export</button>\n                  <label type="button" class="button dangerous">\n                      Import\n                      <input class="hidden" type="file" @change="importFromFile" accept=".json">\n                  </label>\n                </span>\n            </div>\n        </div>\n    ',methods:{sorting:function sorting(event){this.model.moveLayer(event.oldIndex,event.newIndex)},updateBackground:function updateBackground(){var _this=this;imageSelect(function(url){return _this.model.changeBackground(url)})},downloadExport:function downloadExport(){function download(filename,text){var element=document.createElement('a');element.setAttribute('href','data:text/plain;charset=utf-8,'+encodeURIComponent(text));element.setAttribute('download',filename);element.style.display='none';document.body.appendChild(element);element.click();document.body.removeChild(element)}download('colorizer-export.json',this.model.toJson())},importFromFile:function importFromFile(e){var input=e.target;var fileReader=new FileReader;var self=this;fileReader.readAsText(input.files[0]);fileReader.onloadend=function(event){var text=event.target.result;try{var parsed=JSON.parse(text);var model=EditorModel.fromObject(parsed);self.model=model;self.$refs.canvas.setup(model);self.$emit('modelChanged',model)}catch(e){console.log(e);alert('Invalid import file!')}}},setModel:function setModel(model){this.model=model;this.$refs.canvas.setup(this.model)}}});
'use strict';Vue.component('colorizer',{data:function data(){var models=colorizer.models.length?JSON.parse(colorizer.models).map(EditorModel.fromObject):[];while(colorizer.images.length>models.length){models.push(new EditorModel(colorizer.images[models.length]))}return{images:colorizer.images,models:models,selected:null}},template:'\n        <div v-if="images" class="colorizer">\n            <div class="images-select">\n                <span @click="changeSelected(index)" :class="{selected: index === selected}" v-for="(src, index) in images" :key="index"><img :src="src"></span>\n            </div>\n            <colorizer-editor @modelChanged="(m) => models[selected] = m" ref="editor" :style="{display: selected === null ? \'none\' : \'flex\'}"></colorizer-editor>\n            <input type="hidden" id="colorizer_data" name="colorizer_data" value="">\n        </div>\n        <div v-else="!images">\n            Add images (product image and gallery) first!\n        </div>\n    ',methods:{changeSelected:function changeSelected(index){this.selected=index;this.$refs.editor.setModel(this.models[index])}},mounted:function mounted(){if(this.images){var self=this;document.getElementById('post').addEventListener('submit',function(e){document.getElementById('colorizer_data').value='['+self.models.map(function(m){return m.toJson()}).join(',')+']'},false)}}});
'use strict';Vue.component('layer-part',{props:{model:Object,attributes:Array},template:'\n    <div class="layer-part"\n        :class="{active: model.active}"\n        @click="clicked">\n      <div class="layer-part-content">\n        <div class="image-wrapper">\n          <span class="section-title">\n            Image:\n          </span>\n          <img @click="updateImage"  :src="model.src" :class="{ filled: model.src }" class="image-preview">\n        </div>\n        <div class="attributes">\n          <span class="section-title">\n            Hidden when:\n          </span>\n          <div class="attribute"\n               v-for="attribute in attributes"\n               :item="attribute">\n               <span class="attribute-name">\n                {{ attribute.name }}\n               </span>\n               <select :ref="\'visibleWhen\' + attribute.id" multiple @change="updateVisibleWhen(attribute)">\n                <option v-for="value in attribute.values"\n                        :selected=\'model.hiddenWhen.has(attribute.id) && model.hiddenWhen.get(attribute.id).includes(value.id)\'\n                        :item="value"\n                        :value="value.id">\n                  {{ value.name }}\n                </option>\n               </select>\n          </div>\n        </div>\n      </div>\n      <div class="layer-part-footer">\n        <label class="visibility control">\n          <input\n                type="checkbox"\n                v-model="model.visible"\n                @change="() => model.visibilityChanged()">\n          <span class="icon"></span>\n        </label>\n        <button type="button" class="control duplicate" @click="$emit(\'duplicatePart\', model.id)">Duplicate</button>\n        <button type="button" class="control delete" @click="$emit(\'deletePart\', model.id)">Delete</button>\n      </div>\n    </div>\n  ',methods:{updateVisibleWhen:function updateVisibleWhen(attribute){var select=this.$refs['visibleWhen'+attribute.id][0];var options=select&&select.options;function HTMLOptionsCollectionToArray(options){return Array.apply(null,options)}this.model.hiddenWhen.set(attribute.id,HTMLOptionsCollectionToArray(options).filter(function(option){return option.selected}).map(function(option){return parseInt(option.value)}))},updateImage:function updateImage(){var _this=this;imageSelect(function(url){return _this.model.selectImage(url)})},clicked:function clicked(e){if(e.target.tagName!='DIV')return false;this.$emit('partSelected',this.model.layerId,this.model.id)}}});
'use strict';var attributes=Attribute.all(),colorizingAttributes=attributes.filter(function(a){return a.values.some(function(v){return!!v.color})});Vue.component('layer',{props:{model:Object},data:function data(){return{opened:false,attributes:attributes,colorizingAttributes:colorizingAttributes}},template:'\n    <li class="layer"\n        v-bind:class="{ opened: opened, active: model.active }">\n      <div class="layer-bar">\n        <label class="visibility">\n          <input\n                type="checkbox"\n                v-model="model.visible"\n                @change="() => model.visibilityChanged()">\n          <span class="icon"></span>\n        </label>\n        <button type="button" @click="$emit(\'deleteLayer\', model.id)"\n                class="delete">delete</button>\n        <input\n              ref="input"\n              @focusout="leaved"\n              class="layer-name"\n              type="text"\n              v-model="model.name">\n\n        <label class="opener">\n          <input\n                type="checkbox"\n                v-model="opened"\n                class="toggle">\n        </label>\n      </div>\n      <div class="layer-content">\n        <div class="layer-content-inside">\n          <h3 class="section-title">\n          Images\n          </h3>\n          <div class="layer-parts">\n            <layer-part v-for="part in model.parts"\n                        :key="part.id"\n                        :model="part"\n                        v-on:deletePart="(id) => model.removePart(id)"\n                        v-on:duplicatePart="(id) => model.duplicatePart(id)"\n                        v-on:partSelected="(layerId, partId) => $emit(\'partSelected\', layerId, partId)"\n                        :attributes="attributes"></layer-part>\n            <div @click="() => model.addPart()" class="layer-part add-new">+</div>\n          </div>\n          <h3 class="section-title">\n          Settings\n          </h3>\n          <div class="layer-settings">\n          <label>\n          Opacity\n          <input v-model="model.opacity" type="number" min="0" max="100" step="1">\n          </label>\n          <hr>\n          <label>\n          Color opacity\n          <input v-model="model.colorOpacity" type="number" min="0" max="100" step="1">\n          </label>\n          <label>\n          Colorizing attribute\n          <select v-model="model.colorizedBy">\n            <option value="0">-</option>\n            <option v-for="attribute in colorizingAttributes" :value="attribute.id">{{ attribute.name }}</option>\n          </select>\n          </label>\n          <hr>\n          <label>\n          Background color opacity\n          <input v-model="model.backgroundOpacity" type="number" min="0" max="100" step="1">\n          </label>\n          <label>\n          Background color attribute\n          <select v-model="model.background">\n            <option value="0">-</option>\n            <option v-for="attribute in colorizingAttributes" :value="attribute.id">{{ attribute.name }}</option>\n          </select>\n          </label>\n          </div>\n        </div>\n      </div>\n    </li>\n  ',methods:{leaved:function leaved(){if(this.model.name=='')this.model.name='Layer '+this.model.id}}});
'use strict';Array.prototype.move=function(oldIndex,newIndex){if(newIndex>=this.length){var k=newIndex-this.length;while(k--+1){this.push(undefined)}}this.splice(newIndex,0,this.splice(oldIndex,1)[0])};var EditorModel=function(){function EditorModel(background){if(background===void 0){background=''}this.background=background;this.layers=[];this.nextLayerId=0;this.eventBus=new Vue}EditorModel.fromObject=function(object){var toReturn=new EditorModel;if(object.layers){object.layers=object.layers.map(function(l){return LayerModel.fromObject(l,toReturn.eventBus)})}for(var key in toReturn){if(toReturn.hasOwnProperty(key)&&object.hasOwnProperty(key)){toReturn[key]=object[key]}}return toReturn};EditorModel.prototype.toJson=function(){return JSON.stringify(this,function(key,val){if(key=='hiddenWhen'&&val instanceof Map)return Array.from(val.entries());return key==='eventBus'?void 0:val},' ')};EditorModel.prototype.addLayer=function(){var layer=new LayerModel(this.nextLayerId,this.eventBus);this.layers.push(layer);this.nextLayerId++;return layer};EditorModel.prototype.getLayer=function(id){return this.layers.find(function(l){return l.id==id})};EditorModel.prototype.moveLayer=function(oldIndex,newIndex){this.layers.move(oldIndex,newIndex)};EditorModel.prototype.deleteLayer=function(id){var index=this.layers.findIndex(function(layer){return id==layer.id});this.layers.splice(index,1);this.eventBus.$emit('layerDeleted',id)};EditorModel.prototype.selectPart=function(layerId,partId){this.layers.forEach(function(layer){return layer.selectPart(layerId,partId)});this.eventBus.$emit('partSelected',layerId,partId)};EditorModel.prototype.changeBackground=function(url){this.background=url;this.eventBus.$emit('backgroundChanged',url)};return EditorModel}();var LayerModel=function(){function LayerModel(id,eventBus){this.id=id;this.parts=[];this.nextPartId=0;this.colorizedBy=0;this.background=0;this.opacity=100;this.colorOpacity=50;this.backgroundOpacity=50;this.active=false;this.visible=true;this.eventBus=eventBus;this.name='Layer '+this.id}LayerModel.fromObject=function(object,eventBus){var toReturn=new LayerModel(0,eventBus);if(object.parts){object.parts=object.parts.map(function(p){return LayerPartModel.fromObject(p,toReturn.eventBus)})}for(var key in toReturn){if(toReturn.hasOwnProperty(key)&&object.hasOwnProperty(key)){toReturn[key]=object[key]}}return toReturn};LayerModel.prototype.addPart=function(){var id=this.nextPartId;var part=new LayerPartModel(id,this.id,this.eventBus);this.parts.push(part);this.eventBus.$emit('partAdded',this.id,id);this.nextPartId++;this.selectPart(this.id,id);this.eventBus.$emit('partSelected',this.id,id);return part};LayerModel.prototype.getPart=function(id){return this.parts.find(function(p){return p.id==id})};LayerModel.prototype.removePart=function(id){var index=this.parts.findIndex(function(part){return id==part.id});this.parts.splice(index,1);this.eventBus.$emit('partDeleted',this.id,id)};LayerModel.prototype.duplicatePart=function(id){var toDuplicate=this.parts.find(function(part){return id==part.id});var part=this.addPart();part.hiddenWhen=new Map(toDuplicate.hiddenWhen);part.x=toDuplicate.x;part.y=toDuplicate.y;part.scaleX=toDuplicate.scaleX;part.scaleY=toDuplicate.scaleY;part.rotation=toDuplicate.rotation;if(toDuplicate.src){part.selectImage(toDuplicate.src)}};LayerModel.prototype.selectPart=function(layerId,partId){if(layerId==this.id){this.parts.forEach(function(part){part.active=false;if(part.id==partId&&part.visible)part.active=true})}else{this.parts.forEach(function(part){return part.active=false})}};LayerModel.prototype.visibilityChanged=function(){this.eventBus.$emit('layerVisibilityChanged',this.id);var _iteratorNormalCompletion=true;var _didIteratorError=false;var _iteratorError=undefined;try{for(var _iterator=this.parts[Symbol.iterator](),_step;!(_iteratorNormalCompletion=(_step=_iterator.next()).done);_iteratorNormalCompletion=true){var part=_step.value;part.active=false}}catch(err){_didIteratorError=true;_iteratorError=err}finally{try{if(!_iteratorNormalCompletion&&_iterator.return){_iterator.return()}}finally{if(_didIteratorError){throw _iteratorError}}}};return LayerModel}();var LayerPartModel=function(){function LayerPartModel(id,layerId,eventBus){this.id=id;this.layerId=layerId;this.hiddenWhen=new Map;this.src=null;this.x=0;this.y=0;this.rotation=0;this.active=false;this.eventBus=eventBus;this.visible=true;this.scaleX=1;this.scaleY=1}LayerPartModel.fromObject=function(object,eventBus){var toReturn=new LayerPartModel(0,0,eventBus);if(object.hiddenWhen)object.hiddenWhen=new Map(object.hiddenWhen);for(var key in toReturn){if(toReturn.hasOwnProperty(key)&&object.hasOwnProperty(key)){toReturn[key]=object[key]}}return toReturn};LayerPartModel.prototype.selectImage=function(url){if(url){this.src=url;this.eventBus.$emit('imageChanged',this.layerId,this.id)}};LayerPartModel.prototype.visibilityChanged=function(){if(!this.visible){this.active=false}this.eventBus.$emit('partVisibilityChanged',this.layerId,this.id)};return LayerPartModel}();
'use strict';var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break}}catch(err){_d=true;_e=err}finally{try{if(!_n&&_i['return'])_i['return']()}finally{if(_d)throw _e}}return _arr}return function(arr,i){if(Array.isArray(arr)){return arr}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i)}else{throw new TypeError('Invalid attempt to destructure non-iterable instance')}}}();Vue.component('resizable-canvas',{props:{width:Number,height:Number},data:function data(){return{top:0,left:0,dragging:false,initialMouseX:0,initialMouseY:0,fabric:null,scale:100,canvasElements:{},active:null,model:{}}},template:'\n    <div @mousedown="startDrag"\n         @mouseup="stopDrag"\n         @mouseleave="stopDrag"\n         @mousemove="drag"\n         @wheel.prevent="enlarge"\n         class="canvas-wrapper">\n      <span class="scale-indicator">{{ scale }}%</span>\n      <canvas\n        ref="canvas"\n        :height="height"\n        :width="width"></canvas>\n    </div>\n  ',methods:{startDrag:function startDrag(e){if(e.target.tagName=='CANVAS')return;this.dragging=true;this.initialMouseX=parseInt(e.clientX);this.initialMouseY=parseInt(e.clientY)},stopDrag:function stopDrag(e){if(!this.dragging)return;this.dragging=false;this.left+=e.clientX-this.initialMouseX;this.top+=e.clientY-this.initialMouseY;this.moveCanvas()},drag:function drag(e){if(!this.dragging)return false;var dx=e.clientX-this.initialMouseX,dy=e.clientY-this.initialMouseY;this.moveCanvas(dy,dx);return false},resize:function resize(){var wrapperBounding=this.$el.getBoundingClientRect(),canvasBounding=this.$refs.canvas.getBoundingClientRect();this.top=(wrapperBounding.height-canvasBounding.height)/2;this.left=(wrapperBounding.width-canvasBounding.width)/2;this.moveCanvas()},moveCanvas:function moveCanvas(){var dy=arguments.length>0&&arguments[0]!==undefined?arguments[0]:0;var dx=arguments.length>1&&arguments[1]!==undefined?arguments[1]:0;var topString=this.top+dy+'px',leftString=this.left+dx+'px';this.$refs.canvas.style.top=topString;this.fabric.upperCanvasEl.style.top=topString;this.$refs.canvas.style.left=leftString;this.fabric.upperCanvasEl.style.left=leftString},enlarge:function enlarge(e){var delta=Math.max(-1,Math.min(1,e.wheelDelta||-e.detail));this.scale=Math.max(5,this.scale+delta*5);var scale=this.scale/100,transformation='scale('+scale+')';this.$refs.canvas.style.transform=transformation;this.fabric.upperCanvasEl.style.transform=transformation},centerCanvas:function centerCanvas(e){var backgroundWidth=this.fabric.getWidth(),backgroundHeight=this.fabric.getHeight();var horizontalScale=this.$el.getBoundingClientRect().width/backgroundWidth;var verticalScale=this.$el.getBoundingClientRect().height/backgroundHeight;this.scale=Math.floor(100*Math.min(1,Math.min(horizontalScale,verticalScale))/5)*5;var scale=this.scale/100,transformation='scale('+scale+')';this.$refs.canvas.style.transform=transformation;this.fabric.upperCanvasEl.style.transform=transformation;var wrapperBounding=this.$el.getBoundingClientRect();this.top=(wrapperBounding.height-backgroundHeight-2)/2;this.left=(wrapperBounding.width-backgroundWidth-2)/2;this.moveCanvas()},moveActive:function moveActive(_ref){var _ref2=_slicedToArray(_ref,2),top=_ref2[0],left=_ref2[1];var step=arguments.length>1&&arguments[1]!==undefined?arguments[1]:1;if(this.active){this.active.set({'left':this.active.left+top*step,'top':this.active.top+left*step});this.active.dirty=true}},changeBackground:function changeBackground(url){var canvas=this.fabric;var self=this;fabric.Image.fromURL(url,function(oImg){canvas.setHeight(oImg.height);canvas.setWidth(oImg.width);canvas.setBackgroundImage(oImg,canvas.renderAll.bind(canvas),{top:0,left:0});self.centerCanvas()})},addPart:function addPart(layerId,partId){var setAsActive=arguments.length>2&&arguments[2]!==undefined?arguments[2]:false;if(!this.canvasElements[layerId])this.canvasElements[layerId]={};var part=this.getPart(layerId,partId);var canvas=this.fabric;var self=this;var layer=this.model.getLayer(layerId);fabric.Image.fromURL(part.src,function(element){element.set({left:part.x,top:part.y,angle:part.rotation,scaleX:part.scaleX,scaleY:part.scaleY,visible:part.visible&&layer.visible,selectable:part.visible&&layer.visible,opacity:part.active?1:0.5});element.partId=partId;element.layerId=layerId;canvas.add(element);self.canvasElements[layerId][partId]=element;if(setAsActive)self.selectPart(layerId,partId);else canvas.renderAll()})},selectPart:function selectPart(layerId,partId){var element=this.getCanvasElement(layerId,partId);var layer=this.model.getLayer(layerId);if(this.active){this.active.set('selectable',false).set('opacity',0.5)}if(element&&layer.visible&&element.visible){element.set('selectable',true).set('opacity',1);this.fabric.setActiveObject(element);this.active=element}this.fabric.renderAll()},deletePart:function deletePart(layerId,partId){var part=this.getCanvasElement(layerId,partId);if(part){if(this.active==part){this.active=null;this.fabric.discardActiveObject()}delete this.canvasElements[layerId][partId];this.fabric.remove(part)}},deleteLayer:function deleteLayer(layerId){if(this.canvasElements[layerId]){for(var partId in this.canvasElements[layerId]){if(this.canvasElements[layerId].hasOwnProperty(partId))this.deletePart(layerId,partId)}delete this.canvasElements[layerId]}this.fabric.renderAll()},changeImage:function changeImage(layerId,partId){var element=this.getCanvasElement(layerId,partId),part=this.getPart(layerId,partId);if(!element){this.addPart(layerId,partId,part.active);return}var canvas=this.fabric;element.setSrc(part.src,function(_){return canvas.renderAll()});canvas.renderAll()},hideOrShowPart:function hideOrShowPart(layerId,partId){var part=this.getPart(layerId,partId);var element=this.getCanvasElement(layerId,partId);if(element){element.set('visible',part.visible).set('selectable',part.visible);if(!part.visible&&this.active==element){this.active=null;this.fabric.discardActiveObject()}if(part.visible&&this.active!=element){element.set('opacity',0.5)}this.fabric.renderAll()}},hideOrShowLayer:function hideOrShowLayer(layerId){var layer=this.model.getLayer(layerId);var elements=this.canvasElements[layerId];if(elements){for(var partId in elements){if(!elements.hasOwnProperty(partId))continue;var element=elements[partId];if(element==this.active){this.fabric.discardActiveObject();this.active=null}element.set('visible',layer.visible).set('selectable',false)}this.fabric.renderAll()}},getCanvasElement:function getCanvasElement(layerId,partId){if(!this.canvasElements[layerId]||!this.canvasElements[layerId][partId])return null;return this.canvasElements[layerId][partId]},getPart:function getPart(layerId,partId){return this.model.getLayer(layerId).getPart(partId)},setup:function setup(model){var canvas=this.fabric;this.model=model;this.model.eventBus.$on('backgroundChanged',this.changeBackground);this.model.eventBus.$on('partDeleted',this.deletePart);this.model.eventBus.$on('imageChanged',this.changeImage);this.model.eventBus.$on('partSelected',this.selectPart);this.model.eventBus.$on('layerDeleted',this.deleteLayer);this.model.eventBus.$on('partVisibilityChanged',this.hideOrShowPart);this.model.eventBus.$on('layerVisibilityChanged',this.hideOrShowLayer);canvas.clear();this.canvasElements={};if(this.model.background)this.changeBackground(this.model.background);var _iteratorNormalCompletion=true;var _didIteratorError=false;var _iteratorError=undefined;try{for(var _iterator=this.model.layers[Symbol.iterator](),_step;!(_iteratorNormalCompletion=(_step=_iterator.next()).done);_iteratorNormalCompletion=true){var layer=_step.value;var _iteratorNormalCompletion2=true;var _didIteratorError2=false;var _iteratorError2=undefined;try{for(var _iterator2=layer.parts[Symbol.iterator](),_step2;!(_iteratorNormalCompletion2=(_step2=_iterator2.next()).done);_iteratorNormalCompletion2=true){var part=_step2.value;if(part.src)this.addPart(layer.id,part.id,false)}}catch(err){_didIteratorError2=true;_iteratorError2=err}finally{try{if(!_iteratorNormalCompletion2&&_iterator2.return){_iterator2.return()}}finally{if(_didIteratorError2){throw _iteratorError2}}}}}catch(err){_didIteratorError=true;_iteratorError=err}finally{try{if(!_iteratorNormalCompletion&&_iterator.return){_iterator.return()}}finally{if(_didIteratorError){throw _iteratorError}}}}},beforeDestroy:function beforeDestroy(){window.removeEventListener('resize',this.resize)},mounted:function mounted(){var canvas=this.fabric=new fabric.Canvas(this.$refs.canvas,{selection:false,transparentCorners:false});fabric.Object.prototype.set({transparentCorners:false,borderColor:'#000',cornerColor:'#000',cornerStrokeColor:'#FFF',borderOpacityWhenMoving:1});var self=this;canvas.on('selection:cleared',function(e){if(self.active)canvas.setActiveObject(self.active)});canvas.on('object:modified',function(e){var target=e.target;var part=self.getPart(target.layerId,target.partId);part.x=target.left;part.y=target.top;part.rotation=target.angle;part.scaleX=target.scaleX;part.scaleY=target.scaleY});this.centerCanvas();window.addEventListener('resize',this.resize)}});
