/* global Vue, colorizerApplication */

'use strict'

Vue.component('layer-part', {
  props: {
    model: Object,
    attributes: Array
  },
  template: `
    <div class="layer-part"
        :class="{active: model.active}"
        @click="clicked">
      <div class="layer-part-content">
        <div class="image-wrapper">
          <span class="section-title">
            Image:
          </span>
          <img @click="updateImage"  :src="model.src" :class="{ filled: model.src }" class="image-preview">
        </div>
        <div class="attributes">
          <span class="section-title">
            Hidden when:
          </span>
          <div class="attribute"
               v-for="attribute in attributes"
               :item="attribute">
               <span class="attribute-name">
                {{ attribute.name }}
               </span>
               <select :ref="'visibleWhen' + attribute.id" multiple @change="updateVisibleWhen(attribute)">
                <option v-for="value in attribute.values"
                        :selected='model.hiddenWhen.has(attribute.id) && model.hiddenWhen.get(attribute.id).includes(value.id)'
                        :item="value"
                        :value="value.id">
                  {{ value.name }}
                </option>
               </select>
          </div>
        </div>
      </div>
      <div class="layer-part-footer">
        <label class="visibility control">
          <input
                type="checkbox"
                v-model="model.visible"
                @change="() => model.visibilityChanged()">
          <span class="icon"></span>
        </label>
        <button type="button" class="control duplicate" @click="$emit('duplicatePart', model.id)">Duplicate</button>
        <button type="button" class="control delete" @click="$emit('deletePart', model.id)">Delete</button>
      </div>
    </div>
  `,
  methods: {
      updateVisibleWhen: function (attribute) {
        const select = this.$refs['visibleWhen'+attribute.id][0];
        const options = select && select.options;
        function HTMLOptionsCollectionToArray(options) {
          return Array.apply(null, options);
        }
        this.model.hiddenWhen.set( attribute.id, HTMLOptionsCollectionToArray(options)
                                  .filter( (option) => option.selected )
                                  .map( (option)=> parseInt(option.value) ) );
      },
      updateImage: function() {
        imageSelect((url) => this.model.selectImage(url));
      },
      clicked: function(e) {
        if( e.target.tagName != 'DIV' ) return false;
        this.$emit('partSelected', this.model.layerId, this.model.id);
      }
  }
});
