/* global Vue */
/* global Attribute */

'use strict'

const attributes = Attribute.all(),
      colorizingAttributes = attributes.filter(
        (a) => a.values.some((v) => !!v.color)
      );
Vue.component('layer', {
  props: {
    model: Object,
  },
  data: function() {
    return {
       opened: false,
       attributes: attributes,
       colorizingAttributes: colorizingAttributes
    }
  },
  template: `
    <li class="layer"
        v-bind:class="{ opened: opened, active: model.active }">
      <div class="layer-bar">
        <label class="visibility">
          <input
                type="checkbox"
                v-model="model.visible"
                @change="() => model.visibilityChanged()">
          <span class="icon"></span>
        </label>
        <button type="button" @click="$emit('deleteLayer', model.id)"
                class="delete">delete</button>
        <input
              ref="input"
              @focusout="leaved"
              class="layer-name"
              type="text"
              v-model="model.name">

        <label class="opener">
          <input
                type="checkbox"
                v-model="opened"
                class="toggle">
        </label>
      </div>
      <div class="layer-content">
        <div class="layer-content-inside">
          <h3 class="section-title">
          Images
          </h3>
          <div class="layer-parts">
            <layer-part v-for="part in model.parts"
                        :key="part.id"
                        :model="part"
                        v-on:deletePart="(id) => model.removePart(id)"
                        v-on:duplicatePart="(id) => model.duplicatePart(id)"
                        v-on:partSelected="(layerId, partId) => $emit('partSelected', layerId, partId)"
                        :attributes="attributes"></layer-part>
            <div @click="() => model.addPart()" class="layer-part add-new">+</div>
          </div>
          <h3 class="section-title">
          Settings
          </h3>
          <div class="layer-settings">
          <label>
          Opacity
          <input v-model="model.opacity" type="number" min="0" max="100" step="1">
          </label>
          <hr>
          <label>
          Color opacity
          <input v-model="model.colorOpacity" type="number" min="0" max="100" step="1">
          </label>
          <label>
          Colorizing attribute
          <select v-model="model.colorizedBy">
            <option value="0">-</option>
            <option v-for="attribute in colorizingAttributes" :value="attribute.id">{{ attribute.name }}</option>
          </select>
          </label>
          <hr>
          <label>
          Background color opacity
          <input v-model="model.backgroundOpacity" type="number" min="0" max="100" step="1">
          </label>
          <label>
          Background color attribute
          <select v-model="model.background">
            <option value="0">-</option>
            <option v-for="attribute in colorizingAttributes" :value="attribute.id">{{ attribute.name }}</option>
          </select>
          </label>
          </div>
        </div>
      </div>
    </li>
  `,
  methods: {
    leaved: function() {
      if( this.model.name == '' ) this.model.name = 'Layer ' + this.model.id;
    },
  }
})
