Array.prototype.move = function (oldIndex, newIndex) {
    if (newIndex >= this.length) {
        var k = newIndex - this.length;
        while ((k--) + 1) {
            this.push(undefined);
        }
    }
    this.splice(newIndex, 0, this.splice(oldIndex, 1)[0]);
};

var EditorModel = (function () {
    function EditorModel(background) {
        if (background === void 0) { background = ''; }
        this.background = background;
        this.layers = [];
        this.nextLayerId = 0;
        this.eventBus = new Vue();
    }
    EditorModel.fromObject = function(object) {
        const toReturn = new EditorModel();
        if( object.layers ) {
            object.layers = object.layers.map((l) => LayerModel.fromObject(l, toReturn.eventBus));
        }
        for(let key in toReturn) {
            if( toReturn.hasOwnProperty(key) &&
                object.hasOwnProperty(key) ) {
                    toReturn[key] = object[key];
                }
        }
        return toReturn;
    };
    EditorModel.prototype.toJson = function() {
        return JSON.stringify(this, (key, val) => {
            if( key == 'hiddenWhen' && val instanceof Map) return Array.from(val.entries());
            return key === 'eventBus' ? void 0 : val
        }, ' ');
    };
    EditorModel.prototype.addLayer = function () {
        var layer = new LayerModel(this.nextLayerId, this.eventBus);
        this.layers.push(layer);
        this.nextLayerId++;
        return layer;
    };
    EditorModel.prototype.getLayer = function(id) {
        return this.layers.find((l) => l.id == id);
    };
    EditorModel.prototype.moveLayer = function(oldIndex, newIndex) {
        this.layers.move(oldIndex, newIndex);
    }
    EditorModel.prototype.deleteLayer = function (id) {
        const index = this.layers.findIndex((layer) => id == layer.id);
        this.layers.splice(index, 1);
        this.eventBus.$emit('layerDeleted', id);
    }
    EditorModel.prototype.selectPart = function (layerId, partId) {
        this.layers.forEach((layer) => layer.selectPart(layerId, partId));
        this.eventBus.$emit('partSelected', layerId, partId);
    }
    EditorModel.prototype.changeBackground = function (url) {
      this.background = url;
      this.eventBus.$emit('backgroundChanged', url);
    }
    return EditorModel;
}());
var LayerModel = (function () {
    function LayerModel(id, eventBus) {
        this.id = id;
        this.parts = [];
        this.nextPartId = 0;
        this.colorizedBy = 0;
        this.background = 0;
        this.opacity = 100;
        this.colorOpacity = 50;
        this.backgroundOpacity = 50;
        this.active = false;
        this.visible = true;
        this.eventBus = eventBus;
        this.name = `Layer ${this.id}`;
    }
    LayerModel.fromObject = function(object, eventBus) {
       const toReturn = new LayerModel(0, eventBus);
        if( object.parts ) {
            object.parts = object.parts.map((p) => LayerPartModel.fromObject(p, toReturn.eventBus));
        }
        for(let key in toReturn) {
            if( toReturn.hasOwnProperty(key) &&
                object.hasOwnProperty(key) ) {
                    toReturn[key] = object[key];
                }
        }
        return toReturn;
    }
    LayerModel.prototype.addPart = function () {
        const id = this.nextPartId;
        var part = new LayerPartModel(id, this.id, this.eventBus);
        this.parts.push(part);
        this.eventBus.$emit('partAdded', this.id, id);
        this.nextPartId++;
        this.selectPart(this.id, id);
        this.eventBus.$emit('partSelected', this.id, id);
        return part;
    };
    LayerModel.prototype.getPart = function (id) {
        return this.parts.find( (p) => p.id == id);
    };
    LayerModel.prototype.removePart = function (id) {
      const index = this.parts.findIndex((part) => id == part.id);
      this.parts.splice(index, 1);
      this.eventBus.$emit('partDeleted', this.id, id);
    }
    LayerModel.prototype.duplicatePart = function (id) {
      const toDuplicate = this.parts.find((part) => id == part.id);
      const part = this.addPart();
      part.hiddenWhen = new Map(toDuplicate.hiddenWhen);
      part.x = toDuplicate.x;
      part.y = toDuplicate.y;
      part.scaleX = toDuplicate.scaleX;
      part.scaleY = toDuplicate.scaleY;
      part.rotation = toDuplicate.rotation;
      if( toDuplicate.src ) {
        part.selectImage(toDuplicate.src);
      }
    }
    LayerModel.prototype.selectPart = function (layerId, partId) {
      if( layerId == this.id ) {
        this.parts.forEach((part) => {
          part.active = false
          if( part.id == partId && part.visible ) part.active = true;
        });
      } else {
        this.parts.forEach((part) =>
          part.active = false
        );
      }
    }
    LayerModel.prototype.visibilityChanged = function () {
      this.eventBus.$emit('layerVisibilityChanged', this.id);
      for( let part of this.parts ) {
        part.active = false;
      }
    }
    return LayerModel;
}());
var LayerPartModel = (function () {
    function LayerPartModel(id, layerId, eventBus) {
        this.id = id;
        this.layerId = layerId;
        this.hiddenWhen = new Map();
        this.src = null;
        this.x = 0;
        this.y = 0;
        this.rotation = 0;
        this.active = false;
        this.eventBus = eventBus;
        this.visible = true;
        this.scaleX = 1;
        this.scaleY = 1;
    }
    LayerPartModel.fromObject = function(object, eventBus) {
        const toReturn = new LayerPartModel(0, 0, eventBus);
        if( object.hiddenWhen ) object.hiddenWhen = new Map(object.hiddenWhen);
        for(let key in toReturn) {
            if( toReturn.hasOwnProperty(key) &&
                object.hasOwnProperty(key) ) {
                    toReturn[key] = object[key];
                }
        }
        return toReturn;
    }
    LayerPartModel.prototype.selectImage = function (url) {
      if( url ) {
        this.src = url;
        this.eventBus.$emit('imageChanged', this.layerId, this.id);
      }
    }
    LayerPartModel.prototype.visibilityChanged = function () {
      if( !this.visible ) {
        this.active = false;
      }
      this.eventBus.$emit('partVisibilityChanged', this.layerId, this.id)
    }
    return LayerPartModel;
}());
